/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*mihals generate continuum from Mihalas stellar atmosphere */
#include "cddefines.h"
#ifdef NDATA
#	undef NDATA
#endif
#define	NDATA	47
#include "rfield.h"
#include "stars.h"
#include "physconst.h"

void mihals(long int *nstar, 
  double par1, 
  double par2)
{
	long int i, 
	  mtemp;
	double alogg, 
	  temp;
	float fac1, 
	  fac2; 

	/* wavelength scale in inverse microns */
	static float wl[NDATA]={87.7939f,75.0851f,62.3770f,62.3760f,53.1367f,
	  43.8975f,43.8965f,38.6940f,38.6930f,31.7719f,24.8510f,24.8500f,22.3465f,
	  19.8430f,19.8420f,17.3087f,14.7749f,13.5080f,12.2411f,11.6077f,10.9750f,
	  10.9740f,10.2883f,9.7549f,8.2307f,6.5541f,4.8780f,4.8770f,3.8105f,2.7440f,
	  2.7430f,2.4006f,2.0577f,1.7564f,1.7554f,1.5242f,1.2199f,1.2189f,0.9526f,
	  0.6864f,0.6854f,0.5335f,0.4395f,0.4385f,0.2212f,0.0033f,1e-4f};

	/* these puppy's are in MAGNITUDES!!!!! */
	static float t30g4[NDATA]={51.490f,43.717f,35.900f,35.898f,30.234f,
	  24.636f,22.972f,19.877f,20.031f,15.728f,11.647f,11.199f,9.782f,8.417f,
	  4.205f,3.631f,2.850f,2.413f,1.965f,1.741f,1.520f,-1.931f,-1.923f,-1.909f,
	  -1.828f,-1.645f,-1.317f,-1.323f,-0.993f,-0.510f,-0.748f,-0.517f,-0.243f,
	  0.048f,0.048f,0.312f,0.740f,0.695f,1.186f,1.852f,1.840f,2.359f,2.764f,
	  2.761f,4.202f,13.107f,20.699f};

	static float t325g4[NDATA]={43.608f,36.844f,30.128f,30.114f,25.301f,
	  20.573f,17.983f,15.386f,13.113f,10.637f,7.128f,6.695f,5.527f,4.367f,1.771f,
	  1.418f,0.933f,0.646f,0.341f,0.185f,0.029f,-2.016f,-2.011f,-1.999f,-1.926f,
	  -1.750f,-1.421f,-1.437f,-1.088f,-0.569f,-0.764f,-0.529f,-0.248f,0.049f,
	  0.049f,0.319f,0.754f,0.718f,1.214f,1.884f,1.875f,2.395f,2.801f,2.798f,
	  4.238f,13.143f,20.735f};

	static float t35g4[NDATA]={37.814f,31.886f,26.019f,25.986f,21.790f,
	  17.670f,14.982f,12.661f,4.193f,4.020f,2.826f,2.747f,2.082f,1.283f,0.696f,
	  0.388f,0.017f,-0.192f,-0.410f,-0.521f,-0.631f,-2.056f,-2.049f,-2.038f,
	  -1.964f,-1.790f,-1.462f,-1.488f,-1.138f,-0.605f,-0.761f,-0.527f,-0.248f,
	  0.049f,0.048f,0.319f,0.756f,0.728f,1.225f,1.895f,1.886f,2.408f,2.814f,
	  2.812f,4.249f,13.184f,20.776f};

	static float t375g4[NDATA]={33.776f,28.424f,23.152f,23.069f,19.318f,
	  15.642f,13.211f,11.053f,2.397f,1.888f,1.150f,1.143f,0.731f,0.221f,0.097f,
	  -0.171f,-0.475f,-0.637f,-0.803f,-0.886f,-0.966f,-2.102f,-2.093f,-2.079f,
	  -2.000f,-1.820f,-1.487f,-1.518f,-1.166f,-0.628f,-0.756f,-0.524f,-0.246f,
	  0.048f,0.047f,0.317f,0.753f,0.730f,1.225f,1.893f,1.888f,2.407f,2.812f,
	  2.811f,4.249f,13.207f,20.799f};

	static float t40g4[NDATA]={31.030f,26.058f,21.192f,21.030f,17.596f,
	  14.242f,11.981f,9.539f,1.543f,0.939f,0.289f,0.289f,0.002f,-0.337f,-0.355f,
	  -0.587f,-0.838f,-0.969f,-1.100f,-1.164f,-1.225f,-2.158f,-2.146f,-2.130f,
	  -2.040f,-1.856f,-1.514f,-1.547f,-1.191f,-0.647f,-0.758f,-0.525f,-0.247f,
	  0.049f,0.046f,0.316f,0.752f,0.734f,1.228f,1.896f,1.892f,2.411f,2.817f,
	  2.816f,4.256f,13.215f,20.807f};

	static float t45g4[NDATA]={26.168f,21.629f,17.233f,16.584f,13.538f,
	  10.627f,3.420f,2.306f,0.525f,-0.082f,-0.662f,-0.662f,-0.864f,-1.063f,
	  -1.060f,-1.242f,-1.418f,-1.503f,-1.583f,-1.620f,-1.655f,-2.257f,-2.239f,
	  -2.219f,-2.123f,-1.925f,-1.570f,-1.595f,-1.231f,-0.675f,-0.765f,-0.530f,
	  -0.249f,0.049f,0.046f,0.319f,0.759f,0.743f,1.240f,1.913f,1.910f,2.431f,
	  2.839f,2.838f,4.281f,13.235f,20.827f};

	static float t50g4[NDATA]={23.826f,19.658f,15.626f,14.645f,11.833f,
	  9.190f,0.621f,-0.005f,-0.199f,-0.733f,-1.241f,-1.241f,-1.412f,-1.572f,
	  -1.571f,-1.717f,-1.843f,-1.897f,-1.942f,-1.961f,-1.976f,-2.330f,-2.307f,
	  -2.283f,-2.178f,-1.972f,-1.610f,-1.622f,-1.254f,-0.690f,-0.768f,-0.532f,
	  -0.250f,0.049f,0.047f,0.321f,0.764f,0.750f,1.249f,1.925f,1.922f,2.445f,
	  2.853f,2.853f,4.296f,13.256f,20.848f};

	static float t55g4[NDATA]={21.808f,17.921f,14.170f,12.897f,10.251f,
	  7.788f,-0.428f,-0.817f,-0.837f,-1.281f,-1.706f,-1.706f,-1.848f,-1.979f,
	  -1.979f,-2.094f,-2.184f,-2.216f,-2.237f,-2.242f,-2.242f,-2.369f,-2.342f,
	  -2.315f,-2.204f,-1.994f,-1.631f,-1.530f,-1.262f,-0.695f,-0.765f,-0.531f,
	  -0.250f,0.049f,0.048f,0.322f,0.766f,0.752f,1.252f,1.929f,1.927f,2.451f,
	  2.860f,2.859f,4.304f,13.274f,20.866f};

#	ifdef DEBUG_FUN
	fputs( "<+>mihals()\n", debug_fp );
#	endif

	/* following atmospheres NLTE from Mihalas, NCAR-TN/STR-76 */

	/* PAR1 and 2 are LOG(g) and temp */
	if( par1 > 10. )
	{
		temp = par1;
		mtemp = (long)((par1 + 10.)/100.);
		alogg = par2;
	}

	else
	{
		temp = par2;
		mtemp = (long)((par2 + 10.)/100.);
		alogg = par1;
	}

	if( alogg != 4. )
	{
		fprintf( ioQQQ, " only LOG(g)=4 in table at present.\n" );
		puts( "[Stop in mihals]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* create arrays and zero unused elements */
	rfield.lgContMalloc[rfield.nspec] = TRUE;
	/* these do need to be init to zero */
	if( (rfield.tNuRyd[rfield.nspec] = (float*)CALLOC((size_t)NCELL , sizeof(float) ) ) == NULL )
		BadMalloc();
	if( (rfield.tslop[rfield.nspec] = (float*)CALLOC((size_t)NCELL , sizeof(float) ) ) == NULL )
		BadMalloc();
	if( (rfield.tFluxLog[rfield.nspec] = (float*)CALLOC((size_t)NCELL , sizeof(float) ) ) == NULL )
		BadMalloc();

	for( i=0; i < NDATA; i++ )
	{
		/* convert inverse microns to Rydbergs */
		/* rfield.tNuRyd[rfield.nspec][i] = (float)(wl[NDATA-i-1]*0.09116); */
		rfield.tNuRyd[rfield.nspec][i] = (float)(wl[NDATA-i-1]*WAVNRYD*1.e4);
	}

	if( mtemp == 300 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t30g4[NDATA-i-1];
		}
	}

	else if( mtemp == 325 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t325g4[NDATA-i-1];
		}
	}

	else if( mtemp == 350 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t35g4[NDATA-i-1];
		}
	}

	else if( mtemp == 375 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t375g4[NDATA-i-1];
		}
	}

	else if( mtemp == 400 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t40g4[NDATA-i-1];
		}
	}

	else if( mtemp == 450 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t45g4[NDATA-i-1];
		}
	}

	else if( mtemp == 500 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t50g4[NDATA-i-1];
		}
	}

	else if( mtemp == 550 )
	{
		for( i=0; i < NDATA; i++ )
		{
			rfield.tslop[rfield.nspec][i] = t55g4[NDATA-i-1];
		}
	}

	else if( mtemp < 300 || mtemp > 550 )
	{
		fprintf( ioQQQ, " This temp is not inside table.\n" );
		puts( "[Stop in mihals]" );
		cdEXIT(EXIT_FAILURE);
	}

	else
	{
		/*  must interpolate on grid */
		if( mtemp > 300 && mtemp <= 325 )
		{
			fac1 = ((float)temp - 30000.f)/2500.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t30g4[NDATA-i-1] + 
				  fac1*t325g4[NDATA-i-1]);
			}
		}

		else if( mtemp > 325 && mtemp <= 350 )
		{
			fac1 = ((float)temp - 32500.f)/2500.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t325g4[NDATA-i-1] + 
				  fac1*t35g4[NDATA-i-1]);
			}
		}

		else if( mtemp > 350 && mtemp <= 375 )
		{
			fac1 = ((float)temp - 35000.f)/2500.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t35g4[NDATA-i-1] + 
				  fac1*t375g4[NDATA-i-1]);
			}
		}

		else if( mtemp > 375 && mtemp <= 400 )
		{
			fac1 = ((float)temp - 37500.f)/2500.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t375g4[NDATA-i-1] + 
				  fac1*t40g4[NDATA-i-1]);
			}
		}

		else if( mtemp > 400 && mtemp <= 450 )
		{
			fac1 = ((float)temp - 40000.f)/5000.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t40g4[NDATA-i-1] + 
				  fac1*t45g4[NDATA-i-1]);
			}
		}

		else if( mtemp > 450 && mtemp <= 500 )
		{
			fac1 = ((float)temp - 45000.f)/5000.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t45g4[NDATA-i-1] + 
				  fac1*t50g4[NDATA-i-1]);
			}
		}

		else
		{
			/* actually- else if( mtemp.gt.500.and.mtemp.le.550 ) THEN */
			fac1 = ((float)temp - 50000.f)/5000.f;
			fac2 = 1.f - fac1;
			for( i=0; i < NDATA; i++ )
			{
				rfield.tslop[rfield.nspec][i] = (fac2*t50g4[NDATA-i-1] + 
				  fac1*t55g4[NDATA-i-1]);
			}
		}
	}

	/* convert from magnitudes to LOG10( f-nu ) */
	for( i=0; i < NDATA; i++ )
	{
		rfield.tslop[rfield.nspec][i] = 
			(-rfield.tslop[rfield.nspec][i]/2.5f);
	}
	*nstar = NDATA;

	/* this is the log of the low-energy f_nu */
	rfield.tslop[rfield.nspec][0] += 
		(float)(2.*log10( rfield.emm / rfield.tNuRyd[rfield.nspec][0] ) );

	/* now reset lowest energy to current bounds of code */
	rfield.tNuRyd[rfield.nspec][0] = rfield.emm ;

#	ifdef DEBUG_FUN
	fputs( " <->mihals()\n", debug_fp );
#	endif
	return;
}

