/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*MakeRT drive static or wind metal line radiative transfer,
 * if argument is TRUE then do both escape and deEXTERN struction probs,
 * if false only update deEXTERN struction probabilities.  routine only
 * called by cloudy(TRUE) and ConvBase(FALSE) */
void RT_line_all(
	/* this is TRUE if we want to do both escape and destruction probs,
	 * and FALSE if only destruction probabilities are needed */
	int lgDoEsc ,
	/* flag saying whether to update fine opacities */
	int lgUpdateFineOpac );

/*rt_radiative_acceleration radiative accel due to incident continuum, calls rt_line_driving for lines*/
void RT_radiative_acceleration(void);

/*rt_line_driving radiative acceleration due to line absorption of incident continuum */
double RT_line_driving(void);

/* in following two the logical variable says whether to do the
 * escape probs too (TRUE) or just the deEXTERN struction probs (FALSE) */

/*RT_line_one do line radiative transfer */
void RT_line_one(EmLine * t , 
	int lgDoEsc , 
	int lgUpdateFineOpac,
	/* this is option to not include line self shielding across this zone.
	 * this can cause pump to depend on zone thickness, and leads to unstable
	 * feedback in some models with the large H2 molecule, due to Solomon
	 * process depending on zone thickness and level populations. */
	int lgShield_this_zone );

/*rt_continuum_shield_fcn computing continuum shielding due to single line */
float RT_continuum_shield_fcn( EmLine *t );

/*RT_diffuse fill in DiffCont array with diffuse emission for this zone */
void RT_diffuse(void);

/*RT_OTS compute diffuse fields due to helium atom, metals,
 * hydro done in HydroOTS */
void RT_OTS(void);

/*RT_OTS_AddLine add local destruction of lines to ots field */
void RT_OTS_AddLine(double ots, 
	/* pointer on the f scale */
  long int ip );

/*RTOTSUpdata sum flux, otscon, otslin, ConInterOut, outlin, 
 * to form SummeDif, SummedCon SummedOcc, 
 * returns sum of ots rates
 * int * is pointer to energy in continuum where this change happened,
 * BigFrac is largest relative change in ots allowed, 0 for no cap */
void RT_OTS_Update(double* SumOTS , double BigFrac);

/* zero these things out, called in zero */
void RT_OTS_Zero( void );

/*RT_OTS_ChkSum sanity check confirms summed continua reflect contents of individuals */
void RT_OTS_ChkSum(long int ipPnt);

/*RT_line_one_tauinc increment optical depths for all heavy element lines, zone by zone */
void RT_line_one_tauinc(EmLine * t ,
	long int mas_species,
	long int mas_ion,
	long int mas_hi,
	long int mas_lo );

/*RT_tau_init set initial outward optical depths at start of first iteration */
void RT_tau_init(void);

/*RT_line_one_tau_reset computes average of old and new optical depths for new scale at end of iter */
void RT_line_one_tau_reset(EmLine * t , 
  double f1);

/*RT_tau_reset update total optical depth scale, called after iteration is complete */
void RT_tau_reset(void);

/*RT_tau_inc increment optical depths once per zone, called after radius_increment */
void RT_tau_inc(void);

/*RT_OTS_PrtRate print ots arrays, called by ionize */
void RT_OTS_PrtRate(
	  /* arg is weakest rate to print */
	  double weak ,
	  /* flag, 'c' continuum, 'l' line, 'b' both */
	  int chFlag );

/*esc_PRD_1side fundamental escape probability radiative transfer routine for incomplete redistribution */
double esc_PRD_1side(double tau, 
  double a);

/*esc_CRDwing_1side fundamental escape probability radiative transfer routine, for complete redistribution */
double esc_CRDwing_1side(double tau, 
  double a );

/*RTesc_lya escape prob for hydrogen atom Lya, using Hummer and Kunasz results */
double RTesc_lya(double *esin, 
  double *dest, 
  double abund, 
  long int ipZ);/* 0 for H, */

/*esc_CRDwing escape probability CRD with wings, for subordinate lines */
double esc_CRDwing(double tau, 
  double tout, 
  double damp);

/*esc_CRDcore escape probability CRD with no wings, for subordinate lines */
double esc_CRDcore(double tau, 
  double tout);

/*esc_PRD escape probability radiative transfer for incomplete redistribution */
double esc_PRD(double tau, 
  double tout, 
  double damp );

/*esca0k2 derive Hummer's K2 escape probability for Doppler core only */
double esca0k2(double taume);

/*escpcn continuum escape probability */
double esccon(double tau, 
  double hnukt);

/*conesc one of the forms of the continuum escape probability */
double escConE2(double x);

/*RT_DestProb returns line destruction probability due to continuum opacity */
double RT_DestProb(
	  /* abundance of species */
	  double abund, 
	  /* its line absorption cross section */
	  double crsec, 
	  /* pointer to energy within continuum array, to get background opacity,
	   * this is on the f not c scale */
	  long int ipanu, 
	  /* line width */
	  double widl, 
	  /* escape probability */
	  double escp, 
	  /* type of redistribution function */
	  int nCore);

#if 0
/*wrapper to call RT_LineWidth for the special case of Lya */
double RT_LyaWidth(
			 double tauin, 
			 double tauout, 
			 double a, 
			 /* answer will be in whatever units vth is in, since only generates
			  * optical depth dependent scale factor */
			 double vth);
#endif

/*RT_LineWidth compute line width (cm/sec), using optical depth array information */
double RT_LineWidth(EmLine * t);

/* beta is ratio of continuum to mean line opacity,
 * returns dest prob = beta F(beta) */
double RT_DestHummer(double beta); 

/*rt_recom_effic generate escape probability function for continua, */
double RT_recom_effic(long int ip);

/*rt_stark compute stark broadening escape probabilities using Puetter formalism */
void RT_stark(void);

/* DEST0 is the smallest destruction probability to return
 * in high metallicity models */
/*#define DEST0 1e-8*/
#define DEST0 SMALLFLOAT

EXTERN struct t_rt {

	/* wayin - escape probability in inward direction */
	float wayin, 
	/* wayout - escape probability in outward direction
	 * =1 when outward optical depths unknown (touton .false.) */
	  wayout; 
	/* fractin = wayin / (wayin+wayout) when outer defined, else zero */
	double  fracin;

	/* optical depths to add to Lyman lines for three series */
	float TAddHLya, 
	  TAddHeI;

	/* 1 or two, set to double optical depth scale, set to 2 with double command
	* default is 1 */
	float DoubleTau;

	/* offset in continuum array for energy where x-ray opacity determined */
	long int ipxry;

	/* optical depth at this energy */
	float tauxry;

	/* option to turn off fine structure line optical depths */
	int lgFstOn;

	/* which type of line continuum shielding function should be used?  */
	int nLineContShield;

	/* include electron scattering escape for lines? */
	int lgElecScatEscape;

	/* dTauMase is smallest maser optical depth in atoms, set in
	 * RT_tau_inc for H, and in tauchn for heavy elements
	 * it is negative or zero */
	float dTauMase;

	/* set true in radius_next if maser ever sets zone thickness */
	int lgMaserSetDR;

	/* flag set true in tauchn if maser cap ever hit, 
	 * causes comment to be printed in prtComments */
	int lgMaserCapHit;

	/* these identify the species that had a major maser, for debugging */
	long int mas_species , mas_ion , mas_hi , mas_lo ;

	/* flag saying that stark broadening is enabled, set false with no stark */
	int lgStarkON;

}	rt;

/* these are all possible values of rt.nLineContShield,
 * first is default, these are set with set continuum shielding */
#define LINE_CONT_SHIELD_PESC	1
#define LINE_CONT_SHIELD_FEDERMAN	2
#define LINE_CONT_SHIELD_FERLAND	3
