/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*PunchSpecial generate output for the punch special command */
#include "cddefines.h"
#include "taulines.h"
#include "radius.h"
#include "h2.h"
#include "punch.h"

/*PunchSpecial generate output for the punch special command */
void PunchSpecial(FILE* io , 
  const char *chTime)
{
	/*long int i;*/

#	ifdef DEBUG_FUN
	fputs( "<+>PunchSpecial()\n", debug_fp );
#	endif

	if( strncmp(chTime,"LAST",4) == 0 )
	{
		/* code to execute only after last zone */
#		if 0
		long ipISO , nelem , limit , i;
		double EdenAbund , fach;
#		include "physconst.h"
#		include "hydrogenic.h"
		PunFeII( io );*/
		ipISO = ipHYDROGEN;
		nelem = ipHYDROGEN;

		/* in all following the factor of two is because a single
		 * decay produces two photons */
		EdenAbund = iso.Pop2Ion[ipH_LIKE][nelem][ipH2s]*dense.xIonDense[nelem][nelem+1]*8.226*pow(1.+nelem,6);
		fprintf(io," 2s = %.3e\n", EdenAbund);

		/* upper limit to H-like 2-phot is energy of La, which is in ipCont-1 cell */
		limit = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1;
		/* remember sum of rates, this will add up to twice the real rate since
		 * each transition makes two photons */
		for( i=0; i < limit; i++ )
		{
			/*>>chng 01 jan 23, previous change had doubled cross section for H two-photon,
			 * so here we divide by 2 to get old answer */
			/* TODO	2	this most likely needs to be changed in light of new 2nu treatment	*/
			fach = iso.As2nu[ipISO][nelem][i]/2.f;
			fach *= rfield.anu2[i]/rfield.widflx[i]*EN1RYD;
			fprintf(io,"%.3e\t%.3e\t%.3e\n", 
				RYDLAM/1e4/rfield.anu[i] , fach , fach*(float)EdenAbund );
		}
#		endif

	}
	else
	{
		long int iElecHi=1 , iVibHi=0, iRotHi=0;
		/* code to execute after every zone */
		if( h2.lgH2ON )
			fprintf(io,"DEBUG Oion\t%li\t%.2f\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
				iteration,fnzone,
				radius.depth,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].PopLo,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].PopOpc,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].opacity,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].TauCon,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].TauIn,
				H2Lines[iElecHi][iVibHi][iRotHi][0][0][1].pump,
				radius.drad
				);
		/*DumpLine(&EmisLines[ipHE_LIKE][ipHELIUM][ipHe2p1P][0] );*/
		
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunchSpecial()\n", debug_fp );
#	endif
	return;
}

