/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*prtmet print all line optical depths at end of iteration */
#include "cddefines.h"
#include "taulines.h"
#include "h2.h"
#include "iso.h"
#include "lines_service.h"
#include "dense.h"
#include "prt.h"

void prtmet(void)
{
	long int i,
		nelem , 
		ipHi , 
		ipLo , 
		ipISO;

#	ifdef DEBUG_FUN
	fputs( "<+>prtmet()\n", debug_fp );
#	endif

	/* default is to not print optical depths, turn on with
	 * print optical depths on command */
	if( prt.lgPrtTau )
	{

		/* 'In' means to zero counter, following elements mean nothing */
		prme("In",&TauLines[0]);

		/* do hydrogenic species */
		/* >>chng 02 may 16, bring two loops together */
		for( ipISO=ipH_LIKE; ipISO<NISO; ++ipISO )
		{
			for( nelem=ipISO; nelem < LIMELM; nelem++ )
			{
				if( dense.lgElmtOn[nelem] )
				{
					for( ipHi=1; ipHi < iso.numLevels_max[ipISO][nelem]; ipHi++ )
					{
						for( ipLo=0; ipLo < ipHi; ipLo++ )
						{
							prme(" c",&EmisLines[ipISO][nelem][ipHi][ipLo]);
						}
					}
				}
			}
		}

		/* print main lines optical depths */
		for( i=1; i <= nLevel1; i++ )
		{
			prme(" c",&TauLines[i]);
		}

		for( i=0; i < nWindLine; i++ )
		{
			if( TauLine2[i].IonStg < TauLine2[i].nelem+1-NISO )
			{
				prme(" c",&TauLine2[i]);
			}
		}

		for( i=0; i < nUTA; i++ )
		{
			if( UTALines[i].Aul > 0. )
				prme(" c",&UTALines[i]);
		}

		/* print H2 line optical depths */
		H2_Prt_line_tau();

		for( i=0; i < nCORotate; i++ )
		{
			prme(" c",&C12O16Rotate[i]);
		}

		for( i=0; i < nCORotate; i++ )
		{
			prme(" c",&C13O16Rotate[i]);
		}

		for( i=0; i < nHFLines; i++ )
		{
			prme(" c",&HFLines[i]);
		}

		/* this means print it */
		prme("  ",&TauLines[0]);
	}

#	ifdef DEBUG_FUN
	fputs( " <->prtmet()\n", debug_fp );
#	endif
	return;
}

/*prme print heavy element line optical depths at end of calculation */
#define	NLIM	6

/******************************************************************************
 *
 * prme - the helper routine for above 
 *
 ******************************************************************************/

void prme(
  const char *chDoIt, 
  EmLine * t)
{
	/* char chLabel[3]; */
	static char chLsav[NLIM][11];
	long int i;
	static long int n;
	/*lint -e785 too few init for aggregate */
	static float tsav[NLIM] = {0.};
	/*lint +e785 too few init for aggregate */

#	ifdef DEBUG_FUN
	fputs( "<+>prme()\n", debug_fp );
#	endif

	/* this routine is called by prtmet, and is used to print out
	 * line optical depths after model complete - it IS NOT a
	 * timing pace setter */

	/* label for line */
	/* strcpy( chLabel, elementnames.chElementSym[ t->nelem -1] ); */

	if( strcmp(chDoIt,"In") == 0 )
	{
		n = 0;

	}
	else if( strcmp(chDoIt,"  ") == 0 )
	{
		/* NB number in following statement must agree with nlim */
		fprintf( ioQQQ, "   " );
		for( i=0; i < n; i++ )
		{
			fprintf( ioQQQ, "%10.10s",chLsav[i]);
			fprintf( ioQQQ,PrintEfmt("%9.2e", tsav[i] ));
			fprintf( ioQQQ, " ");
		}
		fprintf( ioQQQ, " \n" );

	}
	/* print optical depth if greater than lower limit, or significantly negative */
	else if( t->TauIn > prt.PrtTauFnt || t->TauIn < -1e-5 )
	{
		/* t->t(ipLnTauIn) is the optical depth
		 * PrtTauFnt is threshold for printing it */
		if( n >= NLIM )
		{
			/* NB number in following statement must agree with nlim */
			fprintf( ioQQQ, "   " );
			for( i=0; i < NLIM; i++ )
			{
				fprintf( ioQQQ, "%10.10s",chLsav[i]);
				fprintf( ioQQQ,PrintEfmt("%9.2e", tsav[i] ));
				fprintf( ioQQQ, " ");
			}
			fprintf( ioQQQ, " \n" );
			n = 0;
		}

		strcpy( chLsav[n], chLineLbl(t) );
		tsav[n] = t->TauIn;
		++n;
	}

#	ifdef DEBUG_FUN
	fputs( " <->prme()\n", debug_fp );
#	endif
	return;
}
