/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* phycon.h */
EXTERN struct t_phycon {

	/*te, electron temperature K */
	double te;

	/* the current electron temperature in eV */
	double te_eV;

	/* the current electron temperature in Ryd */
	double te_ryd;

	/* the current electron temperature in wavenumbers */
	double te_wn;

	/* 1/TE */
	double teinv;

	/* T^2 */
	double tesqrd;

	/* total ionization energy of gas, erg/cm^3, evaluated in PressureTotal,
	 * this is the amount of energy needed to go from pure atoms to the current
	 * ionization of the gas. */
	double EnergyIonization;

	/* the total internal energy of atoms and molecules within the gas, erg/cm^3.  This is
	 * the amount of energy to excite the current level populations from the ground.
	 * this includes electronic excitations of atoms and rotation excitations of molecules 
	 */
	double EnergyExcitation;

	/* the enthalpy per unit vol, updated with pressure updated */
	double EnthalpyDensity;

	/* this is the total binding energy of the molecules, and is negative, the energy
	 * need to get back to free atoms */
	double EnergyBinding;

	/* these are simple powers of the electron temperature, are
	 * evaluated in tfidle, and can be used to avoid exponentials*/
	double sqrte, 
	  te32, 
	  te90, 
	  te70, 
	  te40, 
	  te30, 
	  te20, 
	  te10, 
	  te07,
	  te05, 
	  te04, 
	  te03, 
	  te02, 
	  te01, 
	  te007, 
	  te005, 
	  te004, 
	  te003, 
	  te002, 
	  te001;
	/*1 is log Te, 2 is (log T)^2, etc*/
	double telogn[7] ,
		/* this is used to rescale telogn array for other charge,
		 * ith element is log(i+1)^(i+1)*/
		sqlogz[LIMELM];

	/* alogte is base 10 log of temperature */
	double alogte;

	double 
	  /* inital temperature */
	  TeInit, 
	  /* proposed temperature */
	  TeProp,
	  /* inital electron density */
	  EdenInit ,
	  /* proposed electron density */
	  EdenProp ;

	/* energy density temperature */
	double TEnerDen;

	/* lag set if a physical condition has been disabled */
	int lgPhysOK;

	/* largest relative changes in Te, ne, H+, H2, and CO in structure
	 * this is computed as part of prtcomment so does not exist when code not talking,
	 * set to zero in zero and still zero if prtcomment not called */
	float BigJumpTe , BigJumpne , BigJumpH2 , BigJumpCO;

	}	phycon;

