/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseRatio derive continuum luminosity of this continuum relative to previous */
#include "cddefines.h"
#include "optimize.h"
#include "input.h"
#include "rfield.h"
#include "parse.h"
/* HP cc cannot compile following except in -O1 mode */
#if defined(__HP_cc)
  #pragma OPT_LEVEL 1
#endif

void ParseRatio(char *chCard, 
  long int *nqh)
{
	int lgAoxOn, 
	  lgEOL;
	long int  i;
	double aox;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseRatio()\n", debug_fp );
#	endif

	/* enter a continuum luminosity as a ratio of
	 * nuFnu for this continuum relative to a previous continuum
	 * format; first number is ratio of second to first continuum
	 * second number is energy for this ratio
	 * if third numbewr on line, then 2nd number is energy of
	 * first continuum, while 3rd number is energy of second continuum */

	if( *nqh == 0 )
	{
		fprintf( ioQQQ, " Can\'t form ratio since this is first continuum.\n" );
		puts( "[Stop in ParseRatio]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* per sq cm or luminosity is really irrelevant */
	strcpy( rfield.chRSpec[*nqh], "SQCM" );
	strcpy( rfield.chSpNorm[*nqh], "RATI" );

	/* this option is to specify alpha ox */
	if( lgMatch("ALPH",chCard) )
	{
		/* lgAoxOn is flag saying that we will spicify alpha ox */
		lgAoxOn = TRUE;
		/* only one parameter to be recognized, alpha ox */
		i = 5;
		aox = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* 403.3 is ratio of energies where alpha ox defined,
		 * assumed to be 2500A and 2keV */
		rfield.totpow[*nqh] = pow(403.3,aox);
		rfield.range[*nqh][0] = 0.3645;
		rfield.range[*nqh][1] = 147.;
	}

	else
	{
		/* set flag saying that alpha ox will not be specified */
		lgAoxOn = FALSE;
		/* set this to impossible number since not used, but lint needs a value */
		aox = -DBL_MAX;
		/* specify ratio, two energies */
		i = 5;
		rfield.totpow[*nqh] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* assumed to be a log if negative or zero */
		if( rfield.totpow[*nqh] <= 0. || lgMatch(" LOG",chCard ) )
		{
			rfield.totpow[*nqh] = pow(10.,rfield.totpow[*nqh]);
		}

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a number on this line.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(EXIT_FAILURE);
		}

		rfield.range[*nqh][0] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be at least 2 numbers on this line.\n" );
			fprintf( ioQQQ, " The ratio, and two energies\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(EXIT_FAILURE);
		}

		rfield.range[*nqh][1] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* if only one number then assume same for each */
		if( lgEOL )
		{
			rfield.range[*nqh][1] = rfield.range[*nqh][0];
		}

		if( rfield.range[*nqh][0] < rfield.emm || 
			 rfield.range[*nqh][1] < rfield.emm )
		{
			fprintf( ioQQQ, " One of the energies is too low, outside the range of the code.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(EXIT_FAILURE);
		}
		else if( rfield.range[*nqh][0] > rfield.egamry || rfield.range[*nqh][1] > 
		  rfield.egamry )
		{
			fprintf( ioQQQ, " One of the energies is too high, outside the range of the code.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* vary option */
	if( optimize.lgVarOn )
	{
		/* pointer to where to write */
		optimize.nvfpnt[optimize.nparm] = input.nRead;
		if( lgAoxOn )
		{
			/* this is the number of parameters to feed onto the input line */
			optimize.nvarxt[optimize.nparm] = 1;
			/* vary alpha ox */
			strcpy( optimize.chVarFmt[optimize.nparm], "RATIO alphox %f" );
			/* param is linear scale factor */
			optimize.vparm[0][optimize.nparm] = (float)aox;
			optimize.vincr[optimize.nparm] = 0.2f;
		}
		else
		{
			/* this is the number of parameters to feed onto the input line */
			optimize.nvarxt[optimize.nparm] = 3;
			strcpy( optimize.chVarFmt[optimize.nparm], "RATIO LOG %f %f %f" );
			/* param is log of abundance by number relative to hydrogen */
			optimize.vparm[0][optimize.nparm] = (float)log10(rfield.totpow[*nqh]);
			optimize.vparm[1][optimize.nparm] = (float)rfield.range[*nqh][0];
			optimize.vparm[2][optimize.nparm] = (float)rfield.range[*nqh][1];
			optimize.vincr[optimize.nparm] = 0.2f;
		}
		++optimize.nparm;
	}

	++*nqh;
	if( *nqh >= LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseRatio]" );
		cdEXIT(EXIT_FAILURE);
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseRatio()\n", debug_fp );
#	endif
	return;
}

