/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseRangeOption parse the range option on the luminosity command */
#include "cddefines.h"
#include "physconst.h"
#include "rfield.h"
#include "parse.h"

void ParseRangeOption(
	/* the number of continuum luminosity sources entered, on the c scale */
	long int nqh, 
	/* the input line image */
	char *chCard)
{
	int lgEOL;
	long int i;
	double p1, 
	  p2;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseRangeOption()\n", debug_fp );
#	endif

	if( lgMatch("TOTA",chCard) )
	{
		rfield.range[nqh][0] = rfield.emm;
		rfield.range[nqh][1] = rfield.egamry;
	}
	else if( lgMatch("RANG",chCard) )
	{
		i = 1;
		/* first call return the luminosity on the card, ignore it */
		p1 = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* this should be the lower limit */
		p1 = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( p1 == 0. )
			p1 = rfield.emm;

		p2 = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		/* no third numer on card then go all the way to gamma ray */
		if( p2 == 0. )
			p2 = rfield.egamry;

		/* option to enter log if first energy is neg */
		if( p1 < 0. || lgMatch(" LOG",chCard) )
		{
			p1 = pow(10.,p1);
			/* second number may not have been entered */
			if( !lgEOL )
				p2 = pow(10.,p2);
		}

		/* make sure that energies are within array bounds */
		rfield.range[nqh][0] = MAX2((float)p1,rfield.emm);
		rfield.range[nqh][1] = MIN2((float)p2,rfield.egamry);
		if( rfield.range[nqh][0] > rfield.range[nqh][1] )
		{
			fprintf( ioQQQ, " Range MUST be in increasing order - sorry.\n" );
			puts( "[Stop in ParseRangeOption]" );
			cdEXIT(EXIT_FAILURE);
		}
	}
	else
	{
		/* range not specified, use default - total ionizing field
		 * >>chng 96 dec 18, from 1.001 to 1 Ryd for H mass nuc */
		rfield.range[nqh][0] = HIONPOT;
		rfield.range[nqh][1] = rfield.egamry;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseRangeOption()\n", debug_fp );
#	endif
	return;
}

