/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseMetal parse parameters on metal command */
#include "cddefines.h"
#include "input.h"
#include "optimize.h"
#include "grainvar.h"
#include "called.h"
#include "abund.h"
#include "parse.h"

void ParseMetal(char *chCard )
{
	int lgEOL, 
	  lgGrains, 
	  lgLogOn;
	long int i;
	double dmlog;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseMetal()\n", debug_fp );
#	endif

	/* parse the metals command */

	/* metal depletion factor, if negative then it is the log */
	i = 5;
	abund.ScaleMetals = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		if( lgMatch("DEPL",chCard) )
		{
			/* this option - no numbers on line but keyword depletion is
			 * deplete by set of scale factors */
			abund.lgDepln = TRUE;
			for( i=0; i < LIMELM; i++ )
			{
				abund.depset[i] = abund.Depletion[i];
			}
			abund.ScaleMetals = 1.;
			
#			ifdef DEBUG_FUN
			fputs( " <->ParseMetal()\n", debug_fp );
#			endif
			return;
		}
		else
		{
			/* no number, so keyword, punch out */
			if( !called.lgTalk )
			{
				fprintf( ioQQQ, " %80.80s\n", chCard );
			}
			fprintf( ioQQQ, " There must be a number on this line.  Sorry.\n" );
			puts( "[Stop in ParseMetal]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* sort out whether log */
	lgLogOn = FALSE;
	if( lgMatch(" LOG",chCard) )
	{
		lgLogOn = TRUE;
	}
	else if( lgMatch("LINE",chCard) )
	{
		lgLogOn = FALSE;
	}

	if( abund.ScaleMetals <= 0. || lgLogOn )
	{
		dmlog = abund.ScaleMetals;
		abund.ScaleMetals = (float)pow(10.f,abund.ScaleMetals);
	}
	else
	{
		dmlog = log10(abund.ScaleMetals);
	}

	/* option to vary grain abundance as well */
	if( lgMatch("GRAI",chCard) )
	{
		lgGrains = TRUE;
		gv.GrainMetal = abund.ScaleMetals;
	}
	else
	{
		lgGrains = FALSE;
		gv.GrainMetal = 1.;
	}

	/* vary option */
	if( optimize.lgVarOn )
	{
		if( lgGrains )
		{
			strcpy( optimize.chVarFmt[optimize.nparm], "METALS LOG=%f GRAINS" );
		}
		else
		{
			strcpy( optimize.chVarFmt[optimize.nparm], "METALS LOG=%f" );
		}

		/* pointer to where to write */
		optimize.nvfpnt[optimize.nparm] = input.nRead;
		optimize.vparm[0][optimize.nparm] = (float)dmlog;
		optimize.vincr[optimize.nparm] = 0.5;
		optimize.nvarxt[optimize.nparm] = 1;
		++optimize.nparm;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseMetal()\n", debug_fp );
#	endif
	return;
}

