/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseDLaw parse parameters on the dlaw command */
#include "cddefines.h"
#include "dense.h"
#include "optimize.h"
#include "abund.h"
#include "input.h"
#include "parse.h"

void ParseDLaw(char *chCard )
{
	char chCAP[5];
	int lgEOL, 
	  lgEnd;
	long int i, 
	  j;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseDLaw()\n", debug_fp );
#	endif

	/* call fcn fabden(RADIUS) which uses the ten parameters
	 * N.B.; existing version of fabden must be deleted
	 * >>chng 96 nov 29, added table option */
	if( lgMatch("TABL",chCard) )
	{
		/* when called, read in densities from input stream */
		strcpy( dense.chDenseLaw, "DLW2" );
		if( lgMatch("DEPT",chCard) )
		{
			dense.lgDLWDepth = TRUE;
		}
		else
		{
			dense.lgDLWDepth = FALSE;
		}

		input_readarray(chCard,&lgEnd);
		i = 1;
		dense.frad[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		dense.fhden[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			fprintf( ioQQQ, " No pairs entered - can\'t interpolate.\n Sorry.\n" );
			puts( "[Stop in getdlaw]" );
			cdEXIT(EXIT_FAILURE);
		}

		dense.nvals = 2;
		lgEnd = FALSE;

		/* read pairs of numbers until we find line starting with END */
		/* >>chng 04 jan 27, loop to LIMTABDLAW from LIMTABD, as per
		 * var definitions, caught by Will Henney */
		while( !lgEnd && dense.nvals < LIMTABDLAW )
		{
			input_readarray(chCard,&lgEnd);
			if( !lgEnd )
			{
				cap4(chCAP , chCard);
				if( strncmp(chCAP , "END" , 3 ) == 0 )
					lgEnd = TRUE;
			}

			if( !lgEnd )
			{
				i = 1;
				dense.frad[dense.nvals-1] = (float)FFmtRead(chCard
				  ,&i,INPUT_LINE_LENGTH,&lgEOL);
				dense.fhden[dense.nvals-1] = (float)FFmtRead(chCard
				  ,&i,INPUT_LINE_LENGTH,&lgEOL);
				dense.nvals += 1;
			}
		}
		--dense.nvals;

		for( i=1; i < dense.nvals; i++ )
		{
			/* the radius values are assumed to be strictly increasing */
			if( dense.frad[i] <= dense.frad[i-1] )
			{
				fprintf( ioQQQ, " density.in radii must be in increasing order\n" );
				puts( "[Stop in getdlaw]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}
	else
	{
		/* this is usual case, call fabden to get density */
		i = 4;
		for( j=0; j < 10; j++ )
		{
			dense.DensityLaw[j] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		/* set flag so we know which law to use later */
		strcpy( dense.chDenseLaw, "DLW1" );

		/* vary option */
		if( optimize.lgVarOn )
		{
			/* NB - there are 5 = LIMEXT numbers on this line - if LIMEXT ever changes,
			 * chnage this too */
			strcpy( optimize.chVarFmt[optimize.nparm], "DLAW %f %f %f %f %f " );

			/* index for where to write */
			optimize.nvfpnt[optimize.nparm] = input.nRead;
			for( j=0; j<LIMEXT; ++j )
			{
				optimize.vparm[j][optimize.nparm] = (float)dense.DensityLaw[j];
			}
			optimize.vincr[optimize.nparm] = 0.5;
			optimize.nvarxt[optimize.nparm] = LIMEXT;
			++optimize.nparm;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseDLaw()\n", debug_fp );
#	endif
	return;
}
