/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseCoronal parse parameters off coronal equilibrium command */
#include "cddefines.h"
#include "rfield.h"
#include "thermal.h"
#include "radius.h"
#include "stopcalc.h"
#include "parse.h"

/*ParseCoronal parse parameters off coronal equilibrium command */
void ParseCoronal(char *chCard,
  long int *nqh, 
  float *ar1)
{
	int lgEOL;
	long int i;
	double a;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseCoronal()\n", debug_fp );
#	endif

	/* coronal equilibrium; set constant temperature to number on line */
	thermal.lgTSetOn = TRUE;
	i = 5;
	a = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		fprintf( ioQQQ, " There should be a temperature on this line.\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* numbers less than or equal to 10 are the log of the temperature */
	if( a <= 10. && !lgMatch("LINE",chCard) )
	{
		thermal.ConstTemp = (float)pow(10.,a);
	}
	else
	{
		thermal.ConstTemp = (float)a;
	}

	/* insure not below lowest allowed temperature for the code */
	if( thermal.ConstTemp < StopCalc.TeLowest )
	{
		fprintf( ioQQQ, " temperature on coronal command cannot be below %.3f, reset to 3K.\n",
			StopCalc.TeLowest);
		thermal.ConstTemp = 3.;
	}
	else if( thermal.ConstTemp > StopCalc.TeHighest )
	{
		fprintf( ioQQQ, " temperature on coronal command cannot be above %.3f, reset to 3e9K.\n",
			StopCalc.TeHighest);
		thermal.ConstTemp = 3e9;
	}

	/* now simulate a BREMS line */
	strcpy( rfield.chSpType[rfield.nspec], "BREMS" );
	rfield.slope[rfield.nspec] = 1e8;
	rfield.cutoff[rfield.nspec][0] = 0.;
	rfield.cutoff[rfield.nspec][1] = 0.;

	/* simulate an ionization parameter line */
	strcpy( rfield.chRSpec[*nqh], "SQCM" );
	strcpy( rfield.chSpNorm[*nqh], "IONI" );

	/* >>chng 96 jun 17, to stop mole network from crashing */
	/* >>chng 05 aug 15, this sets ionization parameter, in test case ism_hot_brems the
	 * value of 1e-10 was enough to dominate the ionization of he-like N - it's ionization
	 * then jumped due to large optical depth in the continuum - change U from -10 to -15 */
	/* >>chng 05 aug 16, this very strongly affected the coll_t4 sim - apparently there
	 * was a significant photoionization contribution from the -10 continuum,
	 * this was close to a 'no photoionization' case, but lower further to insure
	 * no photo contribution 
	 * chang from -15 to -20 */
	rfield.totpow[*nqh] = -20.f;

	/* set R to large value if U specified but R is not */
	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.,radius.rdfalt);
	}

	++rfield.nspec;
	if( rfield.nspec >= LIMSPC )
	{
		/* too many continua were entered */
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(EXIT_FAILURE);
	}
	++*nqh;
	if( *nqh >= LIMSPC )
	{
		/* too many continua were entered */
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseCoronal()\n", debug_fp );
#	endif
	return;
}

