/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ParseCMB parse parameters from fireball command */
#include "cddefines.h"
#include "radius.h"
#include "rfield.h"
#include "parse.h"

void ParseCMB(double z, 
  long int *nqh, 
  float *ar1)
{
	double a, 
	  rlogl;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseCMB()\n", debug_fp );
#	endif

	/* check that stack of shape and luminosity specifications
	 * is parallel, stop if not - this happens is background comes
	 * BETWEEN another set of shape and luminosity commands */
	if( rfield.nspec != *nqh )
	{
		fprintf( ioQQQ, " This command has come between a previous ordered pair of continuum shape and luminosity commands.\n Reorder the commands to complete each continuum specification before starting another.\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ParseCMB]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* put in a black body */
	strcpy( rfield.chSpType[rfield.nspec], "BLACK" );
	/* >>chng 03 may 23, CMB temp from 2.756 to 2.725 */
	rfield.slope[rfield.nspec] = (CMB_TEMP*(1. + z));
	rfield.cutoff[rfield.nspec][0] = 0.;
	rfield.cutoff[rfield.nspec][1] = 0.;
	strcpy( rfield.chSpNorm[*nqh], "LUMI" );
	a = log10(rfield.slope[rfield.nspec]);
	rlogl = log10(2.99792e10*7.56464e-15) + 4.*a;
	strcpy( rfield.chRSpec[*nqh], "SQCM" );
	rfield.range[*nqh][0] = rfield.emm;
	rfield.range[*nqh][1] = rfield.egamry;
	rfield.totpow[*nqh] = rlogl;

	/* set radius to very large value if not already set */
	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.,radius.rdfalt);
	}

	++rfield.nspec;
	++*nqh;
	if( *nqh >= LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseCMB]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* this flag says that CMB has been set */
	rfield.lgCMB_set = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->ParseCMB()\n", debug_fp );
#	endif
	return;
}

