/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CO_step fills in matrix for heavy elements molecular routines */
#include "cddefines.h"
#include "secondaries.h"
#include "dense.h"
#include "ionbal.h"
#include "hmi.h"
#include "rfield.h"
#include "phycon.h"
#include "doppvel.h"
#include "rt.h"
#include "mole.h"
/* Nick Abel between July and October of 2003 assisted Dr. Ferland in improving the heavy element 
 * molecular network in Cloudy. Before this routine would predict negative abundances if 
 * the fraction of carbon in the form of molecules came close to 100%. A reorganizing of 
 * the reaction network detected several bugs.  Treatment of "coupled reactions",
 * in which both densities in the reaction rate were being predicted by Cloudy, were also 
 * added.  Due to these improvements, Cloudy can now perform calculations
 * where 100% of the carbon is in the form of CO without predicting negative abundances
 *
 * Additional changes were made in November of 2003 so that our reaction 
 * network would include all reactions from the TH85 paper.  This involved 
 * adding silicon to the chemical network.  Also the reaction rates were
 * labeled to make identification with the reaction easier and the matrix 
 * elements of atomic C, O, and Si are now done in a loop, which makes 
 * the addition of future chemical species (like N or S) easy.
 * */
/*lint -e778 constant expression evaluatess to 0 in operation '-' */
/*=================================================================*/

/*CO_step fills in matrix for heavy elements molecular routines */
void CO_monox(void )
{

	int ns, ion;

	double 
	H2O_C3HP_CO_C2H3P_1,
	H2O_C3HP_CO_C2H3P_2,
	b_H2O_C3HP_CO_C2H3P,
	C2H2_HCOP_CO_C2H3P_1,
	C2H2_HCOP_CO_C2H3P_2,
	b_C2H2_HCOP_CO_C2H3P,
	C2H_HCOP_CO_C2H2P_1,
	C2H_HCOP_CO_C2H2P_2,
	b_C2H_HCOP_CO_C2H2P,
	O_C3H_CO_C2H_1,
	O_C3H_CO_C2H_2,
	b_O_C3H_CO_C2H,
	O_C2H2_CO_CH2_1,
	O_C2H2_CO_CH2_2,
	b_O_C2H2_CO_CH2,
	OH_C2H2_CO_CH3_1,
	OH_C2H2_CO_CH3_2,
	b_OH_C2H2_CO_CH3,
	HCOP_C3_C3HP_CO_1,
	HCOP_C3_C3HP_CO_2,
	b_HCOP_C3_C3HP_CO,
	O2_C3_CO_C2_O_1,
	O2_C3_CO_C2_O_2,
	b_O2_C3_CO_C2_O,
	O_C3_CO_C2_1,
	O_C3_CO_C2_2,
	b_O_C3_CO_C2,
	C_COP_CO_CP_1,
	C_HCOP_CO_CHP_1,
	C_O_CO_nu_1,
	C_O2_CO_O_1,
	C_OH_CO_H_1,
	C_SiOP_SiP_CO_1,
	CP_OH_CO_HP_1,
	CP_SiO_SiP_CO_1,
	CP_O2_CO_OP_1,
	O_CH_CO_H_1,
	O_CH2_CO_H_H_1,
	O_CH2_CO_H2_1,
	O_COP_CO_OP_1,
	OP_CO_COP_O_1,
	CH_COP_CO_CHP_1,
	CH_HCOP_CO_CH2P_1,
	CH_O2_CO_OH_1,
	CH2_COP_CO_CH2P_1,
	CH2_HCOP_CO_CH3P_1,
	CH2_O2_CO_H2O_1,
	COP_O2_O2P_CO_1,
	H2O_COP_CO_H2OP_1,
	H2O_HCOP_CO_H3OP_1,
	H2OP_CO_HCOP_OH_1,
	HCOP_SiH_SiH2P_CO_1,
	HCOP_SiO_SiOHP_CO_1,
	OH_COP_CO_OHP_1,
	OH_HCOP_CO_H2OP_1,
	OHP_CO_HCOP_O_1,
	C_COP_CO_CP_2,
	C_HCOP_CO_CHP_2,
	C_O_CO_nu_2,
	C_O2_CO_O_2,
	C_OH_CO_H_2,
	C_SiOP_SiP_CO_2,
	CP_OH_CO_HP_2,
	CP_SiO_SiP_CO_2,
	CP_O2_CO_OP_2,
	O_CH_CO_H_2,
	O_CH2_CO_H_H_2,
	O_CH2_CO_H2_2,
	O_COP_CO_OP_2,
	OP_CO_COP_O_2,
	CH_COP_CO_CHP_2,
	CH_HCOP_CO_CH2P_2,
	CH_O2_CO_OH_2,
	CH2_COP_CO_CH2P_2,
	CH2_HCOP_CO_CH3P_2,
	CH2_O2_CO_H2O_2,
	COP_O2_O2P_CO_2,
	H2O_COP_CO_H2OP_2,
	H2O_HCOP_CO_H3OP_2,
	H2OP_CO_HCOP_OH_2,
	HCOP_SiH_SiH2P_CO_2,
	HCOP_SiO_SiOHP_CO_2,
	OH_COP_CO_OHP_2,
	OH_HCOP_CO_H2OP_2,
	OHP_CO_HCOP_O_2,
	H_COP_CO_HP,
	Hminus_HCOP_CO_H2,
	H2P_CO_HCOP_H,
	H2P_CO_COP_H2,
	H3P_CO_HCOP_H2,
	HeP_CO_OP_C_He,
	HeP_CO_O_CP_He,
	crnu_CO_O_C,
	CRP_CO_COP_e,
	nu_CO_O_C,
	e_HCOP_CO_H,
	co_e_c_o_e,
	COP_CH4_CO_CH4P_1, 
	COP_CH4_CO_CH4P_2, 
	CO_CH4P_HCOP_CH3_1, 
	CO_CH4P_HCOP_CH3_2, 
	CO_CH5P_HCOP_CH4_1, 
	CO_CH5P_HCOP_CH4_2, 
	P_OP_CO,
	P_H2OP_CO,
	P_OHP_CO,
	P_CO_CH4P,
	P_CO_CH5P,
	b_C_COP_CO_CP,
	b_C_HCOP_CO_CHP,
	b_C_O_CO_nu,
	b_C_O2_CO_O,
	b_C_OH_CO_H,
	b_C_SiOP_SiP_CO,
	b_CP_OH_CO_HP,
	b_CP_SiO_SiP_CO,
	b_CP_O2_CO_OP,
	b_O_CH_CO_H,
	b_O_CH2_CO_H_H,
	b_O_CH2_CO_H2,
	b_O_COP_CO_OP,
	b_OP_CO_COP_O,
	b_CH_COP_CO_CHP,
	b_CH_HCOP_CO_CH2P,
	b_CH_O2_CO_OH,
	b_CH2_COP_CO_CH2P,
	b_CH2_HCOP_CO_CH3P,
	b_CH2_O2_CO_H2O,
	b_COP_O2_O2P_CO,
	b_H2O_COP_CO_H2OP,
	b_H2O_HCOP_CO_H3OP,
	b_H2OP_CO_HCOP_OH,
	b_HCOP_SiH_SiH2P_CO,
	b_HCOP_SiO_SiOHP_CO,
	b_OH_COP_CO_OHP,
	b_OH_HCOP_CO_H2OP,
	b_OHP_CO_HCOP_O,
	b_COP_CH4_CO_CH4P,
	b_CO_CH4P_HCOP_CH3,
	b_CO_CH5P_HCOP_CH4,
	esc_co,
	C_NO_CO_N_1,     
	C_OCN_CO_CN_1, 
	C_SO_S_CO_1,   
	O_CN_CO_N_1,       
	O_HCN_CO_NH_1,     
	O_OCN_NO_CO_1,
	O_CS_S_CO_1,  
	O_OCS_SO_CO_1,
	OH_HCN_CO_NH2_1,   
	CN_NO_N2_CO_1,     
	CN_O2_NO_CO_1,     
	CO_HS_OCS_H_1,     
	CP_SO_SP_CO_1,     
	CP_OCS_CSP_CO_1,   
	CHP_OCS_HCSP_CO_1, 
	NP_CO_NOP_C_1,     
	NP_OCS_SP_CO_N_1, 
	NHP_CO_HCOP_N_1,      
	NHP_CO_OCNP_H_1,      
	NH_HCOP_CO_NH2P_1,    
	NH2_HCOP_CO_NH3P_1,  
	NH3_HCOP_CO_NH4P_1,   
	CNP_O2_NOP_CO_1,      
	HCNP_CO_HCOP_CN_1,    
	CO_HNOP_NO_HCOP_1,    
	N2P_OCS_SP_N2_CO_1,   
	HCOP_S_HSP_CO_1,      
	HCOP_CS_HCSP_CO_1,    
	NH_COP_CO_NHP_1,    
	NH2_COP_CO_NH2P_1,    
	NH3_COP_CO_NH3P_1,    
	CNP_CO_COP_CN_1,      
	HCN_COP_CO_HCNP_1,    
	CO_N2P_N2_COP_1,      
	COP_NO_NOP_CO_1,      
	CO_S_OCS_NU_1,        
	NP_CO_COP_N_1,        
	COP_S_SP_CO_1,        
	C_NO_CO_N_2,     
	C_OCN_CO_CN_2, 
	C_SO_S_CO_2,   
	O_CN_CO_N_2,       
	O_HCN_CO_NH_2,     
	O_OCN_NO_CO_2,
	O_CS_S_CO_2,  
	O_OCS_SO_CO_2,
	OH_HCN_CO_NH2_2,   
	CN_NO_N2_CO_2,     
	CN_O2_NO_CO_2,     
	CO_HS_OCS_H_2,     
	CP_SO_SP_CO_2,     
	CP_OCS_CSP_CO_2,   
	CHP_OCS_HCSP_CO_2, 
	NP_CO_NOP_C_2,     
	NP_OCS_SP_CO_N_2, 
	NHP_CO_HCOP_N_2,      
	NHP_CO_OCNP_H_2,      
	NH_HCOP_CO_NH2P_2,    
	NH2_HCOP_CO_NH3P_2,  
	NH3_HCOP_CO_NH4P_2,   
	CNP_O2_NOP_CO_2,      
	HCNP_CO_HCOP_CN_2,    
	CO_HNOP_NO_HCOP_2,    
	N2P_OCS_SP_N2_CO_2,   
	HCOP_S_HSP_CO_2,      
	HCOP_CS_HCSP_CO_2,    
	NH_COP_CO_NHP_2,    
	NH2_COP_CO_NH2P_2,    
	NH3_COP_CO_NH3P_2,    
	CNP_CO_COP_CN_2,      
	HCN_COP_CO_HCNP_2,    
	CO_N2P_N2_COP_2,      
	COP_NO_NOP_CO_2,      
	CO_S_OCS_NU_2,        
	NP_CO_COP_N_2,        
	COP_S_SP_CO_2,        
	HP_OCS_HSP_CO       ,
	HeP_OCS_SP_CO_He,
	OCNP_e_CO_N   ,
	OCSP_e_S_CO   ,
	OCS_NU_S_CO   ,
	OCS_CRP_S_CO      ,
	b_C_NO_CO_N , 
	b_C_OCN_CO_CN , 
	b_C_SO_S_CO ,   
	b_O_CN_CO_N ,       
	b_O_HCN_CO_NH ,     
	b_O_OCN_NO_CO ,
	b_O_CS_S_CO ,  
	b_O_OCS_SO_CO ,
	b_OH_HCN_CO_NH2 ,   
	b_CN_NO_N2_CO ,     
	b_CN_O2_NO_CO ,     
	b_CO_HS_OCS_H ,     
	b_CP_SO_SP_CO ,     
	b_CP_OCS_CSP_CO ,   
	b_CHP_OCS_HCSP_CO , 
	b_NP_CO_NOP_C ,     
	b_NP_OCS_SP_CO_N , 
	b_NHP_CO_HCOP_N ,      
	b_NHP_CO_OCNP_H ,      
	b_NH_HCOP_CO_NH2P ,    
	b_NH2_HCOP_CO_NH3P ,  
	b_NH3_HCOP_CO_NH4P ,   
	b_CNP_O2_NOP_CO ,      
	b_HCNP_CO_HCOP_CN ,    
	b_CO_HNOP_NO_HCOP ,    
	b_N2P_OCS_SP_N2_CO ,   
	b_HCOP_S_HSP_CO ,      
	b_HCOP_CS_HCSP_CO ,    
	b_NH_COP_CO_NHP ,    
	b_NH2_COP_CO_NH2P ,    
	b_NH3_COP_CO_NH3P ,    
	b_CNP_CO_COP_CN ,      
	b_HCN_COP_CO_HCNP ,    
	b_CO_N2P_N2_COP ,      
	b_COP_NO_NOP_CO ,      
	b_CO_S_OCS_NU ,        
	b_NP_CO_COP_N ,        
	b_COP_S_SP_CO ,        
	b_C_CO_C2_O,
	b_O_C2_CO_C,
	b_C2_O2_CO_CO,
	b_C2_O2P_COP_CO,
	b_C2_COP_CO_C2P,
	b_C2P_O2_COP_CO,
	b_O_C2H_CO_CH,
	P_H2O_C3HP,
	P_C2H2_HCOP,
	P_C2H_HCOP,
	P_O_C3H,
	P_O_C2H2,
	P_OH_C2H2,
	P_HCOP_C3,
	P_O_C2H,
	P_CO_HS       ,     
	P_NP_CO       , 
	P_NHP_CO       ,     
	P_HCNP_CO       , 
	P_CO_HNOP       ,        
	P_CNP_CO       ,     
	P_CO_N2P       ,    
	P_CO_S       ,   
	P_C_CO,
	P_C_COP,
	P_C_HCOP,
	P_C_O ,
	P_C_O2,
	P_C_OH,
	P_C_SiOP ,
	P_CP_OH ,
	P_CP_SiO ,
	P_CP_O2 ,
	P_O_CH,
	P_O_CH2 ,
	P_O_COP ,
	P_CH_COP ,
	P_CH_HCOP ,
	P_CH_O2 ,
	P_CH2_COP ,
	P_CH2_HCOP,
	P_CH2_O2 ,
	P_COP_O2 ,
	P_H2O_COP ,
	P_H2O_HCOP ,
	P_HCOP_SiH ,
	P_HCOP_SiO ,
	P_OH_COP ,
	P_COP_CH4 ,
	P_C2_HCOP,
	P_C2H_COP,
	P_O_C2 ,
	P_C2_O2 ,
	P_C2_O2P ,
	P_C2_COP ,
	P_C2P_O2 ,
	P_C_NO ,
	P_C_OCN ,
	P_C_SO ,
	P_OH_HCOP,
    P_O_CN ,
    P_O_HCN ,
    P_O_OCN  ,
    P_O_CS ,
    P_O_OCS ,
    P_OH_HCN , 
    P_CN_NO ,
    P_CN_O2 ,
    P_CP_SO ,
    P_CP_OCS ,
    P_CHP_OCS ,
    P_NP_OCS ,
    P_NH_HCOP, 
    P_NH2_HCOP ,  
    P_NH3_HCOP, 
    P_CNP_O2 ,
    P_N2P_OCS ,
    P_HCOP_S ,
    P_HCOP_CS , 
    P_NH_COP ,
    P_NH2_COP ,
    P_NH3_COP ,
    P_HCN_COP,
    P_COP_NO ,
    P_COP_S ,
    P_O_CCl ,
    P_HNC_HCOP ,  
    P_HCN_HCOP ,
	P_O2_C3,
	P_O_C3,
	C_CO_C2_O_1,
	O_C2_CO_C_1,
	C2_O2_CO_CO_1,
	C2_O2P_COP_CO_1,
	C2_COP_CO_C2P_1,
	C2P_O2_COP_CO_1,
	C_CO_C2_O_2,
	O_C2_CO_C_2,
	C2_O2_CO_CO_2,
	C2_O2P_COP_CO_2,
	C2_COP_CO_C2P_2,
	C2P_O2_COP_CO_2,
	O_CCl_Cl_CO_1,
	CO_H2ClP_HCl_HCOP_1,
	O_CCl_Cl_CO_2,
	CO_H2ClP_HCl_HCOP_2,
	b_O_CCl_Cl_CO,
	b_CO_H2ClP_HCl_HCOP,
	P_CO_H2ClP,
	HNC_HCOP_HCNHP_CO_1  ,
	HNC_HCOP_HCNHP_CO_2  ,
	HCN_HCOP_HCNHP_CO_1  ,
	HCN_HCOP_HCNHP_CO_2  ,
	b_HNC_HCOP_HCNHP_CO  ,
	b_HCN_HCOP_HCNHP_CO  ,
	O_C2H_CO_CH_1,
	O_C2H_CO_CH_2,
	C2H_COP_CO_C2HP_1,
	C2H_COP_CO_C2HP_2,
	b_C2H_COP_CO_C2HP,
	C2_HCOP_CO_C2HP_1,
	C2_HCOP_CO_C2HP_2,
	b_C2_HCOP_CO_C2HP,
	HeII, HII, HI, H2p, H3p, ele,CH,
	CHP,OH,OHP,O2,CO,COP,H2O,H2OP,O2P,
	CH2,HCOP,SIH, 
	SIO,SIOP,CH4,CH4P,CH5P,
	N2P,NO,OCN,NH,
	NHP,NH2,NH3,CN,
	CNP,HCN,HCNP,
	HNOP,HS,CS,
	SO,OCS,C2,C2P,CP,OP,NP,ATC,ATO, 
	ATS,crnu_rate, TH85_field,  Hm,
	CCl,H2ClP, HNC, C2H, C2HP, C3,
	C2H2, C2H2P, C3HP, C3H, C2H3P;

	C2H3P = co.hevmol[ipC2H3P];
	CH	= co.hevmol[ipCH];
	CHP	= co.hevmol[ipCHP];
	OH	= co.hevmol[ipOH];
	OHP	= co.hevmol[ipOHP];
	O2  = co.hevmol[ipO2];
	CO	= co.hevmol[ipCO];
	COP	= co.hevmol[ipCOP];
	H2O	= co.hevmol[ipH2O];
	H2OP = co.hevmol[ipH2OP];
	O2P	= co.hevmol[ipO2P];
	CH2 = co.hevmol[ipCH2];
	HCOP = co.hevmol[ipHCOP];
	SIH   = co.hevmol[ipSIH];
	SIO   = co.hevmol[ipSIO];
	SIOP  = co.hevmol[ipSIOP];
	CH4   = co.hevmol[ipCH4];
	CH4P  = co.hevmol[ipCH4P];
	CH5P  = co.hevmol[ipCH5P];
	N2P	= co.hevmol[ipN2P];
	NO	= co.hevmol[ipNO];
	OCN	= co.hevmol[ipOCN];
	NH	= co.hevmol[ipNH];
	NHP	= co.hevmol[ipNHP];
	NH2	= co.hevmol[ipNH2];
	NH3 = co.hevmol[ipNH3];
	CN  = co.hevmol[ipCN];
	CNP = co.hevmol[ipCNP];
	HCN = co.hevmol[ipHCN];
	HCNP = co.hevmol[ipHCNP];
	HNOP = co.hevmol[ipHNOP];
	HS  = co.hevmol[ipHS];
	CS  = co.hevmol[ipCS];
	SO	= co.hevmol[ipSO];
	OCS	=co.hevmol[ipOCS];
	C2	= co.hevmol[ipC2];
	C2P	= co.hevmol[ipC2P];
	CP   = co.hevmol[ipCP];
	OP    = co.hevmol[ipOP];
	NP  = co.hevmol[ipNP];
	ATC = co.hevmol[ipATC];
	ATO = co.hevmol[ipATO];
	ATS = co.hevmol[ipATS];
	C2H = co.hevmol[ipC2H];
	HeII = dense.xIonDense[ipHELIUM][1];
	HII = dense.xIonDense[ipHYDROGEN][1];
	HI = dense.xIonDense[ipHYDROGEN][0];
	H2p = hmi.Hmolec[ipMH2p];
	H3p = hmi.Hmolec[ipMH3p];
	ele = dense.eden;
	crnu_rate = secondaries.csupra[ipHYDROGEN][0];
	TH85_field = hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f;
	Hm = hmi.Hmolec[ipMHm];
	CCl = co.hevmol[ipCCl];
	CCl = co.hevmol[ipCCl];
	H2ClP = co.hevmol[ipH2ClP];
	HNC = co.hevmol[ipHNC];
	C2HP = co.hevmol[ipC2HP];
	C3 = co.hevmol[ipC3];
	C2H2 = co.hevmol[ipC2H2];
	C2H2P = co.hevmol[ipC2H2P];
	C3H = co.hevmol[ipC3H];
	C3HP = co.hevmol[ipC3HP];

	/* >> chng aug 24, 05 NPA This is the cosmic ray ionization rate used in the molecular network.  TH85 and the e-mail from Amiel Sternberg has each cosmic ray ionization rate as a leading coefficient multiplied by a scale factor.
	The leading coefficient is defined as the cosmic ray rate for H + CR = > H+
	+ e- .  For molecules in the heavy element molecular network, this scale
	factor is derived by taking the rate for:
		X + CRPHOT => Y + Z 
		and dividing it by the rate:
		H + CRP => H+ + e-
	This scale factor is 2.17 for all cosmic ray reactions in this network */
	crnu_rate = 2.17*secondaries.csupra[ipHYDROGEN][0];
	
	P_H2O_C3HP = H2O*C3HP;
	P_C2H2_HCOP = C2H2*HCOP;
	P_C2H_HCOP = C2H*HCOP;
	P_O_C3H = ATO*C3H;
	P_O_C2H2 = ATO*C2H2;
	P_OH_C2H2 = OH*C2H2;
	P_HCOP_C3 = HCOP*C3;
	P_O2_C3 = O2*C3;
	P_O_C3 = ATO*C3;
	P_C2_HCOP = C2*HCOP;
	P_C2H_COP = C2H*COP;
	P_OP_CO = OP*CO;
	P_OHP_CO = OHP*CO;
	P_H2OP_CO = H2OP*CO;
	P_C_CO = ATC*CO;
	P_CO_CH4P = CO*CH4P;
	P_CO_CH5P = CO*CH5P;
	P_CO_HS = CO*HS;
	P_NP_CO = NP*CO;
	P_NHP_CO = NHP*CO;
	P_HCNP_CO = HCNP*CO;
	P_CO_HNOP = CO*HNOP;
	P_CNP_CO = CNP*CO;
	P_CO_N2P = CO*N2P;
	P_CO_S = CO*ATS;
	P_C_COP = ATC*COP;
	P_C_HCOP = ATC*HCOP;
	P_C_O = ATC*ATO;
	P_C_O2 = ATC*O2;
	P_C_OH = ATC*OH;
	P_C_SiOP = ATC*SIOP;
	P_CP_OH = CP*OH;
	P_CP_SiO = CP*SIO;
	P_CP_O2 = CP*O2;
	P_O_CH = ATO*CH;
	P_O_CH2 = ATO*CH2;
	P_O_COP = ATO*COP;
	P_CH_COP = CH*COP;
	P_CH_HCOP = CH*HCOP;
	P_CH_O2 = CH*O2;
	P_CH2_COP = CH2*COP;
	P_CH2_HCOP = CH2*HCOP;
	P_CH2_O2 = CH2*O2;
	P_COP_O2 = COP*O2;
	P_H2O_COP = H2O*COP;
	P_H2O_HCOP = H2O*HCOP;
	P_HCOP_SiH = HCOP*SIH;
	P_HCOP_SiO = HCOP*SIO;
	P_OH_COP = OH*COP;
	P_COP_CH4 = COP*CH4;
	P_O_C2 = ATO*C2;
	P_C2_O2 = C2*O2;
	P_C2_O2P = C2*O2P; 
	P_C2_COP = C2*COP;
	P_C2P_O2 = C2P*O2;
	P_C_NO = ATC*NO;
	P_C_OCN = ATC*OCN; 
	P_C_SO = ATC*SO;
    P_OH_HCOP  = OH*HCOP  ; 
    P_O_CN  = ATO*CN    ;
    P_O_HCN  =  ATO*HCN  ; 
    P_O_OCN  = ATO*OCN    ;
    P_O_CS  = ATO*CS    ;
    P_O_OCS  = ATO*OCS   ; 
    P_OH_HCN = OH*HCN   ;  
    P_CN_NO =  CN*NO    ;
    P_CN_O2 =  CN*O2    ;
    P_CP_SO = CP*SO      ;
    P_CP_OCS = CP*OCS     ;
    P_CHP_OCS =CHP*OCS     ; 
    P_NP_OCS = NP*OCS     ;
    P_NH_HCOP = NH*HCOP    ; 
    P_NH2_HCOP =NH2*HCOP    ;  
    P_NH3_HCOP =NH3*HCOP     ;  
    P_CNP_O2 = CNP*O2      ;
    P_N2P_OCS = N2P*OCS     ;
    P_HCOP_S =  HCOP*ATS     ;
    P_HCOP_CS = HCOP*CS     ; 
    P_NH_COP =  NH*COP    ;
    P_NH2_COP = NH2*COP    ;  
    P_NH3_COP = NH3*COP     ;
    P_HCN_COP = HCN*COP      ;
    P_COP_NO = COP*NO      ;
    P_COP_S = COP*ATS      ;
    P_O_CCl = ATO*CCl      ;
    P_HNC_HCOP = HNC*HCOP ;    
    P_HCN_HCOP = HCN*HCOP  ;   
	P_O_C2H = ATO*C2H;
	P_NP_CO = NP*CO;
	C_COP_CO_CP_1		    = HMRATE(1.1e-10,0,0)*ATC;
	C_HCOP_CO_CHP_1		    = HMRATE(1.1e-9,0,0)*ATC;
	C_O_CO_nu_1			    = HMRATE(2.1E-19,0,0)*ATC;
	C_O2_CO_O_1			    = HMRATE(3.3e-11,0,0)*ATC;
	C_OH_CO_H_1			    = HMRATE(1.1e-10,0.5,0)*ATC;
	C_SiOP_SiP_CO_1		    = HMRATE(1.0e-9,0,0)*ATC;

	/* >>chng 05 mar 20, NA, 
	 * The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	 * data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	 * an order of magnitude too small at 50 K compared with correct rate given by 
	 * >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	if(!co.lgUMISTrates)
	{
		CP_OH_CO_HP_1		    = HMRATE(7.7e-10,0,0)*CP;
	}

	else
	{
		CP_OH_CO_HP_1		    = HMRATE(2.7e-9,-0.3508,0)*CP;
	}

	CP_SiO_SiP_CO_1		    = HMRATE(5.4e-10,0,0)*CP;
	CP_O2_CO_OP_1		    = HMRATE(6.2e-10,0,0)*CP;
	O_CH_CO_H_1			    = HMRATE(6.6e-11,0,0)*ATO;
	O_CH2_CO_H_H_1		    = HMRATE((1e-10)*1.33,0,0)*ATO;
	O_CH2_CO_H2_1		    = HMRATE((1e-11)*8.,0,0)*ATO;
	O_COP_CO_OP_1		    = HMRATE((1e-10)*1.4,0,0)*ATO;
	OP_CO_COP_O_1		    = HMRATE((1e-12)*4.9,0.5,4580)*OP;
	CH_COP_CO_CHP_1		    = HMRATE((1e-10)*3.2,0,0)*CH;
	CH_HCOP_CO_CH2P_1	    = HMRATE((1e-10)*6.3,0,0)*CH;
	CH_O2_CO_OH_1		    = HMRATE((1e-11)*2.6,0,0)*CH;
	CH2_COP_CO_CH2P_1	    = HMRATE((1e-10)*4.3,0,0)*CH2;
	CH2_HCOP_CO_CH3P_1	    = HMRATE((1e-10)*8.6,0,0)*CH2;
	CH2_O2_CO_H2O_1		    = HMRATE((1e-10)*2.48,-3.3,1443)*CH2;
	COP_O2_O2P_CO_1		    = HMRATE((1e-10)*1.2,0,0)*COP;
	H2O_COP_CO_H2OP_1	    = HMRATE((1e-9)*1.72,0,0)*H2O;
	H2O_HCOP_CO_H3OP_1	    = HMRATE((1e-9)*2.5,0,0)*H2O;
	H2OP_CO_HCOP_OH_1	    = HMRATE(5.0e-10,0,0)*H2OP;
	HCOP_SiH_SiH2P_CO_1     = HMRATE((1e-10)*8.7,0,0)*HCOP;
	HCOP_SiO_SiOHP_CO_1     = HMRATE((1e-10)*7.9,0,0)*HCOP;
	OH_COP_CO_OHP_1		    = HMRATE((1e-10)*3.1,0,0)*OH;
	OH_HCOP_CO_H2OP_1	    = HMRATE(6.2e-10,0,0)*OH;
	OHP_CO_HCOP_O_1		    = HMRATE((1e-9)*1.05,0,0)*OHP;
	C_COP_CO_CP_2		    = HMRATE(1.1e-10,0,0)*COP;
	C_HCOP_CO_CHP_2		    = HMRATE(1.1e-9,0,0)*HCOP;
	C_O_CO_nu_2			    = HMRATE(2.1E-19,0,0)*ATO;
	C_O2_CO_O_2			    = HMRATE(3.3e-11,0,0)*O2;
	C_OH_CO_H_2			    = HMRATE(1.1e-10,0.5,0)*OH;
	C_SiOP_SiP_CO_2		    = HMRATE(1.0e-9,0,0)*SIOP;
	/* >>chng 05 mar 20, NA, 
     * The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	   data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	 * an order of magnitude too small at 50 K 
	 * >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	if(!co.lgUMISTrates)
	{
		CP_OH_CO_HP_2		    = HMRATE(7.7e-10,0,0)*OH;
	}

	else
	{
		CP_OH_CO_HP_2		    = HMRATE(2.7e-9,-0.3508,0)*OH;
	}
	CP_SiO_SiP_CO_2		    = HMRATE(5.4e-10,0,0)*SIO;
	CP_O2_CO_OP_2		    = HMRATE(6.2e-10,0,0)*O2;


	O_CH_CO_H_2			    = HMRATE(6.6e-11,0,0)*CH;
	O_CH2_CO_H_H_2		    = HMRATE((1e-10)*1.33,0,0)*CH2;
	O_CH2_CO_H2_2		    = HMRATE((1e-11)*8.,0,0)*CH2;
	O_COP_CO_OP_2		    = HMRATE((1e-10)*1.4,0,0)*COP;
	OP_CO_COP_O_2		    = HMRATE((1e-12)*4.9,0.5,4580)*CO;
	CH_COP_CO_CHP_2		    = HMRATE((1e-10)*3.2,0,0)*COP;
	CH_HCOP_CO_CH2P_2	    = HMRATE((1e-10)*6.3,0,0)*HCOP;
	CH_O2_CO_OH_2		    = HMRATE((1e-11)*2.6,0,0)*O2;
	CH2_COP_CO_CH2P_2	    = HMRATE((1e-10)*4.3,0,0)*COP;
	CH2_HCOP_CO_CH3P_2	    = HMRATE((1e-10)*8.6,0,0)*HCOP;
	CH2_O2_CO_H2O_2		    = HMRATE((1e-10)*2.48,-3.3,1443)*O2;
	COP_O2_O2P_CO_2		    = HMRATE((1e-10)*1.2,0,0)*O2;
	H2O_COP_CO_H2OP_2	    = HMRATE((1e-9)*1.72,0,0)*COP;
	H2O_HCOP_CO_H3OP_2	    = HMRATE((1e-9)*2.5,0,0)*HCOP;
	H2OP_CO_HCOP_OH_2	    = HMRATE(5.0e-10,0,0)*CO;
	HCOP_SiH_SiH2P_CO_2     = HMRATE((1e-10)*8.7,0,0)*SIH;
	HCOP_SiO_SiOHP_CO_2     = HMRATE((1e-10)*7.9,0,0)*SIO;
	OH_COP_CO_OHP_2		    = HMRATE((1e-10)*3.1,0,0)*COP;
	OH_HCOP_CO_H2OP_2	    = HMRATE(6.2e-10,0,0)*HCOP;
	OHP_CO_HCOP_O_2		    = HMRATE((1e-9)*1.05,0,0)*CO;
	COP_CH4_CO_CH4P_1	    = HMRATE((1e-10)*7.93,0,0)*CH4;
	COP_CH4_CO_CH4P_2	    = HMRATE((1e-10)*7.93,0,0)*COP;
	CO_CH4P_HCOP_CH3_1      = HMRATE((1e-9)*1.4,0,0)*CH4P;
	CO_CH4P_HCOP_CH3_2      = HMRATE((1e-9)*1.4,0,0)*CO;
	CO_CH5P_HCOP_CH4_1      = HMRATE(1.0e-9,0,0)*CH5P;
	CO_CH5P_HCOP_CH4_2      = HMRATE(1.0e-9,0,0)*CO;
	H_COP_CO_HP			    = HMRATE((1e-10)*7.5,0,0)*HI;
	Hminus_HCOP_CO_H2       = HMRATE(0.00000023,-0.5,0)*Hm;
	H2P_CO_HCOP_H           = HMRATE((1e-9)*2.16,0,0)*H2p;
	H2P_CO_COP_H2           = HMRATE((1e-10)*6.4,0,0)*H2p;
	H3P_CO_HCOP_H2          = HMRATE((1e-9)*1.7,0,0)*H3p;
	HeP_CO_OP_C_He          = HMRATE(0.00000000000000014,-0.5,0)*HeII;
	HeP_CO_O_CP_He          = HMRATE((1e-9)*1.6,0,0)*HeII;
	crnu_CO_O_C             = crnu_rate * 2. * 10;
	CRP_CO_COP_e            = 0.000000000000000039;
	nu_CO_O_C               = HMRATE(2.0e-10,0,0);
	e_HCOP_CO_H             = HMRATE(0.00000011,-1,0)*ele;
	b_C_COP_CO_CP	    = HMRATE(1.1e-10,0,0)*P_C_COP;
	b_C_HCOP_CO_CHP	    = HMRATE(1.1e-9,0,0)*P_C_HCOP;
	b_C_O_CO_nu		    = HMRATE(2.1E-19,0,0)*P_C_O;
	b_C_O2_CO_O		    = HMRATE(3.3e-11,0,0)*P_C_O2;
	b_C_OH_CO_H		    = HMRATE(1.1e-10,0.5,0)*P_C_OH;
	b_C_SiOP_SiP_CO	    = HMRATE(1.0e-9,0,0)*P_C_SiOP;
	/* >>chng 05 mar 20, NA, 
	 * The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	   data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */
	
	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	 * an order of magnitude too small at 50 K 
	 * >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	
	if(!co.lgUMISTrates)
	{
		b_CP_OH_CO_HP = HMRATE(7.7e-10,0,0)*P_CP_OH;
	}

	else
	{
		b_CP_OH_CO_HP = HMRATE(2.7e-9,-0.3508,0)*P_CP_OH;
	}
	b_CP_SiO_SiP_CO	    = HMRATE(5.4e-10,0,0)*P_CP_SiO;
	b_CP_O2_CO_OP	    = HMRATE(6.2e-10,0,0)*P_CP_O2;

	b_O_CH_CO_H		    = HMRATE(6.6e-11,0,0)*P_O_CH;
	b_O_CH2_CO_H_H	    = HMRATE((1e-10)*1.33,0,0)*P_O_CH2;
	b_O_CH2_CO_H2	    = HMRATE((1e-11)*8.,0,0)*P_O_CH2;
	b_O_COP_CO_OP	    = HMRATE((1e-10)*1.4,0,0)*P_O_COP;
	b_OP_CO_COP_O	    = HMRATE((1e-12)*4.9,0.5,4580)*P_OP_CO;
	b_CH_COP_CO_CHP	    = HMRATE((1e-10)*3.2,0,0)*P_CH_COP;
	b_CH_HCOP_CO_CH2P    = HMRATE((1e-10)*6.3,0,0)*P_CH_HCOP;
	b_CH_O2_CO_OH        = HMRATE((1e-11)*2.6,0,0)*P_CH_O2;
	b_CH2_COP_CO_CH2P    = HMRATE((1e-10)*4.3,0,0)*P_CH2_COP;
	b_CH2_HCOP_CO_CH3P   = HMRATE((1e-10)*8.6,0,0)*P_CH2_HCOP;
	b_CH2_O2_CO_H2O      = HMRATE((1e-10)*2.48,-3.3,1443)*P_CH2_O2;
	b_COP_O2_O2P_CO      = HMRATE((1e-10)*1.2,0,0)*P_COP_O2;
	b_H2O_COP_CO_H2OP    = HMRATE((1e-9)*1.72,0,0)*P_H2O_COP;
	b_H2O_HCOP_CO_H3OP   = HMRATE((1e-9)*2.5,0,0)*P_H2O_HCOP;
	b_H2OP_CO_HCOP_OH    = HMRATE(5.0e-10,0,0)*P_H2OP_CO;
	b_HCOP_SiH_SiH2P_CO  = HMRATE((1e-10)*8.7,0,0)*P_HCOP_SiH;
	b_HCOP_SiO_SiOHP_CO  = HMRATE((1e-10)*7.9,0,0)*P_HCOP_SiO;
	b_OH_COP_CO_OHP      = HMRATE((1e-10)*3.1,0,0)*P_OH_COP;
	b_OH_HCOP_CO_H2OP    = HMRATE(6.2e-10,0,0)*P_OH_HCOP;
	b_OHP_CO_HCOP_O      = HMRATE((1e-9)*1.05,0,0)*P_OHP_CO;
	b_COP_CH4_CO_CH4P    = HMRATE((1e-10)*7.93,0,0)*P_COP_CH4;
	b_CO_CH4P_HCOP_CH3   = HMRATE((1e-9)*1.4,0,0)*P_CO_CH4P;
	b_CO_CH5P_HCOP_CH4   = HMRATE(1.0e-9,0,0)*P_CO_CH5P;
	b_C_CO_C2_O = HMRATE(2.94e-11,0.5,58025)*P_C_CO;
	b_O_C2_CO_C = HMRATE((1e-11)*5.,0.5,0)*P_O_C2;
	b_C2_O2_CO_CO = HMRATE((1e-12)*1.83,0,0)*P_C2_O2;
	b_C2_O2P_COP_CO = HMRATE((1e-10)*4.1,0,0)*P_C2_O2P;
	b_C2_COP_CO_C2P = HMRATE((1e-10)*8.4,0,0)*P_C2_COP;
	b_C2P_O2_COP_CO = HMRATE((1e-10)*8.,0,0)*P_C2P_O2;
	C_CO_C2_O_1 = HMRATE(2.94e-11,0.5,58025)*CO;
	O_C2_CO_C_1 = HMRATE((1e-11)*5.,0.5,0)*C2;
	C2_O2_CO_CO_1 = HMRATE((1e-12)*1.83,0,0)*O2;
	C2_O2P_COP_CO_1 = HMRATE((1e-10)*4.1,0,0)*O2P;
	C2_COP_CO_C2P_1 = HMRATE((1e-10)*8.4,0,0)*COP;
	C2P_O2_COP_CO_1 = HMRATE((1e-10)*8.,0,0)*O2;
	C_CO_C2_O_2 = HMRATE(2.94e-11,0.5,58025)*ATC;
	O_C2_CO_C_2 = HMRATE((1e-11)*5.,0.5,0)*ATO;
	C2_O2_CO_CO_2 = HMRATE((1e-12)*1.83,0,0)*C2;
	C2_O2P_COP_CO_2 = HMRATE((1e-10)*4.1,0,0)*C2;
	C2_COP_CO_C2P_2 = HMRATE((1e-10)*8.4,0,0)*C2;
	C2P_O2_COP_CO_2 = HMRATE((1e-10)*8.,0,0)*C2P;

	if (!co.lgUMISTrates)
	{

		nu_CO_O_C               = HMRATE(2.0e-10,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(3.2*rfield.extin_mag_V_point))/1.66);;
	
	}
	/*  This is what will usually be done, calculating the photodissociation rate by calculating the UV
	 * radiation field self-consistently. */
	else
	{
		
		nu_CO_O_C               = HMRATE(2.0e-10,0,0)*(TH85_field);
	}
	C_NO_CO_N_1          = HMRATE((1e-11)*4.65,0,0)*ATC;
	C_OCN_CO_CN_1        = HMRATE(4.0e-11,0.5,0)*ATC;
	C_SO_S_CO_1          = HMRATE((1e-11)*7.2,0,0)*ATC;
	O_CN_CO_N_1          = HMRATE((1e-11)*4.36,0.46,364)*ATO;
	O_HCN_CO_NH_1        = HMRATE(0.00000000000073,1.14,3742)*ATO;
	O_OCN_NO_CO_1        = HMRATE((1e-11)*9.43,-0.09,100)*ATO;
	O_CS_S_CO_1          = HMRATE((1e-10)*2.48,-0.65,783)*ATO;
	O_OCS_SO_CO_1        = HMRATE((1e-11)*1.6,0,2150)*ATO;
	OH_HCN_CO_NH2_1      = HMRATE((1e-13)*1.07,0,5892)*OH;
	CN_NO_N2_CO_1        = HMRATE((1e-10)*1.79,0,4040)*CN;
	CN_O2_NO_CO_1        = HMRATE(0.00000000000053,0,0)*CN;
	CO_HS_OCS_H_1        = HMRATE(0.0000000000000595,1.12,8330)*CO;
	CP_SO_SP_CO_1        = HMRATE((1e-10)*2.6,0,0)*CP;
	CP_OCS_CSP_CO_1      = HMRATE((1e-9)*1.6,0,0)*CP;
	CHP_OCS_HCSP_CO_1    = HMRATE((1e-9)*1.05,0,0)*CHP;
	NP_CO_NOP_C_1        = HMRATE((1e-10)*1.45,0,0)*NP;
	NP_OCS_SP_CO_N_1     = HMRATE((1e-10)*3.08,0,0)*NP;
	NHP_CO_HCOP_N_1      = HMRATE((1e-10)*4.41,0,0)*NHP;
	NHP_CO_OCNP_H_1      = HMRATE((1e-10)*5.39,0,0)*NHP;
	NH_HCOP_CO_NH2P_1    = HMRATE((1e-10)*6.4,0,0)*NH;
	NH2_HCOP_CO_NH3P_1   = HMRATE((1e-10)*8.9,0,0)*NH2;
	NH3_HCOP_CO_NH4P_1   = HMRATE((1e-9)*2.2,0,0)*NH3;
	CNP_O2_NOP_CO_1      = HMRATE((1e-11)*8.6,0,0)*CNP;
	HCNP_CO_HCOP_CN_1    = HMRATE((1e-10)*1.4,0,0)*HCNP;
	CO_HNOP_NO_HCOP_1    = HMRATE(1.0e-10,0,0)*CO;
	N2P_OCS_SP_N2_CO_1   = HMRATE((1e-9)*1.04,0,0)*N2P;
	HCOP_S_HSP_CO_1      = HMRATE((1e-10)*3.3,0,0)*HCOP;
	HCOP_CS_HCSP_CO_1    = HMRATE(1.2e-9,0,0)*HCOP;
	NH_COP_CO_NHP_1      = HMRATE((1e-10)*3.2,0,0)*NH;
	NH2_COP_CO_NH2P_1    = HMRATE((1e-10)*4.5,0,0)*NH2;
	NH3_COP_CO_NH3P_1    = HMRATE((1e-9)*2.02,0,0)*NH3;
	CNP_CO_COP_CN_1      = HMRATE((1e-10)*6.3,0,0)*CNP;
	HCN_COP_CO_HCNP_1    = HMRATE((1e-9)*3.4,0,0)*HCN;
	CO_N2P_N2_COP_1      = HMRATE((1e-11)*7.4,0,0)*CO;
	COP_NO_NOP_CO_1      = HMRATE((1e-10)*3.3,0,0)*COP;
	CO_S_OCS_NU_1        = HMRATE((1e-17)*1.6,-1.5,0)*CO;
	NP_CO_COP_N_1        = HMRATE((1e-10)*8.25,0,0)*NP;
	COP_S_SP_CO_1        = HMRATE(1.1e-9,0,0)*COP;
	C_NO_CO_N_2        = HMRATE((1e-11)*4.65,0,0)*NO;
	C_OCN_CO_CN_2        = HMRATE(4.0e-11,0.5,0)*OCN;
	C_SO_S_CO_2          = HMRATE((1e-11)*7.2,0,0)*SO;
	O_CN_CO_N_2          = HMRATE((1e-11)*4.36,0.46,364)*CN;
	O_HCN_CO_NH_2        = HMRATE(0.00000000000073,1.14,3742)*HCN;
	O_OCN_NO_CO_2        = HMRATE((1e-11)*9.43,-0.09,100)*OCN;
	O_CS_S_CO_2          = HMRATE((1e-10)*2.48,-0.65,783)*CS;
	O_OCS_SO_CO_2        = HMRATE((1e-11)*1.6,0,2150)*OCS;
	OH_HCN_CO_NH2_2      = HMRATE((1e-13)*1.07,0,5892)*HCN;
	CN_NO_N2_CO_2        = HMRATE((1e-10)*1.79,0,4040)*NO;
	CN_O2_NO_CO_2        = HMRATE(0.00000000000053,0,0)*O2;
	CO_HS_OCS_H_2        = HMRATE(0.0000000000000595,1.12,8330)*HS;
	CP_SO_SP_CO_2        = HMRATE((1e-10)*2.6,0,0)*SO;
	CP_OCS_CSP_CO_2      = HMRATE((1e-9)*1.6,0,0)*OCS;
	CHP_OCS_HCSP_CO_2    = HMRATE((1e-9)*1.05,0,0)*OCS;
	NP_CO_NOP_C_2        = HMRATE((1e-10)*1.45,0,0)*CO;
	NP_OCS_SP_CO_N_2     = HMRATE((1e-10)*3.08,0,0)*OCS;
	NHP_CO_HCOP_N_2      = HMRATE((1e-10)*4.41,0,0)*CO;
	NHP_CO_OCNP_H_2      = HMRATE((1e-10)*5.39,0,0)*CO;
	NH_HCOP_CO_NH2P_2    = HMRATE((1e-10)*6.4,0,0)*HCOP;
	NH2_HCOP_CO_NH3P_2   = HMRATE((1e-10)*8.9,0,0)*HCOP;
	NH3_HCOP_CO_NH4P_2   = HMRATE((1e-9)*2.2,0,0)*HCOP;
	CNP_O2_NOP_CO_2      = HMRATE((1e-11)*8.6,0,0)*O2;
	HCNP_CO_HCOP_CN_2    = HMRATE((1e-10)*1.4,0,0)*CO;
	CO_HNOP_NO_HCOP_2    = HMRATE(1.0e-10,0,0)*HNOP;
	N2P_OCS_SP_N2_CO_2   = HMRATE((1e-9)*1.04,0,0)*OCS;
	HCOP_S_HSP_CO_2      = HMRATE((1e-10)*3.3,0,0)*ATS;
	HCOP_CS_HCSP_CO_2    = HMRATE(1.2e-9,0,0)*CS;
	NH_COP_CO_NHP_2      = HMRATE((1e-10)*3.2,0,0)*COP;
	NH2_COP_CO_NH2P_2    = HMRATE((1e-10)*4.5,0,0)*COP;
	NH3_COP_CO_NH3P_2    = HMRATE((1e-9)*2.02,0,0)*COP;
	CNP_CO_COP_CN_2      = HMRATE((1e-10)*6.3,0,0)*CO;
	HCN_COP_CO_HCNP_2    = HMRATE((1e-9)*3.4,0,0)*COP;
	CO_N2P_N2_COP_2      = HMRATE((1e-11)*7.4,0,0)*N2P;
	COP_NO_NOP_CO_2      = HMRATE((1e-10)*3.3,0,0)*NO;
	CO_S_OCS_NU_2        = HMRATE((1e-17)*1.6,-1.5,0)*ATS;
	NP_CO_COP_N_2        = HMRATE((1e-10)*8.25,0,0)*CO;
	COP_S_SP_CO_2        = HMRATE(1.1e-9,0,0)*ATS;
	HP_OCS_HSP_CO       = HMRATE((1e-9)*2.1,0,0)*HII;
	HeP_OCS_SP_CO_He    = HMRATE((1e-10)*7.6,0,0)*HeII;
	OCNP_e_CO_N       = HMRATE(0.0000003,-0.5,0)*ele;
	OCSP_e_S_CO       = HMRATE(0.00000015,-0.5,0)*ele;
	OCS_NU_S_CO       = HMRATE((1e-9)*3.7,0,0)*(TH85_field);
	OCS_CRP_S_CO      = crnu_rate * 5360 * 2;
	b_C_NO_CO_N          = HMRATE((1e-11)*4.65,0,0)*P_C_NO;
	b_C_OCN_CO_CN          = HMRATE(4.0e-11,0.5,0)*P_C_OCN;
	b_C_SO_S_CO            = HMRATE((1e-11)*7.2,0,0)*P_C_SO;
	b_O_CN_CO_N          = HMRATE((1e-11)*4.36,0.46,364)*P_O_CN;
	b_O_HCN_CO_NH          = HMRATE(0.00000000000073,1.14,3742)*P_O_HCN;
	b_O_OCN_NO_CO          = HMRATE((1e-11)*9.43,-0.09,100)*P_O_OCN;
	b_O_CS_S_CO          = HMRATE((1e-10)*2.48,-0.65,783)*P_O_CS;
	b_O_OCS_SO_CO          = HMRATE((1e-11)*1.6,0,2150)*P_O_OCS;
	b_OH_HCN_CO_NH2          = HMRATE((1e-13)*1.07,0,5892)*P_OH_HCN;
	b_CN_NO_N2_CO          = HMRATE((1e-10)*1.79,0,4040)*P_CN_NO;
	b_CN_O2_NO_CO          = HMRATE(0.00000000000053,0,0)*P_CN_O2;
	b_CO_HS_OCS_H          = HMRATE(0.0000000000000595,1.12,8330)*P_CO_HS;
	b_CP_SO_SP_CO          = HMRATE((1e-10)*2.6,0,0)*P_CP_SO;
	b_CP_OCS_CSP_CO          = HMRATE((1e-9)*1.6,0,0)*P_CP_OCS;
	b_CHP_OCS_HCSP_CO          = HMRATE((1e-9)*1.05,0,0)*P_CHP_OCS;
	b_NP_CO_NOP_C          = HMRATE((1e-10)*1.45,0,0)*P_NP_CO;
	b_NP_OCS_SP_CO_N          = HMRATE((1e-10)*3.08,0,0)*P_NP_OCS;
	b_NHP_CO_HCOP_N          = HMRATE((1e-10)*4.41,0,0)*P_NHP_CO;
	b_NHP_CO_OCNP_H          = HMRATE((1e-10)*5.39,0,0)*P_NHP_CO;
	b_NH_HCOP_CO_NH2P          = HMRATE((1e-10)*6.4,0,0)*P_NH_HCOP;
	b_NH2_HCOP_CO_NH3P          = HMRATE((1e-10)*8.9,0,0)*P_NH2_HCOP;
	b_NH3_HCOP_CO_NH4P          = HMRATE((1e-9)*2.2,0,0)*P_NH3_HCOP;
	b_CNP_O2_NOP_CO          = HMRATE((1e-11)*8.6,0,0)*P_CNP_O2;
	b_HCNP_CO_HCOP_CN          = HMRATE((1e-10)*1.4,0,0)*P_HCNP_CO;
	b_CO_HNOP_NO_HCOP          = HMRATE(1.0e-10,0,0)*P_CO_HNOP;
	b_N2P_OCS_SP_N2_CO          = HMRATE((1e-9)*1.04,0,0)*P_N2P_OCS;
	b_HCOP_S_HSP_CO          = HMRATE((1e-10)*3.3,0,0)*P_HCOP_S;
	b_HCOP_CS_HCSP_CO          = HMRATE(1.2e-9,0,0)*P_HCOP_CS;
	b_NH_COP_CO_NHP          = HMRATE((1e-10)*3.2,0,0)*P_NH_COP;
	b_NH2_COP_CO_NH2P          = HMRATE((1e-10)*4.5,0,0)*P_NH2_COP;
	b_NH3_COP_CO_NH3P          = HMRATE((1e-9)*2.02,0,0)*P_NH3_COP;
	b_CNP_CO_COP_CN          = HMRATE((1e-10)*6.3,0,0)*P_CNP_CO;
	b_HCN_COP_CO_HCNP          = HMRATE((1e-9)*3.4,0,0)*P_HCN_COP;
	b_CO_N2P_N2_COP          = HMRATE((1e-11)*7.4,0,0)*P_CO_N2P;
	b_COP_NO_NOP_CO          = HMRATE((1e-10)*3.3,0,0)*P_COP_NO;
	b_CO_S_OCS_NU          = HMRATE((1e-17)*1.6,-1.5,0)*P_CO_S;
	b_NP_CO_COP_N          = HMRATE((1e-10)*8.25,0,0)*P_NP_CO;
	b_COP_S_SP_CO          = HMRATE(1.1e-9,0,0)*P_COP_S;
	O_CCl_Cl_CO_1 = HMRATE(0.0000000000996,0,0)*CCl;
	CO_H2ClP_HCl_HCOP_1 = HMRATE(0.00000000078,0,0)*H2ClP;
	O_CCl_Cl_CO_2 = HMRATE(0.0000000000996,0,0)*ATO;
	CO_H2ClP_HCl_HCOP_2 = HMRATE(0.00000000078,0,0)*CO;
	P_CO_H2ClP = CO*H2ClP;
	b_O_CCl_Cl_CO = HMRATE(0.0000000000996,0,0)*P_O_CCl;
	b_CO_H2ClP_HCl_HCOP = HMRATE(0.00000000078,0,0)*P_CO_H2ClP;

	/* This turns on the diffuse cloud chemical rates from Tables 6 & 8 of
	>> refer Federman, S. R. & Zsargo, J. 2003, ApJ, 589, 319
	Without the "set rates federman" command, the default values are
	from UMIST */
	if(co.lgFederman)
	{
		e_HCOP_CO_H = HMRATE(2.4e-7,-0.69,0)*ele;
		O_CH_CO_H_1	= HMRATE(9.5e-11,0.5,0)*ATO;
		O_CH_CO_H_2	= HMRATE(9.5e-11,0.5,0)*CH;
		b_O_CH_CO_H	= HMRATE(9.5e-11,0.5,0)*P_O_CH;
	
	}
	HNC_HCOP_HCNHP_CO_1 = HMRATE(0.0000000031,0,0)*HNC;
	HNC_HCOP_HCNHP_CO_2 = HMRATE(0.0000000031,0,0)*HCOP;
	HCN_HCOP_HCNHP_CO_1  =	HMRATE(0.0000000031,0,0)*HCN;
	HCN_HCOP_HCNHP_CO_2  =	HMRATE(0.0000000031,0,0)*HCOP;
	b_HNC_HCOP_HCNHP_CO = HMRATE(0.0000000031,0,0)*P_HNC_HCOP;
	b_HCN_HCOP_HCNHP_CO  =	HMRATE(0.0000000031,0,0)*P_HCN_HCOP;

	O_C2H_CO_CH_1 = HMRATE(0.000000000017,0,0)*ATO;
	O_C2H_CO_CH_2 = HMRATE(0.000000000017,0,0)*C2H;
	b_O_C2H_CO_CH = HMRATE(0.000000000017,0,0)*P_O_C2H;
	C2H_COP_CO_C2HP_1 = HMRATE(0.00000000039,0,0)*C2H;
	C2H_COP_CO_C2HP_2 = HMRATE(0.00000000039,0,0)*COP;
	b_C2H_COP_CO_C2HP = HMRATE(0.00000000039,0,0)*P_C2H_COP;
	C2_HCOP_CO_C2HP_1 = HMRATE(0.00000000083,0,0)*C2;
	C2_HCOP_CO_C2HP_2 = HMRATE(0.00000000083,0,0)*HCOP;
	b_C2_HCOP_CO_C2HP = HMRATE(0.00000000083,0,0)*P_C2_HCOP;
	O2_C3_CO_C2_O_1 = HMRATE(0.000000000001,0,0)*O2;
	O2_C3_CO_C2_O_2 = HMRATE(0.000000000001,0,0)*C3;
	b_O2_C3_CO_C2_O = HMRATE(0.000000000001,0,0)*P_O2_C3;
	O_C3_CO_C2_1 = HMRATE(0.00000000005,0.5,0)*ATO;
	O_C3_CO_C2_2 = HMRATE(0.00000000005,0.5,0)*C3;
	b_O_C3_CO_C2 = HMRATE(0.00000000005,0.5,0)*P_O_C3;
	C2H_HCOP_CO_C2H2P_1 = HMRATE(0.00000000078,0,0)*C2H;
	C2H_HCOP_CO_C2H2P_2 = HMRATE(0.00000000078,0,0)*HCOP;
	b_C2H_HCOP_CO_C2H2P = HMRATE(0.00000000078,0,0)*P_C2H_HCOP;
	O_C3H_CO_C2H_1 = HMRATE(0.0000000001,0,250)*ATO;
	O_C3H_CO_C2H_2 = HMRATE(0.0000000001,0,250)*C3H;
	b_O_C3H_CO_C2H = HMRATE(0.0000000001,0,250)*P_O_C3H;
	O_C2H2_CO_CH2_1 = HMRATE(0.00000000000839,1.03,1197)*ATO;
	O_C2H2_CO_CH2_2 = HMRATE(0.00000000000839,1.03,1197)*C2H2;
	b_O_C2H2_CO_CH2 = HMRATE(0.00000000000839,1.03,1197)*P_O_C2H2;

	/* This rate will blow up if the temperature gets too low, therefore 
	 * set this rate for T < 500 equal to the rate at 500 K */
	if (phycon.te > 500)
	{		
		OH_C2H2_CO_CH3_1 = 0*HMRATE(6.51E-18,4,-1006)*OH;
		OH_C2H2_CO_CH3_2 = 0*HMRATE(6.51E-18,4,-1006)*C2H2;
		b_OH_C2H2_CO_CH3 = 0*HMRATE(6.51E-18,4,-1006)*P_OH_C2H2;

	}
#	if 0
#	endif
	else
	{

		OH_C2H2_CO_CH3_1 = 6.3E-18*OH;
		OH_C2H2_CO_CH3_2 = 6.3E-18*C2H2;
		b_OH_C2H2_CO_CH3 = 6.3E-18*P_OH_C2H2;
	}


	HCOP_C3_C3HP_CO_1 = HMRATE(0.000000002,0,0)*HCOP;
	HCOP_C3_C3HP_CO_2 = HMRATE(0.000000002,0,0)*C3;
	b_HCOP_C3_C3HP_CO = HMRATE(0.000000002,0,0)*P_HCOP_C3;
	H2O_C3HP_CO_C2H3P_1 = HMRATE(0.00000000018,0,0)*H2O;
	H2O_C3HP_CO_C2H3P_2 = HMRATE(0.00000000018,0,0)*C3HP;
	b_H2O_C3HP_CO_C2H3P = HMRATE(0.00000000018,0,0)*P_H2O_C3HP;
	C2H2_HCOP_CO_C2H3P_1 = HMRATE(0.0000000014,0,0)*C2H2;
	C2H2_HCOP_CO_C2H3P_2 = HMRATE(0.0000000014,0,0)*HCOP;
	b_C2H2_HCOP_CO_C2H3P = HMRATE(0.0000000014,0,0)*P_C2H2_HCOP;

	/* add the molecular reactions that form or destroy CO */

	/* >>refer	mol	H	CO+	=>	CO	H+	UMIST	*/
	
	mole.c[ipCOP][ipCOP] -= H_COP_CO_HP;
	mole.c[ipCOP][ipCO] += H_COP_CO_HP;
	
	/* >>refer	mol	H-	HCO+	=>	CO	H2	UMIST	*/
		
	mole.c[ipHCOP][ipHCOP] -= Hminus_HCOP_CO_H2;
	mole.c[ipHCOP][ipCO]   += Hminus_HCOP_CO_H2;

	/* >>refer	mol	H2+	CO	=>	HCO+	H	UMIST	*/
		
	mole.c[ipCO][ipCO] -= H2P_CO_HCOP_H;
	mole.c[ipCO][ipHCOP] += H2P_CO_HCOP_H;
	
	/* >>refer	mol	H2+	CO	=>	CO+	H2	UMIST	*/
		
	mole.c[ipCO][ipCO] -= H2P_CO_COP_H2;
	mole.c[ipCO][ipCOP] += H2P_CO_COP_H2;
	
	/* >>refer	mol	H3+	CO	=>	HCO+	H2	UMIST	*/
		
	mole.c[ipCO][ipCO] -= H3P_CO_HCOP_H2;
	mole.c[ipCO][ipHCOP] += H3P_CO_HCOP_H2;
	
	/* >>refer	mol	He+	CO	=>	O+	C	He	UMIST	*/
		
	mole.c[ipCO][ipCO] -= HeP_CO_OP_C_He;
	mole.c[ipCO][ipOP] += HeP_CO_OP_C_He;
	mole.c[ipCO][ipATC] += HeP_CO_OP_C_He;
	
	/* >>refer	mol	He+	CO	=>	O	C+	He	UMIST	*/
		
	mole.c[ipCO][ipCO] -= HeP_CO_O_CP_He;
	mole.c[ipCO][ipCP] += HeP_CO_O_CP_He;
	mole.c[ipCO][ipATO] += HeP_CO_O_CP_He;

	co.rate_co_hep_o_cp_he = (float)(HMRATE((1e-9)*1.6,0,0));
	
	/* >>refer	mol	cr	CO	=>	C	O	UMIST	*/
		
	mole.c[ipCO][ipCO] -= crnu_CO_O_C;
	mole.c[ipCO][ipATC] += crnu_CO_O_C;
	mole.c[ipCO][ipATO] += crnu_CO_O_C;
	
	/* >>refer	mol	CRP	CO	=>	CO+	e	UMIST	*/
		
	mole.c[ipCO][ipCO] -= CRP_CO_COP_e;
	mole.c[ipCO][ipCOP] += CRP_CO_COP_e;
	
	
	/* >>refer	mol	PHOTON	CO	=>	C	O	UMIST	*/

	/******************************************************************************************
	*	   First define the rate, which is of the form:
	*	   
	*		R = (Ro)*(Go*exp(-3.2Av))*Beta(tau(CO))
	*
	*	   where:
	*
	*	   Ro = 1.67*e-10
	*	   (Go*exp(-3.2Av)) = hmi.UV_Cont_rel2_Habing_TH85_depth
	*	   tauCO = 4.4e-15 * co.hevcol[ipCO] / (DoppVel.doppler[LIMELM]/1e5) /
	*		(1. + phycon.sqrte*0.6019) ; 
	*       tauC = 1.6*e17*N(C)
	*	   Beta(tau(CO)) = esca0k2(esc_co) 
	********************************************************************************************/   
	/* eqn 12 of 
	 * >>refer	CO	dissoc	Hollenbach, D.J., Takahashi, T., & Tielens, A. 1991, ApJ, 377, 192
	 * based on
	 * >>refer	CO	dissoc	Black, J.H., & van Dishoeck, E.F. 1988, ApJ, 334, 771 */
	esc_co = 4.4e-15 * co.hevcol[ipCO] / 
			 /* the line width in km/s */
			 (DoppVel.doppler[LIMELM]/1e5) /
			 /* this term accounts for populations within ground elec state */
			 (1. + phycon.sqrte*0.6019);

	/* hmi.UV_Cont_rel2_Habing_TH85_depth is field relative to Habing background, dimensionless */
	/* >>chng 04 apr 01, move from TH85 to DB96, also correct leading coef to use
	 * UMIST database value */
	/*co.CO_photo_dissoc_rate = 1.67e-10f*hmi.UV_Cont_rel2_Habing_TH85_depth;*/
	co.CO_photo_dissoc_rate = (float)(nu_CO_O_C * esca0k2(esc_co));

	mole.c[ipCO][ipCO]  -= co.CO_photo_dissoc_rate;
	mole.c[ipCO][ipATO] += co.CO_photo_dissoc_rate;
	mole.c[ipCO][ipATC] += co.CO_photo_dissoc_rate;

	/* >>refer	mol	e	HCO+	=>	CO	H	UMIST	*/
		
	mole.c[ipHCOP][ipHCOP] -= e_HCOP_CO_H;
	mole.c[ipHCOP][ipCO] += e_HCOP_CO_H;
	
	/* >>refer	mol	C		CO	=>		C2		O		UMIST	*/
	
	mole.c[ipCO][ipCO] -= C_CO_C2_O_2;
	mole.c[ipATC][ipCO] -= C_CO_C2_O_1;
	mole.b[ipCO]     -= b_C_CO_C2_O;
	
	mole.c[ipCO][ipATC] -= C_CO_C2_O_2;
	mole.c[ipATC][ipATC] -= C_CO_C2_O_1;
	mole.b[ipATC]     -= b_C_CO_C2_O;

	mole.c[ipCO][ipC2]  += C_CO_C2_O_2;
	mole.c[ipATC][ipC2]  += C_CO_C2_O_1;
	mole.b[ipC2]      += b_C_CO_C2_O;

	mole.c[ipCO][ipATO]  += C_CO_C2_O_2;
	mole.c[ipATC][ipATO]  += C_CO_C2_O_1;
	mole.b[ipATO]      += b_C_CO_C2_O;

	/* >>refer	mol	O		C2	=>		CO		C		UMIST	*/
	
	mole.c[ipC2][ipC2] -= O_C2_CO_C_2;
	mole.c[ipATO][ipC2] -= O_C2_CO_C_1;
	mole.b[ipC2]     -= b_O_C2_CO_C;
	
	mole.c[ipC2][ipATO] -= O_C2_CO_C_2;
	mole.c[ipATO][ipATO] -= O_C2_CO_C_1;
	mole.b[ipATO]     -= b_O_C2_CO_C;

	mole.c[ipC2][ipCO]  += O_C2_CO_C_2;
	mole.c[ipATO][ipCO]  += O_C2_CO_C_1;
	mole.b[ipCO]      += b_O_C2_CO_C;

	mole.c[ipC2][ipATC]  += O_C2_CO_C_2;
	mole.c[ipATO][ipATC]  += O_C2_CO_C_1;
	mole.b[ipATC]      += b_O_C2_CO_C;

	/* >>refer	mol	C2		O2	=>		CO		CO		UMIST	*/
	
	mole.c[ipC2][ipC2] -= C2_O2_CO_CO_1;
	mole.c[ipO2][ipC2] -= C2_O2_CO_CO_2;
	mole.b[ipC2]     -= b_C2_O2_CO_CO;
	
	mole.c[ipC2][ipO2] -= C2_O2_CO_CO_1;
	mole.c[ipO2][ipO2] -= C2_O2_CO_CO_2;
	mole.b[ipO2]     -= b_C2_O2_CO_CO;

	mole.c[ipC2][ipCO]  += C2_O2_CO_CO_1;
	mole.c[ipO2][ipCO]  += C2_O2_CO_CO_2;
	mole.b[ipCO]      += b_C2_O2_CO_CO;

	mole.c[ipC2][ipCO]  += C2_O2_CO_CO_1;
	mole.c[ipO2][ipCO]  += C2_O2_CO_CO_2;
	mole.b[ipCO]      += b_C2_O2_CO_CO;

	/* >>refer	mol	C2		O2+	=>		CO+		CO		UMIST	*/
	
	mole.c[ipC2][ipC2] -= C2_O2P_COP_CO_1;
	mole.c[ipO2P][ipC2] -= C2_O2P_COP_CO_2;
	mole.b[ipC2]     -= b_C2_O2P_COP_CO;
	
	mole.c[ipC2][ipO2P] -= C2_O2P_COP_CO_1;
	mole.c[ipO2P][ipO2P] -= C2_O2P_COP_CO_2;
	mole.b[ipO2P]     -= b_C2_O2P_COP_CO;

	mole.c[ipC2][ipCO]  += C2_O2P_COP_CO_1;
	mole.c[ipO2P][ipCO]  += C2_O2P_COP_CO_2;
	mole.b[ipCO]      += b_C2_O2P_COP_CO;

	mole.c[ipC2][ipCOP]  += C2_O2P_COP_CO_1;
	mole.c[ipO2P][ipCOP]  += C2_O2P_COP_CO_2;
	mole.b[ipCOP]      += b_C2_O2P_COP_CO;
	
	/* >>refer	mol	C2		CO+	=>		CO		C2+		UMIST	*/
	
	mole.c[ipCOP][ipCOP] -= C2_COP_CO_C2P_2;
	mole.c[ipC2][ipCOP] -= C2_COP_CO_C2P_1;
	mole.b[ipCOP]     -= b_C2_COP_CO_C2P;
	
	mole.c[ipCOP][ipC2] -= C2_COP_CO_C2P_2;
	mole.c[ipC2][ipC2] -= C2_COP_CO_C2P_1;
	mole.b[ipC2]     -= b_C2_COP_CO_C2P;

	mole.c[ipCOP][ipCO]  += C2_COP_CO_C2P_2;
	mole.c[ipC2][ipCO]  += C2_COP_CO_C2P_1;
	mole.b[ipCO]      += b_C2_COP_CO_C2P;

	mole.c[ipCOP][ipC2P]  += C2_COP_CO_C2P_2;
	mole.c[ipC2][ipC2P]  += C2_COP_CO_C2P_1;
	mole.b[ipC2P]      += b_C2_COP_CO_C2P;

	/* >>refer	mol	C2+		O2	=>		CO+		CO		UMIST	*/
	
	mole.c[ipO2][ipO2] -= C2P_O2_COP_CO_2;
	mole.c[ipC2P][ipO2] -= C2P_O2_COP_CO_1;
	mole.b[ipO2]     -= b_C2P_O2_COP_CO;
	
	mole.c[ipO2][ipC2P] -= C2P_O2_COP_CO_2;
	mole.c[ipC2P][ipC2P] -= C2P_O2_COP_CO_1;
	mole.b[ipC2P]     -= b_C2P_O2_COP_CO;

	mole.c[ipO2][ipCOP]  += C2P_O2_COP_CO_2;
	mole.c[ipC2P][ipCOP]  += C2P_O2_COP_CO_1;
	mole.b[ipCOP]      += b_C2P_O2_COP_CO;

	mole.c[ipO2][ipCO]  += C2P_O2_COP_CO_2;
	mole.c[ipC2P][ipCO]  += C2P_O2_COP_CO_1;
	mole.b[ipCO]      += b_C2P_O2_COP_CO;

	
	/* >>refer	mol	C	CO+	=>	CO	C+	UMIST	*/
	
	mole.c[ipCOP][ipCOP] -= C_COP_CO_CP_1;
	mole.c[ipATC][ipCOP] -= C_COP_CO_CP_2;
	mole.b[ipCOP]     -= b_C_COP_CO_CP;
	
	mole.c[ipCOP][ipATC] -= C_COP_CO_CP_1;
	mole.c[ipATC][ipATC] -= C_COP_CO_CP_2;
	mole.b[ipATC]     -= b_C_COP_CO_CP;

	mole.c[ipCOP][ipCO]  += C_COP_CO_CP_1;
	mole.c[ipATC][ipCO]  += C_COP_CO_CP_2;
	mole.b[ipCO]      += b_C_COP_CO_CP;

	mole.c[ipCOP][ipCP]  += C_COP_CO_CP_1;
	mole.c[ipATC][ipCP]  += C_COP_CO_CP_2;
	mole.b[ipCP]      += b_C_COP_CO_CP;
	
	/* >>refer	mol	C	HCO+	=>	CO	CH+	UMIST	*/
	
	mole.c[ipHCOP][ipHCOP] -= C_HCOP_CO_CHP_1;
	mole.c[ipATC][ipHCOP]  -= C_HCOP_CO_CHP_2;
	mole.b[ipHCOP]      -= b_C_HCOP_CO_CHP;
	
	mole.c[ipHCOP][ipATC] -= C_HCOP_CO_CHP_1;
	mole.c[ipATC][ipATC]  -= C_HCOP_CO_CHP_2;
	mole.b[ipATC]      -= b_C_HCOP_CO_CHP;

	mole.c[ipHCOP][ipCO]   += C_HCOP_CO_CHP_1;
	mole.c[ipATC][ipCO]    += C_HCOP_CO_CHP_2;
	mole.b[ipCO]        += b_C_HCOP_CO_CHP;
	
	mole.c[ipHCOP][ipCHP]  += C_HCOP_CO_CHP_1;
	mole.c[ipATC][ipCHP]   += C_HCOP_CO_CHP_2;
	mole.b[ipCHP]       += b_C_HCOP_CO_CHP;
	
	/* >>refer	mol	C	O	=>	CO	PHOTON	UMIST	*/
	
	mole.c[ipATO][ipATO] -= C_O_CO_nu_1;
	mole.c[ipATC][ipATO] -= C_O_CO_nu_2;
	mole.b[ipATO]     -= b_C_O_CO_nu;
	
	mole.c[ipATO][ipATC] -= C_O_CO_nu_1;
	mole.c[ipATC][ipATC] -= C_O_CO_nu_2;
	mole.b[ipATC]     -= b_C_O_CO_nu;
	
	mole.c[ipATO][ipCO] += C_O_CO_nu_1;
	mole.c[ipATC][ipCO] += C_O_CO_nu_2;
	mole.b[ipCO]     += b_C_O_CO_nu;
	
	/* >>refer	mol	C	O2	=>	CO	O	UMIST	*/
	
	mole.c[ipO2][ipO2]  -= C_O2_CO_O_1;
	mole.c[ipATC][ipO2] -= C_O2_CO_O_2;
	mole.b[ipO2]     -= b_C_O2_CO_O;
	
	mole.c[ipO2][ipATC]  -= C_O2_CO_O_1;
	mole.c[ipATC][ipATC] -= C_O2_CO_O_2;
	mole.b[ipATC]     -= b_C_O2_CO_O;
	
	mole.c[ipO2][ipCO]  += C_O2_CO_O_1;
	mole.c[ipATC][ipCO] += C_O2_CO_O_2;
	mole.b[ipCO]     += b_C_O2_CO_O;
	
	mole.c[ipO2][ipATO]  += C_O2_CO_O_1;
	mole.c[ipATC][ipATO] += C_O2_CO_O_2;
	mole.b[ipATO]     += b_C_O2_CO_O;
	
	/* >>refer	mol	C	OH	=>	CO	H	UMIST	*/
	
	mole.c[ipOH][ipOH]  -= C_OH_CO_H_1;
	mole.c[ipATC][ipOH] -= C_OH_CO_H_2;
	mole.b[ipOH]     -= b_C_OH_CO_H;
	
	mole.c[ipOH][ipATC]  -= C_OH_CO_H_1;
	mole.c[ipATC][ipATC] -= C_OH_CO_H_2;
	mole.b[ipATC]     -= b_C_OH_CO_H;
	
	mole.c[ipOH][ipCO]  += C_OH_CO_H_1;
	mole.c[ipATC][ipCO] += C_OH_CO_H_2;
	mole.b[ipCO]     += b_C_OH_CO_H;
	
	/* >>refer	mol	C	SiO+	=>	Si+	CO	UMIST	*/
		
	mole.c[ipSIOP][ipSIOP] -= C_SiOP_SiP_CO_1;
	mole.c[ipATC][ipSIOP]  -= C_SiOP_SiP_CO_2;
	mole.b[ipSIOP]      -= b_C_SiOP_SiP_CO;
		
	mole.c[ipSIOP][ipATC] -= C_SiOP_SiP_CO_1;
	mole.c[ipATC][ipATC]  -= C_SiOP_SiP_CO_2;
	mole.b[ipATC]      -= b_C_SiOP_SiP_CO;
	
	mole.c[ipSIOP][ipCO]   += C_SiOP_SiP_CO_1;
	mole.c[ipATC][ipCO]    += C_SiOP_SiP_CO_2;
	mole.b[ipCO]        += b_C_SiOP_SiP_CO;
	
	mole.c[ipSIOP][ipSIP]   += C_SiOP_SiP_CO_1;
	mole.c[ipATC][ipSIP]    += C_SiOP_SiP_CO_2;
	mole.b[ipSIP]        += b_C_SiOP_SiP_CO;
	
	/* >>refer	mol	C+	OH	=>	CO	H+	UMIST	*/
	
	mole.c[ipOH][ipCP]  -= CP_OH_CO_HP_1;
	mole.c[ipCP][ipCP] -= CP_OH_CO_HP_2;
	mole.b[ipCP]     -= b_CP_OH_CO_HP;
	
	mole.c[ipOH][ipOH]  -= CP_OH_CO_HP_1;
	mole.c[ipCP][ipOH] -= CP_OH_CO_HP_2;
	mole.b[ipOH]     -= b_CP_OH_CO_HP;
	
	mole.c[ipOH][ipCO]  += CP_OH_CO_HP_1;
	mole.c[ipCP][ipCO] += CP_OH_CO_HP_2;
	mole.b[ipCO]     += b_CP_OH_CO_HP;
	
	/* >>refer	mol	C+	SiO	=>	Si+	CO	UMIST	*/
		
	mole.c[ipSIO][ipCP] -= CP_SiO_SiP_CO_1;
	mole.c[ipCP][ipCP]  -= CP_SiO_SiP_CO_2;
	mole.b[ipCP]     -= b_CP_SiO_SiP_CO;
		
	mole.c[ipSIO][ipSIO] -= CP_SiO_SiP_CO_1;
	mole.c[ipCP][ipSIO]  -= CP_SiO_SiP_CO_2;
	mole.b[ipSIO]     -= b_CP_SiO_SiP_CO;
	
	mole.c[ipSIO][ipCO]  += CP_SiO_SiP_CO_1;
	mole.c[ipCP][ipCO]   += CP_SiO_SiP_CO_2;
	mole.b[ipCO]      += b_CP_SiO_SiP_CO;
	
	mole.c[ipSIO][ipSIP]  += CP_SiO_SiP_CO_1;
	mole.c[ipCP][ipSIP]   += CP_SiO_SiP_CO_2;
	mole.b[ipSIP]      += b_CP_SiO_SiP_CO;
	
	/* >>refer	mol	C+	O2	=>	CO	O+	UMIST	*/
		
	mole.c[ipO2][ipCP] -= CP_O2_CO_OP_1;
	mole.c[ipCP][ipCP] -= CP_O2_CO_OP_2;
	mole.b[ipCP]    -= b_CP_O2_CO_OP;
		
	mole.c[ipO2][ipO2] -= CP_O2_CO_OP_1;
	mole.c[ipCP][ipO2] -= CP_O2_CO_OP_2;
	mole.b[ipO2]    -= b_CP_O2_CO_OP;
	
	mole.c[ipO2][ipCO] += CP_O2_CO_OP_1;
	mole.c[ipCP][ipCO] += CP_O2_CO_OP_2;
	mole.b[ipCO]    += b_CP_O2_CO_OP;
	
	mole.c[ipO2][ipOP] += CP_O2_CO_OP_1;
	mole.c[ipCP][ipOP] += CP_O2_CO_OP_2;
	mole.b[ipOP]    += b_CP_O2_CO_OP;
	
	/* >>refer	mol	O	CH	=>	CO	H	UMIST	*/
		
	mole.c[ipCH][ipCH]  -= O_CH_CO_H_1;
	mole.c[ipATO][ipCH] -= O_CH_CO_H_2;
	mole.b[ipCH]     -= b_O_CH_CO_H;
		
	mole.c[ipCH][ipATO]  -= O_CH_CO_H_1;
	mole.c[ipATO][ipATO] -= O_CH_CO_H_2;
	mole.b[ipATO]     -= b_O_CH_CO_H;
	
	mole.c[ipCH][ipCO]  += O_CH_CO_H_1;
	mole.c[ipATO][ipCO] += O_CH_CO_H_2;
	mole.b[ipCO]     += b_O_CH_CO_H;
	
	/* >>refer	mol	O	CH2	=>	CO	H	H	UMIST	*/
	
	mole.c[ipCH2][ipCH2] -= O_CH2_CO_H_H_1;
	mole.c[ipATO][ipCH2] -= O_CH2_CO_H_H_2;
	mole.b[ipCH2]     -= b_O_CH2_CO_H_H;
	
	mole.c[ipCH2][ipATO] -= O_CH2_CO_H_H_1;
	mole.c[ipATO][ipATO] -= O_CH2_CO_H_H_2;
	mole.b[ipATO]     -= b_O_CH2_CO_H_H;
	
	mole.c[ipCH2][ipCO]  += O_CH2_CO_H_H_1;
	mole.c[ipATO][ipCO]  += O_CH2_CO_H_H_2;
	mole.b[ipCO]      += b_O_CH2_CO_H_H;
	
	/* >>refer	mol	O	CH2	=>	CO	H2	UMIST	*/
		
	mole.c[ipCH2][ipCH2] -= O_CH2_CO_H2_1;
	mole.c[ipATO][ipCH2] -= O_CH2_CO_H2_2;
	mole.b[ipCH2]     -= b_O_CH2_CO_H2;
		
	mole.c[ipCH2][ipATO] -= O_CH2_CO_H2_1;
	mole.c[ipATO][ipATO] -= O_CH2_CO_H2_2;
	mole.b[ipATO]     -= b_O_CH2_CO_H2;
	
	mole.c[ipCH2][ipCO]  += O_CH2_CO_H2_1;
	mole.c[ipATO][ipCO]  += O_CH2_CO_H2_2;
	mole.b[ipCO]      += b_O_CH2_CO_H2;
	
	/* >>refer	mol	O	CO+	=>	CO	O+	UMIST	*/
		
	mole.c[ipCOP][ipCOP] -= O_COP_CO_OP_1;
	mole.c[ipATO][ipCOP] -= O_COP_CO_OP_2;
	mole.b[ipCOP]     -= b_O_COP_CO_OP;
		
	mole.c[ipCOP][ipATO] -= O_COP_CO_OP_1;
	mole.c[ipATO][ipATO] -= O_COP_CO_OP_2;
	mole.b[ipATO]     -= b_O_COP_CO_OP;

	mole.c[ipCOP][ipCO]  += O_COP_CO_OP_1;
	mole.c[ipATO][ipCO]  += O_COP_CO_OP_2;
	mole.b[ipCO]      += b_O_COP_CO_OP;

	mole.c[ipCOP][ipOP]  += O_COP_CO_OP_1;
	mole.c[ipATO][ipOP]  += O_COP_CO_OP_2;
	mole.b[ipOP]      += b_O_COP_CO_OP;
	
	/* >>refer	mol	O+	CO	=>	CO+	O	UMIST	*/
		
	mole.c[ipCO][ipOP] -= OP_CO_COP_O_1;
	mole.c[ipOP][ipOP] -= OP_CO_COP_O_2;
	mole.b[ipOP] -= b_OP_CO_COP_O;
	
	mole.c[ipCO][ipCO] -= OP_CO_COP_O_1;
	mole.c[ipOP][ipCO] -= OP_CO_COP_O_2;
	mole.b[ipCO] -= b_OP_CO_COP_O;
	
	mole.c[ipCO][ipCOP] += OP_CO_COP_O_1;
	mole.c[ipOP][ipCOP] += OP_CO_COP_O_2;
	mole.b[ipCOP] += b_OP_CO_COP_O;
	
	mole.c[ipCO][ipATO] += OP_CO_COP_O_1;
	mole.c[ipOP][ipATO] += OP_CO_COP_O_2;
	mole.b[ipATO] += b_OP_CO_COP_O;
	
	/* >>refer	mol	CH	CO+	=>	CO	CH+	UMIST	*/
	
	mole.c[ipCOP][ipCH] -= CH_COP_CO_CHP_1; 
	mole.c[ipCH][ipCH] -= CH_COP_CO_CHP_2;
	mole.b[ipCH] -= b_CH_COP_CO_CHP;
	
	mole.c[ipCOP][ipCOP] -= CH_COP_CO_CHP_1; 
	mole.c[ipCH][ipCOP] -= CH_COP_CO_CHP_2;
	mole.b[ipCOP] -= b_CH_COP_CO_CHP;
	
	mole.c[ipCOP][ipCO] += CH_COP_CO_CHP_1; 
	mole.c[ipCH][ipCO] += CH_COP_CO_CHP_2;
	mole.b[ipCO] += b_CH_COP_CO_CHP;
	
	mole.c[ipCOP][ipCHP] += CH_COP_CO_CHP_1; 
	mole.c[ipCH][ipCHP] += CH_COP_CO_CHP_2;
	mole.b[ipCHP] += b_CH_COP_CO_CHP;
	
	/* >>refer	mol	CH	HCO+	=>	CO	CH2+	UMIST	*/
		
	mole.c[ipHCOP][ipCH] -= CH_HCOP_CO_CH2P_1; 
	mole.c[ipCH][ipCH] -= CH_HCOP_CO_CH2P_2;
	mole.b[ipCH] -= b_CH_HCOP_CO_CH2P;
	
	mole.c[ipHCOP][ipHCOP] -= CH_HCOP_CO_CH2P_1; 
	mole.c[ipCH][ipHCOP] -= CH_HCOP_CO_CH2P_2;
	mole.b[ipHCOP] -= b_CH_HCOP_CO_CH2P;
	
	mole.c[ipHCOP][ipCO] += CH_HCOP_CO_CH2P_1; 
	mole.c[ipCH][ipCO] += CH_HCOP_CO_CH2P_2;
	mole.b[ipCO] += b_CH_HCOP_CO_CH2P;
	
	mole.c[ipHCOP][ipCH2P] += CH_HCOP_CO_CH2P_1; 
	mole.c[ipCH][ipCH2P] += CH_HCOP_CO_CH2P_2;
	mole.b[ipCH2P] += b_CH_HCOP_CO_CH2P;
	
	/* >>refer	mol	CH	O2	=>	CO	OH	UMIST	*/
		
	mole.c[ipO2][ipCH] -= CH_O2_CO_OH_1; 
	mole.c[ipCH][ipCH] -= CH_O2_CO_OH_2;
	mole.b[ipCH] -= b_CH_O2_CO_OH;
	
	mole.c[ipO2][ipO2] -= CH_O2_CO_OH_1; 
	mole.c[ipCH][ipO2] -= CH_O2_CO_OH_2;
	mole.b[ipO2] -= b_CH_O2_CO_OH;
	
	mole.c[ipO2][ipCO] += CH_O2_CO_OH_1; 
	mole.c[ipCH][ipCO] += CH_O2_CO_OH_2;
	mole.b[ipCO] += b_CH_O2_CO_OH;
	
	mole.c[ipO2][ipOH] += CH_O2_CO_OH_1; 
	mole.c[ipCH][ipOH] += CH_O2_CO_OH_2;
	mole.b[ipOH] += b_CH_O2_CO_OH;
		
	/* >>refer	mol	CH2	CO+	=>	CO	CH2+	UMIST	*/
	
	mole.c[ipCOP][ipCH2] -= CH2_COP_CO_CH2P_1; 
	mole.c[ipCH2][ipCH2] -= CH2_COP_CO_CH2P_2;
	mole.b[ipCH2] -= b_CH2_COP_CO_CH2P;
	
	mole.c[ipCOP][ipCOP] -= CH2_COP_CO_CH2P_1; 
	mole.c[ipCH2][ipCOP] -= CH2_COP_CO_CH2P_2;
	mole.b[ipCOP] -= b_CH2_COP_CO_CH2P;
	
	mole.c[ipCOP][ipCO] += CH2_COP_CO_CH2P_1; 
	mole.c[ipCH2][ipCO] += CH2_COP_CO_CH2P_2;
	mole.b[ipCO] += b_CH2_COP_CO_CH2P;
	
	mole.c[ipCOP][ipCH2P] += CH2_COP_CO_CH2P_1; 
	mole.c[ipCH2][ipCH2P] += CH2_COP_CO_CH2P_2;
	mole.b[ipCH2P] += b_CH2_COP_CO_CH2P;

	/* >>refer	mol	CH2	HCO+	=>	CO	CH3+	UMIST	*/
	
	mole.c[ipHCOP][ipCH2] -= CH2_HCOP_CO_CH3P_1; 
	mole.c[ipCH2][ipCH2] -= CH2_HCOP_CO_CH3P_2;
	mole.b[ipCH2] -= b_CH2_HCOP_CO_CH3P;
	
	mole.c[ipHCOP][ipHCOP] -= CH2_HCOP_CO_CH3P_1; 
	mole.c[ipCH2][ipHCOP] -= CH2_HCOP_CO_CH3P_2;
	mole.b[ipHCOP] -= b_CH2_HCOP_CO_CH3P;
	
	mole.c[ipHCOP][ipCO] += CH2_HCOP_CO_CH3P_1; 
	mole.c[ipCH2][ipCO] += CH2_HCOP_CO_CH3P_2;
	mole.b[ipCO] += b_CH2_HCOP_CO_CH3P;
	
	mole.c[ipHCOP][ipCH3P] += CH2_HCOP_CO_CH3P_1; 
	mole.c[ipCH2][ipCH3P] += CH2_HCOP_CO_CH3P_2;
	mole.b[ipCH3P] += b_CH2_HCOP_CO_CH3P;
	
	/* >>refer	mol	CH2	O2	=>	CO	H2O	UMIST	*/
	
	mole.c[ipO2][ipCH2] -= CH2_O2_CO_H2O_1; 
	mole.c[ipCH2][ipCH2] -= CH2_O2_CO_H2O_2;
	mole.b[ipCH2] -= b_CH2_O2_CO_H2O;
	
	mole.c[ipO2][ipO2] -= CH2_O2_CO_H2O_1; 
	mole.c[ipCH2][ipO2] -= CH2_O2_CO_H2O_2;
	mole.b[ipO2] -= b_CH2_O2_CO_H2O;
	
	mole.c[ipO2][ipCO] += CH2_O2_CO_H2O_1; 
	mole.c[ipCH2][ipCO] += CH2_O2_CO_H2O_2;
	mole.b[ipCO] += b_CH2_O2_CO_H2O;
	
	mole.c[ipO2][ipH2O] += CH2_O2_CO_H2O_1; 
	mole.c[ipCH2][ipH2O] += CH2_O2_CO_H2O_2;
	mole.b[ipH2O] += b_CH2_O2_CO_H2O;
	
	/* >>refer	mol	CO+	O2	=>	O2+	CO	UMIST	*/
	
	mole.c[ipO2][ipCOP] -= COP_O2_O2P_CO_1; 
	mole.c[ipCOP][ipCOP] -= COP_O2_O2P_CO_2;
	mole.b[ipCOP] -= b_COP_O2_O2P_CO;
	
	mole.c[ipO2][ipO2] -= COP_O2_O2P_CO_1; 
	mole.c[ipCOP][ipO2] -= COP_O2_O2P_CO_2;
	mole.b[ipO2] -= b_COP_O2_O2P_CO;
	
	mole.c[ipO2][ipO2P] += COP_O2_O2P_CO_1; 
	mole.c[ipCOP][ipO2P] += COP_O2_O2P_CO_2;
	mole.b[ipO2P] += b_COP_O2_O2P_CO;
	
	mole.c[ipO2][ipCO] += COP_O2_O2P_CO_1; 
	mole.c[ipCOP][ipCO] += COP_O2_O2P_CO_2;
	mole.b[ipCO] += b_COP_O2_O2P_CO;
	
	/* >>refer	mol	H2O	CO+	=>	CO	H2O+	UMIST	*/
		
	mole.c[ipCOP][ipH2O] -= H2O_COP_CO_H2OP_1; 
	mole.c[ipH2O][ipH2O] -= H2O_COP_CO_H2OP_2;
	mole.b[ipH2O] -= b_H2O_COP_CO_H2OP;
	
	mole.c[ipCOP][ipCOP] -= H2O_COP_CO_H2OP_1; 
	mole.c[ipH2O][ipCOP] -= H2O_COP_CO_H2OP_2;
	mole.b[ipCOP] -= b_H2O_COP_CO_H2OP;
	
	mole.c[ipCOP][ipCO] += H2O_COP_CO_H2OP_1; 
	mole.c[ipH2O][ipCO] += H2O_COP_CO_H2OP_2;
	mole.b[ipCO] += b_H2O_COP_CO_H2OP;
	
	mole.c[ipCOP][ipH2OP] += H2O_COP_CO_H2OP_1; 
	mole.c[ipH2O][ipH2OP] += H2O_COP_CO_H2OP_2;
	mole.b[ipH2OP] += b_H2O_COP_CO_H2OP;
	
	/* >>refer	mol	H2O	HCO+	=>	CO	H3O+	UMIST	*/
	
	mole.c[ipHCOP][ipH2O] -= H2O_HCOP_CO_H3OP_1; 
	mole.c[ipH2O][ipH2O] -= H2O_HCOP_CO_H3OP_2;
	mole.b[ipH2O] -= b_H2O_HCOP_CO_H3OP;
	
	mole.c[ipHCOP][ipHCOP] -= H2O_HCOP_CO_H3OP_1; 
	mole.c[ipH2O][ipHCOP] -= H2O_HCOP_CO_H3OP_2;
	mole.b[ipHCOP] -= b_H2O_HCOP_CO_H3OP;
	
	mole.c[ipHCOP][ipCO] += H2O_HCOP_CO_H3OP_1; 
	mole.c[ipH2O][ipCO] += H2O_HCOP_CO_H3OP_2;
	mole.b[ipCO] += b_H2O_HCOP_CO_H3OP;
	
	mole.c[ipHCOP][ipH3OP] += H2O_HCOP_CO_H3OP_1; 
	mole.c[ipH2O][ipH3OP] += H2O_HCOP_CO_H3OP_2;
	mole.b[ipH3OP] += b_H2O_HCOP_CO_H3OP;
	
	
	/* >>refer	mol	H2O+	CO	=>	HCO+	OH	UMIST	*/
		
	mole.c[ipCO][ipH2OP] -= H2OP_CO_HCOP_OH_1; 
	mole.c[ipH2OP][ipH2OP] -= H2OP_CO_HCOP_OH_2;
	mole.b[ipH2OP] -= b_H2OP_CO_HCOP_OH;
	
	mole.c[ipCO][ipCO] -= H2OP_CO_HCOP_OH_1; 
	mole.c[ipH2OP][ipCO] -= H2OP_CO_HCOP_OH_2;
	mole.b[ipCO] -= b_H2OP_CO_HCOP_OH;
	
	mole.c[ipCO][ipHCOP] += H2OP_CO_HCOP_OH_1; 
	mole.c[ipH2OP][ipHCOP] += H2OP_CO_HCOP_OH_2;
	mole.b[ipHCOP] += b_H2OP_CO_HCOP_OH;
	
	mole.c[ipCO][ipOH] += H2OP_CO_HCOP_OH_1; 
	mole.c[ipH2OP][ipOH] += H2OP_CO_HCOP_OH_2;
	mole.b[ipOH] += b_H2OP_CO_HCOP_OH;

	/* >>refer	mol	HCO+	SiH	=>	SiH2+	CO	UMIST	*/
		
	mole.c[ipSIH][ipHCOP] -= HCOP_SiH_SiH2P_CO_1; 
	mole.c[ipHCOP][ipHCOP] -= HCOP_SiH_SiH2P_CO_2;
	mole.b[ipHCOP] -= b_HCOP_SiH_SiH2P_CO;
	
	mole.c[ipSIH][ipSIH] -= HCOP_SiH_SiH2P_CO_1; 
	mole.c[ipHCOP][ipSIH] -= HCOP_SiH_SiH2P_CO_2;
	mole.b[ipSIH] -= b_HCOP_SiH_SiH2P_CO;
	
	mole.c[ipSIH][ipSIH2P] += HCOP_SiH_SiH2P_CO_1; 
	mole.c[ipHCOP][ipSIH2P] += HCOP_SiH_SiH2P_CO_2;
	mole.b[ipSIH2P] += b_HCOP_SiH_SiH2P_CO;
	
	mole.c[ipSIH][ipCO] += HCOP_SiH_SiH2P_CO_1; 
	mole.c[ipHCOP][ipCO] += HCOP_SiH_SiH2P_CO_2;
	mole.b[ipCO] += b_HCOP_SiH_SiH2P_CO;
	
	/* >>refer	mol	HCO+	SiO	=>	SiOH+	CO	UMIST	*/
	
	mole.c[ipSIO][ipHCOP] -= HCOP_SiO_SiOHP_CO_1; 
	mole.c[ipHCOP][ipHCOP] -= HCOP_SiO_SiOHP_CO_2;
	mole.b[ipHCOP] -= b_HCOP_SiO_SiOHP_CO;
	
	mole.c[ipSIO][ipSIO] -= HCOP_SiO_SiOHP_CO_1; 
	mole.c[ipHCOP][ipSIO] -= HCOP_SiO_SiOHP_CO_2;
	mole.b[ipSIO] -= b_HCOP_SiO_SiOHP_CO;
	
	mole.c[ipSIO][ipHOSIP] += HCOP_SiO_SiOHP_CO_1; 
	mole.c[ipHCOP][ipHOSIP] += HCOP_SiO_SiOHP_CO_2;
	mole.b[ipHOSIP] += b_HCOP_SiO_SiOHP_CO;
	
	mole.c[ipSIO][ipCO] += HCOP_SiO_SiOHP_CO_1; 
	mole.c[ipHCOP][ipCO] += HCOP_SiO_SiOHP_CO_2;
	mole.b[ipCO] += b_HCOP_SiO_SiOHP_CO;
	
	/* >>refer	mol	OH	CO+	=>	CO	OH+	UMIST	*/
	
	mole.c[ipCOP][ipOH] -= OH_COP_CO_OHP_1; 
	mole.c[ipOH][ipOH] -= OH_COP_CO_OHP_2;
	mole.b[ipOH] -= b_OH_COP_CO_OHP;
	
	mole.c[ipCOP][ipCOP] -= OH_COP_CO_OHP_1; 
	mole.c[ipOH][ipCOP] -= OH_COP_CO_OHP_2;
	mole.b[ipCOP] -= b_OH_COP_CO_OHP;
	
	mole.c[ipCOP][ipCO] += OH_COP_CO_OHP_1; 
	mole.c[ipOH][ipCO] += OH_COP_CO_OHP_2;
	mole.b[ipCO] += b_OH_COP_CO_OHP;
	
	mole.c[ipCOP][ipOHP] += OH_COP_CO_OHP_1; 
	mole.c[ipOH][ipOHP] += OH_COP_CO_OHP_2;
	mole.b[ipOHP] += b_OH_COP_CO_OHP;
		
	/* >>refer	mol	OH	HCO+	=>	CO	H2O+	UMIST	*/
	
	mole.c[ipHCOP][ipOH] -= OH_HCOP_CO_H2OP_1; 
	mole.c[ipOH][ipOH] -= OH_HCOP_CO_H2OP_2;
	mole.b[ipOH] -= b_OH_HCOP_CO_H2OP;
	
	mole.c[ipHCOP][ipHCOP] -= OH_HCOP_CO_H2OP_1; 
	mole.c[ipOH][ipHCOP] -= OH_HCOP_CO_H2OP_2;
	mole.b[ipHCOP] -= b_OH_HCOP_CO_H2OP;
	
	mole.c[ipHCOP][ipCO] += OH_HCOP_CO_H2OP_1; 
	mole.c[ipOH][ipCO] += OH_HCOP_CO_H2OP_2;
	mole.b[ipCO] += b_OH_HCOP_CO_H2OP;
	
	mole.c[ipHCOP][ipH2OP] += OH_HCOP_CO_H2OP_1; 
	mole.c[ipOH][ipH2OP] += OH_HCOP_CO_H2OP_2;
	mole.b[ipH2OP] += b_OH_HCOP_CO_H2OP;
	
	
	/* >>refer	mol	OH+	CO	=>	HCO+	O	UMIST	*/
		
	mole.c[ipCO][ipOHP] -= OHP_CO_HCOP_O_1; 
	mole.c[ipOHP][ipOHP] -= OHP_CO_HCOP_O_2;
	mole.b[ipOHP] -= b_OHP_CO_HCOP_O;
	
	mole.c[ipCO][ipCO] -= OHP_CO_HCOP_O_1; 
	mole.c[ipOHP][ipCO] -= OHP_CO_HCOP_O_2;
	mole.b[ipCO] -= b_OHP_CO_HCOP_O;
	
	mole.c[ipCO][ipHCOP] += OHP_CO_HCOP_O_1; 
	mole.c[ipOHP][ipHCOP] += OHP_CO_HCOP_O_2;
	mole.b[ipHCOP] += b_OHP_CO_HCOP_O;
	
	mole.c[ipCO][ipATO] += OHP_CO_HCOP_O_1; 
	mole.c[ipOHP][ipATO] += OHP_CO_HCOP_O_2;
	mole.b[ipATO] += b_OHP_CO_HCOP_O;
		
	/* >>refer mol   COP CH4  =>  CO CH4P   UMIST    */
	
	mole.c[ipCOP][ipCOP] -= COP_CH4_CO_CH4P_1;
	mole.c[ipCH4][ipCOP] -= COP_CH4_CO_CH4P_2;
	mole.b[ipCOP] -= b_COP_CH4_CO_CH4P;
	
	mole.c[ipCOP][ipCH4] -= COP_CH4_CO_CH4P_1;
	mole.c[ipCH4][ipCH4] -= COP_CH4_CO_CH4P_2;
	mole.b[ipCH4] -= b_COP_CH4_CO_CH4P;
	
	mole.c[ipCOP][ipCO] += COP_CH4_CO_CH4P_1;
	mole.c[ipCH4][ipCO] += COP_CH4_CO_CH4P_2;
	mole.b[ipCO] += b_COP_CH4_CO_CH4P;
	
	mole.c[ipCOP][ipCH4P] += COP_CH4_CO_CH4P_1;
	mole.c[ipCH4][ipCH4P] += COP_CH4_CO_CH4P_2;
	mole.b[ipCH4P] += b_COP_CH4_CO_CH4P;
	
	
	/* >>refer mol   CO CH4P  =>  HCOP CH3   UMIST    */
	
	mole.c[ipCO][ipCO] -= CO_CH4P_HCOP_CH3_1;
	mole.c[ipCH4P][ipCO] -= CO_CH4P_HCOP_CH3_2;
	mole.b[ipCO] -= b_CO_CH4P_HCOP_CH3;
	
	mole.c[ipCO][ipCH4P] -= CO_CH4P_HCOP_CH3_1;
	mole.c[ipCH4P][ipCH4P] -= CO_CH4P_HCOP_CH3_2;
	mole.b[ipCH4P] -= b_CO_CH4P_HCOP_CH3;
	
	mole.c[ipCO][ipHCOP] += CO_CH4P_HCOP_CH3_1;
	mole.c[ipCH4P][ipHCOP] += CO_CH4P_HCOP_CH3_2;
	mole.b[ipHCOP] += b_CO_CH4P_HCOP_CH3;
	
	mole.c[ipCO][ipCH3] += CO_CH4P_HCOP_CH3_1;
	mole.c[ipCH4P][ipCH3] += CO_CH4P_HCOP_CH3_2;
	mole.b[ipCH3] += b_CO_CH4P_HCOP_CH3;
	
	
	/* >>refer mol   CO CH5P  =>  HCOP CH4   UMIST    */
	
	mole.c[ipCO][ipCO] -= CO_CH5P_HCOP_CH4_1;
	mole.c[ipCH5P][ipCO] -= CO_CH5P_HCOP_CH4_2;
	mole.b[ipCO] -= b_CO_CH5P_HCOP_CH4;
	
	mole.c[ipCO][ipCH5P] -= CO_CH5P_HCOP_CH4_1;
	mole.c[ipCH5P][ipCH5P] -= CO_CH5P_HCOP_CH4_2;
	mole.b[ipCH5P] -= b_CO_CH5P_HCOP_CH4;
	
	mole.c[ipCO][ipHCOP] += CO_CH5P_HCOP_CH4_1;
	mole.c[ipCH5P][ipHCOP] += CO_CH5P_HCOP_CH4_2;
	mole.b[ipHCOP] += b_CO_CH5P_HCOP_CH4;
	
	mole.c[ipCO][ipCH4] += CO_CH5P_HCOP_CH4_1;
	mole.c[ipCH5P][ipCH4] += CO_CH5P_HCOP_CH4_2;
	mole.b[ipCH4] += b_CO_CH5P_HCOP_CH4;
	
	co_e_c_o_e = 0;
	/* inner shell photoionization of CO, assume rates are same as K 1s and 2s
	 * shell of C and O */
	/* >>chng 04 may 26, upper limit should be ns<2, had been ns<2 so picked up
	 * valence shell, which was incorrect */
	for ( ns=0; ns<2; ++ns )
	{
		ion = 0;
		co_e_c_o_e += ionbal.PhotoRate_Shell[ipCARBON][ion][ns][0];
		co_e_c_o_e += ionbal.PhotoRate_Shell[ipOXYGEN][ion][ns][0];
	}
	mole.c[ipCO][ipCO] -= co_e_c_o_e*co.lgUMISTrates;
	mole.c[ipCO][ipATO] += co_e_c_o_e*co.lgUMISTrates;
	mole.c[ipCO][ipATC] += co_e_c_o_e*co.lgUMISTrates;



		/*  >>refer   mol  C      +  NO    =>   CO    +     N	    UMIST  */

			mole.c[ipNO][ipNO] -= C_NO_CO_N_1;
			mole.c[ipATC][ipNO] -= C_NO_CO_N_2;
			mole.b[ipNO] -= b_C_NO_CO_N;

			mole.c[ipNO][ipATC] -= C_NO_CO_N_1;
			mole.c[ipATC][ipATC] -= C_NO_CO_N_2;
			mole.b[ipATC] -= b_C_NO_CO_N;
			
			mole.c[ipNO][ipCO] += C_NO_CO_N_1;
			mole.c[ipATC][ipCO] += C_NO_CO_N_2;
			mole.b[ipCO] += b_C_NO_CO_N;
			
			mole.c[ipNO][ipATN] += C_NO_CO_N_1;
			mole.c[ipATC][ipATN] += C_NO_CO_N_2;
			mole.b[ipATN] += b_C_NO_CO_N;

		/*  >>refer   mol  C      +  OCN   =>   CO    +     CN    UMIST  */

			mole.c[ipOCN][ipOCN] -= C_OCN_CO_CN_1;
			mole.c[ipATC][ipOCN] -= C_OCN_CO_CN_2;
			mole.b[ipOCN] -= b_C_OCN_CO_CN;

			mole.c[ipOCN][ipATC] -= C_OCN_CO_CN_1;
			mole.c[ipATC][ipATC] -= C_OCN_CO_CN_2;
			mole.b[ipATC] -= b_C_OCN_CO_CN;
			
			mole.c[ipOCN][ipCO] += C_OCN_CO_CN_1;
			mole.c[ipATC][ipCO] += C_OCN_CO_CN_2;
			mole.b[ipCO] += b_C_OCN_CO_CN;
			
			mole.c[ipOCN][ipCN] += C_OCN_CO_CN_1;
			mole.c[ipATC][ipCN] += C_OCN_CO_CN_2;
			mole.b[ipCN] += b_C_OCN_CO_CN;

			/*  >>refer   mol  C      +  SO    =>   S     +     CO    UMIST  */

			mole.c[ipSO][ipATC] -= C_SO_S_CO_1;
			mole.c[ipATC][ipATC] -= C_SO_S_CO_2;
			mole.b[ipATC] -= b_C_SO_S_CO;
			
			mole.c[ipSO][ipSO] -= C_SO_S_CO_1;
			mole.c[ipATC][ipSO] -= C_SO_S_CO_2;
			mole.b[ipSO] -= b_C_SO_S_CO;
			
			mole.c[ipSO][ipCO] += C_SO_S_CO_1;
			mole.c[ipATC][ipCO] += C_SO_S_CO_2;
			mole.b[ipCO] += b_C_SO_S_CO;

			mole.c[ipSO][ipATS] += C_SO_S_CO_1;
			mole.c[ipATC][ipATS] += C_SO_S_CO_2;
			mole.b[ipATS] += b_C_SO_S_CO;

		/*  >>refer   mol  O      +  CN    =>   CO    +     N     UMIST  */

			mole.c[ipCN][ipCN] -= O_CN_CO_N_1;
			mole.c[ipATO][ipCN] -= O_CN_CO_N_2;
			mole.b[ipCN] -= b_O_CN_CO_N;
			
			mole.c[ipCN][ipATO] -= O_CN_CO_N_1;
			mole.c[ipATO][ipATO] -= O_CN_CO_N_2;
			mole.b[ipATO] -= b_O_CN_CO_N;
			
			mole.c[ipCN][ipCO] += O_CN_CO_N_1;
			mole.c[ipATO][ipCO] += O_CN_CO_N_2;
			mole.b[ipCO] += b_O_CN_CO_N;

			mole.c[ipCN][ipATN] += O_CN_CO_N_1;
			mole.c[ipATO][ipATN] += O_CN_CO_N_2;
			mole.b[ipATN] += b_O_CN_CO_N;

		/*  >>refer   mol  O      +  HCN   =>   CO    +     NH    UMIST  */

			mole.c[ipHCN][ipHCN] -= O_HCN_CO_NH_1;
			mole.c[ipATO][ipHCN] -= O_HCN_CO_NH_2;
			mole.b[ipHCN] -= b_O_HCN_CO_NH;
			
			mole.c[ipHCN][ipATO] -= O_HCN_CO_NH_1;
			mole.c[ipATO][ipATO] -= O_HCN_CO_NH_2;
			mole.b[ipATO] -= b_O_HCN_CO_NH;

			mole.c[ipHCN][ipCO] += O_HCN_CO_NH_1;
			mole.c[ipATO][ipCO] += O_HCN_CO_NH_2;
			mole.b[ipCO] += b_O_HCN_CO_NH;
			
			mole.c[ipHCN][ipNH] += O_HCN_CO_NH_1;
			mole.c[ipATO][ipNH] += O_HCN_CO_NH_2;
			mole.b[ipNH] += b_O_HCN_CO_NH;

		/*  >>refer   mol  O      +  OCN   =>   NO    +     CO    UMIST  */
			
			mole.c[ipOCN][ipOCN] -= O_OCN_NO_CO_1;
			mole.c[ipATO][ipOCN] -= O_OCN_NO_CO_2;
			mole.b[ipOCN] -= b_O_OCN_NO_CO;
					
			mole.c[ipOCN][ipATO] -= O_OCN_NO_CO_1;
			mole.c[ipATO][ipATO] -= O_OCN_NO_CO_2;
			mole.b[ipATO] -= b_O_OCN_NO_CO;
			
			mole.c[ipOCN][ipNO] += O_OCN_NO_CO_1;
			mole.c[ipATO][ipNO] += O_OCN_NO_CO_2;
			mole.b[ipNO] += b_O_OCN_NO_CO;
			
			mole.c[ipOCN][ipCO] += O_OCN_NO_CO_1;
			mole.c[ipATO][ipCO] += O_OCN_NO_CO_2;
			mole.b[ipCO] += b_O_OCN_NO_CO;

		/*  >>refer   mol  O      +  CS    =>   S     +     CO    UMIST  */

			mole.c[ipCS][ipCS] -= O_CS_S_CO_1;
			mole.c[ipATO][ipCS] -= O_CS_S_CO_2;
			mole.b[ipCS] -= b_O_CS_S_CO;
			
			mole.c[ipCS][ipATO] -= O_CS_S_CO_1;
			mole.c[ipATO][ipATO] -= O_CS_S_CO_2;
			mole.b[ipATO] -= b_O_CS_S_CO;
			
			mole.c[ipCS][ipCO] += O_CS_S_CO_1;
			mole.c[ipATO][ipCO] += O_CS_S_CO_2;
			mole.b[ipCO] += b_O_CS_S_CO;

			mole.c[ipCS][ipATS] += O_CS_S_CO_1;
			mole.c[ipATO][ipATS] += O_CS_S_CO_2;
			mole.b[ipATS] += b_O_CS_S_CO;

		/*  >>refer   mol  O      +  OCS   =>   SO    +     CO    UMIST  */

			mole.c[ipOCS][ipOCS] -= O_OCS_SO_CO_1;
			mole.c[ipATO][ipOCS] -= O_OCS_SO_CO_2;
			mole.b[ipOCS] -= b_O_OCS_SO_CO;
			
			mole.c[ipOCS][ipATO] -= O_OCS_SO_CO_1;
			mole.c[ipATO][ipATO] -= O_OCS_SO_CO_2;
			mole.b[ipATO] -= b_O_OCS_SO_CO;

			mole.c[ipOCS][ipSO] += O_OCS_SO_CO_1;
			mole.c[ipATO][ipSO] += O_OCS_SO_CO_2;
			mole.b[ipSO] += b_O_OCS_SO_CO;
			
			mole.c[ipOCS][ipCO] += O_OCS_SO_CO_1;
			mole.c[ipATO][ipCO] += O_OCS_SO_CO_2;
			mole.b[ipCO] += b_O_OCS_SO_CO;

		/*  >>refer   mol  OH     +  HCN   =>   CO    +     NH2   UMIST  */

			mole.c[ipHCN][ipOH] -= OH_HCN_CO_NH2_1;
			mole.c[ipOH][ipOH] -= OH_HCN_CO_NH2_2;
			mole.b[ipOH] -= b_OH_HCN_CO_NH2;
			
			mole.c[ipHCN][ipHCN] -= OH_HCN_CO_NH2_1;
			mole.c[ipOH][ipHCN] -= OH_HCN_CO_NH2_2;
			mole.b[ipHCN] -= b_OH_HCN_CO_NH2;
			
			mole.c[ipHCN][ipCO] += OH_HCN_CO_NH2_1;
			mole.c[ipOH][ipCO] += OH_HCN_CO_NH2_2;
			mole.b[ipCO] += b_OH_HCN_CO_NH2;
			
			mole.c[ipHCN][ipNH2] += OH_HCN_CO_NH2_1;
			mole.c[ipOH][ipNH2] += OH_HCN_CO_NH2_2;
			mole.b[ipNH2] += b_OH_HCN_CO_NH2;

		/*  >>refer   mol  CN     +  NO    =>   N2    +     CO    UMIST  */

			mole.c[ipNO][ipCN] -= CN_NO_N2_CO_1;
			mole.c[ipCN][ipCN] -= CN_NO_N2_CO_2;
			mole.b[ipCN] -= b_CN_NO_N2_CO;
			
			mole.c[ipNO][ipNO] -= CN_NO_N2_CO_1;
			mole.c[ipCN][ipNO] -= CN_NO_N2_CO_2;
			mole.b[ipNO] -= b_CN_NO_N2_CO;
			
			mole.c[ipNO][ipN2] += CN_NO_N2_CO_1;
			mole.c[ipCN][ipN2] += CN_NO_N2_CO_2;
			mole.b[ipN2] += b_CN_NO_N2_CO;
			
			mole.c[ipNO][ipCO] += CN_NO_N2_CO_1;
			mole.c[ipCN][ipCO] += CN_NO_N2_CO_2;
			mole.b[ipCO] += b_CN_NO_N2_CO;

		/*  >>refer   mol  CN     +  O2    =>   NO    +     CO    UMIST  */

			mole.c[ipO2][ipCN] -= CN_O2_NO_CO_1;
			mole.c[ipCN][ipCN] -= CN_O2_NO_CO_2;
			mole.b[ipCN] -= b_CN_O2_NO_CO;
			
			mole.c[ipO2][ipO2] -= CN_O2_NO_CO_1;
			mole.c[ipCN][ipO2] -= CN_O2_NO_CO_2;
			mole.b[ipO2] -= b_CN_O2_NO_CO;
			
			mole.c[ipO2][ipNO] += CN_O2_NO_CO_1;
			mole.c[ipCN][ipNO] += CN_O2_NO_CO_2;
			mole.b[ipNO] += b_CN_O2_NO_CO;
			
			mole.c[ipO2][ipCO] += CN_O2_NO_CO_1;
			mole.c[ipCN][ipCO] += CN_O2_NO_CO_2;
			mole.b[ipCO] += b_CN_O2_NO_CO;

		/*  >>refer   mol  CO     +  HS    =>   OCS   +     H     UMIST  */

			mole.c[ipHS][ipCO] -= CO_HS_OCS_H_1;
			mole.c[ipCO][ipCO] -= CO_HS_OCS_H_2;
			mole.b[ipCO] -= b_CO_HS_OCS_H;
			
			mole.c[ipHS][ipHS] -= CO_HS_OCS_H_1;
			mole.c[ipCO][ipHS] -= CO_HS_OCS_H_2;
			mole.b[ipHS] -= b_CO_HS_OCS_H;
			
			mole.c[ipHS][ipOCS] += CO_HS_OCS_H_1;
			mole.c[ipCO][ipOCS] += CO_HS_OCS_H_2;
			mole.b[ipOCS] += b_CO_HS_OCS_H;
			
		/*  >>refer   mol  H+     +  OCS   =>   HS+   +     CO    UMIST  */

			mole.c[ipOCS][ipOCS] -= HP_OCS_HSP_CO;
			mole.c[ipOCS][ipHSP] += HP_OCS_HSP_CO;
			mole.c[ipOCS][ipCO] += HP_OCS_HSP_CO;

		/*  >>refer   mol  He+    +  OCS   =>   S+    +     CO +  He     UMIST  */

			mole.c[ipOCS][ipOCS] -= HeP_OCS_SP_CO_He;
			mole.c[ipOCS][ipSP] += HeP_OCS_SP_CO_He;
			mole.c[ipOCS][ipCO] += HeP_OCS_SP_CO_He;

		/*  >>refer   mol  C+     +  SO    =>   S+    +     CO    UMIST  */

			mole.c[ipSO][ipCP] -= CP_SO_SP_CO_1;
			mole.c[ipCP][ipCP] -= CP_SO_SP_CO_2;
			mole.b[ipCP] -= b_CP_SO_SP_CO;
			
			mole.c[ipSO][ipSO] -= CP_SO_SP_CO_1;
			mole.c[ipCP][ipSO] -= CP_SO_SP_CO_2;
			mole.b[ipSO] -= b_CP_SO_SP_CO;
			
			mole.c[ipSO][ipSP] += CP_SO_SP_CO_1;
			mole.c[ipCP][ipSP] += CP_SO_SP_CO_2;
			mole.b[ipSP] += b_CP_SO_SP_CO;
			
			mole.c[ipSO][ipCO] += CP_SO_SP_CO_1;
			mole.c[ipCP][ipCO] += CP_SO_SP_CO_2;
			mole.b[ipCO] += b_CP_SO_SP_CO;

		/*  >>refer   mol  C+     +  OCS   =>   CS+   +     CO    UMIST  */

			mole.c[ipOCS][ipCP] -= CP_OCS_CSP_CO_1;
			mole.c[ipCP][ipCP] -= CP_OCS_CSP_CO_2;
			mole.b[ipCP] -= b_CP_OCS_CSP_CO;
			
			mole.c[ipOCS][ipOCS] -= CP_OCS_CSP_CO_1;
			mole.c[ipCP][ipOCS] -= CP_OCS_CSP_CO_2;
			mole.b[ipOCS] -= b_CP_OCS_CSP_CO;
			
			mole.c[ipOCS][ipCSP] += CP_OCS_CSP_CO_1;
			mole.c[ipCP][ipCSP] += CP_OCS_CSP_CO_2;
			mole.b[ipCSP] += b_CP_OCS_CSP_CO;
			
			mole.c[ipOCS][ipCO] += CP_OCS_CSP_CO_1;
			mole.c[ipCP][ipCO] += CP_OCS_CSP_CO_2;
			mole.b[ipCO] += b_CP_OCS_CSP_CO;

		/*  >>refer   mol  CH+    +  OCS   =>   HCS+  +     CO    UMIST  */

			mole.c[ipOCS][ipCHP] -= CHP_OCS_HCSP_CO_1;
			mole.c[ipCHP][ipCHP] -= CHP_OCS_HCSP_CO_2;
			mole.b[ipCHP] -= b_CHP_OCS_HCSP_CO;
			
			mole.c[ipOCS][ipOCS] -= CHP_OCS_HCSP_CO_1;
			mole.c[ipCHP][ipOCS] -= CHP_OCS_HCSP_CO_2;
			mole.b[ipOCS] -= b_CHP_OCS_HCSP_CO;
			
			mole.c[ipOCS][ipHCSP] += CHP_OCS_HCSP_CO_1;
			mole.c[ipCHP][ipHCSP] += CHP_OCS_HCSP_CO_2;
			mole.b[ipHCSP] += b_CHP_OCS_HCSP_CO;
			
			mole.c[ipOCS][ipCO] += CHP_OCS_HCSP_CO_1;
			mole.c[ipCHP][ipCO] += CHP_OCS_HCSP_CO_2;
			mole.b[ipCO] += b_CHP_OCS_HCSP_CO;

		/*  >>refer   mol  N+     +  CO    =>   NO+   +     C     UMIST  */

			mole.c[ipCO][ipNP] -= NP_CO_NOP_C_1;
			mole.c[ipNP][ipNP] -= NP_CO_NOP_C_2;
			mole.b[ipNP] -= b_NP_CO_NOP_C;
			
			mole.c[ipCO][ipCO] -= NP_CO_NOP_C_1;
			mole.c[ipNP][ipCO] -= NP_CO_NOP_C_2;
			mole.b[ipCO] -= b_NP_CO_NOP_C;
			
			mole.c[ipCO][ipNOP] += NP_CO_NOP_C_1;
			mole.c[ipNP][ipNOP] += NP_CO_NOP_C_2;
			mole.b[ipNOP] += b_NP_CO_NOP_C;
			
			mole.c[ipCO][ipATC] += NP_CO_NOP_C_1;
			mole.c[ipNP][ipATC] += NP_CO_NOP_C_2;
			mole.b[ipATC] += b_NP_CO_NOP_C;
			
		/*  >>refer   mol  N+     +  OCS   =>   S+    +     CO +  N      UMIST  */

			mole.c[ipOCS][ipNP] -= NP_OCS_SP_CO_N_1;
			mole.c[ipNP][ipNP] -= NP_OCS_SP_CO_N_2;
			mole.b[ipNP] -= b_NP_OCS_SP_CO_N;
			
			mole.c[ipOCS][ipOCS] -= NP_OCS_SP_CO_N_1;
			mole.c[ipNP][ipOCS] -= NP_OCS_SP_CO_N_2;
			mole.b[ipOCS] -= b_NP_OCS_SP_CO_N;
			
			mole.c[ipOCS][ipSP] += NP_OCS_SP_CO_N_1;
			mole.c[ipNP][ipSP] += NP_OCS_SP_CO_N_2;
			mole.b[ipSP] += b_NP_OCS_SP_CO_N;
			
			mole.c[ipOCS][ipCO] += NP_OCS_SP_CO_N_1;
			mole.c[ipNP][ipCO] += NP_OCS_SP_CO_N_2;
			mole.b[ipCO] += b_NP_OCS_SP_CO_N;
			
			mole.c[ipOCS][ipATN] += NP_OCS_SP_CO_N_1;
			mole.c[ipNP][ipATN] += NP_OCS_SP_CO_N_2;
			mole.b[ipATN] += b_NP_OCS_SP_CO_N;

		/*  >>refer   mol  NH+    +  CO    =>   HCO+  +     N     UMIST  */

			mole.c[ipCO][ipNHP] -= NHP_CO_HCOP_N_1;
			mole.c[ipNHP][ipNHP] -= NHP_CO_HCOP_N_2;
			mole.b[ipNHP] -= b_NHP_CO_HCOP_N;
			
			mole.c[ipCO][ipCO] -= NHP_CO_HCOP_N_1;
			mole.c[ipNHP][ipCO] -= NHP_CO_HCOP_N_2;
			mole.b[ipCO] -= b_NHP_CO_HCOP_N;
			
			mole.c[ipCO][ipHCOP] += NHP_CO_HCOP_N_1;
			mole.c[ipNHP][ipHCOP] += NHP_CO_HCOP_N_2;
			mole.b[ipHCOP] += b_NHP_CO_HCOP_N;
			
			mole.c[ipCO][ipATN] += NHP_CO_HCOP_N_1;
			mole.c[ipNHP][ipATN] += NHP_CO_HCOP_N_2;
			mole.b[ipATN] += b_NHP_CO_HCOP_N;
			
		/*  >>refer   mol  NH+    +  CO    =>   OCN+  +     H     UMIST  */

			mole.c[ipCO][ipNHP] -= NHP_CO_OCNP_H_1;
			mole.c[ipNHP][ipNHP] -= NHP_CO_OCNP_H_2;
			mole.b[ipNHP] -= b_NHP_CO_OCNP_H;
			
			mole.c[ipCO][ipCO] -= NHP_CO_OCNP_H_1;
			mole.c[ipNHP][ipCO] -= NHP_CO_OCNP_H_2;
			mole.b[ipCO] -= b_NHP_CO_OCNP_H;
			
			mole.c[ipCO][ipOCNP] += NHP_CO_OCNP_H_1;
			mole.c[ipNHP][ipOCNP] += NHP_CO_OCNP_H_2;
			mole.b[ipOCNP] += b_NHP_CO_OCNP_H;

		/*  >>refer   mol  NH     +  HCO+  =>   CO    +     NH2+  UMIST  */

			mole.c[ipHCOP][ipNH] -= NH_HCOP_CO_NH2P_1;
			mole.c[ipNH][ipNH] -= NH_HCOP_CO_NH2P_2;
			mole.b[ipNH] -= b_NH_HCOP_CO_NH2P;
			
			mole.c[ipHCOP][ipHCOP] -= NH_HCOP_CO_NH2P_1;
			mole.c[ipNH][ipHCOP] -= NH_HCOP_CO_NH2P_2;
			mole.b[ipHCOP] -= b_NH_HCOP_CO_NH2P;
			
			mole.c[ipHCOP][ipCO] += NH_HCOP_CO_NH2P_1;
			mole.c[ipNH][ipCO] += NH_HCOP_CO_NH2P_2;
			mole.b[ipCO] += b_NH_HCOP_CO_NH2P;
			
			mole.c[ipHCOP][ipNH2P] += NH_HCOP_CO_NH2P_1;
			mole.c[ipNH][ipNH2P] += NH_HCOP_CO_NH2P_2;
			mole.b[ipNH2P] += b_NH_HCOP_CO_NH2P;

		/*  >>refer   mol  NH2    +  HCO+  =>   CO    +     NH3+  UMIST  */

			mole.c[ipHCOP][ipNH2] -= NH2_HCOP_CO_NH3P_1;
			mole.c[ipNH2][ipNH2] -= NH2_HCOP_CO_NH3P_2;
			mole.b[ipNH2] -= b_NH2_HCOP_CO_NH3P;
			
			mole.c[ipHCOP][ipHCOP] -= NH2_HCOP_CO_NH3P_1;
			mole.c[ipNH2][ipHCOP] -= NH2_HCOP_CO_NH3P_2;
			mole.b[ipHCOP] -= b_NH2_HCOP_CO_NH3P;
			
			mole.c[ipHCOP][ipCO] += NH2_HCOP_CO_NH3P_1;
			mole.c[ipNH2][ipCO] += NH2_HCOP_CO_NH3P_2;
			mole.b[ipCO] += b_NH2_HCOP_CO_NH3P;
			
			mole.c[ipHCOP][ipNH3P] += NH2_HCOP_CO_NH3P_1;
			mole.c[ipNH2][ipNH3P] += NH2_HCOP_CO_NH3P_2;
			mole.b[ipNH3P] += b_NH2_HCOP_CO_NH3P;

		/*  >>refer   mol  NH3    +  HCO+  =>   CO    +     NH4+  UMIST  */

			mole.c[ipHCOP][ipNH3] -= NH3_HCOP_CO_NH4P_1;
			mole.c[ipNH3][ipNH3] -= NH3_HCOP_CO_NH4P_2;
			mole.b[ipNH3] -= b_NH3_HCOP_CO_NH4P;
			
			mole.c[ipHCOP][ipHCOP] -= NH3_HCOP_CO_NH4P_1;
			mole.c[ipNH3][ipHCOP] -= NH3_HCOP_CO_NH4P_2;
			mole.b[ipHCOP] -= b_NH3_HCOP_CO_NH4P;
			
			mole.c[ipHCOP][ipCO] += NH3_HCOP_CO_NH4P_1;
			mole.c[ipNH3][ipCO] += NH3_HCOP_CO_NH4P_2;
			mole.b[ipCO] += b_NH3_HCOP_CO_NH4P;
			
			mole.c[ipHCOP][ipNH4P] += NH3_HCOP_CO_NH4P_1;
			mole.c[ipNH3][ipNH4P] += NH3_HCOP_CO_NH4P_2;
			mole.b[ipNH4P] += b_NH3_HCOP_CO_NH4P;

		/*  >>refer   mol  CN+    +  O2    =>   NO+   +     CO    UMIST  */

			mole.c[ipO2][ipCNP] -= CNP_O2_NOP_CO_1;
			mole.c[ipCNP][ipCNP] -= CNP_O2_NOP_CO_2;
			mole.b[ipCNP] -= b_CNP_O2_NOP_CO;
			
			mole.c[ipO2][ipO2] -= CNP_O2_NOP_CO_1;
			mole.c[ipCNP][ipO2] -= CNP_O2_NOP_CO_2;
			mole.b[ipO2] -= b_CNP_O2_NOP_CO;
			
			mole.c[ipO2][ipNOP] += CNP_O2_NOP_CO_1;
			mole.c[ipCNP][ipNOP] += CNP_O2_NOP_CO_2;
			mole.b[ipNOP] += b_CNP_O2_NOP_CO;
			
			mole.c[ipO2][ipCO] += CNP_O2_NOP_CO_1;
			mole.c[ipCNP][ipCO] += CNP_O2_NOP_CO_2;
			mole.b[ipCO] += b_CNP_O2_NOP_CO;

		/*  >>refer   mol  HCN+   +  CO    =>   HCO+  +     CN    UMIST  */

			mole.c[ipCO][ipHCNP] -= HCNP_CO_HCOP_CN_1;
			mole.c[ipHCNP][ipHCNP] -= HCNP_CO_HCOP_CN_2;
			mole.b[ipHCNP] -= b_HCNP_CO_HCOP_CN;
			
			mole.c[ipCO][ipCO] -= HCNP_CO_HCOP_CN_1;
			mole.c[ipHCNP][ipCO] -= HCNP_CO_HCOP_CN_2;
			mole.b[ipCO] -= b_HCNP_CO_HCOP_CN;
			
			mole.c[ipCO][ipHCOP] += HCNP_CO_HCOP_CN_1;
			mole.c[ipHCNP][ipHCOP] += HCNP_CO_HCOP_CN_2;
			mole.b[ipHCOP] += b_HCNP_CO_HCOP_CN;
			
			mole.c[ipCO][ipCN] += HCNP_CO_HCOP_CN_1;
			mole.c[ipHCNP][ipCN] += HCNP_CO_HCOP_CN_2;
			mole.b[ipCN] += b_HCNP_CO_HCOP_CN;

		/*  >>refer   mol  CO     +  HNO+  =>   NO    +     HCO+  UMIST  */

			mole.c[ipHNOP][ipCO] -= CO_HNOP_NO_HCOP_1;
			mole.c[ipCO][ipCO] -= CO_HNOP_NO_HCOP_2;
			mole.b[ipCO] -= b_CO_HNOP_NO_HCOP;
			
			mole.c[ipHNOP][ipHNOP] -= CO_HNOP_NO_HCOP_1;
			mole.c[ipCO][ipHNOP] -= CO_HNOP_NO_HCOP_2;
			mole.b[ipHNOP] -= b_CO_HNOP_NO_HCOP;
			
			mole.c[ipHNOP][ipNO] += CO_HNOP_NO_HCOP_1;
			mole.c[ipCO][ipNO] += CO_HNOP_NO_HCOP_2;
			mole.b[ipNO] += b_CO_HNOP_NO_HCOP;
			
			mole.c[ipHNOP][ipHCOP] += CO_HNOP_NO_HCOP_1;
			mole.c[ipCO][ipHCOP] += CO_HNOP_NO_HCOP_2;
			mole.b[ipHCOP] += b_CO_HNOP_NO_HCOP;

		/*  >>refer   mol  N2+    +  OCS   =>   S+    +     N2  + CO     UMIST  */

			mole.c[ipOCS][ipN2P] -= N2P_OCS_SP_N2_CO_1;
			mole.c[ipN2P][ipN2P] -= N2P_OCS_SP_N2_CO_2;
			mole.b[ipN2P] -= b_N2P_OCS_SP_N2_CO;
			
			mole.c[ipOCS][ipOCS] -= N2P_OCS_SP_N2_CO_1;
			mole.c[ipN2P][ipOCS] -= N2P_OCS_SP_N2_CO_2;
			mole.b[ipOCS] -= b_N2P_OCS_SP_N2_CO;
			
			mole.c[ipOCS][ipSP] += N2P_OCS_SP_N2_CO_1;
			mole.c[ipN2P][ipSP] += N2P_OCS_SP_N2_CO_2;
			mole.b[ipSP] += b_N2P_OCS_SP_N2_CO;
			
			mole.c[ipOCS][ipN2] += N2P_OCS_SP_N2_CO_1;
			mole.c[ipN2P][ipN2] += N2P_OCS_SP_N2_CO_2;
			mole.b[ipN2] += b_N2P_OCS_SP_N2_CO;

			mole.c[ipOCS][ipCO] += N2P_OCS_SP_N2_CO_1;
			mole.c[ipN2P][ipCO] += N2P_OCS_SP_N2_CO_2;
			mole.b[ipCO] += b_N2P_OCS_SP_N2_CO;

		/*  >>refer   mol  HCO+   +  S     =>   HS+   +     CO    UMIST  */

			mole.c[ipATS][ipHCOP] -= HCOP_S_HSP_CO_1;
			mole.c[ipHCOP][ipHCOP] -= HCOP_S_HSP_CO_2;
			mole.b[ipHCOP] -= b_HCOP_S_HSP_CO;

			mole.c[ipATS][ipATS] -= HCOP_S_HSP_CO_1;
			mole.c[ipHCOP][ipATS] -= HCOP_S_HSP_CO_2;
			mole.b[ipATS] -= b_HCOP_S_HSP_CO;
			
			mole.c[ipATS][ipHSP] += HCOP_S_HSP_CO_1;
			mole.c[ipHCOP][ipHSP] += HCOP_S_HSP_CO_2;
			mole.b[ipHSP] += b_HCOP_S_HSP_CO;
			
			mole.c[ipATS][ipCO] += HCOP_S_HSP_CO_1;
			mole.c[ipHCOP][ipCO] += HCOP_S_HSP_CO_2;
			mole.b[ipCO] += b_HCOP_S_HSP_CO;

		/*  >>refer   mol  HCO+   +  CS    =>   HCS+  +     CO    UMIST  */

			mole.c[ipCS][ipHCOP] -= HCOP_CS_HCSP_CO_1;
			mole.c[ipHCOP][ipHCOP] -= HCOP_CS_HCSP_CO_2;
			mole.b[ipHCOP] -= b_HCOP_CS_HCSP_CO;
			
			mole.c[ipCS][ipCS] -= HCOP_CS_HCSP_CO_1;
			mole.c[ipHCOP][ipCS] -= HCOP_CS_HCSP_CO_2;
			mole.b[ipCS] -= b_HCOP_CS_HCSP_CO;
			
			mole.c[ipCS][ipHCSP] += HCOP_CS_HCSP_CO_1;
			mole.c[ipHCOP][ipHCSP] += HCOP_CS_HCSP_CO_2;
			mole.b[ipHCSP] += b_HCOP_CS_HCSP_CO;
			
			mole.c[ipCS][ipCO] += HCOP_CS_HCSP_CO_1;
			mole.c[ipHCOP][ipCO] += HCOP_CS_HCSP_CO_2;
			mole.b[ipCO] += b_HCOP_CS_HCSP_CO;

		/*  >>refer   mol  NH     +  CO+   =>   CO    +     NH+   UMIST  */

			mole.c[ipCOP][ipNH] -= NH_COP_CO_NHP_1;
			mole.c[ipNH][ipNH] -= NH_COP_CO_NHP_2;
			mole.b[ipNH] -= b_NH_COP_CO_NHP;
			
			mole.c[ipCOP][ipCOP] -= NH_COP_CO_NHP_1;
			mole.c[ipNH][ipCOP] -= NH_COP_CO_NHP_2;
			mole.b[ipCOP] -= b_NH_COP_CO_NHP;
			
			mole.c[ipCOP][ipCO] += NH_COP_CO_NHP_1;
			mole.c[ipNH][ipCO] += NH_COP_CO_NHP_2;
			mole.b[ipCO] += b_NH_COP_CO_NHP;
			
			mole.c[ipCOP][ipNHP] += NH_COP_CO_NHP_1;
			mole.c[ipNH][ipNHP] += NH_COP_CO_NHP_2;
			mole.b[ipNHP] += b_NH_COP_CO_NHP;

		/*  >>refer   mol  NH2    +  CO+   =>   CO    +     NH2+  UMIST  */

			mole.c[ipCOP][ipNH2] -= NH2_COP_CO_NH2P_1;
			mole.c[ipNH2][ipNH2] -= NH2_COP_CO_NH2P_2;
			mole.b[ipNH2] -= b_NH2_COP_CO_NH2P;
			
			mole.c[ipCOP][ipCOP] -= NH2_COP_CO_NH2P_1;
			mole.c[ipNH2][ipCOP] -= NH2_COP_CO_NH2P_2;
			mole.b[ipCOP] -= b_NH2_COP_CO_NH2P;
			
			mole.c[ipCOP][ipCO] += NH2_COP_CO_NH2P_1;
			mole.c[ipNH2][ipCO] += NH2_COP_CO_NH2P_2;
			mole.b[ipCO] += b_NH2_COP_CO_NH2P;
			
			mole.c[ipCOP][ipNH2P] += NH2_COP_CO_NH2P_1;
			mole.c[ipNH2][ipNH2P] += NH2_COP_CO_NH2P_2;
			mole.b[ipNH2P] += b_NH2_COP_CO_NH2P;

		/*  >>refer   mol  NH3    +  CO+   =>   CO    +     NH3+  UMIST  */

			mole.c[ipCOP][ipNH3] -= NH3_COP_CO_NH3P_1;
			mole.c[ipNH3][ipNH3] -= NH3_COP_CO_NH3P_2;
			mole.b[ipNH3] -= b_NH3_COP_CO_NH3P;
			
			mole.c[ipCOP][ipCOP] -= NH3_COP_CO_NH3P_1;
			mole.c[ipNH3][ipCOP] -= NH3_COP_CO_NH3P_2;
			mole.b[ipCOP] -= b_NH3_COP_CO_NH3P;
			
			mole.c[ipCOP][ipCO] += NH3_COP_CO_NH3P_1;
			mole.c[ipNH3][ipCO] += NH3_COP_CO_NH3P_2;
			mole.b[ipCO] += b_NH3_COP_CO_NH3P;
			
			mole.c[ipCOP][ipNH3P] += NH3_COP_CO_NH3P_1;
			mole.c[ipNH3][ipNH3P] += NH3_COP_CO_NH3P_2;
			mole.b[ipNH3P] += b_NH3_COP_CO_NH3P;

		/*  >>refer   mol  CN+    +  CO    =>   CO+   +     CN    UMIST  */

			mole.c[ipCO][ipCNP] -= CNP_CO_COP_CN_1;
			mole.c[ipCNP][ipCNP] -= CNP_CO_COP_CN_2;
			mole.b[ipCNP] -= b_CNP_CO_COP_CN;
			
			mole.c[ipCO][ipCO] -= CNP_CO_COP_CN_1;
			mole.c[ipCNP][ipCO] -= CNP_CO_COP_CN_2;
			mole.b[ipCO] -= b_CNP_CO_COP_CN;
			
			mole.c[ipCO][ipCOP] += CNP_CO_COP_CN_1;
			mole.c[ipCNP][ipCOP] += CNP_CO_COP_CN_2;
			mole.b[ipCOP] += b_CNP_CO_COP_CN;
			
			mole.c[ipCO][ipCN] += CNP_CO_COP_CN_1;
			mole.c[ipCNP][ipCN] += CNP_CO_COP_CN_2;
			mole.b[ipCN] += b_CNP_CO_COP_CN;

		/*  >>refer   mol  HCN    +  CO+   =>   CO    +     HCN+  UMIST  */

			mole.c[ipCOP][ipHCN] -= HCN_COP_CO_HCNP_1;
			mole.c[ipHCN][ipHCN] -= HCN_COP_CO_HCNP_2;
			mole.b[ipHCN] -= b_HCN_COP_CO_HCNP;
			
			mole.c[ipCOP][ipCOP] -= HCN_COP_CO_HCNP_1;
			mole.c[ipHCN][ipCOP] -= HCN_COP_CO_HCNP_2;
			mole.b[ipCOP] -= b_HCN_COP_CO_HCNP;
			
			mole.c[ipCOP][ipCO] += HCN_COP_CO_HCNP_1;
			mole.c[ipHCN][ipCO] += HCN_COP_CO_HCNP_2;
			mole.b[ipCO] += b_HCN_COP_CO_HCNP;
			
			mole.c[ipCOP][ipHCNP] += HCN_COP_CO_HCNP_1;
			mole.c[ipHCN][ipHCNP] += HCN_COP_CO_HCNP_2;
			mole.b[ipHCNP] += b_HCN_COP_CO_HCNP;

		/*  >>refer   mol  CO     +  N2+   =>   N2    +     CO+   UMIST  */

			mole.c[ipN2P][ipCO] -= CO_N2P_N2_COP_1;
			mole.c[ipCO][ipCO] -= CO_N2P_N2_COP_2;
			mole.b[ipCO] -= b_CO_N2P_N2_COP;
			
			mole.c[ipN2P][ipN2P] -= CO_N2P_N2_COP_1;
			mole.c[ipCO][ipN2P] -= CO_N2P_N2_COP_2;
			mole.b[ipN2P] -= b_CO_N2P_N2_COP;
			
			mole.c[ipN2P][ipN2] += CO_N2P_N2_COP_1;
			mole.c[ipCO][ipN2] += CO_N2P_N2_COP_2;
			mole.b[ipN2] += b_CO_N2P_N2_COP;
			
			mole.c[ipN2P][ipCOP] += CO_N2P_N2_COP_1;
			mole.c[ipCO][ipCOP] += CO_N2P_N2_COP_2;
			mole.b[ipCOP] += b_CO_N2P_N2_COP;

		/*  >>refer   mol  CO+    +  NO    =>   NO+   +     CO    UMIST  */

			mole.c[ipNO][ipCOP] -= COP_NO_NOP_CO_1;
			mole.c[ipCOP][ipCOP] -= COP_NO_NOP_CO_2;
			mole.b[ipCOP] -= b_COP_NO_NOP_CO;
			
			mole.c[ipNO][ipNO] -= COP_NO_NOP_CO_1;
			mole.c[ipCOP][ipNO] -= COP_NO_NOP_CO_2;
			mole.b[ipNO] -= b_COP_NO_NOP_CO;
			
			mole.c[ipNO][ipNOP] += COP_NO_NOP_CO_1;
			mole.c[ipCOP][ipNOP] += COP_NO_NOP_CO_2;
			mole.b[ipNOP] += b_COP_NO_NOP_CO;
			
			mole.c[ipNO][ipCO] += COP_NO_NOP_CO_1;
			mole.c[ipCOP][ipCO] += COP_NO_NOP_CO_2;
			mole.b[ipCO] += b_COP_NO_NOP_CO;

		/*  >>refer   mol  OCN+   +  e     =>   CO    +     N     UMIST  */

			mole.c[ipOCNP][ipOCNP] -= OCNP_e_CO_N;
			mole.c[ipOCNP][ipCO] += OCNP_e_CO_N;
			mole.c[ipOCNP][ipATN] += OCNP_e_CO_N;

		/*  >>refer   mol  OCS+   +  e     =>   S     +     CO    UMIST  */

			mole.c[ipOCSP][ipOCSP] -= OCSP_e_S_CO;
			mole.c[ipOCSP][ipCO] += OCSP_e_S_CO;
			mole.c[ipOCSP][ipATS] += OCSP_e_S_CO;

		/*  >>refer   mol  CO     +  S     =>   OCS   +     NU    UMIST  */

			mole.c[ipATS][ipCO]  -= CO_S_OCS_NU_1;
			mole.c[ipCO][ipCO] -= CO_S_OCS_NU_2;
			mole.b[ipCO] -= b_CO_S_OCS_NU;

			mole.c[ipATS][ipATS]  -= CO_S_OCS_NU_1;
			mole.c[ipCO][ipATS] -= CO_S_OCS_NU_2;
			mole.b[ipATS] -= b_CO_S_OCS_NU;

			mole.c[ipATS][ipOCS]  += CO_S_OCS_NU_1;
			mole.c[ipCO][ipOCS] += CO_S_OCS_NU_2;
			mole.b[ipOCS] += b_CO_S_OCS_NU;

		/*  >>refer   mol  OCS    +  NU    =>   S     +     CO    UMIST  */

			mole.c[ipOCS][ipOCS] -= OCS_NU_S_CO;
			mole.c[ipOCS][ipCO] += OCS_NU_S_CO;
			mole.c[ipOCS][ipATS] += OCS_NU_S_CO;

		/*  >>refer   mol  OCS    +  CRP   =>   S     +     CO    UMIST  */

			mole.c[ipOCS][ipOCS] -= OCS_CRP_S_CO;
			mole.c[ipOCS][ipCO] += OCS_CRP_S_CO;
			mole.c[ipOCS][ipATS] += OCS_CRP_S_CO;

		/*  >>refer   mol  N+     +  CO    =>   CO+   +     N	    UMIST  */

			mole.c[ipCO][ipNP] -= NP_CO_COP_N_1;
			mole.c[ipNP][ipNP] -= NP_CO_COP_N_2;
			mole.b[ipNP] -= b_NP_CO_COP_N;
			
			mole.c[ipCO][ipCO] -= NP_CO_COP_N_1;
			mole.c[ipNP][ipCO] -= NP_CO_COP_N_2;
			mole.b[ipCO] -= b_NP_CO_COP_N;
			
			mole.c[ipCO][ipCOP] += NP_CO_COP_N_1;
			mole.c[ipNP][ipCOP] += NP_CO_COP_N_2;
			mole.b[ipCOP] += b_NP_CO_COP_N;
			
			mole.c[ipCO][ipATN] += NP_CO_COP_N_1;
			mole.c[ipNP][ipATN] += NP_CO_COP_N_2;
			mole.b[ipATN] += b_NP_CO_COP_N;

		/*  >>refer   mol  CO+    +  S     =>   S+    +     CO    UMIST  */

			mole.c[ipATS][ipCOP] -= COP_S_SP_CO_1;
			mole.c[ipCOP][ipCOP] -= COP_S_SP_CO_2;
			mole.b[ipCOP] -= b_COP_S_SP_CO;

			mole.c[ipATS][ipATS] -= COP_S_SP_CO_1;
			mole.c[ipCOP][ipATS] -= COP_S_SP_CO_2;
			mole.b[ipATS] -= b_COP_S_SP_CO;
			
			mole.c[ipATS][ipSP] += COP_S_SP_CO_1;
			mole.c[ipCOP][ipSP] += COP_S_SP_CO_2;
			mole.b[ipSP] += b_COP_S_SP_CO;
			
			mole.c[ipATS][ipCO] += COP_S_SP_CO_1;
			mole.c[ipCOP][ipCO] += COP_S_SP_CO_2;
			mole.b[ipCO] += b_COP_S_SP_CO;

		/*  >>refer   mol  O    +  CCl     =>   Cl    +     CO    UMIST  */
		mole.c[ipCCl][ipCCl] -= O_CCl_Cl_CO_2;
		mole.c[ipATO][ipCCl] -= O_CCl_Cl_CO_1;
		mole.b[ipCCl] -= b_O_CCl_Cl_CO;

		mole.c[ipCCl][ipATO] -= O_CCl_Cl_CO_2;
		mole.c[ipATO][ipATO] -= O_CCl_Cl_CO_1;
		mole.b[ipATO] -= b_O_CCl_Cl_CO;

		mole.c[ipCCl][ipATCl] += O_CCl_Cl_CO_2;
		mole.c[ipATO][ipATCl] += O_CCl_Cl_CO_1;
		mole.b[ipATCl] += b_O_CCl_Cl_CO;

		mole.c[ipCCl][ipCO] += O_CCl_Cl_CO_2;
		mole.c[ipATO][ipCO] += O_CCl_Cl_CO_1;
		mole.b[ipCO] += b_O_CCl_Cl_CO;

		/*  >>refer   mol  CO    +  H2Cl+     =>   HCl    +     HCO+    UMIST  */

		mole.c[ipH2ClP][ipH2ClP] -= CO_H2ClP_HCl_HCOP_2;
		mole.c[ipCO][ipH2ClP] -= CO_H2ClP_HCl_HCOP_1;
		mole.b[ipH2ClP] -= b_CO_H2ClP_HCl_HCOP;

		mole.c[ipH2ClP][ipCO] -= CO_H2ClP_HCl_HCOP_2;
		mole.c[ipCO][ipCO] -= CO_H2ClP_HCl_HCOP_1;
		mole.b[ipCO] -= b_CO_H2ClP_HCl_HCOP;
	
		mole.c[ipH2ClP][ipHCl] += CO_H2ClP_HCl_HCOP_2;
		mole.c[ipCO][ipHCl] += CO_H2ClP_HCl_HCOP_1;
		mole.b[ipHCl] += b_CO_H2ClP_HCl_HCOP;

		mole.c[ipH2ClP][ipHCOP] += CO_H2ClP_HCl_HCOP_2;
		mole.c[ipCO][ipHCOP] += CO_H2ClP_HCl_HCOP_1;
		mole.b[ipHCOP] += b_CO_H2ClP_HCl_HCOP;

		/*  >>refer  mol  HNC   +   HCOP   =   HCNHP   +   CO   */

		mole.c[ipHCOP][ipHNC] -= HNC_HCOP_HCNHP_CO_1; 
		mole.c[ipHNC][ipHNC] -= HNC_HCOP_HCNHP_CO_2; 
		mole.b[ipHNC] -= b_HNC_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipHCOP] -= HNC_HCOP_HCNHP_CO_1; 
		mole.c[ipHNC][ipHCOP] -= HNC_HCOP_HCNHP_CO_2; 
		mole.b[ipHCOP] -= b_HNC_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipHCNHP] += HNC_HCOP_HCNHP_CO_1; 
		mole.c[ipHNC][ipHCNHP] += HNC_HCOP_HCNHP_CO_2; 
		mole.b[ipHCNHP] += b_HNC_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipCO] += HNC_HCOP_HCNHP_CO_1; 
		mole.c[ipHNC][ipCO] += HNC_HCOP_HCNHP_CO_2; 
		mole.b[ipCO] += b_HNC_HCOP_HCNHP_CO;

		/*  >>refer  mol  HCN   +   HCOP   =   HCNHP   +   CO   */

		mole.c[ipHCOP][ipHCN] -= HCN_HCOP_HCNHP_CO_1;  
		mole.c[ipHCN][ipHCN] -= HCN_HCOP_HCNHP_CO_2;  
		mole.b[ipHCN] -= b_HCN_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipHCOP] -= HCN_HCOP_HCNHP_CO_1;  
		mole.c[ipHCN][ipHCOP] -= HCN_HCOP_HCNHP_CO_2;  
		mole.b[ipHCOP] -= b_HCN_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipHCNHP] += HCN_HCOP_HCNHP_CO_1;  
		mole.c[ipHCN][ipHCNHP] += HCN_HCOP_HCNHP_CO_2;  
		mole.b[ipHCNHP] += b_HCN_HCOP_HCNHP_CO;

		mole.c[ipHCOP][ipCO] += HCN_HCOP_HCNHP_CO_1;  
		mole.c[ipHCN][ipCO] += HCN_HCOP_HCNHP_CO_2;  
		mole.b[ipCO] += b_HCN_HCOP_HCNHP_CO;

		/* >>refer  mole   O   C2H   -->   CO   CH        */

		mole.c[ipC2H][ipC2H] -= O_C2H_CO_CH_1;
		mole.c[ipATO][ipC2H] -= O_C2H_CO_CH_2;
		mole.b[ipC2H] -= b_O_C2H_CO_CH;

		mole.c[ipC2H][ipATO] -= O_C2H_CO_CH_1;
		mole.c[ipATO][ipATO] -= O_C2H_CO_CH_2;
		mole.b[ipATO] -= b_O_C2H_CO_CH;

		mole.c[ipC2H][ipCO] += O_C2H_CO_CH_1;
		mole.c[ipATO][ipCO] += O_C2H_CO_CH_2;
		mole.b[ipCO] += b_O_C2H_CO_CH;

		mole.c[ipC2H][ipCH] += O_C2H_CO_CH_1;
		mole.c[ipATO][ipCH] += O_C2H_CO_CH_2;
		mole.b[ipCH] += b_O_C2H_CO_CH;

		/* >>refer  mole   C2H   CO+   -->   CO   C2H+        */

		mole.c[ipCOP][ipCOP] -= C2H_COP_CO_C2HP_1;
		mole.c[ipC2H][ipCOP] -= C2H_COP_CO_C2HP_2;
		mole.b[ipCOP] -= b_C2H_COP_CO_C2HP;

		mole.c[ipCOP][ipC2H] -= C2H_COP_CO_C2HP_1;
		mole.c[ipC2H][ipC2H] -= C2H_COP_CO_C2HP_2;
		mole.b[ipC2H] -= b_C2H_COP_CO_C2HP;

		mole.c[ipCOP][ipCO] += C2H_COP_CO_C2HP_1;
		mole.c[ipC2H][ipCO] += C2H_COP_CO_C2HP_2;
		mole.b[ipCO] += b_C2H_COP_CO_C2HP;

		mole.c[ipCOP][ipC2HP] += C2H_COP_CO_C2HP_1;
		mole.c[ipC2H][ipC2HP] += C2H_COP_CO_C2HP_2;
		mole.b[ipC2HP] += b_C2H_COP_CO_C2HP;

		/* >>refer  mole   C2   HCO+   -->   CO   C2H+        */

		mole.c[ipHCOP][ipHCOP] -= C2_HCOP_CO_C2HP_1;
		mole.c[ipC2][ipHCOP] -= C2_HCOP_CO_C2HP_2;
		mole.b[ipHCOP] -= b_C2_HCOP_CO_C2HP;

		mole.c[ipHCOP][ipC2] -= C2_HCOP_CO_C2HP_1;
		mole.c[ipC2][ipC2] -= C2_HCOP_CO_C2HP_2;
		mole.b[ipC2] -= b_C2_HCOP_CO_C2HP;

		mole.c[ipHCOP][ipCO] += C2_HCOP_CO_C2HP_1;
		mole.c[ipC2][ipCO] += C2_HCOP_CO_C2HP_2;
		mole.b[ipCO] += b_C2_HCOP_CO_C2HP;

		mole.c[ipHCOP][ipC2HP] += C2_HCOP_CO_C2HP_1;
		mole.c[ipC2][ipC2HP] += C2_HCOP_CO_C2HP_2;
		mole.b[ipC2HP] += b_C2_HCOP_CO_C2HP;

		/* >>refer  mole   O2   C3   -->   CO   C2   O     */

		mole.c[ipC3][ipC3] -= O2_C3_CO_C2_O_1;
		mole.c[ipO2][ipC3] -= O2_C3_CO_C2_O_2;
		mole.b[ipC3] -= b_O2_C3_CO_C2_O;

		mole.c[ipC3][ipO2] -= O2_C3_CO_C2_O_1;
		mole.c[ipO2][ipO2] -= O2_C3_CO_C2_O_2;
		mole.b[ipO2] -= b_O2_C3_CO_C2_O;

		mole.c[ipC3][ipCO] += O2_C3_CO_C2_O_1;
		mole.c[ipO2][ipCO] += O2_C3_CO_C2_O_2;
		mole.b[ipCO] += b_O2_C3_CO_C2_O;

		mole.c[ipC3][ipC2] += O2_C3_CO_C2_O_1;
		mole.c[ipO2][ipC2] += O2_C3_CO_C2_O_2;
		mole.b[ipC2] += b_O2_C3_CO_C2_O;

		mole.c[ipC3][ipATO] += O2_C3_CO_C2_O_1;
		mole.c[ipO2][ipATO] += O2_C3_CO_C2_O_2;
		mole.b[ipATO] += b_O2_C3_CO_C2_O;

		/* >>refer  mole   O   C3   -->   CO   C2        */

		mole.c[ipC3][ipC3] -= O_C3_CO_C2_1;
		mole.c[ipATO][ipC3] -= O_C3_CO_C2_2;
		mole.b[ipC3] -= b_O_C3_CO_C2;

		mole.c[ipC3][ipATO] -= O_C3_CO_C2_1;
		mole.c[ipATO][ipATO] -= O_C3_CO_C2_2;
		mole.b[ipATO] -= b_O_C3_CO_C2;

		mole.c[ipC3][ipCO] += O_C3_CO_C2_1;
		mole.c[ipATO][ipCO] += O_C3_CO_C2_2;
		mole.b[ipCO] += b_O_C3_CO_C2;

		mole.c[ipC3][ipC2] += O_C3_CO_C2_1;
		mole.c[ipATO][ipC2] += O_C3_CO_C2_2;
		mole.b[ipC2] += b_O_C3_CO_C2;

		/* >>refer  mole   C2H   HCO+   -->   CO   C2H2+        */

		mole.c[ipHCOP][ipHCOP] -= C2H_HCOP_CO_C2H2P_1;
		mole.c[ipC2H][ipHCOP] -= C2H_HCOP_CO_C2H2P_2;
		mole.b[ipHCOP] -= b_C2H_HCOP_CO_C2H2P;

		mole.c[ipHCOP][ipC2H] -= C2H_HCOP_CO_C2H2P_1;
		mole.c[ipC2H][ipC2H] -= C2H_HCOP_CO_C2H2P_2;
		mole.b[ipC2H] -= b_C2H_HCOP_CO_C2H2P;

		mole.c[ipHCOP][ipCO] += C2H_HCOP_CO_C2H2P_1;
		mole.c[ipC2H][ipCO] += C2H_HCOP_CO_C2H2P_2;
		mole.b[ipCO] += b_C2H_HCOP_CO_C2H2P;

		mole.c[ipHCOP][ipC2H2P] += C2H_HCOP_CO_C2H2P_1;
		mole.c[ipC2H][ipC2H2P] += C2H_HCOP_CO_C2H2P_2;
		mole.b[ipC2H2P] += b_C2H_HCOP_CO_C2H2P;

		/* >>refer  mole   O   C3H   -->   CO   C2H        */

		mole.c[ipC3H][ipC3H] -= O_C3H_CO_C2H_1;
		mole.c[ipATO][ipC3H] -= O_C3H_CO_C2H_2;
		mole.b[ipC3H] -= b_O_C3H_CO_C2H;

		mole.c[ipC3H][ipATO] -= O_C3H_CO_C2H_1;
		mole.c[ipATO][ipATO] -= O_C3H_CO_C2H_2;
		mole.b[ipATO] -= b_O_C3H_CO_C2H;

		mole.c[ipC3H][ipCO] += O_C3H_CO_C2H_1;
		mole.c[ipATO][ipCO] += O_C3H_CO_C2H_2;
		mole.b[ipCO] += b_O_C3H_CO_C2H;

		mole.c[ipC3H][ipC2H] += O_C3H_CO_C2H_1;
		mole.c[ipATO][ipC2H] += O_C3H_CO_C2H_2;
		mole.b[ipC2H] += b_O_C3H_CO_C2H;

		/* >>refer  mole   O   C2H2   -->   CO   CH2        */

		mole.c[ipC2H2][ipC2H2] -= O_C2H2_CO_CH2_1;
		mole.c[ipATO][ipC2H2] -= O_C2H2_CO_CH2_2;
		mole.b[ipC2H2] -= b_O_C2H2_CO_CH2;

		mole.c[ipC2H2][ipATO] -= O_C2H2_CO_CH2_1;
		mole.c[ipATO][ipATO] -= O_C2H2_CO_CH2_2;
		mole.b[ipATO] -= b_O_C2H2_CO_CH2;

		mole.c[ipC2H2][ipCO] += O_C2H2_CO_CH2_1;
		mole.c[ipATO][ipCO] += O_C2H2_CO_CH2_2;
		mole.b[ipCO] += b_O_C2H2_CO_CH2;

		mole.c[ipC2H2][ipCH2] += O_C2H2_CO_CH2_1;
		mole.c[ipATO][ipCH2] += O_C2H2_CO_CH2_2;
		mole.b[ipCH2] += b_O_C2H2_CO_CH2;

		/* >>refer  mole   OH   C2H2   -->   CO   CH3        */

		mole.c[ipC2H2][ipC2H2] -= OH_C2H2_CO_CH3_1;
		mole.c[ipOH][ipC2H2] -= OH_C2H2_CO_CH3_2;
		mole.b[ipC2H2] -= b_OH_C2H2_CO_CH3;

		mole.c[ipC2H2][ipOH] -= OH_C2H2_CO_CH3_1;
		mole.c[ipOH][ipOH] -= OH_C2H2_CO_CH3_2;
		mole.b[ipOH] -= b_OH_C2H2_CO_CH3;

		mole.c[ipC2H2][ipCO] += OH_C2H2_CO_CH3_1;
		mole.c[ipOH][ipCO] += OH_C2H2_CO_CH3_2;
		mole.b[ipCO] += b_OH_C2H2_CO_CH3;

		mole.c[ipC2H2][ipCH3] += OH_C2H2_CO_CH3_1;
		mole.c[ipOH][ipCH3] += OH_C2H2_CO_CH3_2;
		mole.b[ipCH3] += b_OH_C2H2_CO_CH3;

		/* >>refer  mole   HCO+   C3   -->   C3H+   CO        */

		mole.c[ipC3][ipC3] -= HCOP_C3_C3HP_CO_1;
		mole.c[ipHCOP][ipC3] -= HCOP_C3_C3HP_CO_2;
		mole.b[ipC3] -= b_HCOP_C3_C3HP_CO;

		mole.c[ipC3][ipHCOP] -= HCOP_C3_C3HP_CO_1;
		mole.c[ipHCOP][ipHCOP] -= HCOP_C3_C3HP_CO_2;
		mole.b[ipHCOP] -= b_HCOP_C3_C3HP_CO;

		mole.c[ipC3][ipC3HP] += HCOP_C3_C3HP_CO_1;
		mole.c[ipHCOP][ipC3HP] += HCOP_C3_C3HP_CO_2;
		mole.b[ipC3HP] += b_HCOP_C3_C3HP_CO;

		mole.c[ipC3][ipCO] += HCOP_C3_C3HP_CO_1;
		mole.c[ipHCOP][ipCO] += HCOP_C3_C3HP_CO_2;
		mole.b[ipCO] += b_HCOP_C3_C3HP_CO;

		/* >>refer  mole   H2O   C3H+   -->   CO   C2H3+        */

		mole.c[ipC3HP][ipC3HP] -= H2O_C3HP_CO_C2H3P_1;
		mole.c[ipH2O][ipC3HP] -= H2O_C3HP_CO_C2H3P_2;
		mole.b[ipC3HP] -= b_H2O_C3HP_CO_C2H3P;

		mole.c[ipC3HP][ipH2O] -= H2O_C3HP_CO_C2H3P_1;
		mole.c[ipH2O][ipH2O] -= H2O_C3HP_CO_C2H3P_2;
		mole.b[ipH2O] -= b_H2O_C3HP_CO_C2H3P;

		mole.c[ipC3HP][ipCO] += H2O_C3HP_CO_C2H3P_1;
		mole.c[ipH2O][ipCO] += H2O_C3HP_CO_C2H3P_2;
		mole.b[ipCO] += b_H2O_C3HP_CO_C2H3P;

		mole.c[ipC3HP][ipC2H3P] += H2O_C3HP_CO_C2H3P_1;
		mole.c[ipH2O][ipC2H3P] += H2O_C3HP_CO_C2H3P_2;
		mole.b[ipC2H3P] += b_H2O_C3HP_CO_C2H3P;

		/* >>refer  mole   C2H2   HCO+   -->   CO   C2H3+        */

		mole.c[ipHCOP][ipHCOP] -= C2H2_HCOP_CO_C2H3P_1;
		mole.c[ipC2H2][ipHCOP] -= C2H2_HCOP_CO_C2H3P_2;
		mole.b[ipHCOP] -= b_C2H2_HCOP_CO_C2H3P;

		mole.c[ipHCOP][ipC2H2] -= C2H2_HCOP_CO_C2H3P_1;
		mole.c[ipC2H2][ipC2H2] -= C2H2_HCOP_CO_C2H3P_2;
		mole.b[ipC2H2] -= b_C2H2_HCOP_CO_C2H3P;

		mole.c[ipHCOP][ipCO] += C2H2_HCOP_CO_C2H3P_1;
		mole.c[ipC2H2][ipCO] += C2H2_HCOP_CO_C2H3P_2;
		mole.b[ipCO] += b_C2H2_HCOP_CO_C2H3P;

		mole.c[ipHCOP][ipC2H3P] += C2H2_HCOP_CO_C2H3P_1;
		mole.c[ipC2H2][ipC2H3P] += C2H2_HCOP_CO_C2H3P_2;
		mole.b[ipC2H3P] += b_C2H2_HCOP_CO_C2H3P;


}

