/* mole.h */
/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CO_drive main driver for heavy molecular equilibrium routines */
void CO_drive(void);

/*CO_step fills in matrix for heavy elements molecular routines */
void CO_solve(
	/* set true if we found neg pops */
	int *lgNegPop, 
	/* set true if we tried to compute the pops, but some were zero */
	int *lgZerPop );


/* evaluate rotation levels populations, emission and cooling */
void CO_PopsEmisCool(
	EmLine ** Rotate , 
	long int nRotate , 
	float abund, 	
	/* string used to identify calling program in case of error */
	const char *chLabel , 
	float *Cooling , 
	float * dCoolingdT  );

/*CO_colden maintain H2 column densities within X */
void CO_Colden( const char *chLabel );

/* called from cdInit to initialized co routines */
void CO_Init(void);
void CO_step(void);
/*CO_update_chem_rates update rate coefficients, only temp part */
void CO_update_chem_rates( void );
void CO_gasgrain( void );
void CO_monox( void );
void CO_ele_recomb( void );
void CO_photo(void);
void CO_h_he(void);
void CO_rates(void);
/*CO_OTS - add CO lines to ots fields, called by RT_OTS */
void CO_OTS( void );

/* >>chng 03 feb 09, rm ipH3P_hev, since not used, and decrement NUM_HEAVY_MOLEC to 17 */
/* >>chng 03 aug 04, rm ipCTWO and ipC2P from hevmol since not included in balance,
 * and always finds zero column density, so NUM_HEAVY_MOLEC from 17 to 15 */
/* >>chng 03 aug 05, rm ch2 and ch3, so n from 15 to 13 */
/* >>chng 03 nov 14  add Si chemistry & CH3+, so that now every
     reaction that is in the TH85 chemical network is also included
     in Cloudy.  Additionally, there are also reactions taken from other
     papers (mostly Hollenbach and McKee...see co.c).  In all 20 molecular
     species are calculated, along with the atomic and first ionization 
	 stages of C, O, and Si*/
/* >>chng 04 May 13, Nick Abel.  Add CH3, CH4, CH4+, and CH5+ to network in order 
	to get the same chemical abundances vs. depth as other PDR codes in the Leiden
	meeting.  With changes we now can predict molecular abundances for 24 C, O, 
	and Si bearing molecules. */

/* >>chng 04 jul 13, Nick Abel.  Add nitrogen and sulphur bearing molecules
   * to the chemical network.  First added to generate a chemical model for
   * eta carinae, but is applicable to all molecular clouds */

/* >>chng 05 mar 11, Nick Abel.  Add C2 and C2+ to chemistry, reactions 
   * involving these species affects the abundance of C*/

/* >>chng 05 mar 23, Nick Abel.  Add Chlorine to chemistry */

	 
#define	NUM_HEAVY_MOLEC	85

/* define a new parameter that includes the atomic and first ionized species
   of each element that can combine to form molecules.  This is used in comole
   to improve the calculation, as deep in molecular regions reactions with molecules
   can be important to the ionization balance */

#define NUM_COMOLE_CALC 97

/* define the number of atomic elements used in the chemical network */

#define NUM_ELEMENTS 6

#define	ipCH	 0
#define	ipCHP	 1
#define	ipOH	 2
#define	ipOHP	 3
#define	ipO2  	 4
#define	ipCO	 5
#define	ipCOP	 6
#define	ipH2O	 7
#define	ipH2OP	 8
#define	ipO2P	 9
#define	ipH3OP	 10
#define	ipCH2P	 11
#define ipCH2    12
#define ipHCOP   13
#define ipCH3P   14
#define ipSIH2P  15
#define ipSIH    16
#define ipHOSIP  17
#define ipSIO    18
#define ipSIOP   19
#define ipCH3    20
#define ipCH4    21
#define ipCH4P   22
#define ipCH5P   23
#define	ipN2	 24
#define	ipN2P	 25
#define	ipNO	 26
#define	ipNOP	 27
#define	ipS2  	 28
#define	ipS2P	 29
#define	ipOCN	 30
#define	ipOCNP	 31
#define	ipNH 	 32
#define	ipNHP 	 33
#define	ipNH2 	 34
#define	ipNH2P 	 35
#define ipNH3    36
#define ipNH3P   37
#define ipNH4P   38
#define ipCN     39
#define ipCNP    40
#define ipHCN    41
#define ipHCNP   42
#define ipHNO    43
#define ipHNOP   44
#define ipHS     45
#define ipHSP    46
#define ipCS     47
#define	ipCSP	 48
#define	ipNO2	 49
#define	ipNO2P	 50
#define	ipNS	 51
#define	ipNSP  	 52
#define	ipSO	 53
#define	ipSOP	 54
#define	ipSIN	 55
#define	ipSINP 	 56
#define	ipN2O	 57
#define	ipHCSP	 58
#define	ipOCS	 59
#define	ipOCSP	 60
#define	ipC2	 61
#define	ipC2P	 62
#define ipCCl    63         
#define ipClO    64      
#define ipHClP   65  
#define ipHCl    66     
#define ipH2ClP  67 
#define ipCClP   68
#define ipH2CClP 69
#define ipClOP   70
#define ipHNC    71
#define ipHCNHP  72
#define ipC2H    73
#define ipC2HP   74
#define ipC2H2   75
#define ipC2H2P  76
#define ipC3H    77
#define ipC3HP   78
#define ipC2H3P  79
#define ipC3     80
#define ipC3P    81
#define ipCOGR   82
#define ipH2OGR  83
#define ipOHGR   84
#define ipCP     85
#define ipOP     86
#define	ipSIP	 87
#define ipNP     88
#define ipSP     89
#define ipClP    90
#define ipATC    91
#define ipATO    92
#define ipATSI   93
#define ipATN    94
#define ipATS    95
#define ipATCl   96


EXTERN struct t_co {

	/* CODissHeat is CO Photodissociation heating */
	float CODissHeat, 
	  /* largest fraction of total heating */
	  codfrc, 
	  /* total heating integrated over cloud */
	  codtot;

	/* flag saying what fraction of total cooling was carried by CO */
	double COCoolBigFrac;

	/* flag saying CO is important but lines capped by highest level */
	int lgCOCoolCaped;

	/* rate OH + hnu -> H + O*, cm-3 s-1, per unit vol and time */
	float rate_OH_dissoc;

	/* flag to turn off CO molecules, set with no molecules command */
	int lgNoCOMole;

	/* molecules of the heavy elements.  order must exactly match that in hevcolumn
	 * number of molecules in heavy element network */

	/* the density (cm-3) of each species */
	float hevmol[NUM_COMOLE_CALC], 
	  /* total column density in this iteration */
	  hevcol[NUM_COMOLE_CALC], 
	  /* column density in previous iteration */
	  hevcol_old[NUM_COMOLE_CALC],
	  /* these are source and sink terms for the hydrogen molecular
	     network that appear in co.c */
	  hydro_sink[8],
	  hydro_source[8], 
	  /* the particle densities in first zone where CO computed,
	   * in last iteration */
	  HevMolSav[NUM_COMOLE_CALC] ,
	  xMoleFracMax[NUM_COMOLE_CALC];

	/* this is the atomic number of the main element within the molecule */
	int nelem_hevmol[NUM_COMOLE_CALC];

	/* previous soln to molec network */
	float co_save[NUM_COMOLE_CALC];

	/* abundance ratio C12O16 to C13O16, init in zero.c  */
	float RatioC12O16_2_C13O16;

	/* flag set true if H2O deEXTERN struction rate went to zero */
	int lgH2Ozer;

	/* set rates to that in UMIST */
	int lgUMISTrates;
	int lgFederman;

	double h2lim;

	long co_nzone , iteration_co;

	/* labels for the molecule names */
	char chLab[NUM_COMOLE_CALC][7];

	/* total electron density in molecules */
	double comole_eden;

	/* number of O, C, Si, N, S, and e- in each molecule */
	int nHydr[NUM_COMOLE_CALC];
	int nCarb[NUM_COMOLE_CALC];
	int nOxyg[NUM_COMOLE_CALC];
	int nElec[NUM_COMOLE_CALC];
	int nSili[NUM_COMOLE_CALC];
	int nNitr[NUM_COMOLE_CALC];
	int nSulp[NUM_COMOLE_CALC];
	int nChlo[NUM_COMOLE_CALC];

	/* is this in solid or gas phase? */
	int lgGas_Phase[NUM_COMOLE_CALC];

	/* the van Dishoeck & Black CO photodissociation rate */
	float CO_photo_dissoc_rate;

	/* The following are rates used in determining the ionization balance of helium */
	float rate_co_hep_o_cp_he,
		hep_destroy,
		rate_HeP_CO_O_CP_He,
		rate_HeP_CH_CHP_He,
		rate_HeP_H2O_H2OP_He, 
		rate_HeP_O2_O2P_He,
		rate_HeP_Si_SiP_He,	
		rate_HeP_CH_CP_He_H,
		rate_HeP_CH2_CHP_He_H,
		rate_HeP_OH_OP_He_H, 
		rate_HeP_H2O_OHP_He_H,
		rate_HeP_SiH_SiP_He_H,
		rate_HeP_H2O_OH_He_HP,
		rate_HeP_CH2_CP_He_H2,
		rate_HeP_O2_OP_O_He,
		rate_HeP_SiO_SiP_O_He,
		rate_HeP_SiO_Si_OP_He,
		rate_HeP_CH3_CHP_He,
		rate_HeP_CH4_CHP_He,
		rate_HeP_CH4_CH2P_He,
		rate_HeP_CH4_CH3_He,
		rate_HeP_CH4_CH3P_He,
		rate_HeP_CH4_CH4P_He,
		rate_HeP_NH_NP_He_H	 ,
		rate_HeP_NH2_NP_He_H2,
		rate_HeP_NH2_NHP_He_H,
		rate_HeP_NH3_NHP_He_H2,
		rate_HeP_NH3_NH2P_He_H ,
		rate_HeP_CN_N_CP_He ,
		rate_HeP_CN_NP_C_He ,
		rate_HeP_HCN_N_CHP_He ,
		rate_HeP_HCN_NP_CH_He ,
		rate_HeP_HCN_N_CP_He_H  ,
		rate_HeP_HCN_CNP_He_H ,
		rate_HeP_N2_NP_N_He ,
		rate_HeP_NO_OP_N_He ,
		rate_HeP_NO_O_NP_He ,
		rate_HeP_HNO_NOP_He_H,
		rate_HeP_HNO_NO_He_HP    ,
		rate_HeP_HS_SP_He_H      ,
		rate_HeP_OCN_CN_OP_He    ,
		rate_HeP_OCN_CNP_O_He    ,
		rate_HeP_SIN_SIP_N_He    ,
		rate_HeP_N2O_N2_OP_He    ,
		rate_HeP_N2O_N2P_O_He    ,
		rate_HeP_N2O_NO_NP_He    ,
		rate_HeP_N2O_NOP_N_He    ,
		rate_HeP_CS_SP_C_He      ,
		rate_HeP_CS_S_CP_He      ,
		rate_HeP_NS_S_NP_He      ,
		rate_HeP_NS_SP_N_He      ,
		rate_HeP_SO_S_OP_He      ,
		rate_HeP_SO_SP_O_He      ,
		rate_HeP_OCS_SP_CO_He    ,
		rate_HeP_OCS_S_COP_He    ,
		rate_HeP_OCS_CSP_O_He    ,
		rate_HeP_OCS_CS_OP_He    ,
		rate_HeP_S2_SP_S_He      ,
		rate_HeP_NH3_NH3P_He     ,
		rate_HeP_N2_N2P_He  ,     
		rate_HeP_HNC_NHP_C_He   ,
		rate_HeP_HNC_N_CP_He_H   ,
		rate_HeP_HNC_CNP_He_H    ;

	/*  These reactions and included in hmole_step as formation and destruction processes */

	double H_CH_C_H_H           ;
	double H_OH_O_H_H	     ;
	double H_H2O_OH_H_H         ;
	double H_COP_CO_HP          ;	
	double H_CH_C_H2            ;
	double H_CHP_CP_H2          ;
	double H_CH2_CH_H2          ;
	double H_CH3P_CH2P_H2       ;
	double H_OH_O_H2            ;
	double H_H2O_OH_H2          ;
	double Hminus_HCOP_CO_H2    ;
	double Hminus_H3OP_H2O_H2   ;
	double Hminus_H3OP_OH_H2_H  ;
	double HP_CH_CHP_H          ;
	double HP_CH2_CH2P_H        ;
	double HP_H2O_H2OP_H        ;
	double HP_O2_O2P_H          ;
	double HP_OH_OHP_H          ;
	double HP_SiO_SiOP_H        ;
	double HP_CH2_CHP_H2        ;
	double HP_SiH_SiP_H2        ;
	double H2_CHP_CH2P_H        ;
	double H2_CH2P_CH3P_H       ;
	double H2_OHP_H2OP_H        ;
	double H2_H2OP_H3OP_H       ;
	double H2_COP_HCOP_H        ;
	double H2_OP_OHP_H          ;
	double H2_SiOP_SiOHP_H      ;
	double H2_C_CH_H            ;
	double H2_CP_CHP_H          ;
	double H2_CH_CH2_H          ;
	double H2_OH_H2O_H          ;
	double H2_O_OH_H            ;
	double H2_CH_C_H2_H         ;
	double H2_OH_O_H2_H         ;
	double H2_H2O_OH_H2_H       ;
	double H2_O2_O_O_H2         ;
	double H2_O2_OH_OH          ;
	double H2s_CH_C_H2_H        ;
	double H2s_OH_O_H2_H        ;
	double H2s_H2O_OH_H2_H      ;
	double H2s_O2_O_O_H2        ;
	double H2P_C_CHP_H          ;
	double H2P_CH_CH2P_H        ;	
	double H2P_CH2_CH3P_H       ;
	double H2P_OH_H2OP_H        ;
	double H2P_H2O_H3OP_H       ;
	double H2P_CO_HCOP_H        ;
	double H2P_O_OHP_H          ;	
	double H2P_CH_CHP_H2        ;
	double H2P_CH2_CH2P_H2      ;
	double H2P_CO_COP_H2        ;
	double H2P_H2O_H2OP_H2      ;
	double H2P_O2_O2P_H2        ;
	double H2P_OH_OHP_H2        ;
	double H3P_C_CHP_H2         ;
	double H3P_CH_CH2P_H2       ;
	double H3P_CH2_CH3P_H2      ;
	double H3P_OH_H2OP_H2       ;
	double H3P_H2O_H3OP_H2      ;
	double H3P_CO_HCOP_H2       ;
	double H3P_O_OHP_H2         ;
	double H3P_SiH_SiH2P_H2     ;
	double H3P_SiO_SiOHP_H2     ;
	double h2s_ch_ch2_h         ;
	double h2s_o_oh_h           ;
	double h2s_oh_h2o_h         ;
	double h2s_c_ch_h           ;
	double h2s_cp_chp_h         ;
	double H_CH3_CH2_H2         ;
	double H_CH4P_CH3P_H2       ;
	double H_CH5P_CH4P_H2       ;
	double H2_CH2_CH3_H         ;
	double H2_CH3_CH4_H         ;
	double H2_CH4P_CH5P_H       ;
	double H2s_CH2_CH3_H        ;
	double H2s_CH3_CH4_H        ;
	double H2P_CH4_CH3P_H2      ;
	double H2P_CH4_CH4P_H2      ;
	double H2P_CH4_CH5P_H       ;
	double H3P_CH3_CH4P_H2      ;
	double H3P_CH4_CH5P_H2      ;
	double HP_CH3_CH3P_H        ;
	double HP_CH4_CH3P_H2       ;
	double HP_CH4_CH4P_H        ;
	double HP_HNC_HCN_HP ;
	double H_HNC_HCN_H ;
	double H2_HCNP_HCNHP_H ;
	double H3P_HCN_HCNHP_H2 ;
	double h2s_op_ohp_h         ;

	double C_H3OP_HCOP_H2_1,
	C_OH_CO_H_1,
	CP_OH_CO_HP_1,
	CP_H2O_HCOP_H_1,
	CP_OH_COP_H_1,
	O_CH_CO_H_1,
	O_CHP_COP_H_1,
	O_CH2_CO_H_H_1,
	O_CH2_CO_H2_1,
	O_CH2P_HCOP_H_1,
	O_CH3P_HCOP_H2_1,
	O_H2OP_O2P_H2_1,
	O_OH_O2_H_1,
	O_OHP_O2P_H_1,
	O_SiH_SiO_H_1,
	O_SiH2P_SiOHP_H_1,
	OP_CH_COP_H_1,
	OP_OH_O2P_H_1,
	Si_OH_SiO_H_1,
	SiP_H2O_SiOHP_H_1,
	SiP_OH_SiOP_H_1,
	CHP_H2O_HCOP_H2_1,
	CHP_OH_COP_H2_1,
	H_C_CH_nu,
	H_CP_CHP_nu,
	H_OH_H2O_nu,
	Hminus_CH_CH2_e,
	Hminus_C_CH_e,
	Hminus_OH_H2O_e,
	Hminus_O_OH_e,
	H2_C_CH2_nu,
	H2_CP_CH2P_nu,
	H2_SiP_SiH2P_nu,
	HeP_CH_CP_He_H,
	HeP_CH2_CHP_He_H,
	HeP_OH_OP_He_H,
	HeP_H2O_OHP_He_H,
	HeP_SiH_SiP_He_H,
	HeP_H2O_OH_He_HP,
	HeP_CH2_CP_He_H2,
	crnu_CH_C_H,
	crnu_CHP_CP_H,
	crnu_H2O_OH_H,
	crnu_OH_O_H,
	crnu_SiH_Si_H,
	nu_CH_C_H,
	nu_CHP_CP_H,
	nu_CH2_CH_H,
	nu_CH2P_CHP_H,
	nu_CH3P_CH2P_H,
	nu_CH3P_CHP_H2,
	nu_H2O_OH_H,
	nu_OH_O_H,
	nu_OHP_O_HP,
	nu_SiH_Si_H,
	e_CHP_C_H,
	e_CH2P_CH_H,
	e_CH2P_C_H_H,
	e_CH2P_C_H2,
	e_CH3P_C_H2_H,
	e_CH3P_CH2_H,
	e_CH3P_CH_H_H,
	e_CH3P_CH_H2,
	e_H2OP_OH_H,
	e_H2OP_O_H_H,
	e_H2OP_O_H2,
	e_H3OP_H2O_H,
	e_H3OP_OH_H_H,
	e_H3OP_OH_H2,
	e_H3OP_O_H2_H,
	e_HCOP_CO_H,
	e_OHP_O_H,
	e_SiH2P_SiH_H,
	e_SiH2P_Si_H_H,
	e_SiH2P_Si_H2,
	e_SiOHP_SiO_H,
	H2_CH_CH3_nu,
	H2_CH3P_CH5P_nu,
	H2s_CH_CH3_nu,
	Hminus_CH2_CH3_e,
	Hminus_CH3_CH4_e,
	nu_CH3_CH2_H,
	nu_CH3_CH_H2,
	nu_CH4_CH3_H,
	nu_CH4_CH2_H2,
	nu_CH4_CH_H2,
	crnu_CH3_CH2_H,
	crnu_CH3_CH_H2,
	crnu_CH4_CH2_H2,
	e_CH5P_CH3_H2,
	e_CH5P_CH4_H,
	e_CH4P_CH3_H,
	e_CH4P_CH2_H_H,
	H2_N_NH_H  ,      
	H2_NH_NH2_H ,        
	H2_NH2_NH3_H , 
	H2_CN_HCN_H   ,      
	HP_HNO_NOP_H2,
	HP_HS_SP_H2,
	H_HSP_SP_H2 ,
	H2P_N_NHP_H  ,     
	H2_NP_NHP_H   ,    
	H2_NHP_N_H3P   ,    
	H2P_NH_NH2P_H   ,  
	H2_NHP_NH2P_H    , 
	H2_NH2P_NH3P_H    , 
	H2_NH3P_NH4P_H     ,
	H2P_CN_HCNP_H     ,
	H2_CNP_HCNP_H     ,
	H2P_NO_HNOP_H      ,
	H2_SP_HSP_H        ,
	H2_CSP_HCSP_H      ,
	H3P_NH_NH2P_H2     ,
	H3P_NH2_NH3P_H2    ,
	H3P_NH3_NH4P_H2    ,
	H3P_CN_HCNP_H2     ,
	H3P_NO_HNOP_H2     ,
	H3P_S_HSP_H2       ,
	H3P_CS_HCSP_H2     ,
	H3P_NO2_NOP_OH_H2  ,
	HP_NH_NHP_H        ,
	HP_NH2_NH2P_H      ,
	HP_NH3_NH3P_H      ,
	H_CNP_CN_HP        ,
	HP_HCN_HCNP_H      ,
	H_HCNP_HCN_HP      ,
	H_N2P_N2_HP        ,
	HP_NO_NOP_H        ,
	HP_HS_HSP_H        ,
	HP_SIN_SINP_H      ,
	HP_CS_CSP_H         ,
	HP_NS_NSP_H        ,
	HP_SO_SOP_H        ,
	HP_OCS_OCSP_H      ,
	HP_S2_S2P_H     ,
	H2P_NH_NHP_H2    ,
	H2P_NH2_NH2P_H2   ,
	H2P_NH3_NH3P_H2   ,
	H2P_CN_CNP_H2      ,
	H2P_HCN_HCNP_H2    ,
	H2P_NO_NOP_H2     ,
	H2_ClP_HClP_H	,
	H2_HClP_H2ClP_H	,
	H3P_Cl_HClP_H2,
	H3P_HCl_H2ClP_H2,
	HP_HCl_HClP_H,
	HP_C2_C2P_H,
	H2_S_HS_H,
	H2P_C2_C2P_H2,
	Hminus_NH4P_NH3_H2,
	Hminus_NP_N_H,
	HP_C2H2_C2H2P_H, 
	HP_C2H2_C2HP_H2 ,
	HP_C3H_C3HP_H ,
	HP_C3H_C3P_H2 ,
	H2P_C2H_C2H2P_H, 
	H2P_C2H2_C2H2P_H2, 
	H3P_C2H_C2H2P_H2 ,
	H3P_C3_C3HP_H2 ,
	H2_C2HP_C2H2P_H ,
	H2_C3P_C3HP_H,
	H_C2H3P_C2H2P_H2 ,
	H3P_C2H2_C2H3P_H2 ,
	H2P_C2H2_C2H3P_H ,
	HP_C3_C3P_H ,
	HP_C2H_C2HP_H, 
	H2P_C2_C2HP_H ,
	H2P_C2H_C2HP_H2, 
	H3P_C2_C2HP_H2 ,
	H2_C2P_C2HP_H ,
	HP_C2H_C2P_H2;
}	co;

EXTERN struct t_mole {

		
	/* limit to the ratio H2/Htot - if ratio is below this, large atom is not called */
	double H2_to_H_limit;

	/* the number of electronic quantum states to include.
	* To do both Lyman and Werner bands want nelec = 3 */
	long int n_h2_elec_states;

	/* this is option to use estimates of the collision rates from g-bar approximations */
	/* turn mole.lgColl_gbar on/off with atom h2 gbar on off */
	int lgColl_gbar;

	/* this is option to turn off the calculated collision rates */
	int lgColl_deexec_Calc;

	/* this is option to turn off gueses of collisional dissociation rates */
	int lgColl_dissoc_coll;

	/* include collision rates that come from real calculations,
	 * off with atom h2 collisions off command */
	int lgH2_grain_deexcitation;

	/* flag to force LTE level populations, atom H2 LTE */
	int lgH2_LTE;

	/* option to turn off ortho-para collisions, command ATOM H2 COLLISIONS ORTHO PARA OFF */
	int lgH2_ortho_para_coll_on;

	/* which set of He - H2 collisions to use? default is Meudon */
	int lgH2_He_Meudon;
	int lgH2_He_Stancil;

	/* turn on trace information */
	int lgH2_TRACE;

	/* put noise into collision rates */
	int lgH2_NOISE ,
		/* noie for the CR collisions */
		lgH2_NOISECOSMIC;

	/* this sets how fine a trace we want for atom  h2 trace */
	int lgH2_trace_final , 
		lgH2_trace_iterations , 
		lgH2_trace_full,
		lgH2_trace_matrix;
	
	 /* do we include capture of molecules onto grain surfaces?  default is true,
	  * turned off with NO GRAIN MOLECULES command */
	 int lgGrain_mole_deplete;

	/* std and mean for the noise, log normal distribution */
	double xMeanNoise , xSTDNoise ;

	/* flag saying whether an element is in the chemistry network */
	int lgElem_in_chemistry[LIMELM];

	/* these are source and sink terms for the ionization ladder, for chemical
	 * processes that remove and add species */
	 double **source , **sink ;
	 /* rate s-1 for molecular charge transfer, nelem from to */
	float ***xMoleChTrRate;/*[LIMELM][LIMELM+1][LIMELM+1];*/
	 	double
	amat[NUM_COMOLE_CALC][NUM_COMOLE_CALC], 
	b[NUM_COMOLE_CALC], 
	c[NUM_COMOLE_CALC + 1][NUM_COMOLE_CALC + 1];

}	mole;

EXTERN struct t_rate {

double	C_CH2_CH_CH_1,
	C_H2OP_OH_CHP_1,
	C_H3OP_HCOP_H2_1,
	C_O2P_O2_CP_1,
	C_O2P_COP_O_1,
	C_OH_O_CH_1,
	C_OHP_O_CHP_1,
	CP_CH_CHP_C_1,
	CP_CH2_CH2P_C_1,
	CP_H2O_HCOP_H_1,
	CP_O_COP_nu_1,
	CP_O2_COP_O_1,
	CP_OH_COP_H_1,
	O_CH_OH_C_1,
	O_CH_HCOP_e_1,
	O_CHP_COP_H_1,
	O_CH2_OH_CH_1,
	O_CH2P_HCOP_H_1,
	O_CH3P_HCOP_H2_1,
	O_H2O_OH_OH_1,
	O_H2OP_O2P_H2_1,
	O_O_O2_nu_1,
	O_OH_O2_H_1,
	O_OHP_O2P_H_1,
	O_Si_SiO_nu_1,
	O_SiP_SiOP_nu_1,
	O_SiH_SiO_H_1,
	O_SiH2P_SiOHP_H_1,
	O_SiOP_O2_SiP_1,
	OP_CH_O_CHP_1,
	OP_CH_COP_H_1,
	OP_CH2_O_CH2P_1,
	OP_H2O_H2OP_O_1,
	OP_O2_O2P_O_1,
	OP_OH_O2P_H_1,
	OP_OH_OHP_O_1,
	Si_CHP_SiP_CH_1,
	Si_H2OP_SiP_H2O_1,
	Si_OH_SiO_H_1,
	Si_O2P_O2_SiP_1,
	SiP_H2O_SiOHP_H_1,
	SiP_OH_SiOP_H_1,
	SiP_O2_SiOP_O_1,
	CH_COP_HCOP_C_1,
	CH_H2OP_H2O_CHP_1,
	CH_H2OP_OH_CH2P_1,
	CH_H3OP_H2O_CH2P_1,
	CH_O2P_O2_CHP_1,
	CH_O2P_HCOP_O_1,
	CH_OHP_OH_CHP_1,
	CH_OHP_O_CH2P_1,
	CH_SiOP_HCOP_Si_1,
	CHP_H2O_H3OP_C_1,
	CHP_OH_COP_H2_1,
	CHP_H2O_HCOP_H2_1,
	CHP_O2_HCOP_O_1,
	CHP_O2_COP_OH_1,
	CH2_COP_HCOP_CH_1,
	CH2_H2OP_H2O_CH2P_1,
	CH2_H2OP_OH_CH3P_1,
	CH2_H3OP_H2O_CH3P_1,
	CH2_O2P_O2_CH2P_1,
	CH2_OH_H2O_CH_1,
	CH2_OHP_OH_CH2P_1,
	CH2_OHP_O_CH3P_1,
	CH2P_O2_HCOP_OH_1,
	H2O_COP_HCOP_OH_1,
	H2OP_H2O_H3OP_OH_1,
	H2OP_O2_O2P_H2O_1,
	H3OP_SiH_SiH2P_H2O_1,
	H3OP_SiO_SiOHP_H2O_1,
	OH_COP_HCOP_O_1,
	OH_H2OP_H3OP_O_1,
	OH_OH_H2O_O_1,
	OHP_H2O_H3OP_O_1,
	OHP_H2O_H2OP_OH_1,
	OHP_O2_O2P_OH_1,
	OHP_OH_H2OP_O_1,
	OHP_SiH_SiH2P_O_1,
	OHP_SiO_SiOHP_O_1,
	C_CH2_CH_CH_2,
	C_H2OP_OH_CHP_2,
	C_H3OP_HCOP_H2_2,
	C_O2P_O2_CP_2,
	C_O2P_COP_O_2,
	C_OH_O_CH_2,
	C_OHP_O_CHP_2,
	CP_CH_CHP_C_2,
	CP_CH2_CH2P_C_2,
	CP_H2O_HCOP_H_2,
	CP_O_COP_nu_2,
	CP_O2_COP_O_2,
	CP_OH_COP_H_2,
	O_CH_OH_C_2,
	O_CH_HCOP_e_2,
	O_CHP_COP_H_2,
	O_CH2_OH_CH_2,
	O_CH2P_HCOP_H_2,
	O_CH3P_HCOP_H2_2,
	O_H2O_OH_OH_2,
	O_H2OP_O2P_H2_2,
	O_O_O2_nu_2,
	O_OH_O2_H_2,
	O_OHP_O2P_H_2,
	O_Si_SiO_nu_2,
	O_SiP_SiOP_nu_2,
	O_SiH_SiO_H_2,
	O_SiH2P_SiOHP_H_2,
	O_SiOP_O2_SiP_2,
	OP_CH_O_CHP_2,
	OP_CH_COP_H_2,
	OP_CH2_O_CH2P_2,
	OP_H2O_H2OP_O_2,
	OP_O2_O2P_O_2,
	OP_OH_O2P_H_2,
	OP_OH_OHP_O_2,
	Si_CHP_SiP_CH_2,
	Si_H2OP_SiP_H2O_2,
	Si_OH_SiO_H_2,
	Si_O2P_O2_SiP_2,
	SiP_H2O_SiOHP_H_2,
	SiP_OH_SiOP_H_2,
	SiP_O2_SiOP_O_2,
	CH_COP_HCOP_C_2,
	CH_H2OP_H2O_CHP_2,
	CH_H2OP_OH_CH2P_2,
	CH_H3OP_H2O_CH2P_2,
	CH_O2P_O2_CHP_2,
	CH_O2P_HCOP_O_2,
	CH_OHP_OH_CHP_2,
	CH_OHP_O_CH2P_2,
	CH_SiOP_HCOP_Si_2,
	CHP_H2O_H3OP_C_2,
	CHP_OH_COP_H2_2,	
	CHP_H2O_HCOP_H2_2,
	CHP_O2_HCOP_O_2,
	CHP_O2_COP_OH_2,
	CH2_COP_HCOP_CH_2,
	CH2_H2OP_H2O_CH2P_2,
	CH2_H2OP_OH_CH3P_2,
	CH2_H3OP_H2O_CH3P_2,
	CH2_O2P_O2_CH2P_2,
	CH2_OH_H2O_CH_2,
	CH2_OHP_OH_CH2P_2,
	CH2_OHP_O_CH3P_2,
	CH2P_O2_HCOP_OH_2,
	H2O_COP_HCOP_OH_2,
	H2OP_H2O_H3OP_OH_2,
	H2OP_O2_O2P_H2O_2,
	H3OP_SiH_SiH2P_H2O_2,
	H3OP_SiO_SiOHP_H2O_2,
	OH_COP_HCOP_O_2,
	OH_H2OP_H3OP_O_2,
	OH_OH_H2O_O_2,
	OHP_H2O_H3OP_O_2,
	OHP_H2O_H2OP_OH_2,
	OHP_O2_O2P_OH_2,
	OHP_OH_H2OP_O_2,
	OHP_SiH_SiH2P_O_2,
	OHP_SiO_SiOHP_O_2,

	C_CH5P_CH4_CHP_1, 
	C_CH5P_CH4_CHP_2, 
	O_CH4_OH_CH3_1, 
	O_CH4_OH_CH3_2, 
	O_CH4P_OH_CH3P_1, 
	O_CH4P_OH_CH3P_2, 
	O_CH5P_H3OP_CH2_1, 
	O_CH5P_H3OP_CH2_2, 
	OP_CH4_OH_CH3P_1, 
	OP_CH4_OH_CH3P_2, 
	OP_CH4_CH4P_O_1, 
	OP_CH4_CH4P_O_2, 
	CH4_CH_CH3_CH2_1, 
	CH4_CH_CH3_CH2_2, 
	CH5P_CH_CH4_CH2P_1, 
	CH5P_CH_CH4_CH2P_2, 
	CH2_CH2_CH3_CH_1, 
	CH2_CH2_CH3_CH_2, 
	CH4_CH2_CH3_CH3_1, 
	CH4_CH2_CH3_CH3_2, 
	OH_CH2_O_CH3_1, 
	OH_CH2_O_CH3_2, 
	CH5P_CH2_CH4_CH3P_1, 
	CH5P_CH2_CH4_CH3P_2, 
	OH_CH3_CH4_O_1, 
	OH_CH3_CH4_O_2, 
	OH_CH3_H2O_CH2_1, 
	OH_CH3_H2O_CH2_2, 
	H2O_CH3_OH_CH4_1, 
	H2O_CH3_OH_CH4_2, 
	CH3_CH3_CH4_CH2_1, 
	CH3_CH3_CH4_CH2_2, 
	OH_CH4_H2O_CH3_1, 
	OH_CH4_H2O_CH3_2, 
	OHP_CH4_CH5P_O_1, 
	OHP_CH4_CH5P_O_2, 
	OHP_CH4_H3OP_CH2_1, 
	OHP_CH4_H3OP_CH2_2, 
	H2OP_CH4_H3OP_CH3_1, 
	H2OP_CH4_H3OP_CH3_2, 
	COP_CH4_HCOP_CH3_1, 
	COP_CH4_HCOP_CH3_2, 
	CH4_CH4P_CH5P_CH3_1, 
	CH4_CH4P_CH5P_CH3_2, 
	H2O_CH4P_H3OP_CH3_1, 
	H2O_CH4P_H3OP_CH3_2, 
	O2_CH4P_O2P_CH4_1, 
	O2_CH4P_O2P_CH4_2, 
	H2O_CH5P_H3OP_CH4_1, 
	H2O_CH5P_H3OP_CH4_2, 
	CH5P_OH_H2OP_CH4_1, 
	CH5P_OH_H2OP_CH4_2, 
		b_C_CH2_CH_CH,
	b_C_H2OP_OH_CHP,
	b_C_H3OP_HCOP_H2,
	b_C_O2P_O2_CP,
	b_C_O2P_COP_O,
	b_C_OH_O_CH,
	b_C_OHP_O_CHP,
	b_CP_CH_CHP_C,
	b_CP_CH2_CH2P_C,
	b_CP_H2O_HCOP_H,
	b_CP_O_COP_nu,
	b_CP_O2_COP_O,
	b_CP_OH_COP_H,
	b_O_CH_OH_C,
	b_O_CH_HCOP_e,
	b_O_CHP_COP_H,
	b_O_CH2_OH_CH,
	b_O_CH2P_HCOP_H,
	b_O_CH3P_HCOP_H2,
	b_O_H2O_OH_OH,
	b_O_H2OP_O2P_H2,
	b_O_O_O2_nu,
	b_O_OH_O2_H,
	b_O_OHP_O2P_H,
	b_O_Si_SiO_nu,
	b_O_SiP_SiOP_nu,
	b_O_SiH_SiO_H,
	b_O_SiH2P_SiOHP_H,
	b_O_SiOP_O2_SiP,
	b_OP_CH_O_CHP,
	b_OP_CH_COP_H,
	b_OP_CH2_O_CH2P,
	b_OP_H2O_H2OP_O,
	b_OP_O2_O2P_O,
	b_OP_OH_O2P_H,
	b_OP_OH_OHP_O,
	b_Si_CHP_SiP_CH,
	b_Si_H2OP_SiP_H2O,
	b_Si_OH_SiO_H,
	b_Si_O2P_O2_SiP,
	b_SiP_H2O_SiOHP_H,
	b_SiP_OH_SiOP_H,
	b_SiP_O2_SiOP_O,
	b_CH_COP_HCOP_C,
	b_CH_H2OP_H2O_CHP,
	b_CH_H2OP_OH_CH2P,
	b_CH_H3OP_H2O_CH2P,
	b_CH_O2P_O2_CHP,
	b_CH_O2P_HCOP_O,
	b_CH_OHP_OH_CHP,
	b_CH_OHP_O_CH2P,
	b_CH_SiOP_HCOP_Si,
	b_CHP_H2O_H3OP_C,
	b_CHP_OH_COP_H2,
	b_CHP_H2O_HCOP_H2,
	b_CHP_O2_HCOP_O,
	b_CHP_O2_COP_OH,
	b_CH2_COP_HCOP_CH,
	b_CH2_H2OP_H2O_CH2P,
	b_CH2_H2OP_OH_CH3P,
	b_CH2_H3OP_H2O_CH3P,
	b_CH2_O2P_O2_CH2P,
	b_CH2_OH_H2O_CH,
	b_CH2_OHP_OH_CH2P,
	b_CH2_OHP_O_CH3P,
	b_CH2P_O2_HCOP_OH,
	b_H2O_COP_HCOP_OH,
	b_H2OP_H2O_H3OP_OH,
	b_H2OP_O2_O2P_H2O,
	b_H3OP_SiH_SiH2P_H2O,
	b_H3OP_SiO_SiOHP_H2O,
	b_OH_COP_HCOP_O,
	b_OH_H2OP_H3OP_O,
	b_OH_OH_H2O_O,
	b_OHP_H2O_H3OP_O,
	b_OHP_H2O_H2OP_OH,
	b_OHP_O2_O2P_OH,
	b_OHP_OH_H2OP_O,
	b_OHP_SiH_SiH2P_O,
	b_OHP_SiO_SiOHP_O,
	b_C_CH5P_CH4_CHP,
	b_O_CH4_OH_CH3,
	b_O_CH4P_OH_CH3P,
	b_O_CH5P_H3OP_CH2,
	b_OP_CH4_OH_CH3P,
	b_OP_CH4_CH4P_O,
	b_CH4_CH_CH3_CH2,
	b_CH5P_CH_CH4_CH2P,
	b_CH2_CH2_CH3_CH,
	b_CH4_CH2_CH3_CH3,
	b_OH_CH2_O_CH3,
	b_CH5P_CH2_CH4_CH3P,
	b_OH_CH3_CH4_O,
	b_OH_CH3_H2O_CH2,
	b_H2O_CH3_OH_CH4,
	b_CH3_CH3_CH4_CH2,
	b_OH_CH4_H2O_CH3,
	b_OHP_CH4_CH5P_O,
	b_OHP_CH4_H3OP_CH2,
	b_H2OP_CH4_H3OP_CH3,
	b_COP_CH4_HCOP_CH3,
	b_CH4_CH4P_CH5P_CH3,
	b_H2O_CH4P_H3OP_CH3,
	b_O2_CH4P_O2P_CH4,
	b_H2O_CH5P_H3OP_CH4,
	b_CH5P_OH_H2OP_CH4,
		C_NH_N_CH_1,          
	C_NH_CN_H_1,         
	C_N2_CN_N_1,      
	C_NO_CN_O_1,      
	C_HS_S_CH_1,    
	C_HS_CS_H_1,   
	C_NS_S_CN_1,   
	C_NS_CS_N_1,   
	C_S2_CS_S_1,       
	CH_N_NH_C_1,       
	CH_N_CN_H_1,       
	CH_N2_HCN_N_1,     
	CH_NO_HCN_O_1,     
	CH_NO_CN_OH_1,     
	CH_NO_OCN_H_1,     
	CH_HNO_NO_CH2_1,   
	CH_S_HS_C_1,       
	CH_S_CS_H_1,       
	N_NH_N2_H_1,       
	N_CH3_HCN_H_H_1,   
	N_CH3_HCN_H2_1,    
	N_OH_O_NH_1,       
	N_OH_NO_H_1,       
	N_CN_N2_C_1,       
	N_SIH_SIN_H_1,     
	N_NO_N2_O_1,       
	N_HNO_NO_NH_1,     
	N_HNO_N2O_H_1,     
	N_O2_NO_O_1,       
	N_HS_NS_H_1,       
	N_HS_S_NH_1,       
	N_CS_S_CN_1,       
	N_NS_S_N2_1,       
	N_SO_NS_O_1,       
	N_SO_S_NO_1,       
	N_S2_NS_S_1,       
	CH2_CN_HCN_CH_1,   
	CH2_NO_HCN_OH_1,   
	CH2_HNO_NO_CH3_1,  
	NH_NH_N2_H_H_1,    
	NH_NH_N2_H2_1,     
	NH_O_OH_N_1,       
	NH_O_NO_H_1,       
	NH_OH_HNO_H_1,     
	NH_OH_NH2_O_1,     
	NH_OH_H2O_N_1,     
	NH_H2O_OH_NH2_1,   
	NH_CN_HCN_N_1,     
	NH_NO_N2O_H_1,     
	NH_NO_N2_O_H_1,    
	NH_NO_N2_OH_1,     
	NH_S_HS_N_1,       
	NH_S_NS_H_1,       
	NH_NO2_HNO_NO_1,   
	NH_NO2_N2O_OH_1,   
	CH3_NH3_CH4_NH2_1, 
	CH3_CN_HCN_CH2_1,  
	CH3_HNO_NO_CH4_1,  
	O_NH2_OH_NH_1,     
	O_NH2_NO_H2_1,     
	O_NH3_OH_NH2_1,    
	O_CN_NO_C_1,       
	O_HCN_CN_OH_1,     
	O_HCN_OCN_H_1,     
	O_N2_NO_N_1,       
	O_NO_O2_N_1,       
	O_HNO_NO_OH_1,     
	O_HNO_O2_NH_1,  
	O_HNO_NO2_H_1, 
	O_HS_S_OH_1,  
	O_HS_SO_H_1, 
	O_OCN_O2_CN_1,
	O_SIN_NO_SI_1,
	O_SIN_SIO_N_1,
	O_N2O_NO_NO_1,
	O_N2O_O2_N2_1,
	O_CS_SO_C_1,  
	O_NS_S_NO_1,  
	O_NS_SO_N_1,  
	O_SO_S_O2_1,  
	O_S2_SO_S_1,     
	NH2_OH_NH3_O_1,  
	NH2_OH_H2O_NH_1, 
	NH2_NO_N2_OH_H_1,
	NH2_NO_N2_H2O_1, 
	CH4_CN_HCN_CH3_1,
	OH_NH3_H2O_NH2_1,
	OH_CN_HCN_O_1,   
	OH_CN_OCN_H_1,     
	OH_HCN_CN_H2O_1,   
	OH_NO_NO2_H_1,     
	OH_S_HS_O_1,       
	OH_S_SO_H_1,       
	OH_N2O_HNO_NO_1,   
	OH_CS_OCS_H_1,     
	NH3_CN_HCN_NH2_1,  
	CN_NO_OCN_N_1,     
	CN_HNO_NO_HCN_1,   
	CN_S_NS_C_1,       
	CN_S_CS_N_1,       
	N2_O2_N2O_O_1,     
	NO_NO_O2_N2_1,     
	NO_NO_N2O_O_1,     
	NO_HNO_N2O_OH_1,   
	NO_S_NS_O_1,       
	NO_S_SO_N_1,       
	O2_S_SO_O_1,       
	S_SO_S2_O_1,       
	C_NHP_N_CHP_1,     
	CP_NH_CNP_H_1,     
	CP_NH2_HCNP_H_1,   
	C_NH2P_NH_CHP_1,   
	CP_NH3_HCNP_H2_1,  
	C_NH3P_NH_CH2P_1,  
	C_HCNP_CN_CHP_1,   
	C_HNOP_NO_CHP_1,   
	CP_HS_CSP_H_1,     
	C_HSP_CSP_H_1,     
	CP_OCN_COP_CN_1,   
	CP_NS_CSP_N_1,     
	CP_SO_S_COP_1,     
	CP_SO_CSP_O_1,     
	CHP_N_CNP_H_1,     
	CH_NP_CNP_H_1,     
	CH_NHP_CH2P_N_1,   
	CHP_NH_CNP_H2_1,   
	CHP_NH2_HCNP_H2_1, 
	CH_NH2P_NH_CH2P_1, 
	CHP_NH3_NH4P_C_1,  
	CH_NH3P_NH4P_C_1,  
	CH_HCNP_CN_CH2P_1, 
	CH_HNOP_NO_CH2P_1, 
	CHP_S_HSP_C_1,     
	CHP_S_CSP_H_1,     
	CH_SP_CSP_H_1,     
	CH_HSP_S_CH2P_1,   
	N_CH2P_HCNP_H_1,   
	NP_NH_N2P_H_1,     
	N_NHP_N2P_H_1,     
	NP_CH4_HCNP_H2_H_1,
	N_OHP_NOP_H_1,     
	NP_NH3_NH2P_NH_1,  
	N_H2OP_HNOP_H_1,   
	NP_NO_N2P_O_1,     
	NP_O2_NO_OP_1,     
	NP_O2_NOP_O_1,     
	N_O2P_NOP_O_1,    
	N_HSP_NSP_H_1,    
	N_SIOP_NOP_SI_1,  
	N_SIOP_NO_SIP_1,  
	N_SOP_NSP_O_1,    
	NP_OCS_CSP_NO_1,  
	CH2_NHP_CH3P_N_1, 
	CH2_NH2P_CH3P_NH_1,
	CH2P_NH3_NH4P_CH_1, 
	CH2_NH3P_NH2_CH3P_1,
	CH2_HCNP_CN_CH3P_1, 
	CH2_HNOP_NO_CH3P_1, 
	CH2P_S_HCSP_H_1,    
	CH2_SP_HCSP_H_1,    
	NHP_NH_NH2P_N_1,    
	NHP_O_OHP_N_1,      
	NH_OP_NOP_H_1,      
	NHP_NH2_NH3P_N_1,   
	NH_NH2P_NH3P_N_1,   
	NHP_OH_H2OP_N_1,    
	NH_OHP_NH2P_O_1,    
	NHP_NH3_NH4P_N_1,   
	NH_NH3P_NH4P_N_1,   
	NH_CH5P_CH4_NH2P_1, 
	NHP_H2O_NH3P_O_1,   
	NHP_H2O_H3OP_N_1,   
	NHP_H2O_HNOP_H2_1,    
	NH_H2OP_H3OP_N_1,     
	NHP_H2O_OH_NH2P_1,    
	NHP_CN_HCNP_N_1,      
	NH_HCNP_CN_NH2P_1,    
	NH_COP_HCOP_N_1,      
	NH_SIP_SINP_H_1,      
	NH_HNOP_NO_NH2P_1,    
	NH_O2P_HNOP_O_1,      
	NHP_O2_NOP_OH_1,      
	NH_O2P_NO2P_H_1,      
	NHP_S_HSP_N_1,        
	NHP_S_NSP_H_1,        
	NH_SP_NSP_H_1,        
	CH3P_NH3_NH4P_CH2_1,  
	CH3P_S_HCSP_H2_1,     
	O_NH2P_HNOP_H_1,      
	O_NH3P_HNOP_H2_1,     
	OP_CN_NOP_C_1,        
	OP_HCN_COP_NH_1,      
	OP_HCN_NOP_CH_1,      
	OP_HCN_HCOP_N_1,      
	OP_N2_NOP_N_1,        
	O_N2P_NOP_N_1,        
	O_HNOP_NO2P_H_1,      
	O_HSP_SP_OH_1,       
	O_HSP_SOP_H_1,       
	O_SINP_SIOP_N_1,     
	OP_N2O_NOP_NO_1,     
	O_CSP_S_COP_1,       
	O_HCSP_S_HCOP_1,    
	O_HCSP_OCSP_H_1,    
	OP_NO2_O2_NOP_1,    
	O_NSP_S_NOP_1,      
	NH2P_NH2_NH3P_NH_1, 
	NH2_OHP_NH3P_O_1,   
	NH2P_OH_H2OP_NH_1,  
	NH2P_NH3_NH4P_NH_1, 
	NH2_NH3P_NH4P_NH_1,
	NH2_CH5P_NH3P_CH4_1, 
	NH2P_H2O_NH3P_OH_1,  
	NH2P_H2O_H3OP_NH_1,  
	NH2_H2OP_NH3P_OH_1,  
	NH2P_H2O_NH4P_O_1,   
	NH2_H3OP_H2O_NH3P_1, 
	NH2_HCNP_CN_NH3P_1,  
	NH2_COP_HCOP_NH_1,   
	NH2_HNOP_NO_NH3P_1,  
	NH2P_O2_HNOP_OH_1,   
	NH2P_S_HSP_NH_1,     
	CH4P_NH3_NH4P_CH3_1, 
	CH4_NH3P_NH4P_CH3_1, 
	CH4_N2P_N2_CH2P_H2_1,
	CH4_N2P_N2_CH3P_H_1, 
	CH4_HNOP_NO_CH5P_1,   
	CH4_SP_HCSP_H2_H_1,   
	CH4_CSP_HCSP_CH3_1,   
	OHP_NH3_NH4P_O_1,     
	OH_NH3P_NH4P_O_1,     
	OHP_CN_HCNP_O_1,      
	OH_HCNP_CN_H2OP_1,    
	OHP_NO_HNOP_O_1,      
	OH_HNOP_NO_H2OP_1,    
	OHP_S_HSP_O_1,        
	OHP_S_SOP_H_1,        
	OH_SP_SOP_H_1,        
	NH3P_NH3_NH4P_NH2_1,  
	NH3_CH5P_NH4P_CH4_1,  
	NH3P_H2O_NH4P_OH_1,   
	NH3_H2OP_NH4P_OH_1,   
	NH3_H3OP_NH4P_H2O_1,  
	NH3_COP_HCOP_NH2_1,   
	NH3_HNOP_NO_NH4P_1,   
	NH3_HSP_S_NH4P_1,     
	NH3_HCSP_CS_NH4P_1,   
	CH5P_S_HSP_CH4_1,     
	H2O_CNP_HCNP_OH_1,    
	H2O_CNP_HCOP_NH_1,    
	H2O_HCNP_CN_H3OP_1,   
	H2O_HNOP_NO_H3OP_1,   
	H2OP_S_HSP_OH_1,      
	H2O_HSP_S_H3OP_1,     
	H3OP_CS_HCSP_H2O_1,   
	CNP_NO_OCNP_N_1,      
	CN_HNOP_NO_HCNP_1,    
	CNP_O2_OCNP_O_1,      
	HCNP_S_HSP_CN_1,      
	HNOP_S_HSP_NO_1,      
	O2_SP_SOP_O_1,        
	O2P_S_SOP_O_1,        
	O2_CSP_OCSP_O_1,      
	S_SIOP_SO_SIP_1,      
	CP_NH3_NH3P_C_1,     
	C_CNP_CN_CP_1,       
	C_N2P_N2_CP_1,      
	CP_NO_NOP_C_1,      
	CP_SIN_SINP_C_1,    
	C_CSP_CS_CP_1,      
	CP_NS_NSP_C_1,      
	CP_SO_SOP_C_1,      
	CP_OCS_OCSP_C_1,    
	CH_NH2P_NH2_CHP_1,  
	CHP_NH3_NH3P_CH_1,  
	CH_CNP_CN_CHP_1,    
	CH_N2P_N2_CHP_1,    
	CHP_NO_NOP_CH_1,    
	NP_NH_NHP_N_1,      
	NP_NH2_NH2P_N_1,    
	NP_NH3_NH3P_N_1,    
	NP_CN_CNP_N_1,      
	NP_HCN_HCNP_N_1,    
	N_N2P_N2_NP_1,      
	NP_NO_NOP_N_1,      
	NP_OCS_OCSP_N_1,    
	CH2_NH2P_NH2_CH2P_1,
	CH2_CNP_CN_CH2P_1,  
	CH2_N2P_N2_CH2P_1,  
	CH2P_NO_NOP_CH2_1,  
	NH_OP_O_NHP_1,      
	NH_OHP_OH_NHP_1,    
	NHP_NH3_NH3P_NH_1,  
	NHP_H2O_H2OP_NH_1,  
	NH_CNP_CN_NHP_1,    
	NH_N2P_N2_NHP_1,    
	NHP_NO_NOP_NH_1,    
	NHP_O2_O2P_NH_1,    
	NHP_S_SP_NH_1,      
	CH3P_NO_NOP_CH3_1,  
	OP_NH2_NH2P_O_1,    
	OP_NH3_NH3P_O_1,    
	O_CNP_CN_OP_1,      
	O_HCNP_HCN_OP_1,    
	O_N2P_N2_OP_1,      
	OP_NO_NOP_O_1,      
	OP_OCS_OCSP_O_1,    
	NH2_OHP_OH_NH2P_1,  
	NH2P_NH3_NH3P_NH2_1,
	NH2_H2OP_H2O_NH2P_1,  
	NH2_CNP_CN_NH2P_1,    
	NH2_N2P_N2_NH2P_1,    
	NH2P_NO_NOP_NH2_1,    
	NH2_O2P_O2_NH2P_1,    
	NH2P_S_SP_NH2_1,      
	CH4P_NH3_NH3P_CH4_1,  
	CH4P_OCS_OCSP_CH4_1,  
	OHP_NH3_NH3P_OH_1,    
	OH_CNP_CN_OHP_1,      
	OH_N2P_N2_OHP_1,      
	OHP_NO_NOP_OH_1,      
	NH3_H2OP_H2O_NH3P_1,  
	NH3_HCNP_HCN_NH3P_1,  
	NH3_N2P_N2_NH3P_1,    
	NH3P_SI_SIP_NH3_1,    
	NH3_O2P_O2_NH3P_1,    
	NH3_SP_S_NH3P_1,      
	NH3_HSP_HS_NH3P_1,    
	NH3_SOP_SO_NH3P_1,    
	H2O_HCNP_HCN_H2OP_1,  
	H2O_N2P_N2_H2OP_1,    
	H2OP_NO_NOP_H2O_1,    
	CNP_HCN_HCNP_CN_1,    
	CN_N2P_N2_CNP_1,      
	CNP_NO_NOP_CN_1,      
	CNP_O2_O2P_CN_1,      
	CNP_S_SP_CN_1,        
	HCN_N2P_N2_HCNP_1,    
	HCNP_NO_NOP_HCN_1,    
	HCNP_O2_O2P_HCN_1,    
	HCNP_S_SP_HCN_1,      
	N2P_NO_NOP_N2_1,      
	N2P_O2_O2P_N2_1,      
	N2P_S_SP_N2_1,        
	SI_NOP_NO_SIP_1,      
	SI_HSP_HS_SIP_1,      
	SI_CSP_CS_SIP_1,      
	NO_HNOP_HNO_NOP_1,    
	NO_O2P_O2_NOP_1,      
	NO_SP_S_NOP_1,        
	NO_HSP_HS_NOP_1,      
	NO_SIOP_SIO_NOP_1,    
	NO_S2P_S2_NOP_1,      
	O2P_NO2_NO2P_O2_1,    
	S_HSP_HS_SP_1,        
	C_N_CN_NU_1,          
	C_S_CS_NU_1,          
	CP_S_CSP_NU_1,        
	NP_N_N2P_NU_1,        
	CH_NP_N_CHP_1,        
	CHP_S_SP_CH_1,        
	NP_CH2_CH2P_N_1,      
	NP_CH4_CH4P_N_1,      
	NP_OH_OHP_N_1,        
	NP_H2O_H2OP_N_1,      
	NP_O2_O2P_N_1,        
	OHP_S_SP_OH_1,        
	H2OP_S_SP_H2O_1,      
	SI_SP_S_SIP_1,        
	O2P_S_SP_O2_1,        
	C_NH_N_CH_2,          
	C_NH_CN_H_2,         
	C_N2_CN_N_2,      
	C_NO_CN_O_2,      
	C_HS_S_CH_2,    
	C_HS_CS_H_2,   
	C_NS_S_CN_2,   
	C_NS_CS_N_2,   
	C_S2_CS_S_2,       
	CH_N_NH_C_2,       
	CH_N_CN_H_2,       
	CH_N2_HCN_N_2,     
	CH_NO_HCN_O_2,     
	CH_NO_CN_OH_2,     
	CH_NO_OCN_H_2,     
	CH_HNO_NO_CH2_2,   
	CH_S_HS_C_2,       
	CH_S_CS_H_2,       
	N_NH_N2_H_2,       
	N_CH3_HCN_H_H_2,   
	N_CH3_HCN_H2_2,    
	N_OH_O_NH_2,       
	N_OH_NO_H_2,       
	N_CN_N2_C_2,       
	N_SIH_SIN_H_2,     
	N_NO_N2_O_2,       
	N_HNO_NO_NH_2,     
	N_HNO_N2O_H_2,     
	N_O2_NO_O_2,       
	N_HS_NS_H_2,       
	N_HS_S_NH_2,       
	N_CS_S_CN_2,       
	N_NS_S_N2_2,       
	N_SO_NS_O_2,       
	N_SO_S_NO_2,       
	N_S2_NS_S_2,       
	CH2_CN_HCN_CH_2,   
	CH2_NO_HCN_OH_2,   
	CH2_HNO_NO_CH3_2,  
	NH_NH_N2_H_H_2,    
	NH_NH_N2_H2_2,     
	NH_O_OH_N_2,       
	NH_O_NO_H_2,       
	NH_OH_HNO_H_2,     
	NH_OH_NH2_O_2,     
	NH_OH_H2O_N_2,     
	NH_H2O_OH_NH2_2,   
	NH_CN_HCN_N_2,     
	NH_NO_N2O_H_2,     
	NH_NO_N2_O_H_2,    
	NH_NO_N2_OH_2,     
	NH_S_HS_N_2,       
	NH_S_NS_H_2,       
	NH_NO2_HNO_NO_2,   
	NH_NO2_N2O_OH_2,   
	CH3_NH3_CH4_NH2_2, 
	CH3_CN_HCN_CH2_2,  
	CH3_HNO_NO_CH4_2,  
	O_NH2_OH_NH_2,     
	O_NH2_NO_H2_2,     
	O_NH3_OH_NH2_2,    
	O_CN_NO_C_2,       
	O_HCN_CN_OH_2,     
	O_HCN_OCN_H_2,     
	O_N2_NO_N_2,       
	O_NO_O2_N_2,       
	O_HNO_NO_OH_2,     
	O_HNO_O2_NH_2,  
	O_HNO_NO2_H_2, 
	O_HS_S_OH_2,  
	O_HS_SO_H_2, 
	O_OCN_O2_CN_2,
	O_SIN_NO_SI_2,
	O_SIN_SIO_N_2,
	O_N2O_NO_NO_2,
	O_N2O_O2_N2_2,
	O_CS_SO_C_2,  
	O_NS_S_NO_2,  
	O_NS_SO_N_2,  
	O_SO_S_O2_2,  
	O_S2_SO_S_2,     
	NH2_OH_NH3_O_2,  
	NH2_OH_H2O_NH_2, 
	NH2_NO_N2_OH_H_2,
	NH2_NO_N2_H2O_2, 
	CH4_CN_HCN_CH3_2,
	OH_NH3_H2O_NH2_2,
	OH_CN_HCN_O_2,   
	OH_CN_OCN_H_2,     
	OH_HCN_CN_H2O_2,   
	OH_NO_NO2_H_2,     
	OH_S_HS_O_2,       
	OH_S_SO_H_2,       
	OH_N2O_HNO_NO_2,   
	OH_CS_OCS_H_2,     
	NH3_CN_HCN_NH2_2,  
	CN_NO_OCN_N_2,     
	CN_HNO_NO_HCN_2,   
	CN_S_NS_C_2,       
	CN_S_CS_N_2,       
	N2_O2_N2O_O_2,     
	NO_NO_O2_N2_2,     
	NO_NO_N2O_O_2,     
	NO_HNO_N2O_OH_2,   
	NO_S_NS_O_2,       
	NO_S_SO_N_2,       
	O2_S_SO_O_2,       
	S_SO_S2_O_2,       
	C_NHP_N_CHP_2,     
	CP_NH_CNP_H_2,     
	CP_NH2_HCNP_H_2,   
	C_NH2P_NH_CHP_2,   
	CP_NH3_HCNP_H2_2,  
	C_NH3P_NH_CH2P_2,  
	C_HCNP_CN_CHP_2,   
	C_HNOP_NO_CHP_2,   
	CP_HS_CSP_H_2,     
	C_HSP_CSP_H_2,     
	CP_OCN_COP_CN_2,   
	CP_NS_CSP_N_2,     
	CP_SO_S_COP_2,     
	CP_SO_CSP_O_2,     
	CHP_N_CNP_H_2,     
	CH_NP_CNP_H_2,     
	CH_NHP_CH2P_N_2,   
	CHP_NH_CNP_H2_2,   
	CHP_NH2_HCNP_H2_2, 
	CH_NH2P_NH_CH2P_2, 
	CHP_NH3_NH4P_C_2,  
	CH_NH3P_NH4P_C_2,  
	CH_HCNP_CN_CH2P_2, 
	CH_HNOP_NO_CH2P_2, 
	CHP_S_HSP_C_2,     
	CHP_S_CSP_H_2,     
	CH_SP_CSP_H_2,     
	CH_HSP_S_CH2P_2,   
	N_CH2P_HCNP_H_2,   
	NP_NH_N2P_H_2,     
	N_NHP_N2P_H_2,     
	NP_CH4_HCNP_H2_H_2,
	N_OHP_NOP_H_2,     
	NP_NH3_NH2P_NH_2,  
	N_H2OP_HNOP_H_2,   
	NP_NO_N2P_O_2,     
	NP_O2_NO_OP_2,     
	NP_O2_NOP_O_2,     
	N_O2P_NOP_O_2,    
	N_HSP_NSP_H_2,    
	N_SIOP_NOP_SI_2,  
	N_SIOP_NO_SIP_2,  
	N_SOP_NSP_O_2,    
	NP_OCS_CSP_NO_2,  
	CH2_NHP_CH3P_N_2, 
	CH2_NH2P_CH3P_NH_2,
	CH2P_NH3_NH4P_CH_2, 
	CH2_NH3P_NH2_CH3P_2,
	CH2_HCNP_CN_CH3P_2, 
	CH2_HNOP_NO_CH3P_2, 
	CH2P_S_HCSP_H_2,    
	CH2_SP_HCSP_H_2,    
	NHP_NH_NH2P_N_2,    
	NHP_O_OHP_N_2,      
	NH_OP_NOP_H_2,      
	NHP_NH2_NH3P_N_2,   
	NH_NH2P_NH3P_N_2,   
	NHP_OH_H2OP_N_2,    
	NH_OHP_NH2P_O_2,    
	NHP_NH3_NH4P_N_2,   
	NH_NH3P_NH4P_N_2,   
	NH_CH5P_CH4_NH2P_2, 
	NHP_H2O_NH3P_O_2,   
	NHP_H2O_H3OP_N_2,   
	NHP_H2O_HNOP_H2_2,    
	NH_H2OP_H3OP_N_2,     
	NHP_H2O_OH_NH2P_2,    
	NHP_CN_HCNP_N_2,      
	NH_HCNP_CN_NH2P_2,    
	NH_COP_HCOP_N_2,      
	NH_SIP_SINP_H_2,      
	NH_HNOP_NO_NH2P_2,    
	NH_O2P_HNOP_O_2,      
	NHP_O2_NOP_OH_2,      
	NH_O2P_NO2P_H_2,      
	NHP_S_HSP_N_2,        
	NHP_S_NSP_H_2,        
	NH_SP_NSP_H_2,        
	CH3P_NH3_NH4P_CH2_2,  
	CH3P_S_HCSP_H2_2,     
	O_NH2P_HNOP_H_2,      
	O_NH3P_HNOP_H2_2,     
	OP_CN_NOP_C_2,        
	OP_HCN_COP_NH_2,      
	OP_HCN_NOP_CH_2,      
	OP_HCN_HCOP_N_2,      
	OP_N2_NOP_N_2,        
	O_N2P_NOP_N_2,        
	O_HNOP_NO2P_H_2,      
	O_HSP_SP_OH_2,       
	O_HSP_SOP_H_2,       
	O_SINP_SIOP_N_2,     
	OP_N2O_NOP_NO_2,     
	O_CSP_S_COP_2,       
	O_HCSP_S_HCOP_2,    
	O_HCSP_OCSP_H_2,    
	OP_NO2_O2_NOP_2,    
	O_NSP_S_NOP_2,      
	NH2P_NH2_NH3P_NH_2, 
	NH2_OHP_NH3P_O_2,   
	NH2P_OH_H2OP_NH_2,  
	NH2P_NH3_NH4P_NH_2, 
	NH2_NH3P_NH4P_NH_2,
	NH2_CH5P_NH3P_CH4_2, 
	NH2P_H2O_NH3P_OH_2,  
	NH2P_H2O_H3OP_NH_2,  
	NH2_H2OP_NH3P_OH_2,  
	NH2P_H2O_NH4P_O_2,   
	NH2_H3OP_H2O_NH3P_2, 
	NH2_HCNP_CN_NH3P_2,  
	NH2_COP_HCOP_NH_2,   
	NH2_HNOP_NO_NH3P_2,  
	NH2P_O2_HNOP_OH_2,   
	NH2P_S_HSP_NH_2,     
	CH4P_NH3_NH4P_CH3_2, 
	CH4_NH3P_NH4P_CH3_2, 
	CH4_N2P_N2_CH2P_H2_2,
	CH4_N2P_N2_CH3P_H_2, 
	CH4_HNOP_NO_CH5P_2,   
	CH4_SP_HCSP_H2_H_2,   
	CH4_CSP_HCSP_CH3_2,   
	OHP_NH3_NH4P_O_2,     
	OH_NH3P_NH4P_O_2,     
	OHP_CN_HCNP_O_2,      
	OH_HCNP_CN_H2OP_2,    
	OHP_NO_HNOP_O_2,      
	OH_HNOP_NO_H2OP_2,    
	OHP_S_HSP_O_2,        
	OHP_S_SOP_H_2,        
	OH_SP_SOP_H_2,        
	NH3P_NH3_NH4P_NH2_2,  
	NH3_CH5P_NH4P_CH4_2,  
	NH3P_H2O_NH4P_OH_2,   
	NH3_H2OP_NH4P_OH_2,   
	NH3_H3OP_NH4P_H2O_2,  
	NH3_COP_HCOP_NH2_2,   
	NH3_HNOP_NO_NH4P_2,   
	NH3_HSP_S_NH4P_2,     
	NH3_HCSP_CS_NH4P_2,   
	CH5P_S_HSP_CH4_2,     
	H2O_CNP_HCNP_OH_2,    
	H2O_CNP_HCOP_NH_2,    
	H2O_HCNP_CN_H3OP_2,   
	H2O_HNOP_NO_H3OP_2,   
	H2OP_S_HSP_OH_2,      
	H2O_HSP_S_H3OP_2,     
	H3OP_CS_HCSP_H2O_2,   
	CNP_NO_OCNP_N_2,      
	CN_HNOP_NO_HCNP_2,    
	CNP_O2_OCNP_O_2,      
	HCNP_S_HSP_CN_2,      
	HNOP_S_HSP_NO_2,      
	O2_SP_SOP_O_2,        
	O2P_S_SOP_O_2,        
	O2_CSP_OCSP_O_2,      
	S_SIOP_SO_SIP_2,      
	CP_NH3_NH3P_C_2,     
	C_CNP_CN_CP_2,       
	C_N2P_N2_CP_2,      
	CP_NO_NOP_C_2,      
	CP_SIN_SINP_C_2,    
	C_CSP_CS_CP_2,      
	CP_NS_NSP_C_2,      
	CP_SO_SOP_C_2,      
	CP_OCS_OCSP_C_2,    
	CH_NH2P_NH2_CHP_2,  
	CHP_NH3_NH3P_CH_2,  
	CH_CNP_CN_CHP_2,    
	CH_N2P_N2_CHP_2, 
	CH_NP_N_CHP_2,
	CHP_NO_NOP_CH_2,    
	NP_NH_NHP_N_2,      
	NP_NH2_NH2P_N_2,    
	NP_NH3_NH3P_N_2,    
	NP_CN_CNP_N_2,      
	NP_HCN_HCNP_N_2,    
	N_N2P_N2_NP_2,      
	NP_NO_NOP_N_2,      
	NP_OCS_OCSP_N_2,    
	CH2_NH2P_NH2_CH2P_2,
	CH2_CNP_CN_CH2P_2,  
	CH2_N2P_N2_CH2P_2,  
	CH2P_NO_NOP_CH2_2,  
	NH_OP_O_NHP_2,      
	NH_OHP_OH_NHP_2,    
	NHP_NH3_NH3P_NH_2,  
	NHP_H2O_H2OP_NH_2,  
	NH_CNP_CN_NHP_2,    
	NH_N2P_N2_NHP_2,    
	NHP_NO_NOP_NH_2,    
	NHP_O2_O2P_NH_2,    
	NHP_S_SP_NH_2,      
	CH3P_NO_NOP_CH3_2,  
	OP_NH2_NH2P_O_2,    
	OP_NH3_NH3P_O_2,    
	O_CNP_CN_OP_2,      
	O_HCNP_HCN_OP_2,    
	O_N2P_N2_OP_2,      
	OP_NO_NOP_O_2,      
	OP_OCS_OCSP_O_2,    
	NH2_OHP_OH_NH2P_2,  
	NH2P_NH3_NH3P_NH2_2,
	NH2_H2OP_H2O_NH2P_2,  
	NH2_CNP_CN_NH2P_2,    
	NH2_N2P_N2_NH2P_2,    
	NH2P_NO_NOP_NH2_2,    
	NH2_O2P_O2_NH2P_2,    
	NH2P_S_SP_NH2_2,      
	CH4P_NH3_NH3P_CH4_2,  
	CH4P_OCS_OCSP_CH4_2,  
	OHP_NH3_NH3P_OH_2,    
	OH_CNP_CN_OHP_2,      
	OH_N2P_N2_OHP_2,      
	OHP_NO_NOP_OH_2,      
	NH3_H2OP_H2O_NH3P_2,  
	NH3_HCNP_HCN_NH3P_2,  
	NH3_N2P_N2_NH3P_2,    
	NH3P_SI_SIP_NH3_2,    
	NH3_O2P_O2_NH3P_2,    
	NH3_SP_S_NH3P_2,      
	NH3_HSP_HS_NH3P_2,    
	NH3_SOP_SO_NH3P_2,    
	H2O_HCNP_HCN_H2OP_2,  
	H2O_N2P_N2_H2OP_2,    
	H2OP_NO_NOP_H2O_2,    
	CNP_HCN_HCNP_CN_2,    
	CN_N2P_N2_CNP_2,      
	CNP_NO_NOP_CN_2,      
	CNP_O2_O2P_CN_2,      
	CNP_S_SP_CN_2,        
	HCN_N2P_N2_HCNP_2,    
	HCNP_NO_NOP_HCN_2,    
	HCNP_O2_O2P_HCN_2,    
	HCNP_S_SP_HCN_2,      
	N2P_NO_NOP_N2_2,      
	N2P_O2_O2P_N2_2,      
	N2P_S_SP_N2_2,        
	SI_NOP_NO_SIP_2,      
	SI_HSP_HS_SIP_2,      
	SI_CSP_CS_SIP_2,      
	NO_HNOP_HNO_NOP_2,    
	NO_O2P_O2_NOP_2,      
	NO_SP_S_NOP_2,        
	NO_HSP_HS_NOP_2,      
	NO_SIOP_SIO_NOP_2,    
	NO_S2P_S2_NOP_2,      
	O2P_NO2_NO2P_O2_2,    
	S_HSP_HS_SP_2,        
	C_N_CN_NU_2,          
	C_S_CS_NU_2,          
	CP_S_CSP_NU_2,        
	NP_N_N2P_NU_2,        
	CHP_S_SP_CH_2,        
	NP_CH2_CH2P_N_2,      
	NP_CH4_CH4P_N_2,      
	NP_OH_OHP_N_2,        
	NP_H2O_H2OP_N_2,      
	NP_O2_O2P_N_2,        
	OHP_S_SP_OH_2,        
	H2OP_S_SP_H2O_2,      
	SI_SP_S_SIP_2,        
	O2P_S_SP_O2_2, 

	b_C_NH_N_CH ,  
	b_C_NH_CN_H , 
	b_C_N2_CN_N ,  
	b_C_NO_CN_O ,  
	b_C_HS_S_CH ,
	b_C_HS_CS_H ,   
	b_C_NS_S_CN ,   
	b_C_NS_CS_N ,   
	b_C_S2_CS_S ,   
	b_CH_N_NH_C ,   
	b_CH_N_CN_H ,   
	b_CH_N2_HCN_N , 
	b_CH_NO_HCN_O , 
	b_CH_NO_CN_OH , 
	b_CH_NO_OCN_H , 
	b_CH_HNO_NO_CH2 ,   
	b_CH_S_HS_C ,   
	b_CH_S_CS_H ,   
	b_N_NH_N2_H ,   
	b_N_CH3_HCN_H_H ,   
	b_N_CH3_HCN_H2 ,
	b_N_OH_O_NH ,   
	b_N_OH_NO_H ,   
	b_N_CN_N2_C ,   
	b_N_SIH_SIN_H , 
	b_N_NO_N2_O ,   
	b_N_HNO_NO_NH , 
	b_N_HNO_N2O_H , 
	b_N_O2_NO_O ,   
	b_N_HS_NS_H ,   
	b_N_HS_S_NH ,   
	b_N_CS_S_CN ,   
	b_N_NS_S_N2 ,   
	b_N_SO_NS_O ,   
	b_N_SO_S_NO ,   
	b_N_S2_NS_S ,   
	b_CH2_CN_HCN_CH ,   
	b_CH2_NO_HCN_OH ,   
	b_CH2_HNO_NO_CH3 ,  
	b_NH_NH_N2_H_H ,
	b_NH_NH_N2_H2 , 
	b_NH_O_OH_N ,   
	b_NH_O_NO_H ,   
	b_NH_OH_HNO_H , 
	b_NH_OH_NH2_O , 
	b_NH_OH_H2O_N , 
	b_NH_H2O_OH_NH2 ,   
	b_NH_CN_HCN_N , 
	b_NH_NO_N2O_H , 
	b_NH_NO_N2_O_H ,
	b_NH_NO_N2_OH , 
	b_NH_S_HS_N ,       
	b_NH_S_NS_H ,       
	b_NH_NO2_HNO_NO ,   
	b_NH_NO2_N2O_OH ,   
	b_CH3_NH3_CH4_NH2 , 
	b_CH3_CN_HCN_CH2 ,  
	b_CH3_HNO_NO_CH4 ,  
	b_O_NH2_OH_NH ,     
	b_O_NH2_NO_H2 ,     
	b_O_NH3_OH_NH2 ,    
	b_O_CN_NO_C ,       
	b_O_HCN_CN_OH ,     
	b_O_HCN_OCN_H ,     
	b_O_N2_NO_N ,       
	b_O_NO_O2_N ,       
	b_O_HNO_NO_OH ,     
	b_O_HNO_O2_NH ,  
	b_O_HNO_NO2_H , 
	b_O_HS_S_OH ,  
	b_O_HS_SO_H , 
	b_O_OCN_O2_CN ,
	b_O_SIN_NO_SI ,
	b_O_SIN_SIO_N ,
	b_O_N2O_NO_NO ,
	b_O_N2O_O2_N2 ,
	b_O_CS_SO_C ,  
	b_O_NS_S_NO ,  
	b_O_NS_SO_N ,  
	b_O_SO_S_O2 ,  
	b_O_S2_SO_S ,     
	b_NH2_OH_NH3_O ,  
	b_NH2_OH_H2O_NH , 
	b_NH2_NO_N2_OH_H ,
	b_NH2_NO_N2_H2O , 
	b_CH4_CN_HCN_CH3 ,
	b_OH_NH3_H2O_NH2 ,
	b_OH_CN_HCN_O ,   
	b_OH_CN_OCN_H ,     
	b_OH_HCN_CN_H2O ,   
	b_OH_NO_NO2_H ,     
	b_OH_S_HS_O ,       
	b_OH_S_SO_H ,       
	b_OH_N2O_HNO_NO ,   
	b_OH_CS_OCS_H ,     
	b_NH3_CN_HCN_NH2 ,  
	b_CN_NO_OCN_N ,     
	b_CN_HNO_NO_HCN ,   
	b_CN_S_NS_C ,       
	b_CN_S_CS_N ,       
	b_N2_O2_N2O_O ,     
	b_NO_NO_O2_N2 ,     
	b_NO_NO_N2O_O ,     
	b_NO_HNO_N2O_OH ,   
	b_NO_S_NS_O ,       
	b_NO_S_SO_N ,       
	b_O2_S_SO_O ,       
	b_S_SO_S2_O ,       
	b_C_NHP_N_CHP ,     
	b_CP_NH_CNP_H ,     
	b_CP_NH2_HCNP_H ,   
	b_C_NH2P_NH_CHP ,   
	b_CP_NH3_HCNP_H2 ,  
	b_C_NH3P_NH_CH2P ,  
	b_C_HCNP_CN_CHP ,   
	b_C_HNOP_NO_CHP ,   
	b_CP_HS_CSP_H ,     
	b_C_HSP_CSP_H ,     
	b_CP_OCN_COP_CN ,   
	b_CP_NS_CSP_N ,     
	b_CP_SO_S_COP ,     
	b_CP_SO_CSP_O ,     
	b_CHP_N_CNP_H ,     
	b_CH_NP_CNP_H ,     
	b_CH_NHP_CH2P_N ,   
	b_CHP_NH_CNP_H2 ,   
	b_CHP_NH2_HCNP_H2 , 
	b_CH_NH2P_NH_CH2P , 
	b_CHP_NH3_NH4P_C ,  
	b_CH_NH3P_NH4P_C ,  
	b_CH_HCNP_CN_CH2P , 
	b_CH_HNOP_NO_CH2P , 
	b_CHP_S_HSP_C ,     
	b_CHP_S_CSP_H ,     
	b_CH_SP_CSP_H ,     
	b_CH_HSP_S_CH2P ,   
	b_N_CH2P_HCNP_H ,   
	b_NP_NH_N2P_H ,     
	b_N_NHP_N2P_H ,     
	b_NP_CH4_HCNP_H2_H ,
	b_N_OHP_NOP_H ,     
	b_NP_NH3_NH2P_NH ,  
	b_N_H2OP_HNOP_H ,   
	b_NP_NO_N2P_O ,     
	b_NP_O2_NO_OP ,     
	b_NP_O2_NOP_O ,     
	b_N_O2P_NOP_O ,    
	b_N_HSP_NSP_H ,    
	b_N_SIOP_NOP_SI ,  
	b_N_SIOP_NO_SIP ,  
	b_N_SOP_NSP_O ,    
	b_NP_OCS_CSP_NO ,  
	b_CH2_NHP_CH3P_N , 
	b_CH2_NH2P_CH3P_NH ,
	b_CH2P_NH3_NH4P_CH , 
	b_CH2_NH3P_NH2_CH3P ,
	b_CH2_HCNP_CN_CH3P , 
	b_CH2_HNOP_NO_CH3P , 
	b_CH2P_S_HCSP_H ,    
	b_CH2_SP_HCSP_H ,    
	b_NHP_NH_NH2P_N ,    
	b_NHP_O_OHP_N ,      
	b_NH_OP_NOP_H ,      
	b_NHP_NH2_NH3P_N ,   
	b_NH_NH2P_NH3P_N ,   
	b_NHP_OH_H2OP_N ,    
	b_NH_OHP_NH2P_O ,    
	b_NHP_NH3_NH4P_N ,   
	b_NH_NH3P_NH4P_N ,   
	b_NH_CH5P_CH4_NH2P , 
	b_NHP_H2O_NH3P_O ,   
	b_NHP_H2O_H3OP_N ,   
	b_NHP_H2O_HNOP_H2 ,    
	b_NH_H2OP_H3OP_N ,     
	b_NHP_H2O_OH_NH2P ,    
	b_NHP_CN_HCNP_N ,      
	b_NH_HCNP_CN_NH2P ,    
	b_NH_COP_HCOP_N ,      
	b_NH_SIP_SINP_H ,      
	b_NH_HNOP_NO_NH2P ,    
	b_NH_O2P_HNOP_O ,      
	b_NHP_O2_NOP_OH ,      
	b_NH_O2P_NO2P_H ,      
	b_NHP_S_HSP_N ,        
	b_NHP_S_NSP_H ,        
	b_NH_SP_NSP_H ,        
	b_CH3P_NH3_NH4P_CH2 ,  
	b_CH3P_S_HCSP_H2 ,     
	b_O_NH2P_HNOP_H ,      
	b_O_NH3P_HNOP_H2 ,     
	b_OP_CN_NOP_C ,        
	b_OP_HCN_COP_NH ,      
	b_OP_HCN_NOP_CH ,      
	b_OP_HCN_HCOP_N ,      
	b_OP_N2_NOP_N ,        
	b_O_N2P_NOP_N ,        
	b_O_HNOP_NO2P_H ,      
	b_O_HSP_SP_OH ,       
	b_O_HSP_SOP_H ,       
	b_O_SINP_SIOP_N ,     
	b_OP_N2O_NOP_NO ,     
	b_O_CSP_S_COP ,       
	b_O_HCSP_S_HCOP ,    
	b_O_HCSP_OCSP_H ,    
	b_OP_NO2_O2_NOP ,    
	b_O_NSP_S_NOP ,      
	b_NH2P_NH2_NH3P_NH , 
	b_NH2_OHP_NH3P_O ,   
	b_NH2P_OH_H2OP_NH ,  
	b_NH2P_NH3_NH4P_NH , 
	b_NH2_NH3P_NH4P_NH ,
	b_NH2_CH5P_NH3P_CH4 , 
	b_NH2P_H2O_NH3P_OH ,  
	b_NH2P_H2O_H3OP_NH ,  
	b_NH2_H2OP_NH3P_OH ,  
	b_NH2P_H2O_NH4P_O ,   
	b_NH2_H3OP_H2O_NH3P , 
	b_NH2_HCNP_CN_NH3P ,  
	b_NH2_COP_HCOP_NH ,   
	b_NH2_HNOP_NO_NH3P ,  
	b_NH2P_O2_HNOP_OH ,   
	b_NH2P_S_HSP_NH ,     
	b_CH4P_NH3_NH4P_CH3 , 
	b_CH4_NH3P_NH4P_CH3 , 
	b_CH4_N2P_N2_CH2P_H2 ,
	b_CH4_N2P_N2_CH3P_H , 
	b_CH4_HNOP_NO_CH5P ,   
	b_CH4_SP_HCSP_H2_H ,   
	b_CH4_CSP_HCSP_CH3 ,   
	b_OHP_NH3_NH4P_O ,     
	b_OH_NH3P_NH4P_O ,     
	b_OHP_CN_HCNP_O ,      
	b_OH_HCNP_CN_H2OP ,    
	b_OHP_NO_HNOP_O ,      
	b_OH_HNOP_NO_H2OP ,    
	b_OHP_S_HSP_O ,        
	b_OHP_S_SOP_H ,        
	b_OH_SP_SOP_H ,        
	b_NH3P_NH3_NH4P_NH2 ,  
	b_NH3_CH5P_NH4P_CH4 ,  
	b_NH3P_H2O_NH4P_OH ,   
	b_NH3_H2OP_NH4P_OH ,   
	b_NH3_H3OP_NH4P_H2O ,  
	b_NH3_COP_HCOP_NH2 ,   
	b_NH3_HNOP_NO_NH4P ,   
	b_NH3_HSP_S_NH4P ,     
	b_NH3_HCSP_CS_NH4P ,   
	b_CH5P_S_HSP_CH4 ,     
	b_H2O_CNP_HCNP_OH ,    
	b_H2O_CNP_HCOP_NH ,    
	b_H2O_HCNP_CN_H3OP ,   
	b_H2O_HNOP_NO_H3OP ,   
	b_H2OP_S_HSP_OH ,      
	b_H2O_HSP_S_H3OP ,     
	b_H3OP_CS_HCSP_H2O ,   
	b_CNP_NO_OCNP_N ,      
	b_CN_HNOP_NO_HCNP ,    
	b_CNP_O2_OCNP_O ,      
	b_HCNP_S_HSP_CN ,      
	b_HNOP_S_HSP_NO ,      
	b_O2_SP_SOP_O ,        
	b_O2P_S_SOP_O ,        
	b_O2_CSP_OCSP_O ,      
	b_S_SIOP_SO_SIP ,      
	b_CP_NH3_NH3P_C ,     
	b_C_CNP_CN_CP ,       
	b_C_N2P_N2_CP ,      
	b_CP_NO_NOP_C ,      
	b_CP_SIN_SINP_C ,    
	b_C_CSP_CS_CP ,      
	b_CP_NS_NSP_C ,      
	b_CP_SO_SOP_C ,      
	b_CP_OCS_OCSP_C ,    
	b_CH_NH2P_NH2_CHP ,  
	b_CHP_NH3_NH3P_CH ,  
	b_CH_CNP_CN_CHP ,    
	b_CH_N2P_N2_CHP ,    
	b_CHP_NO_NOP_CH ,    
	b_NP_NH_NHP_N ,      
	b_NP_NH2_NH2P_N ,    
	b_NP_NH3_NH3P_N ,    
	b_NP_CN_CNP_N ,      
	b_NP_HCN_HCNP_N ,    
	b_N_N2P_N2_NP ,      
	b_NP_NO_NOP_N ,      
	b_NP_OCS_OCSP_N ,    
	b_CH2_NH2P_NH2_CH2P ,
	b_CH2_CNP_CN_CH2P ,  
	b_CH2_N2P_N2_CH2P ,  
	b_CH2P_NO_NOP_CH2 ,  
	b_NH_OP_O_NHP ,      
	b_NH_OHP_OH_NHP ,    
	b_NHP_NH3_NH3P_NH ,  
	b_NHP_H2O_H2OP_NH ,  
	b_NH_CNP_CN_NHP ,    
	b_NH_N2P_N2_NHP ,    
	b_NHP_NO_NOP_NH ,    
	b_NHP_O2_O2P_NH ,    
	b_NHP_S_SP_NH ,      
	b_CH3P_NO_NOP_CH3 ,  
	b_OP_NH2_NH2P_O ,    
	b_OP_NH3_NH3P_O ,    
	b_O_CNP_CN_OP ,      
	b_O_HCNP_HCN_OP ,    
	b_O_N2P_N2_OP ,      
	b_OP_NO_NOP_O ,      
	b_OP_OCS_OCSP_O ,    
	b_NH2_OHP_OH_NH2P ,  
	b_NH2P_NH3_NH3P_NH2 ,
	b_NH2_H2OP_H2O_NH2P ,  
	b_NH2_CNP_CN_NH2P ,    
	b_NH2_N2P_N2_NH2P ,    
	b_NH2P_NO_NOP_NH2 ,    
	b_NH2_O2P_O2_NH2P ,    
	b_NH2P_S_SP_NH2 ,      
	b_CH4P_NH3_NH3P_CH4 ,  
	b_CH4P_OCS_OCSP_CH4 ,  
	b_OHP_NH3_NH3P_OH ,    
	b_OH_CNP_CN_OHP ,      
	b_OH_N2P_N2_OHP ,      
	b_OHP_NO_NOP_OH ,      
	b_NH3_H2OP_H2O_NH3P ,  
	b_NH3_HCNP_HCN_NH3P ,  
	b_NH3_N2P_N2_NH3P ,    
	b_NH3P_SI_SIP_NH3 ,    
	b_NH3_O2P_O2_NH3P ,    
	b_NH3_SP_S_NH3P ,      
	b_NH3_HSP_HS_NH3P ,    
	b_NH3_SOP_SO_NH3P ,    
	b_H2O_HCNP_HCN_H2OP ,  
	b_H2O_N2P_N2_H2OP ,    
	b_H2OP_NO_NOP_H2O ,    
	b_CNP_HCN_HCNP_CN ,    
	b_CN_N2P_N2_CNP ,      
	b_CNP_NO_NOP_CN ,      
	b_CNP_O2_O2P_CN ,      
	b_CNP_S_SP_CN ,        
	b_HCN_N2P_N2_HCNP ,    
	b_HCNP_NO_NOP_HCN ,    
	b_HCNP_O2_O2P_HCN ,    
	b_HCNP_S_SP_HCN ,      
	b_N2P_NO_NOP_N2 ,      
	b_N2P_O2_O2P_N2 ,      
	b_N2P_S_SP_N2 ,        
	b_SI_NOP_NO_SIP ,      
	b_SI_HSP_HS_SIP ,      
	b_SI_CSP_CS_SIP ,      
	b_NO_HNOP_HNO_NOP ,    
	b_NO_O2P_O2_NOP ,      
	b_NO_SP_S_NOP ,        
	b_NO_HSP_HS_NOP ,      
	b_NO_SIOP_SIO_NOP ,    
	b_NO_S2P_S2_NOP ,      
	b_O2P_NO2_NO2P_O2 ,    
	b_S_HSP_HS_SP ,        
	b_C_N_CN_NU ,          
	b_C_S_CS_NU ,          
	b_CP_S_CSP_NU ,        
	b_NP_N_N2P_NU ,        
	b_CH_NP_N_CHP ,        
	b_CHP_S_SP_CH ,        
	b_NP_CH2_CH2P_N ,      
	b_NP_CH4_CH4P_N ,      
	b_NP_OH_OHP_N ,        
	b_NP_H2O_H2OP_N ,      
	b_NP_O2_O2P_N ,        
	b_OHP_S_SP_OH ,        
	b_H2OP_S_SP_H2O ,      
	b_SI_SP_S_SIP ,        
	b_O2P_S_SP_O2 ,  
	b_C_CH_C2_H,
	b_C_CN_C2_N,
	b_C_CS_S_C2,
	b_N_C2_CN_C,
	b_C2_S_CS_C,
	b_NHP_C2_HCNP_C,
	b_OP_C2_COP_C,
	b_C2_SP_CSP_C,
	b_C_C2P_C2_CP,
	b_CH_C2P_C2_CHP,
	b_NP_C2_C2P_N,
	b_CH2_C2P_C2_CH2P,
	b_OP_C2_C2P_O,
	b_NH2_C2P_C2_NH2P,
	b_OHP_C2_C2P_OH,
	b_OH_C2P_C2_OHP,
	b_H2OP_C2_C2P_H2O,
	b_C2_CNP_CN_C2P,
	b_C2_N2P_N2_C2P,
	b_C2P_NO_NOP_C2,
	b_C2_O2P_O2_C2P,
	b_C2P_S_SP_C2,
	b_C_C_C2_nu,
	b_CP_CH_C2P_H,
	b_C_CHP_C2P_H,
	b_CHP_CH_C2P_H2,
	b_N_C2P_CN_CP,
	b_O_C2P_COP_C,
	b_C2P_S_CSP_C,
	b_CP_C_C2P_nu,
		C_CH_C2_H_1,
	C_CN_C2_N_1,
	C_CS_S_C2_1,
	N_C2_CN_C_1,
	C2_S_CS_C_1,
	NHP_C2_HCNP_C_1,
	OP_C2_COP_C_1,
	C2_SP_CSP_C_1,
	C_C2P_C2_CP_1,
	CH_C2P_C2_CHP_1,
	NP_C2_C2P_N_1,
	CH2_C2P_C2_CH2P_1,
	OP_C2_C2P_O_1,
	NH2_C2P_C2_NH2P_1,
	OHP_C2_C2P_OH_1,
	OH_C2P_C2_OHP_1,
	H2OP_C2_C2P_H2O_1,
	C2_CNP_CN_C2P_1,
	C2_N2P_N2_C2P_1,
	C2P_NO_NOP_C2_1,
	C2_O2P_O2_C2P_1,
	C2P_S_SP_C2_1,
	C_C_C2_nu_1,
	CP_CH_C2P_H_1,
	C_CHP_C2P_H_1,
	CHP_CH_C2P_H2_1,
	N_C2P_CN_CP_1,
	O_C2P_COP_C_1,
	C2P_S_CSP_C_1,
	CP_C_C2P_nu_1,
	C_CH_C2_H_2,
	C_CN_C2_N_2,
	C_CS_S_C2_2,
	N_C2_CN_C_2,
	C2_S_CS_C_2,
	NHP_C2_HCNP_C_2,
	OP_C2_COP_C_2,
	CP_S_C_SP_1,
	CP_S_C_SP_2,
	b_CP_S_C_SP,
	C2_SP_CSP_C_2,
	C_C2P_C2_CP_2,
	CH_C2P_C2_CHP_2,
	NP_C2_C2P_N_2,
	CH2_C2P_C2_CH2P_2,
	OP_C2_C2P_O_2,
	NH2_C2P_C2_NH2P_2,
	OHP_C2_C2P_OH_2,
	OH_C2P_C2_OHP_2,
	H2OP_C2_C2P_H2O_2,
	C2_CNP_CN_C2P_2,
	C2_N2P_N2_C2P_2,
	C2P_NO_NOP_C2_2,
	C2_O2P_O2_C2P_2,
	C2P_S_SP_C2_2,
	C_C_C2_nu_2,
	CP_CH_C2P_H_2,
	C_CHP_C2P_H_2,
	CHP_CH_C2P_H2_2,
	N_C2P_CN_CP_2,
	O_C2P_COP_C_2,
	C2P_S_CSP_C_2,
	CP_C_C2P_nu_2,
	O_CCl_ClO_C_1,
	O_ClO_Cl_O2_1,
	CP_HCl_CClP_H_1,
	CH3P_HCl_H2CClP_H2_1,
	H2O_H2ClP_HCl_H3OP_1,
	CP_CCl_CClP_C_1,
	CP_ClO_ClOP_C_1,
	O2_ClP_Cl_O2P_1,
	O_CCl_ClO_C_2,
	O_ClO_Cl_O2_2,
	CP_HCl_CClP_H_2,
	CH3P_HCl_H2CClP_H2_2,
	H2O_H2ClP_HCl_H3OP_2,
	CP_CCl_CClP_C_2,
	CP_ClO_ClOP_C_2,
	O2_ClP_Cl_O2P_2,
	b_O_CCl_ClO_C,
	b_O_ClO_Cl_O2,
	b_CP_HCl_CClP_H,
	b_CH3P_HCl_H2CClP_H2,
	b_H2O_H2ClP_HCl_H3OP,
	b_CP_CCl_CClP_C,
	b_CP_ClO_ClOP_C,
	b_O2_ClP_Cl_O2P,
	CP_NH_CHP_N_1,
	CP_NH_CHP_N_2,
	b_CP_NH_CHP_N ,
	C_NH2_HNC_H_1      ,
	C_NH2_HNC_H_2       , 
	N_CH2_HNC_H_1        ,
	N_CH2_HNC_H_2        ,
	CHP_HNC_HCNHP_C_1    ,
	CHP_HNC_HCNHP_C_2    ,
	CH_HCNHP_HNC_CH2P_1  ,
	CH_HCNHP_HNC_CH2P_2  ,
	CH2_HCNHP_HNC_CH3P_1 ,
	CH2_HCNHP_HNC_CH3P_2 ,
	NHP_HNC_HCNHP_N_1    ,
	NHP_HNC_HCNHP_N_2    ,
	NH2P_HNC_HCNHP_NH_1  ,
	NH2P_HNC_HCNHP_NH_2  ,
	NH2_HCNHP_HNC_NH3P_1 ,
	NH2_HCNHP_HNC_NH3P_2 ,
	OHP_HNC_HCNHP_O_1    ,
	OHP_HNC_HCNHP_O_2    ,
	NH3_HCNHP_HNC_NH4P_1 ,
	NH3_HCNHP_HNC_NH4P_2 ,
	CH5P_HNC_HCNHP_CH4_1 ,
	CH5P_HNC_HCNHP_CH4_2 ,
	H2OP_HNC_HCNHP_OH_1  ,
	H2OP_HNC_HCNHP_OH_2  ,
	H3OP_HNC_HCNHP_H2O_1 ,
	H3OP_HNC_HCNHP_H2O_2 ,
	HCNP_HNC_HCNHP_CN_1  ,
	HCNP_HNC_HCNHP_CN_2  ,
	HNC_HNOP_NO_HCNHP_1  ,
	HNC_HNOP_NO_HCNHP_2  ,
	HNC_HSP_S_HCNHP_1    ,
	HNC_HSP_S_HCNHP_2    ,
	CHP_HCN_HCNHP_C_1    ,
	CHP_HCN_HCNHP_C_2    ,
	CH_HCNHP_HCN_CH2P_1  ,
	CH_HCNHP_HCN_CH2P_2  ,
	NP_CH4_HCNHP_H_H_1   ,
	NP_CH4_HCNHP_H_H_2   ,
	CH2_HCNHP_HCN_CH3P_1 ,
	CH2_HCNHP_HCN_CH3P_2 ,
	NH_CH3P_HCNHP_H2_1   ,
	NH_CH3P_HCNHP_H2_2   ,
	NHP_HCN_HCNHP_N_1    ,
	NHP_HCN_HCNHP_N_2    ,
	NH2P_HCN_HCNHP_NH_1  ,
	NH2P_HCN_HCNHP_NH_2  ,
	NH2_HCNHP_HCN_NH3P_1 ,
	NH2_HCNHP_HCN_NH3P_2 ,
	CH4_HCNP_HCNHP_CH3_1 ,
	CH4_HCNP_HCNHP_CH3_2 ,
	OHP_HCN_HCNHP_O_1    ,
	OHP_HCN_HCNHP_O_2    ,
	NH3_HCNP_HCNHP_NH2_1 ,
	NH3_HCNP_HCNHP_NH2_2 ,
	NH3_HCNHP_HCN_NH4P_1 ,
	NH3_HCNHP_HCN_NH4P_2 ,
	CH5P_HCN_HCNHP_CH4_1 ,
	CH5P_HCN_HCNHP_CH4_2 ,
	H2OP_HCN_HCNHP_OH_1  ,
	H2OP_HCN_HCNHP_OH_2  ,
	H3OP_HCN_HCNHP_H2O_1 ,
	H3OP_HCN_HCNHP_H2O_2 ,
	HCNP_HCN_HCNHP_CN_1  ,
	HCNP_HCN_HCNHP_CN_2  ,
	HCN_HNOP_NO_HCNHP_1  ,
	HCN_HNOP_NO_HCNHP_2  ,
	HCN_HSP_S_HCNHP_1    ,
	HCN_HSP_S_HCNHP_2    ,
	b_C_NH2_HNC_H,        
	b_N_CH2_HNC_H ,       
	b_CHP_HNC_HCNHP_C ,   
	b_CH_HCNHP_HNC_CH2P,  
	b_CH2_HCNHP_HNC_CH3P, 
	b_NHP_HNC_HCNHP_N    ,
	b_NH2P_HNC_HCNHP_NH  ,
	b_NH2_HCNHP_HNC_NH3P ,
	b_OHP_HNC_HCNHP_O    ,
	b_NH3_HCNHP_HNC_NH4P ,
	b_CH5P_HNC_HCNHP_CH4 ,
	b_H2OP_HNC_HCNHP_OH  ,
	b_H3OP_HNC_HCNHP_H2O ,
	b_HCNP_HNC_HCNHP_CN  ,
	b_HNC_HNOP_NO_HCNHP  ,
	b_HNC_HSP_S_HCNHP    ,
	b_CHP_HCN_HCNHP_C    ,
	b_CH_HCNHP_HCN_CH2P  ,
	b_NP_CH4_HCNHP_H_H   ,
	b_CH2_HCNHP_HCN_CH3P ,
	b_NH_CH3P_HCNHP_H2   ,
	b_NHP_HCN_HCNHP_N    ,
	b_NH2P_HCN_HCNHP_NH  ,
	b_NH2_HCNHP_HCN_NH3P ,
	b_CH4_HCNP_HCNHP_CH3 ,
	b_OHP_HCN_HCNHP_O    ,
	b_NH3_HCNP_HCNHP_NH2 ,
	b_NH3_HCNHP_HCN_NH4P ,
	b_CH5P_HCN_HCNHP_CH4 ,
	b_H2OP_HCN_HCNHP_OH  ,
	b_H3OP_HCN_HCNHP_H2O ,
	b_HCNP_HCN_HCNHP_CN  ,
	b_HCN_HNOP_NO_HCNHP  ,
	b_HCN_HSP_S_HCNHP,
	C_CH2_C2H_H_1,
	C_CH2_C2H_H_2,
	OP_C2H_COP_CH_1,
	OP_C2H_COP_CH_2,
	C2H_COP_HCOP_C2_1,
	C2H_COP_HCOP_C2_2,
	b_C_CH2_C2H_H,
	b_OP_C2H_COP_CH,
	b_C2H_COP_HCOP_C2,
	C_CH2P_C2HP_H_1,                                                                                                  
	C_CH2P_C2HP_H_2,                                                                                                  
	C_CH3P_C2HP_H2_1,                                                                                                  
	C_CH3P_C2HP_H2_2,                                                                                                  
	C2_HCNP_CN_C2HP_1,                                                                                                  
	C2_HCNP_CN_C2HP_2,                                                                                                  
	C2_HNOP_NO_C2HP_1,                                                                                                  
	C2_HNOP_NO_C2HP_2,                                                                                                  
	C2H_CNP_CN_C2HP_1,                                                                                                  
	C2H_CNP_CN_C2HP_2,                                                                                                  
	C2H_N2P_N2_C2HP_1,                                                                                                  
	C2H_N2P_N2_C2HP_2,                                                                                                  
	C2HP_HCN_HCNHP_C2_1,                                                                                                  
	C2HP_HCN_HCNHP_C2_2,                                                                                                  
	C2HP_HNC_HCNHP_C2_1,                                                                                                  
	C2HP_HNC_HCNHP_C2_2,                                                                                                  
	C2HP_NO_NOP_C2H_1,                                                                                                  
	C2HP_NO_NOP_C2H_2,                                                                                                  
	C2HP_S_SP_C2H_1,                                                                                                  
	C2HP_S_SP_C2H_2,                                                                                                  
	CH_C2HP_C2_CH2P_1,                                                                                                  
	CH_C2HP_C2_CH2P_2,                                                                                                  
	CH2_C2HP_C2_CH3P_1,                                                                                                  
	CH2_C2HP_C2_CH3P_2,                                                                                                  
	CH4_C2P_C2HP_CH3_1,                                                                                                  
	CH4_C2P_C2HP_CH3_2,                                                                                                  
	CH5P_C2_C2HP_CH4_1,                                                                                                  
	CH5P_C2_C2HP_CH4_2,                                                                                                  
	CHP_CH2_C2HP_H2_1,                                                                                                  
	CHP_CH2_C2HP_H2_2,                                                                                                  
	CP_CH2_C2HP_H_1,                                                                                                  
	CP_CH2_C2HP_H_2,                                                                                                  
	CP_CH3_C2HP_H2_1,                                                                                                  
	CP_CH3_C2HP_H2_2,                                                                                                  
	H2O_C2P_C2HP_OH_1,                                                                                                  
	H2O_C2P_C2HP_OH_2,                                                                                                  
	H2OP_C2_C2HP_OH_1,                                                                                                  
	H2OP_C2_C2HP_OH_2,                                                                                                  
	H2OP_C2H_C2HP_H2O_1,                                                                                                  
	H2OP_C2H_C2HP_H2O_2,                                                                                                  
	H3OP_C2_C2HP_H2O_1,                                                                                                  
	H3OP_C2_C2HP_H2O_2,                                                                                                  
	N_C2HP_CN_CHP_1,                                                                                                  
	N_C2HP_CN_CHP_2,                                                                                                  
	NH_C2P_C2HP_N_1,                                                                                                  
	NH_C2P_C2HP_N_2,                                                                                                  
	NH2_C2HP_C2_NH3P_1,                                                                                                  
	NH2_C2HP_C2_NH3P_2,                                                                                                  
	NH2P_C2_C2HP_NH_1,                                                                                                  
	NH2P_C2_C2HP_NH_2,                                                                                                  
	NH3_C2HP_C2_NH4P_1,                                                                                                  
	NH3_C2HP_C2_NH4P_2,                                                                                                  
	NHP_C2_C2HP_N_1,                                                                                                  
	NHP_C2_C2HP_N_2,                                                                                                  
	NP_C2H_C2HP_N_1,                                                                                                  
	NP_C2H_C2HP_N_2,                                                                                                  
	O_C2HP_HCOP_C_1,                                                                                                  
	O_C2HP_HCOP_C_2,                                                                                                  
	OHP_C2_C2HP_O_1,                                                                                                  
	OHP_C2_C2HP_O_2,                                                                                                  
	OHP_C2H_C2HP_OH_1,                                                                                                  
	OHP_C2H_C2HP_OH_2,                                                                                                  
	OP_C2H_C2HP_O_1,                                                                                                  
	OP_C2H_C2HP_O_2,                                                                                                  
	b_C_CH2P_C2HP_H,                                                                                                  
	b_C_CH3P_C2HP_H2,                                                                                                  
	b_C2_HCNP_CN_C2HP,                                                                                                  
	b_C2_HNOP_NO_C2HP,                                                                                                  
	b_C2H_CNP_CN_C2HP,                                                                                                  
	b_C2H_N2P_N2_C2HP,                                                                                                  
	b_C2HP_HCN_HCNHP_C2,                                                                                                  
	b_C2HP_HNC_HCNHP_C2,                                                                                                  
	b_C2HP_NO_NOP_C2H,                                                                                                  
	b_C2HP_S_SP_C2H,                                                                                                  
	b_CH_C2HP_C2_CH2P,                                                                                                  
	b_CH2_C2HP_C2_CH3P,                                                                                                  
	b_CH4_C2P_C2HP_CH3,                                                                                                  
	b_CH5P_C2_C2HP_CH4,                                                                                                  
	b_CHP_CH2_C2HP_H2,                                                                                                  
	b_CP_CH2_C2HP_H,                                                                                                  
	b_CP_CH3_C2HP_H2,                                                                                                  
	b_H2O_C2P_C2HP_OH,                                                                                                  
	b_H2OP_C2_C2HP_OH,                                                                                                  
	b_H2OP_C2H_C2HP_H2O,                                                                                                  
	b_H3OP_C2_C2HP_H2O,                                                                                                  
	b_N_C2HP_CN_CHP,                                                                                                  
	b_NH_C2P_C2HP_N,                                                                                                  
	b_NH2_C2HP_C2_NH3P,                                                                                                  
	b_NH2P_C2_C2HP_NH,                                                                                                  
	b_NH3_C2HP_C2_NH4P,                                                                                                  
	b_NHP_C2_C2HP_N,                                                                                                  
	b_NP_C2H_C2HP_N,                                                                                                  
	b_O_C2HP_HCOP_C,                                                                                                  
	b_OHP_C2_C2HP_O,                                                                                                  
	b_OHP_C2H_C2HP_OH,                                                                                                  
	b_OP_C2H_C2HP_O,
	CP_C2H_C3P_H_1,
	CP_C2H_C3P_H_2,
	b_CP_C2H_C3P_H,
	CHP_C2H_C3P_H2_1,
	CHP_C2H_C3P_H2_2,
	b_CHP_C2H_C3P_H2,
	C2P_C2_C3P_C_1,
	C2P_C2_C3P_C_2,
	b_C2P_C2_C3P_C,
	CHP_C2_C3P_H_1,
	CHP_C2_C3P_H_2,
	b_CHP_C2_C3P_H,
	CH_C2P_C3P_H_1,
	CH_C2P_C3P_H_2,
	b_CH_C2P_C3P_H,
	C_C2HP_C3P_H_1,
	C_C2HP_C3P_H_2,
	b_C_C2HP_C3P_H,

	b_C_C2H2_C3H_H,
	b_C_C2H2P_C3HP_H,
	b_C2H_HCNP_C2H2P_CN,
	b_C2H2P_HCN_HCNHP_C2H,
	b_C2H2P_NO_NOP_C2H2,
	b_C2HP_HCN_C2H2P_CN,
	b_CH_C2HP_C3HP_H,
	b_CH_CH3P_C2H2P_H2,
	b_CH2_C2P_C3HP_H,
	b_CH2_CH2_C2H2_H_H,
	b_CH2_CH2_C2H2_H2,
	b_CH3P_C2_C3HP_H2,
	b_CH4_C2HP_C2H2P_CH3,
	b_CH4_C2P_C2H2P_CH2,
	b_CH4_C2P_C3HP_H2_H,
	b_CH4P_C2H2_C2H2P_CH4,
	b_CH5P_C2H_C2H2P_CH4,
	b_CHP_CH4_C2H2P_H2_H,
	b_CP_C2H2_C3HP_H,
	b_CP_CH3_C2H2P_H,
	b_CP_CH4_C2H2P_H2,
	b_H2O_C2H2P_C2H_H3OP,
	b_H2O_C3HP_HCOP_C2H2,
	b_H2OP_C2H_C2H2P_OH,
	b_H2OP_C2H2_C2H2P_H2O,
	b_H3OP_C3_C3HP_H2O,
	b_N_C2H2P_HCN_CHP,
	b_NH2_C2H2P_C2H_NH3P,
	b_NH2P_C2H_C2H2P_NH,
	b_NH3_C2H2P_C2H_NH4P,
	b_NH3_C2H2P_C2H2_NH3P,
	b_NH3_C3HP_C3_NH4P,
	b_NH3_C3HP_C3H_NH3P,
	b_NH3P_C2_C2H2P_NH,
	b_NHP_C2H_C2H2P_N,
	b_NO_C3HP_C3H_NOP,
	b_O_C2H2_C2H_OH,
	b_O_C2H2P_HCOP_CH,
	b_OH_C2H2_C2H_H2O,
	b_OHP_C2H_C2H2P_O,
	b_OP_C2H2_C2H2P_O,
	C_C2H2_C3H_H_1,
	C_C2H2_C3H_H_2,
	C_C2H2P_C3HP_H_1,
	C_C2H2P_C3HP_H_2,
	C2H_HCNP_C2H2P_CN_1,
	C2H_HCNP_C2H2P_CN_2,
	C2H2P_HCN_HCNHP_C2H_1,
	C2H2P_HCN_HCNHP_C2H_2,
	C2H2P_NO_NOP_C2H2_1,
	C2H2P_NO_NOP_C2H2_2,
	C2HP_HCN_C2H2P_CN_1,
	C2HP_HCN_C2H2P_CN_2,
	CH_C2HP_C3HP_H_1,
	CH_C2HP_C3HP_H_2,
	CH_CH3P_C2H2P_H2_1,
	CH_CH3P_C2H2P_H2_2,
	CH2_C2P_C3HP_H_1,
	CH2_C2P_C3HP_H_2,
	CH2_CH2_C2H2_H_H_1,
	CH2_CH2_C2H2_H_H_2,
	CH2_CH2_C2H2_H2_1,
	CH2_CH2_C2H2_H2_2,
	CH3P_C2_C3HP_H2_1,
	CH3P_C2_C3HP_H2_2,
	CH4_C2HP_C2H2P_CH3_1,
	CH4_C2HP_C2H2P_CH3_2,
	CH4_C2P_C2H2P_CH2_1,
	CH4_C2P_C2H2P_CH2_2,
	CH4_C2P_C3HP_H2_H_1,
	CH4_C2P_C3HP_H2_H_2,
	CH4P_C2H2_C2H2P_CH4_1,
	CH4P_C2H2_C2H2P_CH4_2,
	CH5P_C2H_C2H2P_CH4_1,
	CH5P_C2H_C2H2P_CH4_2,
	CHP_CH4_C2H2P_H2_H_1,
	CHP_CH4_C2H2P_H2_H_2,
	CP_C2H2_C3HP_H_1,
	CP_C2H2_C3HP_H_2,
	CP_CH3_C2H2P_H_1,
	CP_CH3_C2H2P_H_2,
	CP_CH4_C2H2P_H2_1,
	CP_CH4_C2H2P_H2_2,
	H2O_C2H2P_C2H_H3OP_1,
	H2O_C2H2P_C2H_H3OP_2,
	H2O_C3HP_HCOP_C2H2_1,
	H2O_C3HP_HCOP_C2H2_2,
	H2OP_C2H_C2H2P_OH_1,
	H2OP_C2H_C2H2P_OH_2,
	H2OP_C2H2_C2H2P_H2O_1,
	H2OP_C2H2_C2H2P_H2O_2,
	H3OP_C3_C3HP_H2O_1,
	H3OP_C3_C3HP_H2O_2,
	N_C2H2P_HCN_CHP_1,
	N_C2H2P_HCN_CHP_2,
	NH2_C2H2P_C2H_NH3P_1,
	NH2_C2H2P_C2H_NH3P_2,
	NH2P_C2H_C2H2P_NH_1,
	NH2P_C2H_C2H2P_NH_2,
	NH3_C2H2P_C2H_NH4P_1,
	NH3_C2H2P_C2H_NH4P_2,
	NH3_C2H2P_C2H2_NH3P_1,
	NH3_C2H2P_C2H2_NH3P_2,
	NH3_C3HP_C3_NH4P_1,
	NH3_C3HP_C3_NH4P_2,
	NH3_C3HP_C3H_NH3P_1,
	NH3_C3HP_C3H_NH3P_2,
	NH3P_C2_C2H2P_NH_1,
	NH3P_C2_C2H2P_NH_2,
	NHP_C2H_C2H2P_N_1,
	NHP_C2H_C2H2P_N_2,
	NO_C3HP_C3H_NOP_1,
	NO_C3HP_C3H_NOP_2,
	O_C2H2_C2H_OH_1,
	O_C2H2_C2H_OH_2,
	O_C2H2P_HCOP_CH_1,
	O_C2H2P_HCOP_CH_2,
	OH_C2H2_C2H_H2O_1,
	OH_C2H2_C2H_H2O_2,
	OHP_C2H_C2H2P_O_1,
	OHP_C2H_C2H2P_O_2,
	OP_C2H2_C2H2P_O_1,
	OP_C2H2_C2H2P_O_2,

	b_C_C2H3P_C3HP_H2,
	b_C2H_C2H3P_C2H2P_C2H2,
	b_CH2_CH3P_C2H3P_H2,
	b_CH4_C3HP_C2H3P_C2H2,
	b_CH4_HCNP_C2H3P_NH2,
	b_CH4P_C2H2_C2H3P_CH3,
	b_CH5P_C2H2_C2H3P_CH4,
	b_CHP_CH4_C2H3P_H2,
	b_CP_CH4_C2H3P_H,
	b_H2O_C2H3P_C2H2_H3OP,
	b_HCN_C2H3P_HCNHP_C2H2,
	b_HNC_C2H3P_HCNHP_C2H2,
	b_NH3_C2H3P_C2H2_NH4P,
	b_O_C2H3P_HCOP_CH2,
	C_C2H3P_C3HP_H2_1,
	C_C2H3P_C3HP_H2_2,
	C2H_C2H3P_C2H2P_C2H2_1,
	C2H_C2H3P_C2H2P_C2H2_2,
	CH2_CH3P_C2H3P_H2_1,
	CH2_CH3P_C2H3P_H2_2,
	CH4_C3HP_C2H3P_C2H2_1,
	CH4_C3HP_C2H3P_C2H2_2,
	CH4_HCNP_C2H3P_NH2_1,
	CH4_HCNP_C2H3P_NH2_2,
	CH4P_C2H2_C2H3P_CH3_1,
	CH4P_C2H2_C2H3P_CH3_2,
	CH5P_C2H2_C2H3P_CH4_1,
	CH5P_C2H2_C2H3P_CH4_2,
	CHP_CH4_C2H3P_H2_1,
	CHP_CH4_C2H3P_H2_2,
	CP_CH4_C2H3P_H_1,
	CP_CH4_C2H3P_H_2,
	H2O_C2H3P_C2H2_H3OP_1,
	H2O_C2H3P_C2H2_H3OP_2,
	HCN_C2H3P_HCNHP_C2H2_1,
	HCN_C2H3P_HCNHP_C2H2_2,
	HNC_C2H3P_HCNHP_C2H2_1,
	HNC_C2H3P_HCNHP_C2H2_2,
	NH3_C2H3P_C2H2_NH4P_1,
	NH3_C2H3P_C2H2_NH4P_2,
	O_C2H3P_HCOP_CH2_1,
	O_C2H3P_HCOP_CH2_2;
}	rate_COmole;



