/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*punt produce map of heating-cooling space for specified zone */
void map_do(
			FILE *io, 
			const char *chType);

/* mappar.h */
EXTERN struct t_MapPar {

	/*parameters doing with map command, MapZone is zone number,
	 * -1 for very start, init to 9999 to prevent map*/
	long int MapZone;

	/* RangeMap is range, parsed from same command*/
	float RangeMap[2];

	/* nMapStep is number of steps, set with set nmap command*/
	long int nMapStep;

	/* logical flag indicating whether results of map were ok -
	 * set false if inflection points occurred */
	int lgMapOK;

	/* this is set true when we are in process of doing a map */
	int lgMapBeingDone;

	/* logical flag indicating whether a map has been done */
	int lgMapDone;

	/* number of points actually done */
	long int nmap;

	/* saved temperatures for the map */
	float *temap;

	/* saved heating for the map */
	float *hmap; 

	/* saved cooling for the map */
	float *cmap;

	/* flag saying whether previous three vectors have had space allocated,
	 * this starts out zero and is set to first number needed when alloc happens, 
	 * and then never reset */
	long int nMapAlloc ;

	}	map;
