/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */

/*outline - adds line photons to reflin and outlin */
void outline( EmLine *t );

/* enter lines into the line storage array, called once per zone for each line*/
void linadd(
  double xInten,	/* xInten - local emissivity per unit vol, no fill fac */
  float wavelength,	/* lam integer wavelength */
  const char *chLab,		/* string label for ion */
  char chInfo );		/* character type of entry for line - given below */
						/* 'c' cooling, 'h' heating, 'i' info only, 'r' recom line */

/* define current opacities for H lines */
void HLineTransOpacSet( long int nelem );

/*TexcLine derive excitation temperature of line from contents of line array */
double TexcLine(EmLine * t);

/*DumpLine print various information about an emission line vector, used in debugging */
void DumpLine(EmLine * t);

/*GetGF convert Einstein A into oscillator strength */
double GetGF(double eina, 
	  double enercm, 
	  double gup);

/*eina convert a gf into an Einstein A */
double eina(double gf, 
	  double enercm, 
	  double gup);

/*abscf convert gf into absorption coefficient */
double abscf(double gf, 
	  double enercm, 
	  double gl);

/* setting true will use low-density Lyman branching ratios */
#define LOWDEN_LYMAN FALSE

/* returns fraction of populations the produce emission */
double emit_frac( EmLine *t );

/* generate null terminated line label from contents of line trans array */
void chIonLbl( char*, EmLine * t );

/*chLineLbl use information in line transfer arrays to generate a line label */
/* this label is null terminated */
char* chLineLbl(EmLine * t );

/*RefIndex calculates the index of refraction of air using the line energy in wavenumbers,
 * used to convert vacuum wavelengths to air wavelengths. */
double RefIndex(double EnergyWN);


/*PutCS enter a collision strength into an individual line struc */
void PutCS(double cs, 
  /* the line struc */
  EmLine * t);

/*WavlenErrorGet - given the real wavelength in A for a line
 * routine will find the error expected between the real 
 * wavelength and the wavelength printed in the output, with 4 sig figs,
 * function returns difference between exact and 4 sig fig wl, so 
 * we have found correct line is fabs(d wl) < return */
float WavlenErrorGet( float wavelength );

/* put forbidden line into stack, using index derived below */
void lindst(double xInten, 
  float wavelength, 
  const char *chLab, 
  long int ipnt, 
  char chInfo, 
  int lgOutToo);

/*PntForLine generate pointer for forbidden line */
void PntForLine(double wavelength, 
  const char *chLabel, 
  /* this is array index on the f, not c scale,
   * for the continuum cell holding the line */
  long int *ipnt);

/*PutLine enter local line intensity into the intensity stack for eventual printout */
void PutLine(EmLine * t);

/*OccupationNumberLine - derive the photon occupation number at line center for any line */
double OccupationNumberLine( EmLine * t );

/*PutExtra enter and 'extra' intensity source for some line */
void PutExtra(double Extra);

/*EmLineJunk set all elements of EmLine struc to dangerous values */
void EmLineJunk( EmLine * t );

/*EmLineZero set all elements of EmLine struc to zero */
void EmLineZero( EmLine * t );

/* convert down coll rate back into electron cs in case other parts of code need this for reference */
void LineConvRate2CS( EmLine * t , float rate );

/*lgTauGood returns true is we have not overrun optical depth scale */
int lgTauGood( EmLine * t);

/*MakeCS compute collision strength by g-bar approximations */
void MakeCS(EmLine * t );

/*totlin sum total intensity of cooling, recombination, or intensity lines */
double totlin(
	/* chInfor is 1 char, 
	'i' information, 
	'r' recombination or 
	'c' collision */
	int chInfo);


/*FndLineHt search through line heat arrays to find the strongest heat source */
void FndLineHt(long int *level, 
  /* this is the index of the strongest line in the array on the c scale */
  long int *ipStrong, 
  double *Strong);


