/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* iso.h - information for isoelectronic sequences */

/* set true to use new he opacities, false to use old he atom */
#define	lgHeNew	TRUE

/* This macro is used to zero any radiative process with photon energy below
 * the plasma frequency.  The energy must be in Rydbergs!	*/
#define KillIfBelowPlasma(E_)		( (rfield.lgPlasNu && ((E_)<rfield.plsfrq) ) ? 0.:1. )

/*iso_create create storage space data for hydrogen and helium, 1 one time per coreload */
void iso_create(void);

/* do photoionization rates for element nelem on the ipISO isoelectronic sequence */
void iso_photo( long ipISO , long nelem );

/* evaluate state specific creation and destruction processes */
void iso_ionize_recombine( long ipISO , long nelem );

/* iso_continuum_lower - limit max prin. quan. no. due to continuum lowering processes */
void iso_continuum_lower( long ipISO , long nelem );

/*iso_cool compute net heating/cooling due to hydrogenc atom species */
void iso_cool(
	   /* the isoelectronic sequence, 0 for H */
	   long int ipISO , 
		/* nelem is element, so 0 for H itself */
		long int nelem);

/*	The Elevels data type, and then the iso.quant_desig[ipHE_LIKE] structure,
 *  which contain the quantum numbers n,l, and s for a given
 *  energy level, are defined here, for use in multiple subroutines. 
 *  Moved this definition here from "helike.h"	*/
typedef struct {
	long n;
	long s;
	long l;
} Elevels; 

EXTERN struct t_iso 
{

	/* An array of structures each containing for a given element, n,l, and s
	 * s=0 for singlets, s=1 for triplets - iso.quant_desig[ipISO][ipZ][level],
	 * elements are .s for spin, .l for ang mo, .n for prin quan num,
	 * collapsed levels l and s are -LONG_MAX */
	Elevels ***quant_desig;

	/* number of lyman lines to include only as opacity sources, in each iso seq,
	 * all now set to 100 in zero.c */
	long int nLyman[NISO];

	/* this is the set of extra lines,
	 * LymanLines[ipISO][ipZ][n]*/
	EmLine ***ExtraLymanLines;

	/* a set of array indices for all atoms on the iso sequences,
	 * ipIsoLevNIonCon[ipISO][ipZ][n] */
	long int ***ipIsoLevNIonCon;

	/* >>chng 01 dec 23, from float to double */
	/* ionization potential of level N in Ryd */
	double ***xIsoLevNIonRyd;

	/* ConBoltz excit to continuum */
	double ***ConBoltz/*ipISO][ipZ][n]*/;

	/* the ratio fully stripped ion to atom for all hydrogenic species
	 * HIonSimple is simple estimate, should agree at low density */
	double xIonSimple[NISO][LIMELM];

	/* option to turn off l-mixing collisions */
	int lgColl_l_mixing[NISO];

	/* option to turn off collisional excitation */
	int lgColl_excite[NISO];

	/* option to turn off collisional ionization */
	int lgColl_ionize[NISO];

	/* option to print departure coefficients */
	int lgPrtDepartCoef[NISO][LIMELM];

	/* option to print level populations */
	int lgPrtLevelPops[NISO][LIMELM];

	/* flag saying whether induced two photon is included 
	 * in the level pops for H- and He-like */
	int lgInd2nu_On;

	/* This variable is set to true if the model is full size in the sense that all levels below
	 * continuum are considered.	*/
	int lgFullSize[NISO][LIMELM];

	/* this is the number of collapsed levels along the iso seq atoms - this has
	 * no meaning for H-like (all are collapsed above n=2) */
	long int nCollapsed_max[NISO][LIMELM];
	long int nCollapsed_local[NISO][LIMELM];

	/* how the model atoms are topped off.  nHTopOff is the level, H set to 10 in zero,
	 * this is only used for the H-like iso sequence, no meaning for the he-like sequence */
	long int nTopOff[NISO][LIMELM];

	/*
	* iso.numLevels_max[ipISO][nelem] is the number of levels in iso atoms, 
	* including both resolved levels for lower n in He-like, and collapsed levels
	* n ranges from 0 to n = iso.numLevels_max[ipISO]-1
	* iso.numLevels_max[ipISO] is set on the fly with atom xx-like levels command 
	* it is initialized in zero.c
	*/
	/* the total number of levels in each atom in the iso sequences */
	/* Max is the maximum number of levels ever to be used in this core load. 
	 * local is the number of levels corresponding to local conditions, which, 
	 * of course, must be less than or equal to the max. */
	long int numLevels_max[NISO][LIMELM];
	long int numLevels_local[NISO][LIMELM];

	/* this is the quantum number n of the highest resolved level, only
	 * used for helium */
	/* the array index of the highest resolved level is numLevels-1 - nCollapsed */
	long int n_HighestResolved_max[NISO][LIMELM];
	long int n_HighestResolved_local[NISO][LIMELM];

	/* the total number of levels to print in each atom in the iso sequences */
	long int numPrintLevels[NISO][LIMELM];

	/* the statistical weights of the levels, stat[ipISO][nelem][n] */
	float ***stat;

	/* the statistical weights of the ions for each species,
	 * used for Milne relation and recombination */
	float stat_ion[NISO];

	/* the induced upward two-photon rate */
	double TwoNu_induc_up[NISO][LIMELM];

	/* the induced downward two-photon rate */
	double TwoNu_induc_dn[NISO][LIMELM];

	/* the largest induced downward two photon rate */
	double TwoNu_induc_dn_max[NISO][LIMELM];

	/* radiative recombination rate coefficient, RadRecomb[ipISO][ipZ][n][fcn]
	 * iso.RadRecomb[ipISO][ipZ][ipLo][ipRecEsc] escape prob
	 * iso.RadRecomb[ipISO][ipZ][n][ipRecNetEsc] net escape prob, accounting for absorption 
	 * iso.RadRecomb[ipISO][ipZ][ipLo][ipRecRad] rate coef, cm^3 s^-1 
	 * */
	double ****RadRecomb;

	/* difference between actual case b photons in rtdiffuse, and correct case b */
	float CaseBCheck[NISO][LIMELM];

	/* case b recombination rate coefficient */
	double RadRec_caseB[NISO][LIMELM];

	/* the total effective radiative recombination rate coefficient (cm3 s-1), 
	 * radiative rate with correction for absorption and ionization */
	double RadRec_effec[NISO][LIMELM];

	/* all processes from level n to the continuum, units s-1 */
	double ***RateLevel2Cont; 

	/* all processes from the continuum to level n, units s-1 */
	double ***RateCont2Level; 

	/* ratio of collisional recombination rate to recom from all processes */
	float RecomCollisFrac[NISO][LIMELM];

	/* ipOpac pointers for photoionization cross sections of hydrogen
	 * iso.ipOpac[NISO][LIMELM][NHPLPHOT] */
	long int ***ipOpac;

	/* population of level relative to ion */
	double ***Pop2Ion;

	/* continuum to total opacity factors for each level */
	float ***ConOpacRatio;

	/* departure coefficient */
	double ***DepartCoef;

	/* true is all lte populations positive for Hydrogenic atoms */
	int lgPopLTE_OK[NISO][LIMELM];

	/* hlte is lte population of each level */
	double ***PopLTE;

	/* collisional ionization rate coefficient from each level */
	double ***ColIoniz;

	/* the ratio of ion to recombined species, for H-like and He-like ions of
	 * the heavy elements */
	double pop_ion_ov_neut[NISO][LIMELM];

	/* net free bound cooling for this element */
	double FreeBnd_net_Cool_Rate[NISO][LIMELM];

	/* net cooling due to collisional ionization */
	double coll_ion[NISO][LIMELM];

	/* net cooling due to collisional excit of higher lines */
	double cRest_cool[NISO][LIMELM];

	/* net cooling due to total collisional excit of lines */
	double xLineTotCool[NISO][LIMELM];

	/* deriv of net cooling due to total collisional excit of lines */
	double dLTot[NISO][LIMELM];

	/* net cooling due to rad rec */
	double RadRecCool[NISO][LIMELM];

	/* net cooling due to collisional excit of balmer lines */
	double cBal_cool[NISO][LIMELM];

	/* net cooling due to collisional excit of higher lyman lines */
	double cLyrest_cool[NISO][LIMELM];

	/* net cooling due to collisional excit of Lya */
	double cLya_cool[NISO][LIMELM];

	/* photoionization rate, gammnc[iso][nelem][level] */
	double ***gamnc;

	/* RecomInducRate will become induced recombination rate coefficient
	 * when multipled by lte population.  
	 * integral of photorate times exp(-hu/kt) 
	 * for ind rec, produced by gamma routine needs to be mult
	 * by lte pop to become real rate  */
	double ***RecomInducRate;

	/* RecomInducCool_Coef becomes rate coef for incuded recombination cooling,
	 * when multipled by lte population. 
	 * this times hnu-hnuo0 to get cooling,
	 * evaluated in gamma routine and saved */
	double ***RecomInducCool_Coef;

	/* the actual induced recom cooling rate, erg cm-3 s-1 */
	double RecomInducCool_Rate[NISO][LIMELM];

	/* Boltzmann factor from lower to upper level, [ISO][nelem][up][lo] */
	double ****Boltzmann;

	/* photoelectric heating rate */
	double ***PhotoHeat;

	/* this is the rate for the Aul given to bogus transitions,
	 * set to 1e-30 in zero */
	/* >>chng 04 may 17, esd 1e-20, changed to 1e-30 to allow
	 * rydberg levels to be treated with their small As */
	float SmallA;

	/* will become array of indices for induced two photon,
	 * series of symmetric indices 
	 * ipHy2nu[ipISO][ipZ][energy] */
	long int ***ipSym2nu;

	/* will become array of two photon transition probabilities per energy bin	*/
	float ***As2nu;

	/* These are pointers to the energies representing the two-photon gap,
	 * and half the gap, respectively.  */
	long ipTwoPhoE[NISO][LIMELM];
	long ipHalfTwoPhoE[NISO][LIMELM];

	/* types of redistribution functions for Lya, other resonances, and subordinate lines */
	int ipLyaRedist[NISO] , ipResoRedist[NISO] , ipSubRedist[NISO] ;

	/* this is the upper level for Lya */
	int nLyaLevel[NISO];

	/* flag to set which type of solution to do for level pops, low T or pops */
	char chTypeAtomSet[NISO][10];
	/* flag to set which type of solution was used for level pops, low T or pops */
	char chTypeAtomUsed[NISO][LIMELM][10];

} iso;
