/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ion_trim raise or lower most extreme stages of ionization considered */
void ion_trim(
	/* element number on the C scale, 5 for C */
	long int nelem );

/*ion_zero zero out heating and charge transfer save arrays */
void ion_zero(long int nelem);

/*ion_collis fill in collisional ionization rates, and resulting cooling */
void ion_collis(
	/* element number on C scale, h is 0 */
	long nelem);

/*ion_solver solve the bi-diagonal matrix for ionization balance */
void ion_solver(long int nelem, 
  int lgPrintIt);

/*ion_photo fill array PhotoRate with photoionization rates for heavy elements */
void ion_photo(
	/* nlem is atomic number on C scale, 0 for H */
	long int nelem , 
	/* debugging flag to turn on print */
	int lgPrintIt );

/*ion_recomb generate recombination coefficients for any species */
void ion_recomb(int,double*,double*,double[],double[],double[],
	double[],double[],double[],long);

/*ion_recombAGN generate recombination coefficients for AGN table */
void ion_recombAGN( FILE * io );

/*Badnell_rec_init This code is written by Terry Yun, 2005 *
 * It reads rate coefficient fits into 3D arrays and output array.out for testing *
 * The testing can be commented out */
void Badnell_rec_init( void );

/*Badnell_DR_rate_eval This code is written by Terry Yun, 2005 *
 * It interpolates the rate coefficients in a given temperature.*
   It recieves ATOMIC_NUM_BIG, NELECTRONS values, temperature and returns the rate coefficient*
   It returns
        '-2': initial <= final
              init < 0 or init >302 or final < 0 or final > 302
        '-1': the transition is not defined
        '99': unknown invalid entries                         */ 
double Badnell_DR_rate_eval(
	/* atomic number on physics scale - He - 2 */
	int z_val, 
	/* number of core electrons before capture of free electron */
	int n_val );

double Badnell_RR_rate_eval(
	/* atomic number on physics scale - He - 2 */
	int z_val, 
	/* number of core electrons before capture of free electron */
	int n_val );

/* routines to do heavy element ionization balance */
void IonAlumi(void);
void IonArgon(void);
void IonBeryl(void);
void IonBoron(void);
void IonCalci(void);
void IonCarbo(void);
void IonChlor(void);
void IonChrom(void);
void IonCobal(void);
void IonCoppe(void);
void IonFluor(void);
void IonHelium(void);
void IonIron(void);
void IonLithi(void);
void IonMagne(void);
void IonManga(void);
void IonNeon(void);
void IonNicke(void);
void IonNitro(void);
void IonOxyge(void);
void IonPhosi(void);
void IonPotas(void);
void IonScand(void);
void IonSilic(void);
void IonSodiu(void);
void IonSulph(void);
void IonTitan(void);
void IonVanad(void);
void IonZinc(void);

/* max number of shells we ever have to deal with */
#define NSHELLS	7

/* struc defn for vars dealing with ionization balance */
EXTERN struct t_ionbal {

	/* flag saying not to decrement this range */
	int lgNoDec;

	/* limits for highest and lowest stages of ionization in ion_trim,
	 * these are set with command "set trim xx" where xx is log of upper
	 * and lower ionization fractions.  if only one number then both are
	 * set to it.  These variables are used in trimStages to adjust the
	 * range of ionization. */

	/* limit to fractional abundance of high stage of ionization,
	 * set to 1e-6 in zero.c */
	double trimhi, 

	/* limit to fractional abundance of low stage of ionization,
	 * set to 1e-10 in zero.c */
	  trimlo;

	/* option to turn off upward ionization trimming, with set trim upper off  */
	int lgTrimhiOn;

	/* ==============================================================
	 * all following deals with ionization processes */

	/* store photoionization rates for all shells of all elements
	 * first dim is nelem, the atomic number of element on the c scale, H is 0.
	 * second dim is stage of ionization, on the c scale, atom is 0.
	 * third dim is shell number, K shell is 0, valence shell depends on ion, up to 7
	 * last dim: 0 is photo rate (s-1)
	 *           1 is low energy heating
	 *           2 is high energy (secondary-capable) total heating
	 *           both will be nultiplied by ion abundance to get vol rates 
	 * some special last pairs - 
	 * [x][0][10][0] pair production in highen
	 */
	double ****PhotoRate_Shell/*[LIMELM][LIMELM][7][3]*/;

	/* set to 1 in zero, so have no effect, 
	 * set to 0 with 'no photoionization' command, 
	 * kills photoionization of everything */
	int lgPhotoIoniz_On;

	/* should H - O charge transfer be done in ionization or chemistry? 
	 * default is chemistry, TRUE */
	int lgHO_ct_chem;

	/* collisional ionization rate for CollidRate[nelem][ion][0], s-1
	* cooling, erg/s in CollidRate[nelem][ion][1] */
	double ***CollIonRate_Ground/*[LIMELM][LIMELM][2]*/;

	/* cosmic ray ionization rate */
	double CosRayIonRate;

	/* cosmic ray heating rate */
	double CosRayHeatRate;

	/* local heating rate due to some "extra" process */
	double ExtraHeatRate;

	/* heating due to fast neutrons */
	double xNeutronHeatRate;

	/* ionization and heating due to pair production */
	double PairProducPhotoRate[3];

	/* ==============================================================
	 * following deal with compton recoil ionization of bound electrons */
	/* flag saying that compton recoil ionization of bound
	 * electrons is enabled,
	 * set false with no recoil ionization command */
	int lgCompRecoil;

	/* the local heating due to compton recoil ionization */
	double CompRecoilHeatLocal;

	/* array indices for continuum offset of compton recoil ionization threshold */
	long int **ipCompRecoil;

	/* rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRate;

	/* save rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRateSave;

	/* heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRate;

	/* save heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRateSave;

	/* inner shell ionization rate due to Behar inner shell line absorption */
	double **xInnerShellIonize;

	/* this says whether to include inner shell absorption lines */
	int lgInnerShellLine_on;
	/* says whether to include the new Romas data set */
	int lgInnerShell_Romas;

	/* total ionization rate (s-1) all processes */
	double **RateIonizTot;

	/* number of valence electrons that can participate - multipies since electron rate */
	long int  nCompRecoilElec[LIMELM];

	double CompHeating_Max;
	/* ==============================================================
	 * end compton recoil ionization of bound electrons */

	/* ==============================================================
	 * all following deals with recombination */

	/* total recombination rate (s-1) all processes */
	double **RateRecomTot;

	/* rate coefficients [cm3 s-1] for Badnell DR recombination */
	double **RR_Badnell_rate_coef ,
		   **DR_Badnell_rate_coef,
		   *DR_Badnell_rate_coef_mean_ion;

	/* do these rate coefficients exist? */
	int **lgDR_Badnell_rate_coef_exist ,
		**lgRR_Badnell_rate_coef_exist;

	/* use the mean Badnell rates in place of existing hacks? */
	int lg_use_DR_Badnell_rate_coef_mean_ion;

	/* do we use new Badnell rates? */
	int lgDR_recom_Badnell_use,
		lgRR_recom_Badnell_use,
		/* option to print rates then exit */
		lgRecom_Badnell_print;

	/* rate coefficients [cm3 s-1] for older DR recombination */
	double **DR_old_rate_coef;

	/* radiative recombination rate coef (cm3 s-1) used by code */
	double **RR_rate_coef_used,
		   **DR_rate_coef_used;

	/* radiative recombination rate coef returned from Dima Verner's routine */
	double **RR_Verner_rate_coef;

	/* rate for recombination and ionization on grain surfaces */
	float **GrainCreat,
		**GrainDestr;

	int 
	 /*grecon usually TRUE, set to 0 with no grain neutralization command	 */
	  lgGrainIonRecom;

	/* suppresssion factors for dielectronic recombination
	 * 1 is burgess and 2 is storey */
	float DielSupprs[2][LIMELM];

	/* flag for guess of entire range of dr - false by default, true with kludge steve */
	float lg_guess_coef;
	/* log normal noise for guess, zero by default, turned on with noise option */
	float guess_noise;

	/* logical flag for suppression of dielectronic recombination
	 * 1 is burgess, 2 is nussbaumer and storey	 */
	int lgSupDie[2];

	/* this is fudge factor for scaled nussbamer and story diel recom
	 * set with diel kludge commmand, usually 1 */
	float GuessDiel[4];

	/* following all for 3-body recombination */
	/* lgNoCota flag set with no three body recombination */
	int lgNoCota;

	/* the actual rates */
	float CotaRate[LIMELM];

	/* these are error flags for three-body recombination */
	long int ilt, 
	  iltln, 
	  ilthn, 
	  ihthn, 
	  ifail;

	}	ionbal;


