/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*IonPotas compute ionization equilibrium for Potassium */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	20
#define	NELEM	19
#include "dense.h"
#include "ionbal.h"

void IonPotas(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double ditcrt[NDIM - 1]={6e3,2e4,4e4,5e4,7e4,8e4,8e4,3e4,
	  3e4,3e4,3e4,9e4,4e4,5e4,3e4,9e5,2e5,2e5,1e20};
	static double aa[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.};
	static double bb[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.};
	static double dd[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.};
	static double ff[NDIM - 1]={0.,0.1,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {3.28e-4,.0584,.122,.132,.133,.126,
		  .139,.0955,.0402,.0419,.0257,.0445,.0548,.0713,.0903,.110,
		  .0205,.549,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {.0907,.110,.0174,.132,.114,.162,
		  .0878,.263,.0627,.0616,2.77,2.23,2.00,1.82,.424,.243,.185,
		  .292,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {3.46e4,3.84e5,4.08e5,3.82e5,3.53e5,
		  3.19e5,3.22e5,2.47e5,2.29e5,3.73e6,9.26e5,7.96e5,6.90e5,
		  6.70e5,4.72e5,5.67e5,4.21e5,3.65e7,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {1.64e4,2.45e5,4.27e5,6.92e5,8.78e5,
		  7.43e5,6.99e5,4.43e5,2.81e5,5.84e6,4.89e6,4.62e6,4.52e6,
		  3.32e6,1.37e6,4.41e6,2.27e6,7.25e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonPotas()\n", debug_fp );
#	endif

	/* potassium nelem=19
	 * rec data from calcium
	 *
	 * rates from Shull and van Steenberg, Ap.J. Sup 48, 95. */

	/* rates from Shull and van Steenberg, Ap.J. Sup 48, 95. */
	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	/* potassium, atomic number 19 */
	if( !dense.lgElmtOn[NELEM-1] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonPotas()\n", debug_fp );
#		endif
		return;
	}

	ion_zero(NELEM-1);

	ion_photo(NELEM-1,FALSE);

	/* find collisional ionization rates */
	ion_collis(NELEM-1);

	/* get recombination coefficients */
	ion_recomb(FALSE,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1);

	/* >>chng 03 nov 02, rm pl and rec components, were old */
#	if 0
	/* correct low temp rad rec coef */
	if( phycon.te < 1e3 )
	{
		ionbal.RateRecomTot[NELEM-1][1] += ((5.49e-10*(pow(phycon.te,-0.647f)) - 
		  rec[1]*(pow((double)phycon.te,pl[1])))*dense.eden);
	}
#	endif

	/* solve for ionization balance */
	ion_solver(NELEM-1,FALSE);

#	ifdef DEBUG_FUN
	fputs( " <->IonPotas()\n", debug_fp );
#	endif
	return;
}

