/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*IonChlor ionization balance for chlorine */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	18
#define	NELEM	17
#include "dense.h"
#include "atmdat.h"
#include "ionbal.h"

void IonChlor(void)
{
	long int i, 
	  _r;
	double ct_save;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double ditcrt[NDIM - 1]={3.0e4,2.5e4,2.5e4,1.8e4,1.8e4,2.2e4,
	  5.0e5,1.6e5,1.5e5,1.5e5,1.3e5,1.3e5,1.1e5,7.6e4,6.5e6,1.4e7,
	  1e20};
	static double aa[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.};
	static double bb[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.};
	static double dd[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.};
	static double ff[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {5.5e-5,1.0e-2,1.1e-2,1.0e-2,5.0e-2,
		  3.2e-2,3.4e-2,1.6e-2,2.4e-2,4.0e-2,4.0e-2,3.8e-2,6.8e-2,
		  2.6e-2,4.6e-1,11.,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {1.3e5,1.4e5,1.4e5,1.4e5,2.0e5,1.8e5,
		  2.3e5,7.2e5,6.4e5,6.0e5,4.9e5,4.6e5,5.3e5,3.2e5,2.6e7,2.8e7,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp3[_r++];
			}
		}
		for( i=1; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = 0.;
			}
		for( i=1; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = 0.;
			}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonChlor()\n", debug_fp );
#	endif

	/* chlorine ipCHLORINE=17
	 *
	 * rates from Shull and van Steenberg, Ap.J. Sup 48, 95.
	 * these are for argon, but no better can be done today */

	/* fits to Aldrovandi and Pequignot Rev Bras Fisica 4, 491 */

	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	/* clorine, atomic number 17 */
	if( !dense.lgElmtOn[16] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonChlor()\n", debug_fp );
#		endif
		return;
	}

	ion_zero(NELEM-1);

	ion_photo(NELEM-1,FALSE);

	/* find collisional ionization rates */
	ion_collis(NELEM-1);

	/* save the CT recom rate for H only */
	ct_save = atmdat.HCharExcRecTo[ipCHLORINE][0];

	/* >>chng 05 mar 23 add process Cl+ + H2 -> Cl0 + several molecules 
	 * rate is rate for first step with H2 from UMIST
	atmdat.HCharExcRecTo[ipCHLORINE][0] += 
		1e-9 * hmi.H2_total / SDIV(iso.Pop2Ion[ipH_LIKE][ipHYDROGEN][ipH1s]*dense.xIonDense[ipHYDROGEN][1]); */

	/* get recombination coefficients */
	ion_recomb(FALSE,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1);

	/* solve for ionization balance */
	ion_solver(NELEM-1,FALSE);
	
	/* reset the rate */
	atmdat.HCharExcRecTo[ipCHLORINE][0] = ct_save;

#	ifdef DEBUG_FUN
	fputs( " <->IonChlor()\n", debug_fp );
#	endif
	return;
}

