/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/****************************************************************************
 *                                                                          *
 * hydrogenic.h -                                                           *
 * this file contains the variables for the model hydrogen ions,            *
 * and prototypes for the series of routines that drive the atom            *
 * the EXTERN structure hydro is defined here -                             *
 * all H variables should migrate here                                      *
 *                                                                          *
 * the hydrogenic lines, EmisLines[ipH_LIKE] are in taulines.h                       *
 *                                                                          *
 ****************************************************************************/

/* the routine that calls the hydrogenic routines */
void Hydrogenic(void);

/*HydroLevel solve for ionization balance level populations of model hydrogen atom */
void HydroLevel(long int ipZ);

/*HydroLevelPop solve for departure coefs in hydrogen ionization balance */
void HydroLevelPop(long int nelem );

/*HydroCollid evaluate collision rate for model hydrogen atom */
void HydroCollid(long int ipZ);

/*HydroT2Low called to do hydrogenic level populations when temp too low for matrix */
void HydroT2Low(long int nelem );

/*HydroRecCool hydrogen recombination cooling */
double HydroRecCool(long int n, long int ipZ);

/* returns the ratio of recombination cooling to recombination coefficient */
double HCoolRatio( 
	/* the scaled temperature, T * n^2 / Z^2, n is prin quant number, Z is charge, 1 for H */
	double t );

/*HydroBranch compute branching ratios for Jason's model hydrogen atom */
double HydroBranch(long int ihigh, 
  long int ilow, 
  long int iz);

/*HydroRecom photoionization, recombination, radiative rates for model hydrogen atom */
void HydroRecom(long int ipZ);

/* HydroRenorm - renormalize H so that it agrees with the chemistry */
void HydroRenorm( void );

/* all of these are initialized in zero */
EXTERN struct t_hydro {

	/* flag to say (true) to produce emissivity for hydrogenic species,
	 * rather than intensity (the default).  Set with 
	 * hydrogen emissivity commmand.  default is false */
	int lgHydEmiss;

	/* flag saying whether H atom is photo=false or collis ionized=true */
	int lgHColionImp;

	/* lgHiPop2 flag set if H n=2 population gets large relative to ground
	 * pop2mx is maximum population of n=2 relative to ground */
	int lgHiPop2;
	float pop2mx;

	/* Flag saying to reeval recom, because continuum lowering may otherwise leave
	 * us with zero'd levels. */
	int lgReevalRecom;

	/* arrays for stark broadening in Puetter formalism */
	float **strkar/*strkar[LMHLVL+1][LMHLVL+1]*/;
	double **pestrk/*pestrk[LMHLVL+1][LMHLVL+1]*/;

	/* dstfe2lya is destruction probability for Lya onto FeII,
	 * net deexcitation of Lya but not ots destruction */
	float dstfe2lya;

	/* width of Lya */
	float HLineWidth;

	/* TexcLya is the excitation temperature of Lya */
	float TexcLya;

	/* nLyaHot is counts how ofter Lya hotter than gas */
	long int nLyaHot;

	/* TLyaMax is hottest */
	float TLyaMax, 
	/* TeLyaMax is electron temp at point where Lya max  */
	  TeLyaMax;

	/* nZTLaMax is the zone where this happened */
	long int nZTLaMax;

	/* flag saying that Lya mased */
	int lgHLyaMased;

	/* smallest Lya optical depth that occured in the calculation */
	float xLaMase;

	/* chHTopType is the method.used to top off the H atom */
	char chHTopType[5];

	/* relative importance of photo ioniz from n=2 of H */
	float H_ion_frac_photo;

	/* largest fraction of ground state H destruction due to collisional ionization */
	float HCollIonMax;

	/* fraction of H ionizations due to ground collisions */
	float H_ion_frac_collis;

	/* array of lifetimes for HI levels, not including Lyman lines
	 * lifetime for principal quantum numbers
	 * [0] and [1] are set to -1e37, no defined,
	 * [2] is lya 
	 *
	 * this is used for full H iso sequence, so
	 * must be defined up through most number of levels
	 * needed for any atom on this sequence
	 */
	double HyLife[NHYDRO_MAX_LEVEL];

	/* cintot is total induced cooling over model */
	double cintot;

	/* lgHInducImp says whether or not induced recombination is important*/
	int lgHInducImp;

	/* this is the D/H ratio, set with SET D/H command */
	double D2H_ratio;

	/* usually 1, set to 0 with hydrogen damping off command, scales rayleigh scat */
	float DampOnFac;

	/* remember induced fractions for hydrogen  */
	float FracInd;
	long int ndclev;
	float fbul;
	long int nbul;

	/* is continuum pumping of H lyman lines included?  yes, but turned off
	 * with atom h-like lyman pumping off command */
	int lgLymanPumping;

	/* multiplicative scale factor for HI lyman line pump rate, takes into account
	 * possible emission lines - NB test against equal to 1.f in rt_lines_all to
	 * see if it has been set */
	float xLymanPumpingScaleFactor;

	} hydro;
