/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*hydro_vs_deexcit compute collision strength for collisional deexcitation for hydrogen atom, 
 * from Vriens and Smeets */
double hydro_vs_deexcit( long int ipISO,
						 long int nelem,
						 long int ipHi,
						 long int ipLo );

/*hydro_vs_excit compute collision rate for collisional excitation for hydrogen atom, 
 * from Vriens and Smeets */
double hydro_vs_excit( long int ipISO,
					   long int nelem,
					   long int ipHi,
					   long int ipLo );

double CS_VS80( long int ipISO,
			   long int nelem,
			   long int ipHi,
			   long int ipLo,
			   double temp,
			   long int Collider );

/*hydro_vs_ioniz generate hydrogenic collisional ionization rate coefficients 
 * for quantum number n */
double hydro_vs_ioniz( long int ipISO, long int nelem, long int level );


/*Hion_coll_ioniz_ratecoef calculate hydrogenic ionization rates for all n, and Z*/
double Hion_coll_ioniz_ratecoef(
		/* the isoelectronic sequence */
		long int ipISO ,
		/* element, >=1 since only used for ions 
		 * nelem = 1 is helium the least possible charge */
		long int nelem,
		/* principal quantum number, > 1
		 * since only used for excited states */
		/* >>chng 19 dec 02 made this index rather than n...so that Boltzmann factor 
		   and energy are easily retrieved.	*/
		long int level);

/*Hion_colldeexc_cs collision strength for collisional de-excitation for any levels of hydrogenic Z*/
double Hion_colldeexc_cs(long int ipHi, 
  long int ipLo, 
  long int nelem,
  long int ipISO );
