/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
#define ipELECTRON	0
#define ipPROTON	1
#define ipHE_PLUS	2

/* evaluate collisional rates */
void HeCollid( long int nelem);

/*HeCSInterp interpolate on He1 collision strengths */
float HeCSInterp( long int nelem,
				 long int ipHi,
				 long int ipLo,
				 long int Collider );

/*AtomCSInterp do the atom	*/
float AtomCSInterp( long int nelem,
				   long int ipHi,
				   long int ipLo,
				   float *factor,
				   const char **where,
				   long int Collider );

/*IonCSInterp do the ions	*/
float IonCSInterp( long int nelem,
				  long int ipHi,
				  long int ipLo,
				  float *factor,
				  const char **where,
				  long int Collider );

/* Three different collision treatments, based on
 * Seaton 1962;
 * Pengelly and Seaton 1964; and
 * Vrinceanu and Flannery 2001.
 */

/*CS_l_mixing - find rate for l-mixing collisions by protons, for neutrals */
double CS_l_mixing_S62(
	long int ipISO,
	long int nelem,
	long int ipLo,
	long int ipHi,
	double temp,
	long int Collider );

double CS_l_mixing_PS64(
	long int nelem /* the chemical element, 1 for He */,
	long int ipLo /* lower level, 0 for ground */,
	long int ipHi /* upper level, 0 for ground */,
	long int Collider );

double CS_l_mixing_VF01( 
	long int nelem,
	long int n,
	long int l,
	long int lp,
	long int s,
	double temp,
	long int Collider );

