/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CoolZero set cooling and heating stack to zero */
void CoolZero(void);

/*CoolAdd add coolants to the cooling stack, called in evaluation of cooling function */
void CoolAdd(
  const char *chLabel, 
  float xlambda, 
  double cool);

/*CoolSum  total cooling from all entries into cooling stack */
void CoolSum(double *total);

/*CoolEvaluate main routine to call others, to evaluate total cooling */
void CoolEvaluate(double *tot);

/*coolpr stores coolants before block printed, when printing cooling agents */
void coolpr(
	FILE *io,
	/* the label for the coolant */
	const char *chLabel ,
	/* the wavelength */
	float lambda, 
	/* the ratio of this coolant, to total cooling, may be negative */
	double ratio, 
	/* which job, either ZERO, DOIT, or DONE */
	const char *chJOB );

/*HeatSum evaluate all heating agents to determine total heating for this zone,
 * called at end of ionize */
void HeatSum(void);

/*HeatZero zeroes out the heating array, called at start of ionize*/
void HeatZero(void);

/* cooling functions for the heavy elements */
void CoolAlum(void);
void CoolArgo(void);
void CoolCalc(void);
void CoolCarb(void);
void CoolChlo(void);
void CoolChro(void);
void CoolCoba(void);
void CoolDima(void);
void CoolFluo(void);
void CoolIron(void);
void CoolMagn(void);
void CoolMang(void);
void CoolNeon(void);
void CoolNick(void);
void CoolNitr(void);
void CoolOxyg(void);
void CoolPhos(void);
void CoolPota(void);
void CoolScan(void);
void CoolSili(void);
void CoolSodi(void);
void CoolSulf(void);
void CoolTita(void);
void CoolVana(void);
void CoolZinc(void);
