/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*atmdat_phfit derive photoionization cross sectoins for first 30 elements */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable bogus const const double to float warning in MS VS*/
#endif
#include "cddefines.h"
#include "atmdat.h"
static void blkdata10(void);
static void blkdata10a(void);
static void blkdata10b(void);
static void blkdata10c(void);
static void blkdata10d(void);
static void blkdata10e(void);
static void blkdata10f(void);
static void blkdata10g(void);
static void blkdata10h(void);
static void blkdata10i(void);
static void blkdata10j(void);
static void blkdata10k(void);
static void blkdata10l(void);
static void blkdata10n(void);
static void blkdata10m(void);
static void blkdata10o(void);
static void blkdata10p(void);
static void blkdata10q(void);
static void blkdata10v(void);
static void blkdata10w(void);
static void blkdata10x(void);

struct t_ADfAL {
	long int L[7];
	}	ADfAL;
struct t_ADfANINN {
	long int NINN[30];
	}	ADfANINN;
struct t_ADfANTOT {
	long int NTOT[30];
	}	ADfANTOT;
/*struct t_PH1COM {
	float PH1[7][30][30][6];
	}	PH1COM;*/
struct t_ADfAPH2 {
	float PH2[30][30][7];
	}	ADfAPH2;

double atmdat_phfit(long int nz, 
	  long int ne, 
	  long int is, 
	  double e, 
	  int lghs)
{
	long int nint, 
	  nout;
	double a, 
	  b, 
	  crs, 
	  einn, 
	  p1, 
	  q, 
	  x, 
	  y, 
	  z;
	static int lgInit=FALSE;

#	ifdef DEBUG_FUN
	fputs( "<+>atmdat_phfit()\n", debug_fp );
#	endif
	/*** Version 3. October 8, 1996.
	 *** Written by D. A. Verner, verner@pa.uky.edu
	 *** Inner-shell ionization energies of some low-ionized species are slightly
	 *** improved to fit smoothly the experimental inner-shell ionization energies 
	 *** of neutral atoms.
	 *** New logical argument lghs
	 ******************************************************************************
	 *** This subroutine calculates partial photoionization cross sections
	 *** for all ionization stages of all atoms from H to Zn (Z=30) by use of
	 *** the following fit parameters:
	 *** Outer shells of the Opacity Project (OP) elements:
	 *** >>refer	all	photocs	Verner, Ferland, Korista, Yakovlev, 1996, ApJ, in press.
	 *** Inner shells of all elements, and outer shells of the non-OP elements:
	 ***  Verner and Yakovlev, 1995, A&AS, 109, 125
	 *** Input parameters:  nz - atomic number from 1 to 30 (integer) 
	 ***          ne - number of electrons from 1 to iz (integer)
	 ***          is - shell number (integer)
	 ***          e - photon energy, eV 
	 ***          lghs - logical, "FALSE" (default) calculates 
	 ***                 new cross sections, "TRUE" calculates
	 ***                 only old Hartree-Slater cross sections
	 *** Output parameter:  s - photoionization cross section, Mb
	 *** Shell numbers:
	 *** 1 - 1s, 2 - 2s, 3 - 2p, 4 - 3s, 5 - 3p, 6 - 3d, 7 - 4s. 
	 *** If a species in the ground state has no electrons on the given shell,
	 *** the subroutine returns s=0.
	 ****************************************************************************** */

	/* has the translatted block data been called yet? */
	if( !lgInit )
	{
		lgInit = TRUE;
		blkdata10();
		blkdata10a();
		blkdata10b();
		blkdata10c();
		blkdata10d();
		blkdata10e();
		blkdata10f();
		blkdata10g();
		blkdata10h();
		blkdata10i();
		blkdata10j();
		blkdata10k();
		blkdata10l();
		blkdata10m();
		blkdata10n();
		blkdata10o();
		blkdata10p();
		blkdata10q();
		blkdata10v();
		blkdata10w();
		blkdata10x();
	}

	crs = 0.0;
	if( nz < 1 || nz > 30 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->atmdat_phfit()\n", debug_fp );
#		endif
		return(crs);
	}

	if( ne < 1 || ne > nz )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->atmdat_phfit()\n", debug_fp );
#		endif
		return(crs);
	}

	nout = ADfANTOT.NTOT[ne-1];
	if( nz == ne && nz > 18 )
		nout = 7;
	if( nz == (ne + 1) && ((((nz == 20 || nz == 21) || nz == 22) || 
	  nz == 25) || nz == 26) )
		nout = 7;
	if( is > nout )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->atmdat_phfit()\n", debug_fp );
#		endif
		return(crs);
	}

	if( (is == 6 && (nz == 20 || nz == 19)) && ne >= 19 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->atmdat_phfit()\n", debug_fp );
#		endif
		return(crs);
	}

	if( e < PH1COM.PH1[is-1][ne-1][nz-1][0] )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->atmdat_phfit()\n", debug_fp );
#		endif
		return(crs);
	}

	nint = ADfANINN.NINN[ne-1];
	if( ((nz == 15 || nz == 17) || nz == 19) || (nz > 20 && nz != 26) )
	{
		einn = 0.0;
	}
	else
	{
		if( ne < 3 )
		{
			einn = 1.0e30;
		}
		else
		{
			einn = PH1COM.PH1[nint-1][ne-1][nz-1][0];
		}
	}

	if( (is <= nint || e >= einn) || lghs )
	{
		p1 = -PH1COM.PH1[is-1][ne-1][nz-1][4];
		y = e/PH1COM.PH1[is-1][ne-1][nz-1][1];
		q = -0.5*p1 - ADfAL.L[is-1] - 5.5;
		a = PH1COM.PH1[is-1][ne-1][nz-1][2]*(POW2(y - 1.0) + 
			POW2(PH1COM.PH1[is-1][ne-1][nz-1][5]));
		b = sqrt(y/PH1COM.PH1[is-1][ne-1][nz-1][3]) + 1.0;
		crs = a*pow(y,q)*pow(b,p1);
	}
	else
	{
		if( (is < nout && is > nint) && e < einn )
		{ 
#			ifdef DEBUG_FUN
			fputs( " <->atmdat_phfit()\n", debug_fp );
#			endif
			return(crs);
		}
		p1 = -ADfAPH2.PH2[ne-1][nz-1][3];
		q = -0.5*p1 - 5.5;
		x = e/ADfAPH2.PH2[ne-1][nz-1][0] - ADfAPH2.PH2[ne-1][nz-1][5];
		z = sqrt(x*x+POW2(ADfAPH2.PH2[ne-1][nz-1][6]));
		a = ADfAPH2.PH2[ne-1][nz-1][1]*(POW2(x - 1.0) + 
			POW2(ADfAPH2.PH2[ne-1][nz-1][4]));
		b = 1.0 + sqrt(z/ADfAPH2.PH2[ne-1][nz-1][2]);
		crs = a*pow(z,q)*pow(b,p1);
	}
	
#	ifdef DEBUG_FUN
	fputs( " <->atmdat_phfit()\n", debug_fp );
#	endif
	return(crs);
}

/******************************************************************** */
static void blkdata10(void)
{
	int j;
	{ static long _itmp0[] = {0,0,1,0,1,2,0};
	for( j=0; j < 7; j++ )
	{
		ADfAL.L[j] = _itmp0[j];
		}
	}
	{ static long _itmp1[] = {0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,3,
	  3,3,5,5,5,5,5,5,5,5,5,5,5,5};
	for( j=0; j < 30; j++ )
	{
		ADfANINN.NINN[j] = _itmp1[j];
		}
	}
	{ static long _itmp2[] = {1,1,2,2,3,3,3,3,3,3,4,4,5,5,5,5,
	  5,5,6,6,6,6,6,6,6,6,6,6,7,7};
	for( j=0; j < 30; j++ )
	{
		ADfANTOT.NTOT[j] = _itmp2[j];
		}
	}
	{ static float _itmp3[] = {1.360e01,4.298e-01,5.475e04,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][0][j] = _itmp3[j];
		}
	}
	{ static float _itmp4[] = {5.442e01,1.720e00,1.369e04,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][1][j] = _itmp4[j];
		}
	}
	{ static float _itmp5[] = {2.459e01,5.996e00,4.470e03,2.199e00,
	  6.098e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][1][j] = _itmp5[j];
		}
	}
	{ static float _itmp6[] = {1.225e02,3.871e00,6.083e03,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][2][j] = _itmp6[j];
		}
	}
	{ static float _itmp7[] = {7.564e01,2.006e01,3.201e02,7.391e00,
	  2.916e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][2][j] = _itmp7[j];
		}
	}
	{ static float _itmp8[] = {6.439e01,2.740e01,1.564e02,3.382e01,
	  1.490e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][2][j] = _itmp8[j];
		}
	}
	{ static float _itmp9[] = {5.392e00,3.466e00,4.774e01,2.035e01,
	  4.423e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][2][j] = _itmp9[j];
		}
	}
	{ static float _itmp10[] = {2.177e02,6.879e00,3.422e03,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][3][j] = _itmp10[j];
		}
	}
	{ static float _itmp11[] = {1.539e02,1.760e01,5.458e02,1.719e01,
	  3.157e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][3][j] = _itmp11[j];
		}
	}
	{ static float _itmp12[] = {1.299e02,4.759e01,9.796e01,1.166e03,
	  1.022e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][3][j] = _itmp12[j];
		}
	}
	{ static float _itmp13[] = {1.821e01,6.685e00,4.904e01,3.419e01,
	  3.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][3][j] = _itmp13[j];
		}
	}
	{ static float _itmp14[] = {1.193e02,4.093e01,1.306e02,1.212e02,
	  1.348e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][3][j] = _itmp14[j];
		}
	}
	{ static float _itmp15[] = {9.323e00,3.427e00,1.423e03,2.708e00,
	  1.064e01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][3][j] = _itmp15[j];
		}
	}
	{ static float _itmp16[] = {3.402e02,1.075e01,2.190e03,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][4][j] = _itmp16[j];
		}
	}
	{ static float _itmp17[] = {2.594e02,3.336e01,2.846e02,2.163e01,
	  2.624e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][4][j] = _itmp17[j];
		}
	}
	{ static float _itmp18[] = {2.274e02,6.592e01,8.605e01,1.906e02,
	  1.210e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][4][j] = _itmp18[j];
		}
	}
	{ static float _itmp19[] = {3.793e01,1.054e01,4.273e01,4.433e01,
	  3.501e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][4][j] = _itmp19[j];
		}
	}
	{ static float _itmp20[] = {2.098e02,5.984e01,1.037e02,7.915e01,
	  1.436e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][4][j] = _itmp20[j];
		}
	}
	{ static float _itmp21[] = {2.516e01,2.403e00,1.530e02,9.203e00,
	  9.374e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][4][j] = _itmp21[j];
		}
	}
	{ static float _itmp22[] = {1.940e02,6.155e01,9.698e01,7.354e01,
	  1.438e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][4][j] = _itmp22[j];
		}
	}
	{ static float _itmp23[] = {1.405e01,6.495e00,1.525e04,1.352e00,
	  1.218e01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][4][j] = _itmp23[j];
		}
	}
	{ static float _itmp24[] = {8.298e00,6.658e00,3.643e02,9.500e00,
	  5.469e00,5.608e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][4][j] = _itmp24[j];
		}
	}
	{ static float _itmp25[] = {4.900e02,1.548e01,1.521e03,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][5][j] = _itmp25[j];
		}
	}
	{ static float _itmp26[] = {3.921e02,4.624e01,2.344e02,2.183e01,
	  2.581e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][5][j] = _itmp26[j];
		}
	}
	{ static float _itmp27[] = {3.522e02,8.412e01,8.111e01,7.459e01,
	  1.428e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][5][j] = _itmp27[j];
		}
	}
	{ static float _itmp28[] = {6.449e01,7.843e00,7.109e01,2.828e01,
	  4.754e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][5][j] = _itmp28[j];
		}
	}
	{ static float _itmp29[] = {3.289e02,8.370e01,8.067e01,7.471e01,
	  1.442e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][5][j] = _itmp29[j];
		}
	}
	{ static float _itmp30[] = {4.789e01,3.942e00,1.219e02,1.499e01,
	  7.489e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][5][j] = _itmp30[j];
		}
	}
	{ static float _itmp31[] = {3.076e02,9.113e01,6.649e01,9.609e01,
	  1.338e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][5][j] = _itmp31[j];
		}
	}
	{ static float _itmp32[] = {3.047e01,2.991e00,1.184e03,3.085e00,
	  1.480e01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][5][j] = _itmp32[j];
		}
	}
	{ static float _itmp33[] = {2.438e01,1.094e01,1.792e02,3.308e01,
	  4.150e00,5.276e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][5][j] = _itmp33[j];
		}
	}
	{ static float _itmp34[] = {2.910e02,8.655e01,7.421e01,5.498e01,
	  1.503e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][5][j] = _itmp34[j];
		}
	}
}
static void blkdata10a(void)
{
	int j;
	{ static float _itmp35[] = {1.939e01,1.026e01,4.564e03,1.568e00,
	  1.085e01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][5][j] = _itmp35[j];
		}
	}
	{ static float _itmp36[] = {1.126e01,9.435e00,1.152e03,5.687e00,
	  6.336e00,4.474e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][5][j] = _itmp36[j];
		}
	}
	{ static float _itmp37[] = {6.671e02,2.108e01,1.117e03,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][6][j] = _itmp37[j];
		}
	}
	{ static float _itmp38[] = {5.521e02,6.943e01,1.519e02,2.627e01,
	  2.315e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][6][j] = _itmp38[j];
		}
	}
	{ static float _itmp39[] = {5.043e02,1.060e02,7.304e01,5.547e01,
	  1.538e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][6][j] = _itmp39[j];
		}
	}
	{ static float _itmp40[] = {9.789e01,1.862e01,3.447e01,4.231e01,
	  3.606e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][6][j] = _itmp40[j];
		}
	}
	{ static float _itmp41[] = {4.753e02,1.070e02,7.046e01,5.342e01,
	  1.552e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][6][j] = _itmp41[j];
		}
	}
	{ static float _itmp42[] = {7.747e01,6.225e00,1.110e02,1.733e01,
	  6.719e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][6][j] = _itmp42[j];
		}
	}
	{ static float _itmp43[] = {4.473e02,1.220e02,5.235e01,9.428e01,
	  1.335e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][6][j] = _itmp43[j];
		}
	}
	{ static float _itmp44[] = {5.545e01,5.853e00,1.908e02,6.264e00,
	  9.711e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][6][j] = _itmp44[j];
		}
	}
	{ static float _itmp45[] = {4.745e01,1.925e01,9.400e01,1.152e02,
	  3.194e00,5.496e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][6][j] = _itmp45[j];
		}
	}
	{ static float _itmp46[] = {4.236e02,1.242e02,5.002e01,9.100e01,
	  1.335e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][6][j] = _itmp46[j];
		}
	}
	{ static float _itmp47[] = {3.796e01,1.094e01,7.483e02,2.793e00,
	  9.956e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][6][j] = _itmp47[j];
		}
	}
	{ static float _itmp48[] = {2.960e01,1.827e01,1.724e02,8.893e01,
	  3.348e00,4.209e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][6][j] = _itmp48[j];
		}
	}
	{ static float _itmp49[] = {4.048e02,1.270e02,4.748e01,1.380e02,
	  1.252e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][6][j] = _itmp49[j];
		}
	}
	{ static float _itmp50[] = {2.541e01,1.482e01,7.722e02,2.306e00,
	  9.139e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][6][j] = _itmp50[j];
		}
	}
	{ static float _itmp51[] = {1.453e01,1.164e01,1.029e04,2.361e00,
	  8.821e00,4.239e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][6][j] = _itmp51[j];
		}
	}
	{ static float _itmp52[] = {8.714e02,2.754e01,8.554e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][7][j] = _itmp52[j];
		}
	}
	{ static float _itmp53[] = {7.393e02,8.709e01,1.329e02,2.535e01,
	  2.336e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][7][j] = _itmp53[j];
		}
	}
	{ static float _itmp54[] = {6.837e02,1.354e02,6.029e01,5.682e01,
	  1.533e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][7][j] = _itmp54[j];
		}
	}
	{ static float _itmp55[] = {1.381e02,9.141e00,6.896e01,3.896e01,
	  4.943e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][7][j] = _itmp55[j];
		}
	}
	{ static float _itmp56[] = {6.491e02,1.377e02,5.735e01,5.486e01,
	  1.540e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][7][j] = _itmp56[j];
		}
	}
	{ static float _itmp57[] = {1.139e02,8.467e00,9.641e01,2.287e01,
	  6.061e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][7][j] = _itmp57[j];
		}
	}
	{ static float _itmp58[] = {6.144e02,1.593e02,4.123e01,1.141e02,
	  1.287e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][7][j] = _itmp58[j];
		}
	}
	{ static float _itmp59[] = {8.737e01,7.942e00,1.063e02,9.708e00,
	  8.183e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][7][j] = _itmp59[j];
		}
	}
	{ static float _itmp60[] = {7.741e01,1.937e01,1.619e02,7.312e01,
	  3.648e00,3.760e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][7][j] = _itmp60[j];
		}
	}
	{ static float _itmp61[] = {5.840e02,1.620e02,3.939e01,1.104e02,
	  1.289e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][7][j] = _itmp61[j];
		}
	}
	{ static float _itmp62[] = {6.551e01,1.594e01,1.217e02,6.156e00,
	  7.271e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][7][j] = _itmp62[j];
		}
	}
	{ static float _itmp63[] = {5.494e01,2.067e01,2.318e02,7.136e01,
	  3.618e00,5.538e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][7][j] = _itmp63[j];
		}
	}
	{ static float _itmp64[] = {5.581e02,1.690e02,3.584e01,1.894e02,
	  1.185e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][7][j] = _itmp64[j];
		}
	}
	{ static float _itmp65[] = {4.599e01,1.759e01,1.962e02,4.020e00,
	  7.999e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][7][j] = _itmp65[j];
		}
	}
	{ static float _itmp66[] = {3.512e01,1.745e01,5.186e02,1.728e01,
	  4.995e00,2.182e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][7][j] = _itmp66[j];
		}
	}
	{ static float _itmp67[] = {5.380e02,1.774e02,3.237e01,3.812e02,
	  1.083e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][7][j] = _itmp67[j];
		}
	}
	{ static float _itmp68[] = {2.848e01,1.994e01,2.415e02,3.241e00,
	  8.037e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][7][j] = _itmp68[j];
		}
	}
	{ static float _itmp69[] = {1.362e01,1.391e01,1.220e05,1.364e00,
	  1.140e01,4.103e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][7][j] = _itmp69[j];
		}
	}
	{ static float _itmp70[] = {1.103e03,3.485e01,6.759e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][8][j] = _itmp70[j];
		}
	}
	{ static float _itmp71[] = {9.539e02,1.131e02,1.039e02,2.657e01,
	  2.255e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][8][j] = _itmp71[j];
		}
	}
	{ static float _itmp72[] = {8.905e02,1.711e02,4.890e01,6.137e01,
	  1.501e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][8][j] = _itmp72[j];
		}
	}
	{ static float _itmp73[] = {1.852e02,6.423e00,8.497e01,6.075e01,
	  5.214e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][8][j] = _itmp73[j];
		}
	}
	{ static float _itmp74[] = {8.502e02,1.737e02,4.668e01,5.876e01,
	  1.511e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][8][j] = _itmp74[j];
		}
	}
	{ static float _itmp75[] = {1.572e02,1.146e01,8.453e01,2.457e01,
	  5.771e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][8][j] = _itmp75[j];
		}
	}
	{ static float _itmp76[] = {8.091e02,1.925e02,3.680e01,7.933e01,
	  1.377e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][8][j] = _itmp76[j];
		}
	}
	{ static float _itmp77[] = {1.262e02,1.889e01,7.149e01,1.194e01,
	  6.030e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][8][j] = _itmp77[j];
		}
	}
	{ static float _itmp78[] = {1.142e02,2.528e01,1.419e02,7.089e01,
	  3.628e00,3.418e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][8][j] = _itmp78[j];
		}
	}
	{ static float _itmp79[] = {7.709e02,1.603e02,5.302e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][8][j] = _itmp79[j];
		}
	}
	{ static float _itmp80[] = {9.957e01,2.629e01,3.563e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][8][j] = _itmp80[j];
		}
	}
	{ static float _itmp81[] = {8.714e01,2.292e01,3.005e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][8][j] = _itmp81[j];
		}
	}
	{ static float _itmp82[] = {7.392e02,2.055e02,3.144e01,1.230e02,
	  1.263e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][8][j] = _itmp82[j];
		}
	}
	{ static float _itmp83[] = {7.610e01,2.307e01,7.140e01,7.282e00,
	  6.543e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][8][j] = _itmp83[j];
		}
	}
	{ static float _itmp84[] = {6.271e01,2.744e01,2.458e02,7.329e01,
	  3.596e00,1.390e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][8][j] = _itmp84[j];
		}
	}
	{ static float _itmp85[] = {7.122e02,1.660e02,4.798e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][8][j] = _itmp85[j];
		}
	}
	{ static float _itmp86[] = {5.459e01,2.882e01,2.439e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][8][j] = _itmp86[j];
		}
	}
	{ static float _itmp87[] = {3.497e01,2.658e01,2.649e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][8][j] = _itmp87[j];
		}
	}
	{ static float _itmp88[] = {6.940e02,2.390e02,2.295e01,1.257e03,
	  9.638e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][8][j] = _itmp88[j];
		}
	}
}
static void blkdata10b(void)
{
	int j;
	{ static float _itmp89[] = {3.786e01,2.568e01,1.097e02,4.297e00,
	  7.303e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][8][j] = _itmp89[j];
		}
	}
	{ static float _itmp90[] = {1.742e01,1.658e01,2.775e05,1.242e00,
	  1.249e01,3.857e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][8][j] = _itmp90[j];
		}
	}
	{ static float _itmp91[] = {1.362e03,4.304e01,5.475e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][9][j] = _itmp91[j];
		}
	}
	{ static float _itmp92[] = {1.196e03,1.586e02,6.695e01,3.352e01,
	  2.002e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][9][j] = _itmp92[j];
		}
	}
	{ static float _itmp93[] = {1.125e03,2.193e02,3.719e01,8.181e01,
	  1.396e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][9][j] = _itmp93[j];
		}
	}
	{ static float _itmp94[] = {2.391e02,2.859e01,2.897e01,3.836e01,
	  3.992e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][9][j] = _itmp94[j];
		}
	}
	{ static float _itmp95[] = {1.078e03,1.886e02,5.011e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][9][j] = _itmp95[j];
		}
	}
	{ static float _itmp96[] = {2.073e02,2.822e01,4.978e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][9][j] = _itmp96[j];
		}
	}
	{ static float _itmp97[] = {1.031e03,2.308e02,3.232e01,7.167e01,
	  1.411e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][9][j] = _itmp97[j];
		}
	}
	{ static float _itmp98[] = {1.719e02,2.496e01,5.575e01,1.427e01,
	  5.562e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][9][j] = _itmp98[j];
		}
	}
	{ static float _itmp99[] = {1.579e02,2.740e01,1.717e02,6.423e01,
	  3.819e00,1.680e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][9][j] = _itmp99[j];
		}
	}
	{ static float _itmp100[] = {9.873e02,2.343e02,3.097e01,6.907e01,
	  1.416e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][9][j] = _itmp100[j];
		}
	}
	{ static float _itmp101[] = {1.415e02,2.615e01,5.421e01,1.117e01,
	  5.907e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][9][j] = _itmp101[j];
		}
	}
	{ static float _itmp102[] = {1.262e02,3.316e01,1.962e02,7.397e01,
	  3.563e00,2.895e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][9][j] = _itmp102[j];
		}
	}
	{ static float _itmp103[] = {9.480e02,2.360e02,3.027e01,6.734e01,
	  1.422e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][9][j] = _itmp103[j];
		}
	}
	{ static float _itmp104[] = {1.132e02,3.092e01,4.190e01,1.139e01,
	  5.554e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][9][j] = _itmp104[j];
		}
	}
	{ static float _itmp105[] = {9.712e01,3.494e01,2.214e02,7.203e01,
	  3.563e00,2.573e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][9][j] = _itmp105[j];
		}
	}
	{ static float _itmp106[] = {9.131e02,2.387e02,2.943e01,6.525e01,
	  1.424e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][9][j] = _itmp106[j];
		}
	}
	{ static float _itmp107[] = {8.721e01,3.192e01,3.797e01,1.054e01,
	  5.652e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][9][j] = _itmp107[j];
		}
	}
	{ static float _itmp108[] = {6.346e01,3.485e01,2.451e02,6.937e01,
	  3.645e00,2.042e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][9][j] = _itmp108[j];
		}
	}
	{ static float _itmp109[] = {8.831e02,2.452e02,2.783e01,6.075e01,
	  1.420e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][9][j] = _itmp109[j];
		}
	}
	{ static float _itmp110[] = {6.374e01,3.187e01,4.025e01,8.495e00,
	  6.038e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][9][j] = _itmp110[j];
		}
	}
	{ static float _itmp111[] = {4.096e01,3.428e01,2.766e02,4.179e01,
	  4.029e00,3.052e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][9][j] = _itmp111[j];
		}
	}
	{ static float _itmp112[] = {8.701e02,3.144e02,1.664e01,2.042e05,
	  8.450e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][9][j] = _itmp112[j];
		}
	}
	{ static float _itmp113[] = {4.847e01,3.204e01,5.615e01,5.808e00,
	  6.678e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][9][j] = _itmp113[j];
		}
	}
	{ static float _itmp114[] = {2.156e01,2.000e01,1.691e04,2.442e00,
	  1.043e01,3.345e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][9][j] = _itmp114[j];
		}
	}
	{ static float _itmp115[] = {1.649e03,5.211e01,4.525e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][10][j] = _itmp115[j];
		}
	}
	{ static float _itmp116[] = {1.465e03,2.268e02,3.995e01,5.315e01,
	  1.678e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][10][j] = _itmp116[j];
		}
	}
	{ static float _itmp117[] = {1.386e03,2.406e02,3.850e01,5.198e01,
	  1.575e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][10][j] = _itmp117[j];
		}
	}
	{ static float _itmp118[] = {2.999e02,1.758e01,4.531e01,4.549e01,
	  4.689e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][10][j] = _itmp118[j];
		}
	}
	{ static float _itmp119[] = {1.335e03,2.464e02,3.613e01,4.968e01,
	  1.579e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][10][j] = _itmp119[j];
		}
	}
	{ static float _itmp120[] = {2.642e02,2.097e01,6.127e01,2.644e01,
	  5.246e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][10][j] = _itmp120[j];
		}
	}
	{ static float _itmp121[] = {1.281e03,2.777e02,2.745e01,7.512e01,
	  1.397e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][10][j] = _itmp121[j];
		}
	}
	{ static float _itmp122[] = {2.244e02,2.947e01,4.802e01,1.621e01,
	  5.395e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][10][j] = _itmp122[j];
		}
	}
	{ static float _itmp123[] = {2.085e02,3.552e01,1.374e02,7.062e01,
	  3.675e00,1.613e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][10][j] = _itmp123[j];
		}
	}
	{ static float _itmp124[] = {1.230e03,2.806e02,2.654e01,7.237e01,
	  1.405e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][10][j] = _itmp124[j];
		}
	}
	{ static float _itmp125[] = {1.899e02,3.303e01,4.218e01,1.377e01,
	  5.458e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][10][j] = _itmp125[j];
		}
	}
	{ static float _itmp126[] = {1.722e02,4.212e01,1.650e02,9.649e01,
	  3.367e00,2.182e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][10][j] = _itmp126[j];
		}
	}
	{ static float _itmp127[] = {1.185e03,2.360e02,3.753e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][10][j] = _itmp127[j];
		}
	}
	{ static float _itmp128[] = {1.567e02,3.868e01,2.607e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][10][j] = _itmp128[j];
		}
	}
	{ static float _itmp129[] = {1.384e02,3.523e01,3.028e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][10][j] = _itmp129[j];
		}
	}
	{ static float _itmp130[] = {1.143e03,2.841e02,2.551e01,6.977e01,
	  1.414e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][10][j] = _itmp130[j];
		}
	}
	{ static float _itmp131[] = {1.269e02,3.807e01,3.144e01,1.250e01,
	  5.405e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][10][j] = _itmp131[j];
		}
	}
	{ static float _itmp132[] = {9.892e01,4.314e01,2.232e02,8.352e01,
	  3.511e00,1.644e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][10][j] = _itmp132[j];
		}
	}
	{ static float _itmp133[] = {1.118e03,2.426e02,3.466e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][10][j] = _itmp133[j];
		}
	}
	{ static float _itmp134[] = {9.945e01,4.130e01,1.933e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][10][j] = _itmp134[j];
		}
	}
	{ static float _itmp135[] = {7.162e01,3.957e01,2.748e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][10][j] = _itmp135[j];
		}
	}
	{ static float _itmp136[] = {1.097e03,3.266e02,1.889e01,2.527e02,
	  1.120e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][10][j] = _itmp136[j];
		}
	}
	{ static float _itmp137[] = {7.347e01,3.939e01,2.629e01,1.103e01,
	  5.618e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][10][j] = _itmp137[j];
		}
	}
	{ static float _itmp138[] = {4.729e01,3.911e01,3.551e02,2.257e01,
	  4.643e00,2.900e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][10][j] = _itmp138[j];
		}
	}
	{ static float _itmp139[] = {1.079e03,4.216e02,1.119e01,5.642e07,
	  7.736e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][10][j] = _itmp139[j];
		}
	}
	{ static float _itmp140[] = {7.084e01,4.537e01,1.142e01,2.395e02,
	  3.380e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][10][j] = _itmp140[j];
		}
	}
	{ static float _itmp141[] = {3.814e01,3.655e01,2.486e02,3.222e02,
	  3.570e00,1.465e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][10][j] = _itmp141[j];
		}
	}
	{ static float _itmp142[] = {5.139e00,5.968e00,1.460e00,2.557e07,
	  3.789e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][10][j] = _itmp142[j];
		}
	}
}
static void blkdata10c(void)
{
	int j;
	{ static float _itmp143[] = {1.963e03,6.203e01,3.802e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][11][j] = _itmp143[j];
		}
	}
	{ static float _itmp144[] = {1.762e03,2.042e02,6.140e01,2.778e01,
	  2.161e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][11][j] = _itmp144[j];
		}
	}
	{ static float _itmp145[] = {1.675e03,2.858e02,3.290e01,5.384e01,
	  1.560e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][11][j] = _itmp145[j];
		}
	}
	{ static float _itmp146[] = {3.675e02,4.041e01,2.228e01,3.904e01,
	  3.986e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][11][j] = _itmp146[j];
		}
	}
	{ static float _itmp147[] = {1.618e03,2.671e02,3.699e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][11][j] = _itmp147[j];
		}
	}
	{ static float _itmp148[] = {3.282e02,3.981e01,3.936e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][11][j] = _itmp148[j];
		}
	}
	{ static float _itmp149[] = {1.558e03,3.082e02,2.721e01,5.108e01,
	  1.539e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][11][j] = _itmp149[j];
		}
	}
	{ static float _itmp150[] = {2.839e02,3.967e01,3.755e01,1.873e01,
	  4.950e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][11][j] = _itmp150[j];
		}
	}
	{ static float _itmp151[] = {2.660e02,2.461e01,3.546e02,6.160e01,
	  4.366e00,6.452e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][11][j] = _itmp151[j];
		}
	}
	{ static float _itmp152[] = {1.501e03,2.742e02,3.407e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][11][j] = _itmp152[j];
		}
	}
	{ static float _itmp153[] = {2.444e02,4.341e01,2.832e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][11][j] = _itmp153[j];
		}
	}
	{ static float _itmp154[] = {2.249e02,4.016e01,2.442e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][11][j] = _itmp154[j];
		}
	}
	{ static float _itmp155[] = {1.449e03,2.777e02,3.278e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][11][j] = _itmp155[j];
		}
	}
	{ static float _itmp156[] = {2.076e02,4.500e01,2.434e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][11][j] = _itmp156[j];
		}
	}
	{ static float _itmp157[] = {1.865e02,4.155e01,2.901e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][11][j] = _itmp157[j];
		}
	}
	{ static float _itmp158[] = {1.400e03,3.259e02,2.350e01,6.173e01,
	  1.464e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][11][j] = _itmp158[j];
		}
	}
	{ static float _itmp159[] = {1.735e02,4.710e01,2.448e01,1.636e01,
	  4.951e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][11][j] = _itmp159[j];
		}
	}
	{ static float _itmp160[] = {1.413e02,5.114e01,2.134e02,9.563e01,
	  3.438e00,5.419e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][11][j] = _itmp160[j];
		}
	}
	{ static float _itmp161[] = {1.356e03,3.345e02,2.212e01,7.147e01,
	  1.413e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][11][j] = _itmp161[j];
		}
	}
	{ static float _itmp162[] = {1.411e02,4.810e01,2.118e01,1.675e01,
	  4.941e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][11][j] = _itmp162[j];
		}
	}
	{ static float _itmp163[] = {1.093e02,5.137e01,2.223e02,9.301e01,
	  3.513e00,5.276e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][11][j] = _itmp163[j];
		}
	}
	{ static float _itmp164[] = {1.336e03,3.607e02,1.877e01,1.401e02,
	  1.238e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][11][j] = _itmp164[j];
		}
	}
	{ static float _itmp165[] = {1.111e02,4.804e01,1.914e01,1.613e01,
	  5.050e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][11][j] = _itmp165[j];
		}
	}
	{ static float _itmp166[] = {8.014e01,5.319e01,2.104e02,7.813e01,
	  3.630e00,2.851e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][11][j] = _itmp166[j];
		}
	}
	{ static float _itmp167[] = {1.320e03,3.709e02,1.767e01,1.346e02,
	  1.225e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][11][j] = _itmp167[j];
		}
	}
	{ static float _itmp168[] = {9.881e01,5.142e01,1.290e01,5.775e01,
	  3.903e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][11][j] = _itmp168[j];
		}
	}
	{ static float _itmp169[] = {6.569e01,4.940e01,2.049e02,4.112e03,
	  2.995e00,2.223e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][11][j] = _itmp169[j];
		}
	}
	{ static float _itmp170[] = {1.504e01,8.139e00,3.278e00,4.341e07,
	  3.610e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][11][j] = _itmp170[j];
		}
	}
	{ static float _itmp171[] = {1.311e03,2.711e02,3.561e01,2.374e01,
	  1.952e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][11][j] = _itmp171[j];
		}
	}
	{ static float _itmp172[] = {9.400e01,4.587e01,1.671e01,2.389e01,
	  4.742e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][11][j] = _itmp172[j];
		}
	}
	{ static float _itmp173[] = {5.490e01,4.937e01,2.023e02,1.079e04,
	  2.960e00,1.463e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][11][j] = _itmp173[j];
		}
	}
	{ static float _itmp174[] = {7.646e00,9.393e00,3.034e00,2.625e07,
	  3.923e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][11][j] = _itmp174[j];
		}
	}
	{ static float _itmp175[] = {2.304e03,7.281e01,3.239e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][12][j] = _itmp175[j];
		}
	}
	{ static float _itmp176[] = {2.086e03,2.738e02,4.036e01,3.567e01,
	  1.915e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][12][j] = _itmp176[j];
		}
	}
	{ static float _itmp177[] = {1.992e03,3.137e02,3.272e01,4.295e01,
	  1.676e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][12][j] = _itmp177[j];
		}
	}
	{ static float _itmp178[] = {4.421e02,4.434e01,2.098e01,3.913e01,
	  4.062e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][12][j] = _itmp178[j];
		}
	}
	{ static float _itmp179[] = {1.929e03,3.117e02,3.223e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][12][j] = _itmp179[j];
		}
	}
	{ static float _itmp180[] = {3.994e02,4.639e01,3.516e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][12][j] = _itmp180[j];
		}
	}
	{ static float _itmp181[] = {1.862e03,3.305e02,2.857e01,3.660e01,
	  1.712e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][12][j] = _itmp181[j];
		}
	}
	{ static float _itmp182[] = {3.502e02,4.550e01,3.393e01,1.945e01,
	  4.926e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][12][j] = _itmp182[j];
		}
	}
	{ static float _itmp183[] = {3.301e02,4.084e01,1.706e02,6.480e01,
	  3.927e00,1.386e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][12][j] = _itmp183[j];
		}
	}
	{ static float _itmp184[] = {1.799e03,3.193e02,2.989e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][12][j] = _itmp184[j];
		}
	}
	{ static float _itmp185[] = {3.065e02,5.016e01,2.604e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][12][j] = _itmp185[j];
		}
	}
	{ static float _itmp186[] = {2.846e02,4.719e01,2.229e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][12][j] = _itmp186[j];
		}
	}
	{ static float _itmp187[] = {1.739e03,3.396e02,2.653e01,3.478e01,
	  1.721e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][12][j] = _itmp187[j];
		}
	}
	{ static float _itmp188[] = {2.662e02,5.726e01,2.274e01,1.983e01,
	  4.594e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][12][j] = _itmp188[j];
		}
	}
	{ static float _itmp189[] = {2.414e02,5.746e01,1.941e02,8.747e01,
	  3.460e00,1.206e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][12][j] = _itmp189[j];
		}
	}
	{ static float _itmp190[] = {1.688e03,3.268e02,2.786e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][12][j] = _itmp190[j];
		}
	}
	{ static float _itmp191[] = {2.268e02,5.340e01,1.982e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][12][j] = _itmp191[j];
		}
	}
	{ static float _itmp192[] = {1.905e02,5.032e01,2.888e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][12][j] = _itmp192[j];
		}
	}
	{ static float _itmp193[] = {1.634e03,3.432e02,2.572e01,3.376e01,
	  1.730e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][12][j] = _itmp193[j];
		}
	}
	{ static float _itmp194[] = {1.903e02,5.651e01,1.865e01,1.904e01,
	  4.763e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][12][j] = _itmp194[j];
		}
	}
	{ static float _itmp195[] = {1.538e02,6.049e01,2.132e02,8.633e01,
	  3.522e00,1.041e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][12][j] = _itmp195[j];
		}
	}
	{ static float _itmp196[] = {1.604e03,3.482e02,2.494e01,3.260e01,
	  1.732e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][12][j] = _itmp196[j];
		}
	}
	{ static float _itmp197[] = {1.558e02,5.735e01,1.619e01,1.989e01,
	  4.749e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][12][j] = _itmp197[j];
		}
	}
	{ static float _itmp198[] = {1.200e02,6.033e01,2.186e02,8.353e01,
	  3.609e00,9.152e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][12][j] = _itmp198[j];
		}
	}
	{ static float _itmp199[] = {1.583e03,3.200e02,2.994e01,2.757e01,
	  1.876e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][12][j] = _itmp199[j];
		}
	}
	{ static float _itmp200[] = {1.407e02,5.629e01,1.398e01,3.550e01,
	  4.267e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][12][j] = _itmp200[j];
		}
	}
	{ static float _itmp201[] = {1.026e02,6.016e01,1.990e02,5.082e02,
	  3.110e00,2.016e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][12][j] = _itmp201[j];
		}
	}
	{ static float _itmp202[] = {2.845e01,1.027e01,4.915e00,1.990e06,
	  3.477e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][12][j] = _itmp202[j];
		}
	}
	{ static float _itmp203[] = {1.571e03,3.049e02,3.295e01,2.905e01,
	  1.898e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][12][j] = _itmp203[j];
		}
	}
	{ static float _itmp204[] = {1.281e02,5.171e01,1.642e01,2.275e01,
	  4.810e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][12][j] = _itmp204[j];
		}
	}
	{ static float _itmp205[] = {8.997e01,6.154e01,1.842e02,2.404e03,
	  2.920e00,7.839e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][12][j] = _itmp205[j];
		}
	}
	{ static float _itmp206[] = {1.883e01,1.012e01,6.324e00,2.195e02,
	  4.481e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][12][j] = _itmp206[j];
		}
	}
	{ static float _itmp207[] = {1.567e03,3.670e02,2.206e01,4.405e01,
	  1.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][12][j] = _itmp207[j];
		}
	}
	{ static float _itmp208[] = {1.256e02,5.594e01,1.425e01,3.094e01,
	  4.399e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][12][j] = _itmp208[j];
		}
	}
	{ static float _itmp209[] = {8.040e01,6.445e01,1.735e02,1.131e04,
	  2.762e00,2.337e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][12][j] = _itmp209[j];
		}
	}
	{ static float _itmp210[] = {1.133e01,1.204e01,5.384e00,4.341e02,
	  4.088e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][12][j] = _itmp210[j];
		}
	}
	{ static float _itmp211[] = {5.986e00,1.860e01,1.828e02,2.797e00,
	  1.084e01,3.076e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][12][j] = _itmp211[j];
		}
	}
	{ static float _itmp212[] = {2.673e03,8.447e01,2.793e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][13][j] = _itmp212[j];
		}
	}
	{ static float _itmp213[] = {2.438e03,2.752e02,4.754e01,2.848e01,
	  2.135e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][13][j] = _itmp213[j];
		}
	}
	{ static float _itmp214[] = {2.336e03,3.150e02,3.880e01,3.034e01,
	  1.925e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][13][j] = _itmp214[j];
		}
	}
	{ static float _itmp215[] = {5.235e02,4.847e01,1.966e01,3.851e01,
	  4.148e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][13][j] = _itmp215[j];
		}
	}
	{ static float _itmp216[] = {2.268e03,3.599e02,2.832e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][13][j] = _itmp216[j];
		}
	}
	{ static float _itmp217[] = {4.761e02,5.350e01,3.155e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][13][j] = _itmp217[j];
		}
	}
	{ static float _itmp218[] = {2.194e03,3.356e02,3.343e01,2.487e01,
	  1.982e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][13][j] = _itmp218[j];
		}
	}
	{ static float _itmp219[] = {4.234e02,6.098e01,2.624e01,2.213e01,
	  4.520e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][13][j] = _itmp219[j];
		}
	}
	{ static float _itmp220[] = {4.014e02,3.950e01,2.223e02,6.521e01,
	  4.118e00,4.760e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][13][j] = _itmp220[j];
		}
	}
	{ static float _itmp221[] = {2.125e03,3.679e02,2.641e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][13][j] = _itmp221[j];
		}
	}
	{ static float _itmp222[] = {3.756e02,5.745e01,2.394e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][13][j] = _itmp222[j];
		}
	}
	{ static float _itmp223[] = {3.511e02,5.486e01,2.031e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][13][j] = _itmp223[j];
		}
	}
}
static void blkdata10d(void)
{
	int j;
	{ static float _itmp224[] = {2.058e03,3.442e02,3.135e01,2.260e01,
	  2.020e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][13][j] = _itmp224[j];
		}
	}
	{ static float _itmp225[] = {3.310e02,6.593e01,2.049e01,2.121e01,
	  4.515e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][13][j] = _itmp225[j];
		}
	}
	{ static float _itmp226[] = {3.032e02,5.911e01,2.326e02,6.806e01,
	  3.718e00,2.813e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][13][j] = _itmp226[j];
		}
	}
	{ static float _itmp227[] = {2.001e03,3.759e02,2.474e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][13][j] = _itmp227[j];
		}
	}
	{ static float _itmp228[] = {2.872e02,6.086e01,1.857e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][13][j] = _itmp228[j];
		}
	}
	{ static float _itmp229[] = {2.465e02,5.786e01,2.777e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][13][j] = _itmp229[j];
		}
	}
	{ static float _itmp230[] = {1.946e03,3.799e02,2.398e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][13][j] = _itmp230[j];
		}
	}
	{ static float _itmp231[] = {2.468e02,6.237e01,1.648e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][13][j] = _itmp231[j];
		}
	}
	{ static float _itmp232[] = {2.051e02,6.007e01,2.789e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][13][j] = _itmp232[j];
		}
	}
	{ static float _itmp233[] = {1.887e03,3.460e02,3.100e01,1.979e01,
	  2.094e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][13][j] = _itmp233[j];
		}
	}
	{ static float _itmp234[] = {2.076e02,6.653e01,1.463e01,2.200e01,
	  4.611e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][13][j] = _itmp234[j];
		}
	}
	{ static float _itmp235[] = {1.668e02,7.021e01,2.109e02,8.199e01,
	  3.588e00,6.329e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][13][j] = _itmp235[j];
		}
	}
	{ static float _itmp236[] = {1.868e03,3.131e02,3.784e01,2.017e01,
	  2.186e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][13][j] = _itmp236[j];
		}
	}
	{ static float _itmp237[] = {1.899e02,5.977e01,1.486e01,2.786e01,
	  4.565e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][13][j] = _itmp237[j];
		}
	}
	{ static float _itmp238[] = {1.466e02,6.482e01,2.326e02,1.188e02,
	  3.547e00,8.417e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][13][j] = _itmp238[j];
		}
	}
	{ static float _itmp239[] = {4.514e01,1.288e01,6.083e00,1.356e06,
	  3.353e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][13][j] = _itmp239[j];
		}
	}
	{ static float _itmp240[] = {1.852e03,3.201e02,3.591e01,2.174e01,
	  2.123e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][13][j] = _itmp240[j];
		}
	}
	{ static float _itmp241[] = {1.744e02,5.843e01,1.569e01,2.296e01,
	  4.803e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][13][j] = _itmp241[j];
		}
	}
	{ static float _itmp242[] = {1.311e02,6.652e01,2.197e02,1.169e02,
	  3.529e00,8.658e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][13][j] = _itmp242[j];
		}
	}
	{ static float _itmp243[] = {3.349e01,1.182e01,8.666e00,3.532e02,
	  4.208e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][13][j] = _itmp243[j];
		}
	}
	{ static float _itmp244[] = {1.848e03,4.580e02,1.628e01,7.706e01,
	  1.385e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][13][j] = _itmp244[j];
		}
	}
	{ static float _itmp245[] = {1.619e02,6.738e01,1.263e01,3.623e01,
	  4.172e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][13][j] = _itmp245[j];
		}
	}
	{ static float _itmp246[] = {1.186e02,7.154e01,1.832e02,3.537e02,
	  3.133e00,2.870e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][13][j] = _itmp246[j];
		}
	}
	{ static float _itmp247[] = {2.240e01,1.364e01,8.454e00,7.489e01,
	  4.676e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][13][j] = _itmp247[j];
		}
	}
	{ static float _itmp248[] = {1.635e01,2.123e01,6.975e01,4.907e00,
	  9.525e00,3.169e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][13][j] = _itmp248[j];
		}
	}
	{ static float _itmp249[] = {1.846e03,5.322e02,1.184e01,2.580e02,
	  1.102e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][13][j] = _itmp249[j];
		}
	}
	{ static float _itmp250[] = {1.560e02,7.017e01,1.166e01,4.742e01,
	  3.933e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][13][j] = _itmp250[j];
		}
	}
	{ static float _itmp251[] = {1.060e02,7.808e01,1.532e02,5.765e06,
	  2.639e00,2.774e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][13][j] = _itmp251[j];
		}
	}
	{ static float _itmp252[] = {1.517e01,1.413e01,1.166e01,2.288e01,
	  5.334e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][13][j] = _itmp252[j];
		}
	}
	{ static float _itmp253[] = {8.152e00,2.212e01,1.845e02,3.849e00,
	  9.721e00,2.921e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][13][j] = _itmp253[j];
		}
	}
	{ static float _itmp254[] = {3.070e03,9.701e01,2.433e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][14][j] = _itmp254[j];
		}
	}
	{ static float _itmp255[] = {2.817e03,3.381e02,3.646e01,3.254e01,
	  2.002e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][14][j] = _itmp255[j];
		}
	}
	{ static float _itmp256[] = {2.707e03,3.711e02,3.220e01,3.257e01,
	  1.869e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][14][j] = _itmp256[j];
		}
	}
	{ static float _itmp257[] = {6.119e02,6.401e01,1.519e01,3.741e01,
	  3.995e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][14][j] = _itmp257[j];
		}
	}
	{ static float _itmp258[] = {2.633e03,3.790e02,3.053e01,3.068e01,
	  1.885e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][14][j] = _itmp258[j];
		}
	}
	{ static float _itmp259[] = {5.604e02,5.712e01,2.980e01,2.988e01,
	  4.450e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][14][j] = _itmp259[j];
		}
	}
	{ static float _itmp260[] = {2.553e03,3.860e02,2.914e01,2.656e01,
	  1.945e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][14][j] = _itmp260[j];
		}
	}
	{ static float _itmp261[] = {5.035e02,7.791e01,2.079e01,2.573e01,
	  4.191e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][14][j] = _itmp261[j];
		}
	}
	{ static float _itmp262[] = {4.796e02,7.305e01,7.867e01,7.330e01,
	  3.527e00,1.286e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][14][j] = _itmp262[j];
		}
	}
	{ static float _itmp263[] = {2.477e03,3.824e02,2.955e01,2.402e01,
	  2.010e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][14][j] = _itmp263[j];
		}
	}
	{ static float _itmp264[] = {4.522e02,7.664e01,1.966e01,2.403e01,
	  4.317e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][14][j] = _itmp264[j];
		}
	}
	{ static float _itmp265[] = {4.245e02,6.502e01,1.792e02,6.744e01,
	  3.727e00,1.364e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][14][j] = _itmp265[j];
		}
	}
	{ static float _itmp266[] = {2.407e03,4.243e02,2.277e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][14][j] = _itmp266[j];
		}
	}
	{ static float _itmp267[] = {4.018e02,6.712e01,1.952e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][14][j] = _itmp267[j];
		}
	}
	{ static float _itmp268[] = {3.717e02,6.437e01,2.384e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][14][j] = _itmp268[j];
		}
	}
	{ static float _itmp269[] = {2.337e03,3.811e02,2.964e01,2.122e01,
	  2.087e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][14][j] = _itmp269[j];
		}
	}
	{ static float _itmp270[] = {3.552e02,7.217e01,1.771e01,2.129e01,
	  4.617e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][14][j] = _itmp270[j];
		}
	}
	{ static float _itmp271[] = {3.094e02,5.587e01,3.696e02,4.738e01,
	  4.244e00,1.094e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][14][j] = _itmp271[j];
		}
	}
	{ static float _itmp272[] = {2.280e03,4.327e02,2.146e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][14][j] = _itmp272[j];
		}
	}
	{ static float _itmp273[] = {3.098e02,7.044e01,1.553e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][14][j] = _itmp273[j];
		}
	}
	{ static float _itmp274[] = {2.632e02,6.819e01,2.712e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][14][j] = _itmp274[j];
		}
	}
	{ static float _itmp275[] = {2.214e03,3.828e02,2.932e01,1.991e01,
	  2.123e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][14][j] = _itmp275[j];
		}
	}
	{ static float _itmp276[] = {2.663e02,6.951e01,1.560e01,1.845e01,
	  4.938e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][14][j] = _itmp276[j];
		}
	}
	{ static float _itmp277[] = {2.204e02,6.893e01,2.980e02,3.497e01,
	  4.307e00,1.008e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][14][j] = _itmp277[j];
		}
	}
	{ static float _itmp278[] = {2.192e03,3.423e02,3.671e01,2.010e01,
	  2.232e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][14][j] = _itmp278[j];
		}
	}
	{ static float _itmp279[] = {2.461e02,6.270e01,1.535e01,2.486e01,
	  4.787e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][14][j] = _itmp279[j];
		}
	}
	{ static float _itmp280[] = {1.977e02,6.186e01,3.368e02,4.700e01,
	  4.256e00,1.118e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][14][j] = _itmp280[j];
		}
	}
	{ static float _itmp281[] = {6.503e01,1.526e00,3.688e01,1.111e03,
	  4.890e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][14][j] = _itmp281[j];
		}
	}
	{ static float _itmp282[] = {2.173e03,3.969e02,2.640e01,2.945e01,
	  1.901e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][14][j] = _itmp282[j];
		}
	}
	{ static float _itmp283[] = {2.280e02,6.564e01,1.491e01,2.333e01,
	  4.787e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][14][j] = _itmp283[j];
		}
	}
	{ static float _itmp284[] = {1.795e02,6.946e01,2.661e02,5.760e01,
	  3.967e00,4.482e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][14][j] = _itmp284[j];
		}
	}
	{ static float _itmp285[] = {5.144e01,1.151e01,1.153e01,2.303e02,
	  4.447e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][14][j] = _itmp285[j];
		}
	}
	{ static float _itmp286[] = {2.157e03,5.025e02,1.577e01,6.163e01,
	  1.467e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][14][j] = _itmp286[j];
		}
	}
	{ static float _itmp287[] = {2.124e02,7.708e01,1.206e01,3.388e01,
	  4.192e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][14][j] = _itmp287[j];
		}
	}
	{ static float _itmp288[] = {1.639e02,7.943e01,1.949e02,1.392e02,
	  3.391e00,5.039e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][14][j] = _itmp288[j];
		}
	}
	{ static float _itmp289[] = {3.828e01,1.832e01,8.260e00,7.058e02,
	  3.682e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][14][j] = _itmp289[j];
		}
	}
	{ static float _itmp290[] = {3.020e01,2.401e01,2.851e01,9.795e00,
	  8.210e00,3.290e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][14][j] = _itmp290[j];
		}
	}
	{ static float _itmp291[] = {2.155e03,4.445e02,1.990e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][14][j] = _itmp291[j];
		}
	}
	{ static float _itmp292[] = {1.987e02,7.299e01,1.328e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][14][j] = _itmp292[j];
		}
	}
	{ static float _itmp293[] = {1.495e02,7.517e01,2.347e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][14][j] = _itmp293[j];
		}
	}
	{ static float _itmp294[] = {2.709e01,1.666e01,7.930e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][14][j] = _itmp294[j];
		}
	}
	{ static float _itmp295[] = {1.973e01,2.511e01,2.564e01,1.800e01,
	  7.200e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][14][j] = _itmp295[j];
		}
	}
	{ static float _itmp296[] = {2.154e03,6.472e02,9.167e00,2.562e02,
	  1.063e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][14][j] = _itmp296[j];
		}
	}
	{ static float _itmp297[] = {1.940e02,8.632e01,9.931e00,6.594e01,
	  3.617e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][14][j] = _itmp297[j];
		}
	}
	{ static float _itmp298[] = {1.400e02,8.812e01,1.512e02,2.230e03,
	  2.795e00,3.422e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][14][j] = _itmp298[j];
		}
	}
	{ static float _itmp299[] = {2.017e01,1.658e01,1.125e01,2.613e01,
	  5.205e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][14][j] = _itmp299[j];
		}
	}
	{ static float _itmp300[] = {1.049e01,2.580e01,9.925e01,6.712e00,
	  8.516e00,2.765e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][14][j] = _itmp300[j];
		}
	}
	{ static float _itmp301[] = {3.494e03,1.104e02,2.139e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][15][j] = _itmp301[j];
		}
	}
	{ static float _itmp302[] = {3.224e03,4.390e02,2.453e01,4.405e01,
	  1.765e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][15][j] = _itmp302[j];
		}
	}
	{ static float _itmp303[] = {3.107e03,4.667e02,2.293e01,4.459e01,
	  1.668e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][15][j] = _itmp303[j];
		}
	}
	{ static float _itmp304[] = {7.072e02,4.414e01,2.178e01,4.365e01,
	  4.480e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][15][j] = _itmp304[j];
		}
	}
}
static void blkdata10e(void)
{
	int j;
	{ static float _itmp305[] = {3.029e03,4.669e02,2.233e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][15][j] = _itmp305[j];
		}
	}
	{ static float _itmp306[] = {6.517e02,6.930e01,2.571e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][15][j] = _itmp306[j];
		}
	}
	{ static float _itmp307[] = {2.941e03,4.828e02,2.087e01,3.742e01,
	  1.720e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][15][j] = _itmp307[j];
		}
	}
	{ static float _itmp308[] = {5.906e02,6.791e01,2.451e01,2.306e01,
	  4.707e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][15][j] = _itmp308[j];
		}
	}
	{ static float _itmp309[] = {5.647e02,5.542e01,1.641e02,6.822e01,
	  4.000e00,4.183e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][15][j] = _itmp309[j];
		}
	}
	{ static float _itmp310[] = {2.859e03,4.758e02,2.101e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][15][j] = _itmp310[j];
		}
	}
	{ static float _itmp311[] = {5.346e02,7.360e01,2.030e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][15][j] = _itmp311[j];
		}
	}
	{ static float _itmp312[] = {5.048e02,7.213e01,1.689e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][15][j] = _itmp312[j];
		}
	}
	{ static float _itmp313[] = {2.782e03,4.802e02,2.041e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][15][j] = _itmp313[j];
		}
	}
	{ static float _itmp314[] = {4.804e02,7.555e01,1.812e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][15][j] = _itmp314[j];
		}
	}
	{ static float _itmp315[] = {4.471e02,7.326e01,2.213e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][15][j] = _itmp315[j];
		}
	}
	{ static float _itmp316[] = {2.705e03,4.937e02,1.946e01,3.568e01,
	  1.737e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][15][j] = _itmp316[j];
		}
	}
	{ static float _itmp317[] = {4.296e02,8.031e01,1.659e01,2.170e01,
	  4.615e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][15][j] = _itmp317[j];
		}
	}
	{ static float _itmp318[] = {3.791e02,6.911e01,2.970e02,5.519e01,
	  4.011e00,2.178e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][15][j] = _itmp318[j];
		}
	}
	{ static float _itmp319[] = {2.641e03,4.891e02,1.931e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][15][j] = _itmp319[j];
		}
	}
	{ static float _itmp320[] = {3.797e02,7.905e01,1.462e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][15][j] = _itmp320[j];
		}
	}
	{ static float _itmp321[] = {3.282e02,7.695e01,2.615e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][15][j] = _itmp321[j];
		}
	}
	{ static float _itmp322[] = {2.569e03,4.952e02,1.916e01,3.555e01,
	  1.742e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][15][j] = _itmp322[j];
		}
	}
	{ static float _itmp323[] = {3.321e02,8.439e01,1.291e01,2.335e01,
	  4.545e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][15][j] = _itmp323[j];
		}
	}
	{ static float _itmp324[] = {2.809e02,7.813e01,2.751e02,4.495e01,
	  4.110e00,2.108e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][15][j] = _itmp324[j];
		}
	}
	{ static float _itmp325[] = {2.544e03,4.681e02,2.148e01,4.092e01,
	  1.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][15][j] = _itmp325[j];
		}
	}
	{ static float _itmp326[] = {3.094e02,6.780e01,1.495e01,2.519e01,
	  4.826e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][15][j] = _itmp326[j];
		}
	}
	{ static float _itmp327[] = {2.557e02,5.747e01,4.712e02,3.610e01,
	  4.742e00,2.480e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][15][j] = _itmp327[j];
		}
	}
	{ static float _itmp328[] = {8.805e01,1.413e01,9.139e00,1.656e03,
	  3.626e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][15][j] = _itmp328[j];
		}
	}
	{ static float _itmp329[] = {2.522e03,4.813e02,2.029e01,3.854e01,
	  1.736e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][15][j] = _itmp329[j];
		}
	}
	{ static float _itmp330[] = {2.888e02,7.355e01,1.407e01,2.397e01,
	  4.754e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][15][j] = _itmp330[j];
		}
	}
	{ static float _itmp331[] = {2.350e02,7.411e01,2.919e02,4.864e01,
	  4.142e00,2.785e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][15][j] = _itmp331[j];
		}
	}
	{ static float _itmp332[] = {7.268e01,1.271e01,1.363e01,2.570e02,
	  4.361e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][15][j] = _itmp332[j];
		}
	}
	{ static float _itmp333[] = {2.502e03,5.523e02,1.504e01,5.527e01,
	  1.517e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][15][j] = _itmp333[j];
		}
	}
	{ static float _itmp334[] = {2.703e02,8.665e01,1.155e01,3.202e01,
	  4.227e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][15][j] = _itmp334[j];
		}
	}
	{ static float _itmp335[] = {2.164e02,8.744e01,2.037e02,9.310e01,
	  3.565e00,9.497e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][15][j] = _itmp335[j];
		}
	}
	{ static float _itmp336[] = {5.750e01,2.143e01,9.080e00,7.224e02,
	  3.618e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][15][j] = _itmp336[j];
		}
	}
	{ static float _itmp337[] = {4.731e01,3.325e01,1.099e01,3.639e01,
	  5.977e00,3.761e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][15][j] = _itmp337[j];
		}
	}
	{ static float _itmp338[] = {2.486e03,6.434e02,1.082e01,1.410e02,
	  1.221e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][15][j] = _itmp338[j];
		}
	}
	{ static float _itmp339[] = {2.536e02,9.233e01,1.048e01,4.007e01,
	  3.968e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][15][j] = _itmp339[j];
		}
	}
	{ static float _itmp340[] = {1.995e02,9.246e01,1.780e02,1.498e02,
	  3.319e00,2.142e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][15][j] = _itmp340[j];
		}
	}
	{ static float _itmp341[] = {4.415e01,2.175e01,8.208e00,7.941e02,
	  3.591e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][15][j] = _itmp341[j];
		}
	}
	{ static float _itmp342[] = {3.483e01,2.934e01,3.702e01,1.445e01,
	  7.321e00,2.989e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][15][j] = _itmp342[j];
		}
	}
	{ static float _itmp343[] = {2.478e03,7.306e02,8.303e00,7.483e02,
	  9.844e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][15][j] = _itmp343[j];
		}
	}
	{ static float _itmp344[] = {2.387e02,9.694e01,9.659e00,5.188e01,
	  3.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][15][j] = _itmp344[j];
		}
	}
	{ static float _itmp345[] = {1.846e02,9.058e01,1.896e02,7.538e01,
	  3.635e00,2.934e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][15][j] = _itmp345[j];
		}
	}
	{ static float _itmp346[] = {3.190e01,2.047e01,7.824e00,2.396e02,
	  3.950e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][15][j] = _itmp346[j];
		}
	}
	{ static float _itmp347[] = {2.333e01,2.890e01,1.054e02,7.474e00,
	  8.421e00,2.840e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][15][j] = _itmp347[j];
		}
	}
	{ static float _itmp348[] = {2.477e03,8.114e02,6.649e00,3.734e03,
	  8.646e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][15][j] = _itmp348[j];
		}
	}
	{ static float _itmp349[] = {2.350e02,1.047e02,8.520e00,9.469e01,
	  3.346e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][15][j] = _itmp349[j];
		}
	}
	{ static float _itmp350[] = {1.700e02,9.152e01,1.883e02,7.193e01,
	  3.633e00,2.485e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][15][j] = _itmp350[j];
		}
	}
	{ static float _itmp351[] = {2.130e01,1.916e01,1.003e01,3.296e01,
	  5.038e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][15][j] = _itmp351[j];
		}
	}
	{ static float _itmp352[] = {1.036e01,2.975e01,5.644e01,1.321e01,
	  7.513e00,2.621e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][15][j] = _itmp352[j];
		}
	}
	{ static float _itmp353[] = {3.946e03,1.247e02,1.894e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][16][j] = _itmp353[j];
		}
	}
	{ static float _itmp354[] = {3.659e03,4.174e02,3.143e01,3.162e01,
	  2.037e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][16][j] = _itmp354[j];
		}
	}
	{ static float _itmp355[] = {3.534e03,4.432e02,2.956e01,3.058e01,
	  1.953e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][16][j] = _itmp355[j];
		}
	}
	{ static float _itmp356[] = {8.094e02,7.444e01,1.356e01,3.797e01,
	  4.103e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][16][j] = _itmp356[j];
		}
	}
	{ static float _itmp357[] = {3.448e03,4.473e02,2.878e01,2.772e01,
	  1.999e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][16][j] = _itmp357[j];
		}
	}
	{ static float _itmp358[] = {7.498e02,7.310e01,2.449e01,3.044e01,
	  4.421e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][16][j] = _itmp358[j];
		}
	}
	{ static float _itmp359[] = {3.356e03,4.633e02,2.651e01,2.523e01,
	  2.025e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][16][j] = _itmp359[j];
		}
	}
	{ static float _itmp360[] = {6.846e02,1.049e02,1.622e01,2.683e01,
	  4.067e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][16][j] = _itmp360[j];
		}
	}
	{ static float _itmp361[] = {6.567e02,3.905e01,3.845e02,8.984e01,
	  4.272e00,3.017e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][16][j] = _itmp361[j];
		}
	}
	{ static float _itmp362[] = {3.266e03,4.610e02,2.666e01,2.298e01,
	  2.085e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][16][j] = _itmp362[j];
		}
	}
	{ static float _itmp363[] = {6.249e02,9.701e01,1.646e01,2.531e01,
	  4.266e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][16][j] = _itmp363[j];
		}
	}
	{ static float _itmp364[] = {5.920e02,7.621e01,1.831e02,6.513e01,
	  3.852e00,3.987e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][16][j] = _itmp364[j];
		}
	}
	{ static float _itmp365[] = {3.184e03,5.397e02,1.840e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][16][j] = _itmp365[j];
		}
	}
	{ static float _itmp366[] = {5.660e02,8.450e01,1.684e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][16][j] = _itmp366[j];
		}
	}
	{ static float _itmp367[] = {5.293e02,8.280e01,2.053e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][16][j] = _itmp367[j];
		}
	}
	{ static float _itmp368[] = {3.100e03,4.593e02,2.668e01,2.099e01,
	  2.148e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][16][j] = _itmp368[j];
		}
	}
	{ static float _itmp369[] = {5.109e02,9.134e01,1.502e01,2.321e01,
	  4.515e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][16][j] = _itmp369[j];
		}
	}
	{ static float _itmp370[] = {4.556e02,8.470e01,2.378e02,5.655e01,
	  3.889e00,3.329e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][16][j] = _itmp370[j];
		}
	}
	{ static float _itmp371[] = {3.030e03,5.491e02,1.746e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][16][j] = _itmp371[j];
		}
	}
	{ static float _itmp372[] = {4.565e02,8.818e01,1.375e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][16][j] = _itmp372[j];
		}
	}
	{ static float _itmp373[] = {4.001e02,8.635e01,2.505e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][16][j] = _itmp373[j];
		}
	}
	{ static float _itmp374[] = {2.951e03,4.603e02,2.645e01,1.991e01,
	  2.182e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][16][j] = _itmp374[j];
		}
	}
	{ static float _itmp375[] = {4.048e02,8.397e01,1.392e01,2.002e01,
	  4.904e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][16][j] = _itmp375[j];
		}
	}
	{ static float _itmp376[] = {3.483e02,8.434e01,2.880e02,4.019e01,
	  4.242e00,2.672e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][16][j] = _itmp376[j];
		}
	}
	{ static float _itmp377[] = {2.923e03,4.414e02,2.836e01,2.402e01,
	  2.121e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][16][j] = _itmp377[j];
		}
	}
	{ static float _itmp378[] = {3.797e02,6.106e01,1.676e01,2.195e01,
	  5.347e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][16][j] = _itmp378[j];
		}
	}
	{ static float _itmp379[] = {3.207e02,6.471e01,4.512e02,3.950e01,
	  4.637e00,2.356e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][16][j] = _itmp379[j];
		}
	}
	{ static float _itmp380[] = {1.142e02,1.534e00,6.782e01,1.497e03,
	  4.756e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][16][j] = _itmp380[j];
		}
	}
	{ static float _itmp381[] = {2.898e03,5.111e02,2.068e01,3.167e01,
	  1.860e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][16][j] = _itmp381[j];
		}
	}
	{ static float _itmp382[] = {3.566e02,7.233e01,1.520e01,2.042e01,
	  5.148e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][16][j] = _itmp382[j];
		}
	}
	{ static float _itmp383[] = {2.974e02,7.682e01,3.345e02,3.803e01,
	  4.431e00,2.396e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][16][j] = _itmp383[j];
		}
	}
	{ static float _itmp384[] = {9.703e01,8.603e00,2.080e01,2.738e02,
	  4.689e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][16][j] = _itmp384[j];
		}
	}
	{ static float _itmp385[] = {2.875e03,6.130e02,1.391e01,5.524e01,
	  1.527e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][16][j] = _itmp385[j];
		}
	}
}
static void blkdata10f(void)
{
	int j;
	{ static float _itmp386[] = {3.354e02,8.204e01,1.391e01,2.025e01,
	  4.934e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][16][j] = _itmp386[j];
		}
	}
	{ static float _itmp387[] = {2.760e02,8.644e01,2.701e02,3.890e01,
	  4.239e00,2.462e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][16][j] = _itmp387[j];
		}
	}
	{ static float _itmp388[] = {7.997e01,1.825e01,1.148e01,1.976e02,
	  4.245e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][16][j] = _itmp388[j];
		}
	}
	{ static float _itmp389[] = {6.782e01,3.654e01,1.195e01,3.759e01,
	  6.009e00,4.036e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][16][j] = _itmp389[j];
		}
	}
	{ static float _itmp390[] = {2.851e03,5.520e02,1.713e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][16][j] = _itmp390[j];
		}
	}
	{ static float _itmp391[] = {3.151e02,9.076e01,1.198e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][16][j] = _itmp391[j];
		}
	}
	{ static float _itmp392[] = {2.552e02,9.562e01,2.144e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][16][j] = _itmp392[j];
		}
	}
	{ static float _itmp393[] = {6.470e01,2.019e01,9.833e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][16][j] = _itmp393[j];
		}
	}
	{ static float _itmp394[] = {5.347e01,3.505e01,2.148e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][16][j] = _itmp394[j];
		}
	}
	{ static float _itmp395[] = {2.838e03,7.650e02,8.653e00,2.714e02,
	  1.105e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][16][j] = _itmp395[j];
		}
	}
	{ static float _itmp396[] = {2.979e02,9.151e01,1.265e01,2.088e01,
	  4.703e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][16][j] = _itmp396[j];
		}
	}
	{ static float _itmp397[] = {2.382e02,9.580e01,2.222e02,4.214e01,
	  4.019e00,2.237e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][16][j] = _itmp397[j];
		}
	}
	{ static float _itmp398[] = {5.019e01,2.307e01,8.302e00,2.450e02,
	  3.950e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][16][j] = _itmp398[j];
		}
	}
	{ static float _itmp399[] = {3.961e01,3.460e01,3.044e01,3.383e01,
	  6.261e00,2.707e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][16][j] = _itmp399[j];
		}
	}
	{ static float _itmp400[] = {2.832e03,5.619e02,1.634e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][16][j] = _itmp400[j];
		}
	}
	{ static float _itmp401[] = {2.837e02,9.168e01,1.167e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][16][j] = _itmp401[j];
		}
	}
	{ static float _itmp402[] = {2.236e02,9.695e01,2.052e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][16][j] = _itmp402[j];
		}
	}
	{ static float _itmp403[] = {3.686e01,2.191e01,7.493e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][16][j] = _itmp403[j];
		}
	}
	{ static float _itmp404[] = {2.381e01,3.339e01,4.993e01,1.800e01,
	  7.200e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][16][j] = _itmp404[j];
		}
	}
	{ static float _itmp405[] = {2.830e03,9.700e02,5.255e00,1.856e06,
	  7.888e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][16][j] = _itmp405[j];
		}
	}
	{ static float _itmp406[] = {2.780e02,1.092e02,1.059e01,2.491e01,
	  4.205e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][16][j] = _itmp406[j];
		}
	}
	{ static float _itmp407[] = {2.090e02,8.004e01,3.053e02,3.498e01,
	  4.457e00,2.017e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][16][j] = _itmp407[j];
		}
	}
	{ static float _itmp408[] = {2.531e01,2.231e01,6.628e00,1.843e02,
	  4.196e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][16][j] = _itmp408[j];
		}
	}
	{ static float _itmp409[] = {1.297e01,3.398e01,4.539e01,2.232e01,
	  6.896e00,2.479e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][16][j] = _itmp409[j];
		}
	}
	{ static float _itmp410[] = {4.426e03,1.399e02,1.690e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][17][j] = _itmp410[j];
		}
	}
	{ static float _itmp411[] = {4.121e03,4.468e02,3.108e01,3.039e01,
	  2.092e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][17][j] = _itmp411[j];
		}
	}
	{ static float _itmp412[] = {3.988e03,4.680e02,3.003e01,2.854e01,
	  2.037e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][17][j] = _itmp412[j];
		}
	}
	{ static float _itmp413[] = {9.180e02,5.440e01,1.838e01,4.656e01,
	  4.439e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][17][j] = _itmp413[j];
		}
	}
	{ static float _itmp414[] = {3.898e03,4.756e02,2.883e01,2.615e01,
	  2.074e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][17][j] = _itmp414[j];
		}
	}
	{ static float _itmp415[] = {8.548e02,8.162e01,2.235e01,3.057e01,
	  4.418e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][17][j] = _itmp415[j];
		}
	}
	{ static float _itmp416[] = {3.798e03,4.749e02,2.874e01,2.235e01,
	  2.171e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][17][j] = _itmp416[j];
		}
	}
	{ static float _itmp417[] = {7.856e02,1.086e02,1.606e01,2.688e01,
	  4.173e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][17][j] = _itmp417[j];
		}
	}
	{ static float _itmp418[] = {7.558e02,8.270e01,1.006e02,7.201e01,
	  3.789e00,5.509e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][17][j] = _itmp418[j];
		}
	}
	{ static float _itmp419[] = {3.702e03,4.731e02,2.888e01,2.042e01,
	  2.234e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][17][j] = _itmp419[j];
		}
	}
	{ static float _itmp420[] = {7.217e02,1.081e02,1.515e01,2.572e01,
	  4.251e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][17][j] = _itmp420[j];
		}
	}
	{ static float _itmp421[] = {6.861e02,5.722e01,3.784e02,7.663e01,
	  4.151e00,1.194e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][17][j] = _itmp421[j];
		}
	}
	{ static float _itmp422[] = {3.613e03,6.028e02,1.666e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][17][j] = _itmp422[j];
		}
	}
	{ static float _itmp423[] = {6.584e02,9.398e01,1.567e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][17][j] = _itmp423[j];
		}
	}
	{ static float _itmp424[] = {6.183e02,9.297e01,1.904e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][17][j] = _itmp424[j];
		}
	}
	{ static float _itmp425[] = {3.523e03,4.789e02,2.796e01,1.917e01,
	  2.271e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][17][j] = _itmp425[j];
		}
	}
	{ static float _itmp426[] = {5.992e02,9.884e01,1.431e01,2.351e01,
	  4.545e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][17][j] = _itmp426[j];
		}
	}
	{ static float _itmp427[] = {5.390e02,7.562e01,3.466e02,5.329e01,
	  4.195e00,1.392e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][17][j] = _itmp427[j];
		}
	}
	{ static float _itmp428[] = {3.446e03,6.126e02,1.585e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][17][j] = _itmp428[j];
		}
	}
	{ static float _itmp429[] = {5.403e02,9.783e01,1.294e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][17][j] = _itmp429[j];
		}
	}
	{ static float _itmp430[] = {4.787e02,9.639e01,2.389e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][17][j] = _itmp430[j];
		}
	}
	{ static float _itmp431[] = {3.361e03,4.679e02,2.931e01,1.744e01,
	  2.362e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][17][j] = _itmp431[j];
		}
	}
	{ static float _itmp432[] = {4.845e02,9.273e01,1.306e01,2.086e01,
	  4.862e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][17][j] = _itmp432[j];
		}
	}
	{ static float _itmp433[] = {4.225e02,9.230e01,2.855e02,4.508e01,
	  4.165e00,8.883e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][17][j] = _itmp433[j];
		}
	}
	{ static float _itmp434[] = {3.331e03,4.486e02,3.143e01,2.008e01,
	  2.315e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][17][j] = _itmp434[j];
		}
	}
	{ static float _itmp435[] = {4.570e02,6.529e01,1.602e01,2.336e01,
	  5.323e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][17][j] = _itmp435[j];
		}
	}
	{ static float _itmp436[] = {3.925e02,7.368e01,4.198e02,4.419e01,
	  4.492e00,7.712e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][17][j] = _itmp436[j];
		}
	}
	{ static float _itmp437[] = {1.435e02,3.884e00,3.295e01,7.082e02,
	  4.645e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][17][j] = _itmp437[j];
		}
	}
	{ static float _itmp438[] = {3.303e03,6.199e02,1.559e01,4.503e01,
	  1.664e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][17][j] = _itmp438[j];
		}
	}
	{ static float _itmp439[] = {4.314e02,8.000e01,1.424e01,2.136e01,
	  5.094e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][17][j] = _itmp439[j];
		}
	}
	{ static float _itmp440[] = {3.667e02,8.563e01,3.204e02,4.230e01,
	  4.329e00,7.258e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][17][j] = _itmp440[j];
		}
	}
	{ static float _itmp441[] = {1.243e02,8.091e00,2.596e01,3.212e02,
	  4.685e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][17][j] = _itmp441[j];
		}
	}
	{ static float _itmp442[] = {3.277e03,6.427e02,1.444e01,4.208e01,
	  1.659e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][17][j] = _itmp442[j];
		}
	}
	{ static float _itmp443[] = {4.076e02,8.974e01,1.313e01,2.094e01,
	  4.919e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][17][j] = _itmp443[j];
		}
	}
	{ static float _itmp444[] = {3.426e02,9.233e01,2.786e02,4.220e01,
	  4.227e00,7.408e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][17][j] = _itmp444[j];
		}
	}
	{ static float _itmp445[] = {1.056e02,1.839e01,1.304e01,2.002e02,
	  4.303e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][17][j] = _itmp445[j];
		}
	}
	{ static float _itmp446[] = {9.101e01,3.564e01,1.418e01,3.945e01,
	  6.194e00,7.398e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][17][j] = _itmp446[j];
		}
	}
	{ static float _itmp447[] = {3.253e03,6.819e02,1.269e01,4.958e01,
	  1.562e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][17][j] = _itmp447[j];
		}
	}
	{ static float _itmp448[] = {3.852e02,9.393e01,1.265e01,2.082e01,
	  4.848e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][17][j] = _itmp448[j];
		}
	}
	{ static float _itmp449[] = {3.200e02,9.835e01,2.474e02,4.284e01,
	  4.125e00,7.283e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][17][j] = _itmp449[j];
		}
	}
	{ static float _itmp450[] = {8.828e01,2.249e01,1.048e01,2.022e02,
	  4.127e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][17][j] = _itmp450[j];
		}
	}
	{ static float _itmp451[] = {7.502e01,3.732e01,2.476e01,3.876e01,
	  6.142e00,1.882e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][17][j] = _itmp451[j];
		}
	}
	{ static float _itmp452[] = {3.228e03,6.171e02,1.548e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][17][j] = _itmp452[j];
		}
	}
	{ static float _itmp453[] = {3.642e02,1.010e02,1.120e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][17][j] = _itmp453[j];
		}
	}
	{ static float _itmp454[] = {2.987e02,1.073e02,2.007e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][17][j] = _itmp454[j];
		}
	}
	{ static float _itmp455[] = {7.174e01,2.269e01,9.306e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][17][j] = _itmp455[j];
		}
	}
	{ static float _itmp456[] = {5.981e01,3.958e01,3.058e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][17][j] = _itmp456[j];
		}
	}
	{ static float _itmp457[] = {3.216e03,8.408e02,8.071e00,1.847e02,
	  1.160e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][17][j] = _itmp457[j];
		}
	}
	{ static float _itmp458[] = {3.455e02,1.031e02,1.164e01,2.134e01,
	  4.657e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][17][j] = _itmp458[j];
		}
	}
	{ static float _itmp459[] = {2.801e02,1.025e02,2.281e02,4.380e01,
	  4.046e00,7.167e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][17][j] = _itmp459[j];
		}
	}
	{ static float _itmp460[] = {5.637e01,2.612e01,7.899e00,2.318e02,
	  3.961e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][17][j] = _itmp460[j];
		}
	}
	{ static float _itmp461[] = {4.074e01,3.862e01,3.973e01,3.208e01,
	  6.347e00,2.643e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][17][j] = _itmp461[j];
		}
	}
	{ static float _itmp462[] = {3.208e03,6.260e02,1.489e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][17][j] = _itmp462[j];
		}
	}
	{ static float _itmp463[] = {3.317e02,1.018e02,1.096e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][17][j] = _itmp463[j];
		}
	}
	{ static float _itmp464[] = {2.662e02,1.085e02,1.937e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][17][j] = _itmp464[j];
		}
	}
	{ static float _itmp465[] = {4.198e01,2.473e01,7.104e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][17][j] = _itmp465[j];
		}
	}
	{ static float _itmp466[] = {2.763e01,3.780e01,6.006e01,1.800e01,
	  7.200e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][17][j] = _itmp466[j];
		}
	}
}
static void blkdata10g(void)
{
	int j;
	{ static float _itmp467[] = {3.203e03,1.135e03,4.280e00,3.285e07,
	  7.631e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][17][j] = _itmp467[j];
		}
	}
	{ static float _itmp468[] = {3.260e02,1.302e02,9.185e00,2.693e01,
	  4.021e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][17][j] = _itmp468[j];
		}
	}
	{ static float _itmp469[] = {2.492e02,1.647e02,8.372e01,5.452e01,
	  3.328e00,6.270e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][17][j] = _itmp469[j];
		}
	}
	{ static float _itmp470[] = {2.892e01,2.525e01,6.394e00,1.700e02,
	  4.223e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][17][j] = _itmp470[j];
		}
	}
	{ static float _itmp471[] = {1.576e01,3.854e01,4.872e01,2.640e01,
	  6.662e00,2.355e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][17][j] = _itmp471[j];
		}
	}
	{ static float _itmp472[] = {4.934e03,1.559e02,1.517e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][18][j] = _itmp472[j];
		}
	}
	{ static float _itmp473[] = {4.611e03,5.177e02,2.589e01,3.282e01,
	  2.018e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][18][j] = _itmp473[j];
		}
	}
	{ static float _itmp474[] = {4.471e03,5.376e02,2.534e01,3.129e01,
	  1.966e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][18][j] = _itmp474[j];
		}
	}
	{ static float _itmp475[] = {1.035e03,1.155e02,8.875e00,3.732e01,
	  3.844e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][18][j] = _itmp475[j];
		}
	}
	{ static float _itmp476[] = {4.375e03,5.442e02,2.451e01,2.858e01,
	  2.005e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][18][j] = _itmp476[j];
		}
	}
	{ static float _itmp477[] = {9.680e02,8.979e01,2.067e01,3.141e01,
	  4.401e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][18][j] = _itmp477[j];
		}
	}
	{ static float _itmp478[] = {4.269e03,5.279e02,2.596e01,2.351e01,
	  2.144e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][18][j] = _itmp478[j];
		}
	}
	{ static float _itmp479[] = {8.935e02,1.199e02,1.483e01,2.724e01,
	  4.169e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][18][j] = _itmp479[j];
		}
	}
	{ static float _itmp480[] = {8.611e02,9.596e01,7.963e01,6.368e01,
	  3.884e00,1.487e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][18][j] = _itmp480[j];
		}
	}
	{ static float _itmp481[] = {4.166e03,5.297e02,2.562e01,2.213e01,
	  2.182e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][18][j] = _itmp481[j];
		}
	}
	{ static float _itmp482[] = {8.255e02,1.179e02,1.420e01,2.609e01,
	  4.262e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][18][j] = _itmp482[j];
		}
	}
	{ static float _itmp483[] = {7.867e02,1.054e02,1.244e02,6.541e01,
	  3.764e00,9.280e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][18][j] = _itmp483[j];
		}
	}
	{ static float _itmp484[] = {4.070e03,6.694e02,1.515e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][18][j] = _itmp484[j];
		}
	}
	{ static float _itmp485[] = {7.578e02,1.040e02,1.460e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][18][j] = _itmp485[j];
		}
	}
	{ static float _itmp486[] = {7.147e02,1.038e02,1.768e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][18][j] = _itmp486[j];
		}
	}
	{ static float _itmp487[] = {3.974e03,5.204e02,2.646e01,1.958e01,
	  2.282e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][18][j] = _itmp487[j];
		}
	}
	{ static float _itmp488[] = {6.945e02,1.112e02,1.306e01,2.458e01,
	  4.472e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][18][j] = _itmp488[j];
		}
	}
	{ static float _itmp489[] = {6.295e02,1.376e02,1.164e02,5.816e01,
	  3.609e00,8.872e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][18][j] = _itmp489[j];
		}
	}
	{ static float _itmp490[] = {3.890e03,6.796e02,1.446e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][18][j] = _itmp490[j];
		}
	}
	{ static float _itmp491[] = {6.310e02,1.080e02,1.218e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][18][j] = _itmp491[j];
		}
	}
	{ static float _itmp492[] = {5.647e02,1.071e02,2.272e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][18][j] = _itmp492[j];
		}
	}
	{ static float _itmp493[] = {3.799e03,5.158e02,2.685e01,1.837e01,
	  2.338e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][18][j] = _itmp493[j];
		}
	}
	{ static float _itmp494[] = {5.712e02,1.100e02,1.119e01,2.456e01,
	  4.565e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][18][j] = _itmp494[j];
		}
	}
	{ static float _itmp495[] = {5.038e02,1.558e02,1.104e02,5.635e01,
	  3.554e00,7.774e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][18][j] = _itmp495[j];
		}
	}
	{ static float _itmp496[] = {3.766e03,5.034e02,2.785e01,2.112e01,
	  2.275e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][18][j] = _itmp496[j];
		}
	}
	{ static float _itmp497[] = {5.413e02,8.084e01,1.395e01,2.604e01,
	  4.988e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][18][j] = _itmp497[j];
		}
	}
	{ static float _itmp498[] = {4.713e02,1.737e02,8.545e01,4.865e01,
	  3.547e00,8.892e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][18][j] = _itmp498[j];
		}
	}
	{ static float _itmp499[] = {1.758e02,1.352e01,1.538e01,7.752e02,
	  3.884e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][18][j] = _itmp499[j];
		}
	}
	{ static float _itmp500[] = {3.735e03,6.944e02,1.389e01,4.826e01,
	  1.635e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][18][j] = _itmp500[j];
		}
	}
	{ static float _itmp501[] = {5.133e02,1.060e02,1.113e01,2.784e01,
	  4.499e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][18][j] = _itmp501[j];
		}
	}
	{ static float _itmp502[] = {4.430e02,1.414e02,1.332e02,5.593e01,
	  3.674e00,7.309e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][18][j] = _itmp502[j];
		}
	}
	{ static float _itmp503[] = {1.547e02,1.930e01,1.619e01,3.223e02,
	  4.079e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][18][j] = _itmp503[j];
		}
	}
	{ static float _itmp504[] = {3.706e03,7.193e02,1.288e01,4.554e01,
	  1.628e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][18][j] = _itmp504[j];
		}
	}
	{ static float _itmp505[] = {4.868e02,1.155e02,1.017e01,2.932e01,
	  4.325e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][18][j] = _itmp505[j];
		}
	}
	{ static float _itmp506[] = {4.162e02,1.360e02,1.449e02,5.618e01,
	  3.706e00,6.504e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][18][j] = _itmp506[j];
		}
	}
	{ static float _itmp507[] = {1.344e02,3.470e01,9.467e00,1.032e03,
	  3.365e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][18][j] = _itmp507[j];
		}
	}
	{ static float _itmp508[] = {1.176e02,4.576e01,1.153e01,6.308e01,
	  5.520e00,2.470e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][18][j] = _itmp508[j];
		}
	}
	{ static float _itmp509[] = {3.679e03,8.147e02,9.835e00,9.408e01,
	  1.355e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][18][j] = _itmp509[j];
		}
	}
	{ static float _itmp510[] = {4.618e02,1.184e02,9.849e00,2.972e01,
	  4.280e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][18][j] = _itmp510[j];
		}
	}
	{ static float _itmp511[] = {3.909e02,2.054e02,5.562e01,1.347e04,
	  2.349e00,5.284e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][18][j] = _itmp511[j];
		}
	}
	{ static float _itmp512[] = {1.152e02,3.602e01,8.591e00,2.262e03,
	  3.242e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][18][j] = _itmp512[j];
		}
	}
	{ static float _itmp513[] = {9.944e01,5.453e01,1.638e01,9.114e01,
	  5.035e00,4.138e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][18][j] = _itmp513[j];
		}
	}
	{ static float _itmp514[] = {3.651e03,6.817e02,1.428e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][18][j] = _itmp514[j];
		}
	}
	{ static float _itmp515[] = {4.374e02,1.113e02,1.061e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][18][j] = _itmp515[j];
		}
	}
	{ static float _itmp516[] = {3.665e02,1.188e02,1.922e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][18][j] = _itmp516[j];
		}
	}
	{ static float _itmp517[] = {9.657e01,2.466e01,9.855e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][18][j] = _itmp517[j];
		}
	}
	{ static float _itmp518[] = {8.266e01,4.382e01,3.214e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][18][j] = _itmp518[j];
		}
	}
	{ static float _itmp519[] = {3.633e03,8.442e02,9.086e00,8.929e01,
	  1.343e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][18][j] = _itmp519[j];
		}
	}
	{ static float _itmp520[] = {4.165e02,1.249e02,9.136e00,3.259e01,
	  4.130e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][18][j] = _itmp520[j];
		}
	}
	{ static float _itmp521[] = {3.452e02,1.876e02,6.770e01,1.658e07,
	  2.363e00,4.546e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][18][j] = _itmp521[j];
		}
	}
	{ static float _itmp522[] = {7.925e01,3.296e01,7.619e00,1.323e03,
	  3.423e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][18][j] = _itmp522[j];
		}
	}
	{ static float _itmp523[] = {6.091e01,4.791e01,3.344e01,5.426e01,
	  5.626e00,3.140e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][18][j] = _itmp523[j];
		}
	}
	{ static float _itmp524[] = {3.623e03,6.897e02,1.383e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][18][j] = _itmp524[j];
		}
	}
	{ static float _itmp525[] = {3.990e02,1.121e02,1.039e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][18][j] = _itmp525[j];
		}
	}
	{ static float _itmp526[] = {3.279e02,1.199e02,1.862e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][18][j] = _itmp526[j];
		}
	}
	{ static float _itmp527[] = {6.269e01,2.670e01,7.455e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][18][j] = _itmp527[j];
		}
	}
	{ static float _itmp528[] = {4.581e01,4.055e01,6.784e01,1.800e01,
	  7.200e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][18][j] = _itmp528[j];
		}
	}
	{ static float _itmp529[] = {3.617e03,1.103e03,5.173e00,2.564e03,
	  8.917e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][18][j] = _itmp529[j];
		}
	}
	{ static float _itmp530[] = {3.867e02,1.488e02,7.085e00,6.561e01,
	  3.449e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][18][j] = _itmp530[j];
		}
	}
	{ static float _itmp531[] = {3.067e02,2.286e02,4.199e01,8.731e06,
	  2.239e00,5.560e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][18][j] = _itmp531[j];
		}
	}
	{ static float _itmp532[] = {4.728e01,2.985e01,6.625e00,3.001e02,
	  3.891e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][18][j] = _itmp532[j];
		}
	}
	{ static float _itmp533[] = {3.163e01,4.195e01,7.392e01,1.697e01,
	  7.208e00,2.531e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][18][j] = _itmp533[j];
		}
	}
	{ static float _itmp534[] = {3.614e03,1.171e03,4.540e00,6.165e03,
	  8.392e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][18][j] = _itmp534[j];
		}
	}
	{ static float _itmp535[] = {3.843e02,1.602e02,6.389e00,1.044e02,
	  3.159e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][18][j] = _itmp535[j];
		}
	}
	{ static float _itmp536[] = {3.014e02,2.666e02,3.107e01,7.187e06,
	  2.067e00,5.274e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][18][j] = _itmp536[j];
		}
	}
	{ static float _itmp537[] = {4.080e01,2.910e01,6.377e00,2.229e03,
	  3.587e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][18][j] = _itmp537[j];
		}
	}
	{ static float _itmp538[] = {2.466e01,4.138e01,2.614e01,2.143e02,
	  5.631e00,2.437e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][18][j] = _itmp538[j];
		}
	}
	{ static float _itmp539[] = {1.000e00,1.000e00,0.000e00,1.000e00,
	  1.000e00,1.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][18][j] = _itmp539[j];
		}
	}
	{ static float _itmp540[] = {4.341e00,3.824e00,7.363e-01,2.410e07,
	  4.427e00,2.049e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][18][18][j] = _itmp540[j];
		}
	}
	{ static float _itmp541[] = {5.470e03,1.729e02,1.369e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][19][j] = _itmp541[j];
		}
	}
	{ static float _itmp542[] = {5.129e03,6.297e02,1.936e01,3.921e01,
	  1.862e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][19][j] = _itmp542[j];
		}
	}
	{ static float _itmp543[] = {4.982e03,6.640e02,1.820e01,3.979e01,
	  1.777e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][19][j] = _itmp543[j];
		}
	}
	{ static float _itmp544[] = {1.157e03,9.395e01,1.115e01,3.959e01,
	  4.176e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][19][j] = _itmp544[j];
		}
	}
	{ static float _itmp545[] = {4.880e03,7.235e02,1.486e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][19][j] = _itmp545[j];
		}
	}
	{ static float _itmp546[] = {1.087e03,1.072e02,1.788e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][19][j] = _itmp546[j];
		}
	}
	{ static float _itmp547[] = {4.767e03,6.862e02,1.665e01,3.443e01,
	  1.823e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][19][j] = _itmp547[j];
		}
	}
	{ static float _itmp548[] = {1.008e03,1.169e02,1.552e01,2.618e01,
	  4.389e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][19][j] = _itmp548[j];
		}
	}
	{ static float _itmp549[] = {9.745e02,4.041e01,5.215e02,1.044e02,
	  4.452e00,1.164e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][19][j] = _itmp549[j];
		}
	}
	{ static float _itmp550[] = {4.659e03,7.342e02,1.417e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][19][j] = _itmp550[j];
		}
	}
	{ static float _itmp551[] = {9.357e02,1.122e02,1.490e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][19][j] = _itmp551[j];
		}
	}
	{ static float _itmp552[] = {8.946e02,1.144e02,1.199e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][19][j] = _itmp552[j];
		}
	}
	{ static float _itmp553[] = {4.555e03,7.396e02,1.384e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][19][j] = _itmp553[j];
		}
	}
	{ static float _itmp554[] = {8.642e02,1.145e02,1.363e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][19][j] = _itmp554[j];
		}
	}
	{ static float _itmp555[] = {8.177e02,1.152e02,1.643e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][19][j] = _itmp555[j];
		}
	}
	{ static float _itmp556[] = {4.453e03,6.989e02,1.570e01,3.218e01,
	  1.851e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][19][j] = _itmp556[j];
		}
	}
	{ static float _itmp557[] = {7.968e02,1.154e02,1.287e01,2.461e01,
	  4.561e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][19][j] = _itmp557[j];
		}
	}
}
static void blkdata10h(void)
{
	int j;
	{ static float _itmp558[] = {7.267e02,8.942e01,3.336e02,5.766e01,
	  4.171e00,1.104e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][19][j] = _itmp558[j];
		}
	}
	{ static float _itmp559[] = {4.362e03,7.503e02,1.324e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][19][j] = _itmp559[j];
		}
	}
	{ static float _itmp560[] = {7.287e02,1.187e02,1.147e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][19][j] = _itmp560[j];
		}
	}
	{ static float _itmp561[] = {6.572e02,1.184e02,2.157e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][19][j] = _itmp561[j];
		}
	}
	{ static float _itmp562[] = {4.265e03,7.010e02,1.547e01,3.197e01,
	  1.858e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][19][j] = _itmp562[j];
		}
	}
	{ static float _itmp563[] = {6.649e02,9.384e01,1.413e01,1.780e01,
	  5.361e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][19][j] = _itmp563[j];
		}
	}
	{ static float _itmp564[] = {5.919e02,7.052e01,5.909e02,4.129e01,
	  4.878e00,7.117e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][19][j] = _itmp564[j];
		}
	}
	{ static float _itmp565[] = {4.229e03,6.805e02,1.642e01,3.522e01,
	  1.842e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][19][j] = _itmp565[j];
		}
	}
	{ static float _itmp566[] = {6.326e02,8.448e01,1.359e01,2.702e01,
	  5.021e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][19][j] = _itmp566[j];
		}
	}
	{ static float _itmp567[] = {5.569e02,6.511e01,6.616e02,4.371e01,
	  4.937e00,7.881e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][19][j] = _itmp567[j];
		}
	}
	{ static float _itmp568[] = {2.113e02,1.605e01,1.437e01,6.989e02,
	  3.857e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][19][j] = _itmp568[j];
		}
	}
	{ static float _itmp569[] = {4.198e03,7.401e02,1.369e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][19][j] = _itmp569[j];
		}
	}
	{ static float _itmp570[] = {6.018e02,1.203e02,1.052e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][19][j] = _itmp570[j];
		}
	}
	{ static float _itmp571[] = {5.270e02,1.293e02,1.934e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][19][j] = _itmp571[j];
		}
	}
	{ static float _itmp572[] = {1.883e02,2.552e01,1.335e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][19][j] = _itmp572[j];
		}
	}
	{ static float _itmp573[] = {4.163e03,7.816e02,1.217e01,4.492e01,
	  1.646e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][19][j] = _itmp573[j];
		}
	}
	{ static float _itmp574[] = {5.732e02,1.243e02,9.859e00,2.823e01,
	  4.388e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][19][j] = _itmp574[j];
		}
	}
	{ static float _itmp575[] = {4.967e02,1.070e02,2.788e02,4.768e01,
	  4.200e00,4.591e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][19][j] = _itmp575[j];
		}
	}
	{ static float _itmp576[] = {1.664e02,3.989e01,9.257e00,9.884e02,
	  3.326e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][19][j] = _itmp576[j];
		}
	}
	{ static float _itmp577[] = {1.472e02,5.202e01,1.127e01,6.821e01,
	  5.408e00,2.204e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][19][j] = _itmp577[j];
		}
	}
	{ static float _itmp578[] = {4.133e03,8.261e02,1.079e01,5.751e01,
	  1.531e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][19][j] = _itmp578[j];
		}
	}
	{ static float _itmp579[] = {5.455e02,1.268e02,9.589e00,2.852e01,
	  4.353e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][19][j] = _itmp579[j];
		}
	}
	{ static float _itmp580[] = {4.687e02,1.208e02,2.181e02,5.816e01,
	  3.907e00,4.346e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][19][j] = _itmp580[j];
		}
	}
	{ static float _itmp581[] = {1.452e02,4.100e01,8.521e00,1.977e03,
	  3.218e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][19][j] = _itmp581[j];
		}
	}
	{ static float _itmp582[] = {1.272e02,6.097e01,1.648e01,9.236e01,
	  5.007e00,4.261e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][19][j] = _itmp582[j];
		}
	}
	{ static float _itmp583[] = {4.105e03,8.505e02,1.012e01,6.416e01,
	  1.482e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][19][j] = _itmp583[j];
		}
	}
	{ static float _itmp584[] = {5.193e02,1.297e02,9.293e00,2.927e01,
	  4.300e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][19][j] = _itmp584[j];
		}
	}
	{ static float _itmp585[] = {4.423e02,1.303e02,1.855e02,6.993e01,
	  3.707e00,1.400e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][19][j] = _itmp585[j];
		}
	}
	{ static float _itmp586[] = {1.249e02,3.994e01,8.068e00,2.341e03,
	  3.235e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][19][j] = _itmp586[j];
		}
	}
	{ static float _itmp587[] = {1.088e02,5.749e01,2.483e01,7.819e01,
	  5.203e00,3.800e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][19][j] = _itmp587[j];
		}
	}
	{ static float _itmp588[] = {4.078e03,8.635e02,9.791e00,6.215e01,
	  1.479e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][19][j] = _itmp588[j];
		}
	}
	{ static float _itmp589[] = {4.948e02,1.315e02,9.126e00,2.928e01,
	  4.281e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][19][j] = _itmp589[j];
		}
	}
	{ static float _itmp590[] = {4.175e02,1.384e02,1.622e02,8.811e01,
	  3.521e00,4.384e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][19][j] = _itmp590[j];
		}
	}
	{ static float _itmp591[] = {1.054e02,3.722e01,7.757e00,1.194e03,
	  3.398e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][19][j] = _itmp591[j];
		}
	}
	{ static float _itmp592[] = {8.451e01,5.673e01,3.044e01,7.647e01,
	  5.265e00,3.557e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][19][j] = _itmp592[j];
		}
	}
	{ static float _itmp593[] = {4.063e03,9.606e02,7.782e00,1.191e02,
	  1.271e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][19][j] = _itmp593[j];
		}
	}
	{ static float _itmp594[] = {4.719e02,1.373e02,8.622e00,3.169e01,
	  4.152e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][19][j] = _itmp594[j];
		}
	}
	{ static float _itmp595[] = {3.944e02,1.413e02,1.542e02,9.906e01,
	  3.446e00,1.107e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][19][j] = _itmp595[j];
		}
	}
	{ static float _itmp596[] = {8.680e01,3.645e01,7.134e00,1.200e03,
	  3.447e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][19][j] = _itmp596[j];
		}
	}
	{ static float _itmp597[] = {6.727e01,5.169e01,4.224e01,4.415e01,
	  5.864e00,3.052e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][19][j] = _itmp597[j];
		}
	}
	{ static float _itmp598[] = {4.053e03,1.003e03,7.079e00,1.108e02,
	  1.256e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][19][j] = _itmp598[j];
		}
	}
	{ static float _itmp599[] = {4.542e02,1.483e02,7.770e00,3.866e01,
	  3.891e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][19][j] = _itmp599[j];
		}
	}
	{ static float _itmp600[] = {3.731e02,1.260e02,1.945e02,6.819e01,
	  3.770e00,4.791e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][19][j] = _itmp600[j];
		}
	}
	{ static float _itmp601[] = {6.920e01,3.504e01,6.596e00,7.909e02,
	  3.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][19][j] = _itmp601[j];
		}
	}
	{ static float _itmp602[] = {5.091e01,4.617e01,7.930e01,1.711e01,
	  7.186e00,2.658e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][19][j] = _itmp602[j];
		}
	}
	{ static float _itmp603[] = {4.047e03,7.997e02,1.168e01,3.233e01,
	  1.744e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][19][j] = _itmp603[j];
		}
	}
	{ static float _itmp604[] = {4.445e02,1.335e02,8.939e00,2.914e01,
	  4.269e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][19][j] = _itmp604[j];
		}
	}
	{ static float _itmp605[] = {3.638e02,1.448e02,1.446e02,1.349e02,
	  3.300e00,3.358e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][19][j] = _itmp605[j];
		}
	}
	{ static float _itmp606[] = {6.037e01,3.176e01,6.924e00,5.246e02,
	  3.771e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][19][j] = _itmp606[j];
		}
	}
	{ static float _itmp607[] = {4.090e01,4.498e01,7.314e01,1.898e01,
	  7.152e00,2.735e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][19][j] = _itmp607[j];
		}
	}
	{ static float _itmp608[] = {1.000e00,1.000e00,0.000e00,1.000e00,
	  1.000e00,1.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][19][j] = _itmp608[j];
		}
	}
	{ static float _itmp609[] = {1.187e01,4.155e00,2.235e00,1.595e04,
	  4.313e00,3.539e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][18][19][j] = _itmp609[j];
		}
	}
	{ static float _itmp610[] = {4.043e03,6.947e02,1.586e01,2.563e01,
	  1.966e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][19][j] = _itmp610[j];
		}
	}
	{ static float _itmp611[] = {4.425e02,1.201e02,1.010e01,2.468e01,
	  4.592e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][19][j] = _itmp611[j];
		}
	}
	{ static float _itmp612[] = {3.523e02,1.529e02,1.282e02,2.217e02,
	  3.087e00,3.343e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][19][j] = _itmp612[j];
		}
	}
	{ static float _itmp613[] = {4.830e01,3.012e01,7.227e00,1.736e02,
	  4.165e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][19][j] = _itmp613[j];
		}
	}
	{ static float _itmp614[] = {3.443e01,4.487e01,9.017e01,1.465e01,
	  7.498e00,2.754e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][19][j] = _itmp614[j];
		}
	}
	{ static float _itmp615[] = {1.000e00,1.000e00,0.000e00,1.000e00,
	  1.000e00,1.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][19][j] = _itmp615[j];
		}
	}
	{ static float _itmp616[] = {6.113e00,7.366e00,2.373e00,2.082e02,
	  4.841e00,5.841e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][19][19][j] = _itmp616[j];
		}
	}
	{ static float _itmp617[] = {6.034e03,1.907e02,1.241e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][20][j] = _itmp617[j];
		}
	}
	{ static float _itmp618[] = {5.675e03,6.267e02,2.182e01,3.452e01,
	  1.998e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][20][j] = _itmp618[j];
		}
	}
	{ static float _itmp619[] = {5.520e03,6.439e02,2.169e01,3.290e01,
	  1.960e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][20][j] = _itmp619[j];
		}
	}
	{ static float _itmp620[] = {1.288e03,1.197e02,8.820e00,3.718e01,
	  4.054e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][20][j] = _itmp620[j];
		}
	}
	{ static float _itmp621[] = {5.413e03,6.607e02,2.038e01,3.109e01,
	  1.971e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][20][j] = _itmp621[j];
		}
	}
	{ static float _itmp622[] = {1.213e03,1.109e02,1.725e01,3.167e01,
	  4.371e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][20][j] = _itmp622[j];
		}
	}
	{ static float _itmp623[] = {5.294e03,6.684e02,1.971e01,2.792e01,
	  2.022e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][20][j] = _itmp623[j];
		}
	}
	{ static float _itmp624[] = {1.130e03,1.386e02,1.325e01,2.785e01,
	  4.218e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][20][j] = _itmp624[j];
		}
	}
	{ static float _itmp625[] = {1.094e03,1.435e02,4.807e01,8.557e01,
	  3.452e00,4.096e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][20][j] = _itmp625[j];
		}
	}
	{ static float _itmp626[] = {5.178e03,6.752e02,1.918e01,2.616e01,
	  2.052e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][20][j] = _itmp626[j];
		}
	}
	{ static float _itmp627[] = {1.054e03,1.367e02,1.270e01,2.670e01,
	  4.303e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][20][j] = _itmp627[j];
		}
	}
	{ static float _itmp628[] = {1.009e03,1.269e02,1.155e02,8.134e01,
	  3.618e00,1.480e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][20][j] = _itmp628[j];
		}
	}
	{ static float _itmp629[] = {5.067e03,8.133e02,1.269e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][20][j] = _itmp629[j];
		}
	}
	{ static float _itmp630[] = {9.775e02,1.256e02,1.274e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][20][j] = _itmp630[j];
		}
	}
	{ static float _itmp631[] = {9.275e02,1.273e02,1.529e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][20][j] = _itmp631[j];
		}
	}
	{ static float _itmp632[] = {4.960e03,6.739e02,1.909e01,2.432e01,
	  2.101e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][20][j] = _itmp632[j];
		}
	}
	{ static float _itmp633[] = {9.062e02,1.274e02,1.195e01,2.504e01,
	  4.532e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][20][j] = _itmp633[j];
		}
	}
	{ static float _itmp634[] = {8.308e02,7.899e01,4.780e02,6.650e01,
	  4.304e00,9.238e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][20][j] = _itmp634[j];
		}
	}
	{ static float _itmp635[] = {4.861e03,8.244e02,1.216e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][20][j] = _itmp635[j];
		}
	}
	{ static float _itmp636[] = {8.333e02,1.300e02,1.081e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][20][j] = _itmp636[j];
		}
	}
	{ static float _itmp637[] = {7.567e02,1.304e02,2.045e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][20][j] = _itmp637[j];
		}
	}
	{ static float _itmp638[] = {4.759e03,6.781e02,1.869e01,2.393e01,
	  2.110e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][20][j] = _itmp638[j];
		}
	}
	{ static float _itmp639[] = {7.657e02,1.156e02,1.130e01,2.296e01,
	  4.853e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][20][j] = _itmp639[j];
		}
	}
	{ static float _itmp640[] = {6.874e02,8.313e01,5.075e02,4.739e01,
	  4.637e00,3.716e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][20][j] = _itmp640[j];
		}
	}
	{ static float _itmp641[] = {4.720e03,6.682e02,1.915e01,2.701e01,
	  2.060e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][20][j] = _itmp641[j];
		}
	}
	{ static float _itmp642[] = {7.309e02,7.807e01,1.420e01,2.694e01,
	  5.297e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][20][j] = _itmp642[j];
		}
	}
	{ static float _itmp643[] = {6.505e02,8.091e01,5.240e02,4.759e01,
	  4.674e00,3.660e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][20][j] = _itmp643[j];
		}
	}
	{ static float _itmp644[] = {2.498e02,3.414e00,5.976e01,1.109e03,
	  4.577e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][20][j] = _itmp644[j];
		}
	}
}
static void blkdata10i(void)
{
	int j;
	{ static float _itmp645[] = {4.684e03,7.696e02,1.415e01,3.494e01,
	  1.825e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][20][j] = _itmp645[j];
		}
	}
	{ static float _itmp646[] = {6.982e02,1.019e02,1.215e01,2.361e01,
	  5.033e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][20][j] = _itmp646[j];
		}
	}
	{ static float _itmp647[] = {6.173e02,1.007e02,3.568e02,4.400e01,
	  4.463e00,3.640e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][20][j] = _itmp647[j];
		}
	}
	{ static float _itmp648[] = {2.251e02,1.104e01,2.980e01,3.451e02,
	  4.545e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][20][j] = _itmp648[j];
		}
	}
	{ static float _itmp649[] = {4.649e03,8.283e02,1.206e01,4.105e01,
	  1.707e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][20][j] = _itmp649[j];
		}
	}
	{ static float _itmp650[] = {6.666e02,1.131e02,1.124e01,2.303e01,
	  4.893e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][20][j] = _itmp650[j];
		}
	}
	{ static float _itmp651[] = {5.852e02,1.050e02,3.290e02,4.379e01,
	  4.411e00,3.675e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][20][j] = _itmp651[j];
		}
	}
	{ static float _itmp652[] = {2.015e02,1.499e01,2.155e01,2.761e02,
	  4.455e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][20][j] = _itmp652[j];
		}
	}
	{ static float _itmp653[] = {1.800e02,4.763e01,1.441e01,4.454e01,
	  6.085e00,5.576e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][20][j] = _itmp653[j];
		}
	}
	{ static float _itmp654[] = {4.615e03,9.428e02,9.117e00,7.840e01,
	  1.428e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][20][j] = _itmp654[j];
		}
	}
	{ static float _itmp655[] = {6.362e02,1.182e02,1.081e01,2.278e01,
	  4.836e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][20][j] = _itmp655[j];
		}
	}
	{ static float _itmp656[] = {5.544e02,1.106e02,2.980e02,4.355e01,
	  4.348e00,3.645e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][20][j] = _itmp656[j];
		}
	}
	{ static float _itmp657[] = {1.784e02,2.031e01,1.547e01,2.264e02,
	  4.346e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][20][j] = _itmp657[j];
		}
	}
	{ static float _itmp658[] = {1.581e02,4.941e01,2.617e01,4.344e01,
	  6.056e00,6.050e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][20][j] = _itmp658[j];
		}
	}
	{ static float _itmp659[] = {4.582e03,8.245e02,1.210e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][20][j] = _itmp659[j];
		}
	}
	{ static float _itmp660[] = {6.052e02,1.335e02,9.523e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][20][j] = _itmp660[j];
		}
	}
	{ static float _itmp661[] = {5.236e02,1.434e02,1.765e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][20][j] = _itmp661[j];
		}
	}
	{ static float _itmp662[] = {1.557e02,2.891e01,1.052e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][20][j] = _itmp662[j];
		}
	}
	{ static float _itmp663[] = {1.380e02,5.322e01,3.348e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][20][j] = _itmp663[j];
		}
	}
	{ static float _itmp664[] = {4.554e03,9.555e02,8.840e00,7.637e01,
	  1.426e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][20][j] = _itmp664[j];
		}
	}
	{ static float _itmp665[] = {5.803e02,1.249e02,1.026e01,2.249e01,
	  4.764e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][20][j] = _itmp665[j];
		}
	}
	{ static float _itmp666[] = {4.977e02,1.266e02,2.303e02,4.517e01,
	  4.139e00,3.408e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][20][j] = _itmp666[j];
		}
	}
	{ static float _itmp667[] = {1.348e02,2.899e01,9.855e00,1.921e02,
	  4.175e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][20][j] = _itmp667[j];
		}
	}
	{ static float _itmp668[] = {1.107e02,5.034e01,4.505e01,3.882e01,
	  6.159e00,6.694e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][20][j] = _itmp668[j];
		}
	}
	{ static float _itmp669[] = {4.531e03,8.307e02,1.185e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][20][j] = _itmp669[j];
		}
	}
	{ static float _itmp670[] = {5.552e02,1.344e02,9.326e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][20][j] = _itmp670[j];
		}
	}
	{ static float _itmp671[] = {4.730e02,1.444e02,1.721e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][20][j] = _itmp671[j];
		}
	}
	{ static float _itmp672[] = {1.141e02,3.036e01,8.550e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][20][j] = _itmp672[j];
		}
	}
	{ static float _itmp673[] = {9.187e01,5.439e01,4.585e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][20][j] = _itmp673[j];
		}
	}
	{ static float _itmp674[] = {4.517e03,9.957e02,8.077e00,7.124e01,
	  1.415e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][20][j] = _itmp674[j];
		}
	}
	{ static float _itmp675[] = {5.306e02,1.371e02,9.401e00,2.320e01,
	  4.579e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][20][j] = _itmp675[j];
		}
	}
	{ static float _itmp676[] = {4.476e02,1.422e02,1.820e02,5.428e01,
	  3.854e00,3.269e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][20][j] = _itmp676[j];
		}
	}
	{ static float _itmp677[] = {9.451e01,3.451e01,7.316e00,1.881e02,
	  4.071e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][20][j] = _itmp677[j];
		}
	}
	{ static float _itmp678[] = {7.349e01,5.468e01,5.377e01,3.321e01,
	  6.239e00,2.941e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][20][j] = _itmp678[j];
		}
	}
	{ static float _itmp679[] = {4.508e03,1.030e03,7.512e00,6.545e01,
	  1.410e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][20][j] = _itmp679[j];
		}
	}
	{ static float _itmp680[] = {5.148e02,1.443e02,8.939e00,2.406e01,
	  4.456e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][20][j] = _itmp680[j];
		}
	}
	{ static float _itmp681[] = {4.285e02,1.348e02,2.014e02,5.215e01,
	  3.952e00,3.368e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][20][j] = _itmp681[j];
		}
	}
	{ static float _itmp682[] = {7.762e01,3.513e01,6.785e00,1.898e02,
	  4.068e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][20][j] = _itmp682[j];
		}
	}
	{ static float _itmp683[] = {5.591e01,5.169e01,5.465e01,2.788e01,
	  6.613e00,2.567e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][20][j] = _itmp683[j];
		}
	}
	{ static float _itmp684[] = {2.476e01,2.183e01,8.459e01,6.603e01,
	  6.452e00,3.890e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][20][j] = _itmp684[j];
		}
	}
	{ static float _itmp685[] = {4.500e03,7.669e02,1.437e01,2.629e01,
	  1.953e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][20][j] = _itmp685[j];
		}
	}
	{ static float _itmp686[] = {5.054e02,1.274e02,1.003e01,2.215e01,
	  4.755e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][20][j] = _itmp686[j];
		}
	}
	{ static float _itmp687[] = {4.190e02,1.472e02,1.711e02,5.517e01,
	  3.796e00,3.289e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][20][j] = _itmp687[j];
		}
	}
	{ static float _itmp688[] = {6.848e01,3.246e01,6.970e00,1.757e02,
	  4.198e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][20][j] = _itmp688[j];
		}
	}
	{ static float _itmp689[] = {4.678e01,4.990e01,5.795e01,2.476e01,
	  6.870e00,2.658e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][20][j] = _itmp689[j];
		}
	}
	{ static float _itmp690[] = {1.444e01,1.611e01,1.269e02,5.229e01,
	  7.300e00,3.103e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][20][j] = _itmp690[j];
		}
	}
	{ static float _itmp691[] = {1.280e01,3.837e00,1.909e00,5.825e02,
	  5.018e00,1.415e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][19][20][j] = _itmp691[j];
		}
	}
	{ static float _itmp692[] = {4.494e03,7.367e02,1.554e01,2.940e01,
	  1.937e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][20][j] = _itmp692[j];
		}
	}
	{ static float _itmp693[] = {5.032e02,1.180e02,1.065e01,2.172e01,
	  4.911e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][20][j] = _itmp693[j];
		}
	}
	{ static float _itmp694[] = {4.054e02,1.593e02,1.473e02,6.007e01,
	  3.635e00,3.208e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][20][j] = _itmp694[j];
		}
	}
	{ static float _itmp695[] = {5.640e01,3.284e01,6.849e00,1.709e02,
	  4.207e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][20][j] = _itmp695[j];
		}
	}
	{ static float _itmp696[] = {3.360e01,4.936e01,6.176e01,2.186e01,
	  7.081e00,2.671e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][20][j] = _itmp696[j];
		}
	}
	{ static float _itmp697[] = {8.010e00,9.733e00,2.488e02,2.066e01,
	  1.022e01,3.104e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][20][j] = _itmp697[j];
		}
	}
	{ static float _itmp698[] = {7.342e00,8.324e00,2.252e00,4.118e02,
	  4.588e00,1.441e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][20][20][j] = _itmp698[j];
		}
	}
	{ static float _itmp699[] = {6.626e03,2.094e02,1.131e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][21][j] = _itmp699[j];
		}
	}
	{ static float _itmp700[] = {6.249e03,8.656e02,1.234e01,5.893e01,
	  1.622e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][21][j] = _itmp700[j];
		}
	}
	{ static float _itmp701[] = {6.087e03,8.854e02,1.240e01,8.225e01,
	  1.477e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][21][j] = _itmp701[j];
		}
	}
	{ static float _itmp702[] = {1.425e03,1.025e02,1.038e01,4.131e01,
	  4.265e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][21][j] = _itmp702[j];
		}
	}
	{ static float _itmp703[] = {5.974e03,7.415e02,1.773e01,3.385e01,
	  1.915e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][21][j] = _itmp703[j];
		}
	}
	{ static float _itmp704[] = {1.346e03,1.388e02,1.408e01,3.133e01,
	  4.198e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][21][j] = _itmp704[j];
		}
	}
	{ static float _itmp705[] = {5.848e03,7.545e02,1.694e01,3.060e01,
	  1.955e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][21][j] = _itmp705[j];
		}
	}
	{ static float _itmp706[] = {1.260e03,1.433e02,1.296e01,2.842e01,
	  4.278e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][21][j] = _itmp706[j];
		}
	}
	{ static float _itmp707[] = {1.221e03,1.686e02,3.856e01,9.198e01,
	  3.355e00,3.372e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][21][j] = _itmp707[j];
		}
	}
	{ static float _itmp708[] = {5.726e03,7.617e02,1.648e01,2.934e01,
	  1.972e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][21][j] = _itmp708[j];
		}
	}
	{ static float _itmp709[] = {1.179e03,1.419e02,1.240e01,2.693e01,
	  4.373e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][21][j] = _itmp709[j];
		}
	}
	{ static float _itmp710[] = {1.131e03,1.291e02,1.268e02,8.686e01,
	  3.655e00,1.321e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][21][j] = _itmp710[j];
		}
	}
	{ static float _itmp711[] = {5.607e03,8.905e02,1.167e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][21][j] = _itmp711[j];
		}
	}
	{ static float _itmp712[] = {1.098e03,1.372e02,1.192e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][21][j] = _itmp712[j];
		}
	}
	{ static float _itmp713[] = {1.044e03,1.401e02,1.425e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][21][j] = _itmp713[j];
		}
	}
	{ static float _itmp714[] = {5.495e03,7.690e02,1.599e01,2.789e01,
	  1.997e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][21][j] = _itmp714[j];
		}
	}
	{ static float _itmp715[] = {1.022e03,1.341e02,1.154e01,2.533e01,
	  4.576e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][21][j] = _itmp715[j];
		}
	}
	{ static float _itmp716[] = {9.419e02,1.084e02,2.972e02,6.609e01,
	  4.056e00,1.465e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][21][j] = _itmp716[j];
		}
	}
	{ static float _itmp717[] = {5.387e03,9.021e02,1.121e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][21][j] = _itmp717[j];
		}
	}
	{ static float _itmp718[] = {9.448e02,1.417e02,1.019e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][21][j] = _itmp718[j];
		}
	}
	{ static float _itmp719[] = {8.631e02,1.430e02,1.937e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][21][j] = _itmp719[j];
		}
	}
	{ static float _itmp720[] = {5.281e03,7.712e02,1.576e01,2.765e01,
	  2.005e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][21][j] = _itmp720[j];
		}
	}
	{ static float _itmp721[] = {8.734e02,1.250e02,1.070e01,2.364e01,
	  4.830e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][21][j] = _itmp721[j];
		}
	}
	{ static float _itmp722[] = {7.878e02,9.852e01,4.256e02,4.955e01,
	  4.485e00,1.750e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][21][j] = _itmp722[j];
		}
	}
	{ static float _itmp723[] = {5.239e03,7.394e02,1.717e01,2.884e01,
	  2.020e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][21][j] = _itmp723[j];
		}
	}
	{ static float _itmp724[] = {8.363e02,9.240e01,1.291e01,2.687e01,
	  5.160e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][21][j] = _itmp724[j];
		}
	}
	{ static float _itmp725[] = {7.511e02,9.404e01,4.550e02,5.003e01,
	  4.543e00,1.753e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][21][j] = _itmp725[j];
		}
	}
	{ static float _itmp726[] = {2.915e02,3.359e00,6.875e01,1.244e03,
	  4.559e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][21][j] = _itmp726[j];
		}
	}
	{ static float _itmp727[] = {5.200e03,9.318e02,1.045e01,5.288e01,
	  1.604e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][21][j] = _itmp727[j];
		}
	}
	{ static float _itmp728[] = {8.013e02,1.259e02,1.049e01,2.445e01,
	  4.779e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][21][j] = _itmp728[j];
		}
	}
	{ static float _itmp729[] = {7.156e02,1.122e02,3.306e02,4.701e01,
	  4.376e00,1.686e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][21][j] = _itmp729[j];
		}
	}
	{ static float _itmp730[] = {2.650e02,9.778e00,3.726e01,4.225e02,
	  4.552e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][21][j] = _itmp730[j];
		}
	}
	{ static float _itmp731[] = {5.162e03,9.469e02,1.008e01,5.127e01,
	  1.603e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][21][j] = _itmp731[j];
		}
	}
	{ static float _itmp732[] = {7.670e02,1.254e02,1.046e01,2.368e01,
	  4.830e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][21][j] = _itmp732[j];
		}
	}
	{ static float _itmp733[] = {6.807e02,1.133e02,3.222e02,4.654e01,
	  4.373e00,1.686e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][21][j] = _itmp733[j];
		}
	}
	{ static float _itmp734[] = {2.397e02,1.712e01,2.117e01,2.738e02,
	  4.407e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][21][j] = _itmp734[j];
		}
	}
	{ static float _itmp735[] = {2.159e02,5.265e01,1.405e01,4.648e01,
	  6.025e00,8.018e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][21][j] = _itmp735[j];
		}
	}
	{ static float _itmp736[] = {5.126e03,9.454e02,1.011e01,5.151e01,
	  1.603e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][21][j] = _itmp736[j];
		}
	}
}
static void blkdata10j(void)
{
	int j;
	{ static float _itmp737[] = {7.342e02,1.245e02,1.045e01,2.319e01,
	  4.873e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][21][j] = _itmp737[j];
		}
	}
	{ static float _itmp738[] = {6.473e02,1.160e02,3.065e02,4.592e01,
	  4.355e00,1.680e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][21][j] = _itmp738[j];
		}
	}
	{ static float _itmp739[] = {2.148e02,1.736e01,1.941e01,2.691e02,
	  4.420e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][21][j] = _itmp739[j];
		}
	}
	{ static float _itmp740[] = {1.921e02,5.337e01,2.611e01,4.514e01,
	  6.042e00,7.441e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][21][j] = _itmp740[j];
		}
	}
	{ static float _itmp741[] = {5.089e03,9.027e02,1.114e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][21][j] = _itmp741[j];
		}
	}
	{ static float _itmp742[] = {6.999e02,1.454e02,9.019e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][21][j] = _itmp742[j];
		}
	}
	{ static float _itmp743[] = {6.129e02,1.565e02,1.694e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][21][j] = _itmp743[j];
		}
	}
	{ static float _itmp744[] = {1.900e02,3.119e01,1.069e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][21][j] = _itmp744[j];
		}
	}
	{ static float _itmp745[] = {1.704e02,5.839e01,3.348e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][21][j] = _itmp745[j];
		}
	}
	{ static float _itmp746[] = {5.059e03,9.613e02,9.746e00,5.327e01,
	  1.581e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][21][j] = _itmp746[j];
		}
	}
	{ static float _itmp747[] = {6.729e02,1.313e02,9.948e00,2.269e01,
	  4.817e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][21][j] = _itmp747[j];
		}
	}
	{ static float _itmp748[] = {5.853e02,1.296e02,2.477e02,4.576e01,
	  4.216e00,1.795e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][21][j] = _itmp748[j];
		}
	}
	{ static float _itmp749[] = {1.673e02,2.786e01,1.099e01,1.974e02,
	  4.259e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][21][j] = _itmp749[j];
		}
	}
	{ static float _itmp750[] = {1.408e02,5.484e01,4.527e01,3.999e01,
	  6.137e00,9.213e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][21][j] = _itmp750[j];
		}
	}
	{ static float _itmp751[] = {5.027e03,9.080e02,1.096e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][21][j] = _itmp751[j];
		}
	}
	{ static float _itmp752[] = {6.441e02,1.464e02,8.835e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][21][j] = _itmp752[j];
		}
	}
	{ static float _itmp753[] = {5.563e02,1.574e02,1.656e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][21][j] = _itmp753[j];
		}
	}
	{ static float _itmp754[] = {1.445e02,3.258e01,8.817e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][21][j] = _itmp754[j];
		}
	}
	{ static float _itmp755[] = {1.195e02,5.940e01,4.665e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][21][j] = _itmp755[j];
		}
	}
	{ static float _itmp756[] = {5.011e03,1.031e03,8.364e00,6.468e01,
	  1.478e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][21][j] = _itmp756[j];
		}
	}
	{ static float _itmp757[] = {6.178e02,1.446e02,9.107e00,2.319e01,
	  4.635e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][21][j] = _itmp757[j];
		}
	}
	{ static float _itmp758[] = {5.296e02,1.466e02,1.952e02,4.874e01,
	  4.006e00,1.732e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][21][j] = _itmp758[j];
		}
	}
	{ static float _itmp759[] = {1.231e02,3.545e01,7.729e00,1.792e02,
	  4.142e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][21][j] = _itmp759[j];
		}
	}
	{ static float _itmp760[] = {9.930e01,5.902e01,5.520e01,3.434e01,
	  6.226e00,2.921e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][21][j] = _itmp760[j];
		}
	}
	{ static float _itmp761[] = {4.998e03,1.048e03,8.085e00,6.252e01,
	  1.476e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][21][j] = _itmp761[j];
		}
	}
	{ static float _itmp762[] = {5.949e02,1.452e02,9.082e00,2.289e01,
	  4.645e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][21][j] = _itmp762[j];
		}
	}
	{ static float _itmp763[] = {5.066e02,1.497e02,1.878e02,4.955e01,
	  3.967e00,1.717e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][21][j] = _itmp763[j];
		}
	}
	{ static float _itmp764[] = {1.035e02,3.700e01,6.988e00,1.778e02,
	  4.126e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][21][j] = _itmp764[j];
		}
	}
	{ static float _itmp765[] = {7.917e01,5.872e01,5.237e01,3.131e01,
	  6.379e00,2.839e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][21][j] = _itmp765[j];
		}
	}
	{ static float _itmp766[] = {4.327e01,2.624e01,9.279e01,6.851e01,
	  6.300e00,3.297e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][21][j] = _itmp766[j];
		}
	}
	{ static float _itmp767[] = {4.988e03,1.086e03,7.494e00,5.795e01,
	  1.469e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][21][j] = _itmp767[j];
		}
	}
	{ static float _itmp768[] = {5.792e02,1.542e02,8.585e00,2.370e01,
	  4.508e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][21][j] = _itmp768[j];
		}
	}
	{ static float _itmp769[] = {4.870e02,1.508e02,1.834e02,5.660e01,
	  3.868e00,1.691e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][21][j] = _itmp769[j];
		}
	}
	{ static float _itmp770[] = {8.603e01,3.786e01,6.489e00,1.768e02,
	  4.124e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][21][j] = _itmp770[j];
		}
	}
	{ static float _itmp771[] = {6.201e01,5.643e01,5.284e01,2.686e01,
	  6.696e00,2.571e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][21][j] = _itmp771[j];
		}
	}
	{ static float _itmp772[] = {2.749e01,2.399e01,1.731e02,5.474e01,
	  6.742e00,3.650e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][21][j] = _itmp772[j];
		}
	}
	{ static float _itmp773[] = {4.980e03,6.950e02,1.983e01,1.966e01,
	  2.290e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][21][j] = _itmp773[j];
		}
	}
	{ static float _itmp774[] = {5.704e02,1.312e02,9.886e00,2.185e01,
	  4.872e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][21][j] = _itmp774[j];
		}
	}
	{ static float _itmp775[] = {4.772e02,1.630e02,1.584e02,5.914e01,
	  3.739e00,1.643e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][21][j] = _itmp775[j];
		}
	}
	{ static float _itmp776[] = {7.654e01,3.518e01,6.620e00,1.617e02,
	  4.260e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][21][j] = _itmp776[j];
		}
	}
	{ static float _itmp777[] = {5.253e01,5.494e01,5.561e01,2.416e01,
	  6.917e00,2.642e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][21][j] = _itmp777[j];
		}
	}
	{ static float _itmp778[] = {1.613e01,1.771e01,2.597e02,3.909e01,
	  7.825e00,2.982e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][21][j] = _itmp778[j];
		}
	}
	{ static float _itmp779[] = {1.358e01,5.011e00,1.639e00,5.095e02,
	  4.958e00,1.633e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][20][21][j] = _itmp779[j];
		}
	}
	{ static float _itmp780[] = {4.972e03,6.826e02,2.029e01,2.415e01,
	  2.187e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][21][j] = _itmp780[j];
		}
	}
	{ static float _itmp781[] = {5.690e02,1.177e02,1.068e01,2.144e01,
	  5.085e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][21][j] = _itmp781[j];
		}
	}
	{ static float _itmp782[] = {4.640e02,1.814e02,1.291e02,6.629e01,
	  3.531e00,5.519e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][21][j] = _itmp782[j];
		}
	}
	{ static float _itmp783[] = {6.500e01,3.562e01,6.517e00,1.572e02,
	  4.268e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][21][j] = _itmp783[j];
		}
	}
	{ static float _itmp784[] = {4.000e01,5.424e01,5.924e01,2.151e01,
	  7.123e00,2.645e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][21][j] = _itmp784[j];
		}
	}
	{ static float _itmp785[] = {9.940e00,1.102e01,5.478e02,1.610e01,
	  1.096e01,2.972e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][21][j] = _itmp785[j];
		}
	}
	{ static float _itmp786[] = {6.820e00,9.184e00,2.167e00,4.297e02,
	  4.552e00,3.612e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][21][21][j] = _itmp786[j];
		}
	}
	{ static float _itmp787[] = {7.246e03,2.290e02,1.035e02,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][22][j] = _itmp787[j];
		}
	}
	{ static float _itmp788[] = {6.852e03,7.669e02,1.757e01,3.884e01,
	  1.928e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][22][j] = _itmp788[j];
		}
	}
	{ static float _itmp789[] = {6.682e03,7.973e02,1.694e01,3.805e01,
	  1.874e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][22][j] = _itmp789[j];
		}
	}
	{ static float _itmp790[] = {1.570e03,4.820e01,1.999e01,7.258e01,
	  4.724e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][22][j] = _itmp790[j];
		}
	}
	{ static float _itmp791[] = {6.563e03,8.146e02,1.606e01,3.587e01,
	  1.887e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][22][j] = _itmp791[j];
		}
	}
	{ static float _itmp792[] = {1.487e03,1.341e02,1.463e01,3.226e01,
	  4.336e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][22][j] = _itmp792[j];
		}
	}
	{ static float _itmp793[] = {6.431e03,8.301e02,1.528e01,3.284e01,
	  1.918e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][22][j] = _itmp793[j];
		}
	}
	{ static float _itmp794[] = {1.396e03,1.597e02,1.178e01,2.849e01,
	  4.246e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][22][j] = _itmp794[j];
		}
	}
	{ static float _itmp795[] = {1.355e03,1.329e02,7.374e01,1.017e02,
	  3.596e00,2.681e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][22][j] = _itmp795[j];
		}
	}
	{ static float _itmp796[] = {6.302e03,8.379e02,1.487e01,3.151e01,
	  1.935e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][22][j] = _itmp796[j];
		}
	}
	{ static float _itmp797[] = {1.311e03,1.437e02,1.233e01,2.743e01,
	  4.461e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][22][j] = _itmp797[j];
		}
	}
	{ static float _itmp798[] = {1.260e03,1.761e02,7.417e01,9.459e01,
	  3.402e00,1.814e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][22][j] = _itmp798[j];
		}
	}
	{ static float _itmp799[] = {6.174e03,9.714e02,1.078e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][22][j] = _itmp799[j];
		}
	}
	{ static float _itmp800[] = {1.225e03,1.493e02,1.118e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][22][j] = _itmp800[j];
		}
	}
	{ static float _itmp801[] = {1.168e03,1.535e02,1.330e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][22][j] = _itmp801[j];
		}
	}
	{ static float _itmp802[] = {6.058e03,8.454e02,1.444e01,3.020e01,
	  1.955e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][22][j] = _itmp802[j];
		}
	}
	{ static float _itmp803[] = {1.146e03,1.434e02,1.098e01,2.603e01,
	  4.573e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][22][j] = _itmp803[j];
		}
	}
	{ static float _itmp804[] = {1.060e03,1.412e02,1.992e02,6.905e01,
	  3.834e00,1.640e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][22][j] = _itmp804[j];
		}
	}
	{ static float _itmp805[] = {5.941e03,9.834e02,1.036e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][22][j] = _itmp805[j];
		}
	}
	{ static float _itmp806[] = {1.063e03,1.540e02,9.623e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][22][j] = _itmp806[j];
		}
	}
	{ static float _itmp807[] = {9.758e02,1.562e02,1.835e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][22][j] = _itmp807[j];
		}
	}
	{ static float _itmp808[] = {5.831e03,8.491e02,1.420e01,2.950e01,
	  1.968e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][22][j] = _itmp808[j];
		}
	}
	{ static float _itmp809[] = {9.883e02,1.272e02,1.058e01,2.434e01,
	  4.902e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][22][j] = _itmp809[j];
		}
	}
	{ static float _itmp810[] = {8.960e02,1.198e02,3.365e02,5.275e01,
	  4.289e00,1.591e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][22][j] = _itmp810[j];
		}
	}
	{ static float _itmp811[] = {5.787e03,8.254e02,1.504e01,3.096e01,
	  1.969e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][22][j] = _itmp811[j];
		}
	}
	{ static float _itmp812[] = {9.488e02,9.010e01,1.292e01,2.883e01,
	  5.244e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][22][j] = _itmp812[j];
		}
	}
	{ static float _itmp813[] = {8.589e02,1.178e02,3.418e02,5.198e01,
	  4.329e00,1.528e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][22][j] = _itmp813[j];
		}
	}
	{ static float _itmp814[] = {3.363e02,4.802e00,5.149e01,9.708e02,
	  4.521e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][22][j] = _itmp814[j];
		}
	}
	{ static float _itmp815[] = {5.745e03,8.791e02,1.315e01,3.287e01,
	  1.891e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][22][j] = _itmp815[j];
		}
	}
	{ static float _itmp816[] = {9.114e02,1.194e02,1.089e01,2.492e01,
	  4.980e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][22][j] = _itmp816[j];
		}
	}
	{ static float _itmp817[] = {8.209e02,1.210e02,3.219e02,4.969e01,
	  4.340e00,1.495e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][22][j] = _itmp817[j];
		}
	}
	{ static float _itmp818[] = {3.081e02,1.475e01,2.755e01,3.277e02,
	  4.457e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][22][j] = _itmp818[j];
		}
	}
	{ static float _itmp819[] = {5.704e03,9.381e02,1.144e01,3.678e01,
	  1.793e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][22][j] = _itmp819[j];
		}
	}
	{ static float _itmp820[] = {8.746e02,1.297e02,1.022e01,2.418e01,
	  4.886e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][22][j] = _itmp820[j];
		}
	}
	{ static float _itmp821[] = {7.834e02,1.219e02,3.155e02,4.959e01,
	  4.332e00,1.503e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][22][j] = _itmp821[j];
		}
	}
	{ static float _itmp822[] = {2.810e02,1.396e01,2.795e01,3.475e02,
	  4.463e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][22][j] = _itmp822[j];
		}
	}
	{ static float _itmp823[] = {2.557e02,6.549e01,1.189e01,4.523e01,
	  5.865e00,5.604e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][22][j] = _itmp823[j];
		}
	}
	{ static float _itmp824[] = {5.664e03,9.448e02,1.126e01,3.775e01,
	  1.777e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][22][j] = _itmp824[j];
		}
	}
	{ static float _itmp825[] = {8.391e02,1.492e02,8.956e00,2.627e01,
	  4.576e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][22][j] = _itmp825[j];
		}
	}
	{ static float _itmp826[] = {7.474e02,1.218e02,3.136e02,4.700e01,
	  4.379e00,1.470e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][22][j] = _itmp826[j];
		}
	}
	{ static float _itmp827[] = {2.543e02,5.439e01,8.345e00,9.136e02,
	  3.280e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][22][j] = _itmp827[j];
		}
	}
	{ static float _itmp828[] = {2.305e02,7.687e01,1.769e01,7.556e01,
	  5.183e00,4.070e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][22][j] = _itmp828[j];
		}
	}
	{ static float _itmp829[] = {5.624e03,9.854e02,1.025e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][22][j] = _itmp829[j];
		}
	}
	{ static float _itmp830[] = {8.017e02,1.579e02,8.542e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][22][j] = _itmp830[j];
		}
	}
	{ static float _itmp831[] = {7.093e02,1.701e02,1.628e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][22][j] = _itmp831[j];
		}
	}
	{ static float _itmp832[] = {2.274e02,3.357e01,1.077e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][22][j] = _itmp832[j];
		}
	}
	{ static float _itmp833[] = {2.058e02,6.386e01,3.315e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][22][j] = _itmp833[j];
		}
	}
	{ static float _itmp834[] = {5.591e03,9.640e02,1.077e01,4.005e01,
	  1.740e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][22][j] = _itmp834[j];
		}
	}
	{ static float _itmp835[] = {7.727e02,1.513e02,8.749e00,2.570e01,
	  4.587e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][22][j] = _itmp835[j];
		}
	}
	{ static float _itmp836[] = {6.800e02,1.400e02,2.393e02,5.044e01,
	  4.150e00,1.006e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][22][j] = _itmp836[j];
		}
	}
	{ static float _itmp837[] = {2.031e02,5.013e01,7.844e00,8.057e02,
	  3.393e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][22][j] = _itmp837[j];
		}
	}
}
static void blkdata10k(void)
{
	int j;
	{ static float _itmp838[] = {1.735e02,6.959e01,3.541e01,6.440e01,
	  5.460e00,2.830e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][22][j] = _itmp838[j];
		}
	}
	{ static float _itmp839[] = {5.557e03,9.898e02,1.013e01,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][22][j] = _itmp839[j];
		}
	}
	{ static float _itmp840[] = {7.401e02,1.589e02,8.371e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][22][j] = _itmp840[j];
		}
	}
	{ static float _itmp841[] = {6.468e02,1.710e02,1.594e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][22][j] = _itmp841[j];
		}
	}
	{ static float _itmp842[] = {1.781e02,3.490e01,9.007e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][22][j] = _itmp842[j];
		}
	}
	{ static float _itmp843[] = {1.506e02,6.472e01,4.696e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][22][j] = _itmp843[j];
		}
	}
	{ static float _itmp844[] = {5.531e03,9.782e02,1.044e01,3.841e01,
	  1.745e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][22][j] = _itmp844[j];
		}
	}
	{ static float _itmp845[] = {7.123e02,1.580e02,8.337e00,2.583e01,
	  4.520e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][22][j] = _itmp845[j];
		}
	}
	{ static float _itmp846[] = {6.188e02,1.692e02,1.626e02,6.988e01,
	  3.712e00,1.180e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][22][j] = _itmp846[j];
		}
	}
	{ static float _itmp847[] = {1.549e02,4.722e01,6.956e00,5.988e02,
	  3.553e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][22][j] = _itmp847[j];
		}
	}
	{ static float _itmp848[] = {1.281e02,6.736e01,4.931e01,4.579e01,
	  5.859e00,3.123e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][22][j] = _itmp848[j];
		}
	}
	{ static float _itmp849[] = {5.516e03,9.875e02,1.024e01,3.726e01,
	  1.748e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][22][j] = _itmp849[j];
		}
	}
	{ static float _itmp850[] = {6.859e02,1.633e02,8.009e00,2.702e01,
	  4.427e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][22][j] = _itmp850[j];
		}
	}
	{ static float _itmp851[] = {5.923e02,1.721e02,1.571e02,6.951e01,
	  3.697e00,1.225e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][22][j] = _itmp851[j];
		}
	}
	{ static float _itmp852[] = {1.329e02,4.591e01,6.536e00,5.301e02,
	  3.633e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][22][j] = _itmp852[j];
		}
	}
	{ static float _itmp853[] = {1.059e02,6.053e01,5.762e01,2.883e01,
	  6.578e00,2.283e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][22][j] = _itmp853[j];
		}
	}
	{ static float _itmp854[] = {6.528e01,3.190e01,8.329e01,1.369e02,
	  5.672e00,1.237e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][22][j] = _itmp854[j];
		}
	}
	{ static float _itmp855[] = {5.504e03,9.965e02,9.948e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][22][j] = _itmp855[j];
		}
	}
	{ static float _itmp856[] = {6.654e02,1.599e02,8.204e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][22][j] = _itmp856[j];
		}
	}
	{ static float _itmp857[] = {5.715e02,1.723e02,1.553e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][22][j] = _itmp857[j];
		}
	}
	{ static float _itmp858[] = {1.118e02,3.793e01,6.694e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][22][j] = _itmp858[j];
		}
	}
	{ static float _itmp859[] = {8.555e01,6.751e01,4.255e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][22][j] = _itmp859[j];
		}
	}
	{ static float _itmp860[] = {4.671e01,2.794e01,2.071e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][22][j] = _itmp860[j];
		}
	}
	{ static float _itmp861[] = {5.493e03,1.056e03,8.926e00,3.290e01,
	  1.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][22][j] = _itmp861[j];
		}
	}
	{ static float _itmp862[] = {6.421e02,1.795e02,7.208e00,3.031e01,
	  4.183e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][22][j] = _itmp862[j];
		}
	}
	{ static float _itmp863[] = {5.487e02,1.685e02,1.634e02,6.966e01,
	  3.723e00,1.158e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][22][j] = _itmp863[j];
		}
	}
	{ static float _itmp864[] = {9.452e01,4.339e01,5.872e00,3.580e02,
	  3.847e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][22][j] = _itmp864[j];
		}
	}
	{ static float _itmp865[] = {6.813e01,6.101e01,5.383e01,2.353e01,
	  6.904e00,2.586e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][22][j] = _itmp865[j];
		}
	}
	{ static float _itmp866[] = {2.931e01,1.913e01,3.556e03,5.763e00,
	  1.187e01,5.113e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][22][j] = _itmp866[j];
		}
	}
	{ static float _itmp867[] = {5.484e03,1.467e03,4.369e00,3.858e02,
	  1.042e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][22][j] = _itmp867[j];
		}
	}
	{ static float _itmp868[] = {6.389e02,1.378e02,9.535e00,2.195e01,
	  4.927e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][22][j] = _itmp868[j];
		}
	}
	{ static float _itmp869[] = {5.292e02,1.302e02,2.706e02,4.385e01,
	  4.365e00,6.490e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][22][j] = _itmp869[j];
		}
	}
	{ static float _itmp870[] = {7.942e01,4.123e01,5.887e00,1.634e02,
	  4.188e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][22][j] = _itmp870[j];
		}
	}
	{ static float _itmp871[] = {5.323e01,6.049e01,5.264e01,2.216e01,
	  7.058e00,2.583e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][22][j] = _itmp871[j];
		}
	}
	{ static float _itmp872[] = {1.466e01,1.451e01,7.154e02,1.749e01,
	  1.038e01,4.665e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][22][j] = _itmp872[j];
		}
	}
	{ static float _itmp873[] = {5.475e03,6.550e02,2.420e01,2.343e01,
	  2.326e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][22][j] = _itmp873[j];
		}
	}
	{ static float _itmp874[] = {6.380e02,9.688e01,1.212e01,1.905e01,
	  5.757e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][22][j] = _itmp874[j];
		}
	}
	{ static float _itmp875[] = {5.270e02,2.290e02,8.513e01,5.037e02,
	  2.767e00,9.964e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][22][j] = _itmp875[j];
		}
	}
	{ static float _itmp876[] = {7.700e01,3.668e01,6.690e00,7.759e01,
	  4.706e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][22][j] = _itmp876[j];
		}
	}
	{ static float _itmp877[] = {4.700e01,5.937e01,7.599e01,1.488e01,
	  7.586e00,2.690e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][22][j] = _itmp877[j];
		}
	}
	{ static float _itmp878[] = {1.200e01,1.146e01,3.134e03,7.037e00,
	  1.377e01,3.417e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][22][j] = _itmp878[j];
		}
	}
	{ static float _itmp879[] = {6.740e00,1.002e01,2.059e00,3.914e02,
	  4.565e00,5.057e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][22][22][j] = _itmp879[j];
		}
	}
	{ static float _itmp880[] = {7.895e03,2.495e02,9.505e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][23][j] = _itmp880[j];
		}
	}
	{ static float _itmp881[] = {7.482e03,9.695e02,1.185e01,5.351e01,
	  1.696e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][23][j] = _itmp881[j];
		}
	}
	{ static float _itmp882[] = {7.306e03,9.824e02,1.199e01,5.185e01,
	  1.668e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][23][j] = _itmp882[j];
		}
	}
	{ static float _itmp883[] = {1.721e03,1.480e02,7.312e00,3.880e01,
	  4.083e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][23][j] = _itmp883[j];
		}
	}
	{ static float _itmp884[] = {7.181e03,9.952e02,1.156e01,4.841e01,
	  1.687e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][23][j] = _itmp884[j];
		}
	}
	{ static float _itmp885[] = {1.634e03,1.488e02,1.333e01,3.225e01,
	  4.310e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][23][j] = _itmp885[j];
		}
	}
	{ static float _itmp886[] = {7.042e03,1.003e03,1.125e01,4.457e01,
	  1.717e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][23][j] = _itmp886[j];
		}
	}
	{ static float _itmp887[] = {1.539e03,1.748e02,1.089e01,2.892e01,
	  4.221e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][23][j] = _itmp887[j];
		}
	}
	{ static float _itmp888[] = {1.497e03,2.216e02,2.692e01,1.091e02,
	  3.193e00,3.540e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][23][j] = _itmp888[j];
		}
	}
	{ static float _itmp889[] = {6.907e03,1.004e03,1.114e01,4.238e01,
	  1.740e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][23][j] = _itmp889[j];
		}
	}
	{ static float _itmp890[] = {1.450e03,1.749e02,1.035e01,2.790e01,
	  4.278e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][23][j] = _itmp890[j];
		}
	}
	{ static float _itmp891[] = {1.396e03,2.006e02,6.290e01,1.016e02,
	  3.330e00,1.634e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][23][j] = _itmp891[j];
		}
	}
	{ static float _itmp892[] = {6.769e03,1.056e03,9.975e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][23][j] = _itmp892[j];
		}
	}
	{ static float _itmp893[] = {1.359e03,1.619e02,1.050e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][23][j] = _itmp893[j];
		}
	}
	{ static float _itmp894[] = {1.299e03,1.675e02,1.244e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][23][j] = _itmp894[j];
		}
	}
	{ static float _itmp895[] = {6.650e03,1.010e03,1.086e01,4.093e01,
	  1.755e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][23][j] = _itmp895[j];
		}
	}
	{ static float _itmp896[] = {1.276e03,1.514e02,1.053e01,2.659e01,
	  4.591e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][23][j] = _itmp896[j];
		}
	}
	{ static float _itmp897[] = {1.185e03,1.297e02,2.646e02,7.449e01,
	  3.960e00,6.187e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][23][j] = _itmp897[j];
		}
	}
	{ static float _itmp898[] = {6.523e03,1.068e03,9.610e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][23][j] = _itmp898[j];
		}
	}
	{ static float _itmp899[] = {1.189e03,1.668e02,9.095e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][23][j] = _itmp899[j];
		}
	}
	{ static float _itmp900[] = {1.097e03,1.701e02,1.738e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][23][j] = _itmp900[j];
		}
	}
	{ static float _itmp901[] = {6.409e03,1.017e03,1.063e01,4.093e01,
	  1.756e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][23][j] = _itmp901[j];
		}
	}
	{ static float _itmp902[] = {1.110e03,1.388e02,9.935e00,2.496e01,
	  4.858e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][23][j] = _itmp902[j];
		}
	}
	{ static float _itmp903[] = {1.011e03,1.397e02,2.826e02,5.599e01,
	  4.153e00,5.775e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][23][j] = _itmp903[j];
		}
	}
	{ static float _itmp904[] = {6.362e03,9.927e02,1.118e01,4.335e01,
	  1.752e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][23][j] = _itmp904[j];
		}
	}
	{ static float _itmp905[] = {1.068e03,9.748e01,1.227e01,2.968e01,
	  5.204e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][23][j] = _itmp905[j];
		}
	}
	{ static float _itmp906[] = {9.738e02,1.312e02,3.124e02,5.494e01,
	  4.251e00,6.239e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][23][j] = _itmp906[j];
		}
	}
	{ static float _itmp907[] = {3.842e02,5.856e00,4.533e01,8.787e02,
	  4.495e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][23][j] = _itmp907[j];
		}
	}
	{ static float _itmp908[] = {6.318e03,1.103e03,8.914e00,5.657e01,
	  1.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][23][j] = _itmp908[j];
		}
	}
	{ static float _itmp909[] = {1.029e03,1.295e02,1.028e01,2.555e01,
	  4.945e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][23][j] = _itmp909[j];
		}
	}
	{ static float _itmp910[] = {9.334e02,1.427e02,2.652e02,5.321e01,
	  4.178e00,5.905e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][23][j] = _itmp910[j];
		}
	}
	{ static float _itmp911[] = {3.548e02,1.135e01,3.894e01,4.475e02,
	  4.496e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][23][j] = _itmp911[j];
		}
	}
	{ static float _itmp912[] = {6.274e03,1.115e03,8.708e00,5.540e01,
	  1.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][23][j] = _itmp912[j];
		}
	}
	{ static float _itmp913[] = {9.893e02,1.454e02,9.421e00,2.472e01,
	  4.803e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][23][j] = _itmp913[j];
		}
	}
	{ static float _itmp914[] = {8.933e02,1.424e02,2.644e02,5.317e01,
	  4.181e00,5.962e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][23][j] = _itmp914[j];
		}
	}
	{ static float _itmp915[] = {3.255e02,1.164e01,3.651e01,4.413e02,
	  4.490e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][23][j] = _itmp915[j];
		}
	}
	{ static float _itmp916[] = {2.981e02,6.675e01,1.246e01,4.963e01,
	  5.860e00,3.057e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][23][j] = _itmp916[j];
		}
	}
	{ static float _itmp917[] = {6.231e03,1.111e03,8.763e00,5.576e01,
	  1.589e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][23][j] = _itmp917[j];
		}
	}
	{ static float _itmp918[] = {9.512e02,1.447e02,9.388e00,2.428e01,
	  4.837e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][23][j] = _itmp918[j];
		}
	}
	{ static float _itmp919[] = {8.546e02,1.426e02,2.618e02,5.270e01,
	  4.188e00,5.989e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][23][j] = _itmp919[j];
		}
	}
	{ static float _itmp920[] = {2.969e02,2.539e01,1.632e01,2.419e02,
	  4.286e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][23][j] = _itmp920[j];
		}
	}
	{ static float _itmp921[] = {2.708e02,6.544e01,2.411e01,4.849e01,
	  5.923e00,2.753e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][23][j] = _itmp921[j];
		}
	}
	{ static float _itmp922[] = {6.187e03,1.073e03,9.448e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][23][j] = _itmp922[j];
		}
	}
	{ static float _itmp923[] = {9.108e02,1.710e02,8.093e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][23][j] = _itmp923[j];
		}
	}
	{ static float _itmp924[] = {8.130e02,1.843e02,1.566e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][23][j] = _itmp924[j];
		}
	}
	{ static float _itmp925[] = {2.680e02,3.606e01,1.078e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][23][j] = _itmp925[j];
		}
	}
	{ static float _itmp926[] = {2.444e02,6.965e01,3.257e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][23][j] = _itmp926[j];
		}
	}
	{ static float _itmp927[] = {6.152e03,1.110e03,8.774e00,5.647e01,
	  1.586e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][23][j] = _itmp927[j];
		}
	}
	{ static float _itmp928[] = {8.797e02,1.476e02,9.146e00,2.358e01,
	  4.847e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][23][j] = _itmp928[j];
		}
	}
	{ static float _itmp929[] = {7.819e02,1.427e02,2.573e02,5.042e01,
	  4.228e00,5.960e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][23][j] = _itmp929[j];
		}
	}
	{ static float _itmp930[] = {2.419e02,2.465e01,1.419e01,2.341e02,
	  4.369e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][23][j] = _itmp930[j];
		}
	}
	{ static float _itmp931[] = {2.093e02,6.644e01,4.311e01,4.198e01,
	  6.057e00,3.135e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][23][j] = _itmp931[j];
		}
	}
	{ static float _itmp932[] = {6.114e03,1.076e03,9.366e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][23][j] = _itmp932[j];
		}
	}
	{ static float _itmp933[] = {8.432e02,1.720e02,7.934e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][23][j] = _itmp933[j];
		}
	}
	{ static float _itmp934[] = {7.444e02,1.850e02,1.537e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][23][j] = _itmp934[j];
		}
	}
	{ static float _itmp935[] = {2.148e02,3.733e01,9.131e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][23][j] = _itmp935[j];
		}
	}
	{ static float _itmp936[] = {1.847e02,7.035e01,4.687e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][23][j] = _itmp936[j];
		}
	}
	{ static float _itmp937[] = {6.080e03,1.122e03,8.562e00,5.603e01,
	  1.582e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][23][j] = _itmp937[j];
		}
	}
	{ static float _itmp938[] = {8.140e02,1.553e02,8.726e00,2.320e01,
	  4.789e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][23][j] = _itmp938[j];
		}
	}
	{ static float _itmp939[] = {7.153e02,1.571e02,2.130e02,5.017e01,
	  4.114e00,5.706e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][23][j] = _itmp939[j];
		}
	}
	{ static float _itmp940[] = {1.900e02,3.531e01,8.881e00,1.815e02,
	  4.264e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][23][j] = _itmp940[j];
		}
	}
	{ static float _itmp941[] = {1.602e02,6.754e01,5.675e01,3.729e01,
	  6.191e00,2.358e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][23][j] = _itmp941[j];
		}
	}
	{ static float _itmp942[] = {6.062e03,1.128e03,8.464e00,5.569e01,
	  1.580e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][23][j] = _itmp942[j];
		}
	}
	{ static float _itmp943[] = {7.842e02,1.551e02,8.723e00,2.287e01,
	  4.810e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][23][j] = _itmp943[j];
		}
	}
	{ static float _itmp944[] = {6.855e02,1.640e02,1.963e02,5.019e01,
	  4.060e00,5.648e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][23][j] = _itmp944[j];
		}
	}
	{ static float _itmp945[] = {1.656e02,3.830e01,7.706e00,1.719e02,
	  4.245e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][23][j] = _itmp945[j];
		}
	}
	{ static float _itmp946[] = {1.359e02,6.693e01,5.368e01,3.420e01,
	  6.344e00,2.242e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][23][j] = _itmp946[j];
		}
	}
	{ static float _itmp947[] = {9.064e01,3.098e01,1.201e02,6.811e01,
	  6.392e00,3.113e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][23][j] = _itmp947[j];
		}
	}
	{ static float _itmp948[] = {6.046e03,1.081e03,9.244e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][23][j] = _itmp948[j];
		}
	}
	{ static float _itmp949[] = {7.598e02,1.731e02,7.776e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][23][j] = _itmp949[j];
		}
	}
	{ static float _itmp950[] = {6.602e02,1.862e02,1.500e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][23][j] = _itmp950[j];
		}
	}
	{ static float _itmp951[] = {1.427e02,4.027e01,6.892e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][23][j] = _itmp951[j];
		}
	}
}
static void blkdata10l(void)
{
	int j;
	{ static float _itmp952[] = {1.134e02,7.290e01,4.327e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][23][j] = _itmp952[j];
		}
	}
	{ static float _itmp953[] = {6.946e01,3.105e01,2.269e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][23][j] = _itmp953[j];
		}
	}
	{ static float _itmp954[] = {6.033e03,1.224e03,7.106e00,7.179e01,
	  1.455e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][23][j] = _itmp954[j];
		}
	}
	{ static float _itmp955[] = {7.331e02,1.640e02,8.333e00,2.286e01,
	  4.721e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][23][j] = _itmp955[j];
		}
	}
	{ static float _itmp956[] = {6.344e02,1.721e02,1.795e02,5.067e01,
	  3.993e00,5.538e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][23][j] = _itmp956[j];
		}
	}
	{ static float _itmp957[] = {1.219e02,4.256e01,6.252e00,1.605e02,
	  4.224e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][23][j] = _itmp957[j];
		}
	}
	{ static float _itmp958[] = {9.275e01,6.776e01,4.856e01,2.817e01,
	  6.628e00,2.673e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][23][j] = _itmp958[j];
		}
	}
	{ static float _itmp959[] = {4.916e01,3.483e01,2.224e02,5.448e01,
	  6.484e00,3.436e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][23][j] = _itmp959[j];
		}
	}
	{ static float _itmp960[] = {6.021e03,1.085e03,9.165e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][23][j] = _itmp960[j];
		}
	}
	{ static float _itmp961[] = {7.161e02,1.735e02,7.720e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][23][j] = _itmp961[j];
		}
	}
	{ static float _itmp962[] = {6.164e02,1.871e02,1.480e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][23][j] = _itmp962[j];
		}
	}
	{ static float _itmp963[] = {1.032e02,4.293e01,5.797e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][23][j] = _itmp963[j];
		}
	}
	{ static float _itmp964[] = {7.436e01,6.450e01,5.388e01,2.100e01,
	  7.200e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][23][j] = _itmp964[j];
		}
	}
	{ static float _itmp965[] = {3.096e01,9.947e00,1.924e03,9.000e00,
	  1.450e01,3.500e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][23][j] = _itmp965[j];
		}
	}
	{ static float _itmp966[] = {6.009e03,1.497e03,4.593e00,1.465e02,
	  1.189e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][23][j] = _itmp966[j];
		}
	}
	{ static float _itmp967[] = {7.074e02,2.013e02,6.869e00,2.572e01,
	  4.266e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][23][j] = _itmp967[j];
		}
	}
	{ static float _itmp968[] = {5.970e02,1.477e02,2.382e02,4.633e01,
	  4.261e00,6.156e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][23][j] = _itmp968[j];
		}
	}
	{ static float _itmp969[] = {8.745e01,4.462e01,5.566e00,1.542e02,
	  4.230e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][23][j] = _itmp969[j];
		}
	}
	{ static float _itmp970[] = {5.879e01,6.599e01,5.021e01,2.175e01,
	  7.102e00,2.576e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][23][j] = _itmp970[j];
		}
	}
	{ static float _itmp971[] = {1.650e01,1.521e01,1.031e03,1.415e01,
	  1.123e01,4.827e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][23][j] = _itmp971[j];
		}
	}
	{ static float _itmp972[] = {5.996e03,1.035e03,1.025e01,3.343e01,
	  1.822e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][23][j] = _itmp972[j];
		}
	}
	{ static float _itmp973[] = {7.030e02,1.588e02,8.555e00,2.258e01,
	  4.789e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][23][j] = _itmp973[j];
		}
	}
	{ static float _itmp974[] = {5.850e02,1.865e02,1.540e02,5.560e01,
	  3.823e00,5.785e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][23][j] = _itmp974[j];
		}
	}
	{ static float _itmp975[] = {7.900e01,4.234e01,5.602e00,1.356e02,
	  4.374e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][23][j] = _itmp975[j];
		}
	}
	{ static float _itmp976[] = {4.900e01,6.567e01,5.313e01,1.981e01,
	  7.258e00,2.601e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][23][j] = _itmp976[j];
		}
	}
	{ static float _itmp977[] = {8.660e00,7.244e00,1.485e03,9.671e00,
	  1.575e01,7.760e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][23][j] = _itmp977[j];
		}
	}
	{ static float _itmp978[] = {6.767e00,9.636e00,6.532e-01,5.232e02,
	  4.641e00,9.332e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][23][23][j] = _itmp978[j];
		}
	}
	{ static float _itmp979[] = {8.572e03,2.709e02,8.759e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][24][j] = _itmp979[j];
		}
	}
	{ static float _itmp980[] = {8.141e03,9.661e02,1.309e01,4.829e01,
	  1.794e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][24][j] = _itmp980[j];
		}
	}
	{ static float _itmp981[] = {7.957e03,9.997e02,1.266e01,4.727e01,
	  1.749e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][24][j] = _itmp981[j];
		}
	}
	{ static float _itmp982[] = {1.880e03,2.004e02,5.352e00,3.934e01,
	  3.800e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][24][j] = _itmp982[j];
		}
	}
	{ static float _itmp983[] = {7.827e03,9.916e02,1.277e01,4.256e01,
	  1.799e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][24][j] = _itmp983[j];
		}
	}
	{ static float _itmp984[] = {1.788e03,1.631e02,1.229e01,3.227e01,
	  4.294e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][24][j] = _itmp984[j];
		}
	}
	{ static float _itmp985[] = {7.682e03,9.946e02,1.255e01,3.824e01,
	  1.847e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][24][j] = _itmp985[j];
		}
	}
	{ static float _itmp986[] = {1.689e03,1.952e02,9.881e00,2.837e01,
	  4.199e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][24][j] = _itmp986[j];
		}
	}
	{ static float _itmp987[] = {1.644e03,2.576e02,2.159e01,1.234e02,
	  3.086e00,1.723e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][24][j] = _itmp987[j];
		}
	}
	{ static float _itmp988[] = {7.539e03,9.973e02,1.238e01,3.663e01,
	  1.868e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][24][j] = _itmp988[j];
		}
	}
	{ static float _itmp989[] = {1.596e03,1.879e02,9.744e00,2.825e01,
	  4.277e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][24][j] = _itmp989[j];
		}
	}
	{ static float _itmp990[] = {1.539e03,2.403e02,4.744e01,1.147e02,
	  3.190e00,1.237e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][24][j] = _itmp990[j];
		}
	}
	{ static float _itmp991[] = {7.391e03,1.144e03,9.260e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][24][j] = _itmp991[j];
		}
	}
	{ static float _itmp992[] = {1.500e03,1.751e02,9.871e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][24][j] = _itmp992[j];
		}
	}
	{ static float _itmp993[] = {1.437e03,1.822e02,1.165e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][24][j] = _itmp993[j];
		}
	}
	{ static float _itmp994[] = {7.270e03,1.005e03,1.205e01,3.464e01,
	  1.893e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][24][j] = _itmp994[j];
		}
	}
	{ static float _itmp995[] = {1.414e03,1.452e02,1.087e01,2.737e01,
	  4.741e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][24][j] = _itmp995[j];
		}
	}
	{ static float _itmp996[] = {1.317e03,1.889e02,1.381e02,7.915e01,
	  3.619e00,1.713e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][24][j] = _itmp996[j];
		}
	}
	{ static float _itmp997[] = {7.132e03,1.157e03,8.934e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][24][j] = _itmp997[j];
		}
	}
	{ static float _itmp998[] = {1.321e03,1.802e02,8.605e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][24][j] = _itmp998[j];
		}
	}
	{ static float _itmp999[] = {1.224e03,1.847e02,1.647e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][24][j] = _itmp999[j];
		}
	}
	{ static float _itmp1000[] = {7.016e03,1.007e03,1.191e01,3.374e01,
	  1.907e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][24][j] = _itmp1000[j];
		}
	}
	{ static float _itmp1001[] = {1.239e03,1.468e02,9.533e00,2.564e01,
	  4.859e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][24][j] = _itmp1001[j];
		}
	}
	{ static float _itmp1002[] = {1.133e03,1.588e02,2.466e02,5.979e01,
	  4.044e00,1.415e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][24][j] = _itmp1002[j];
		}
	}
	{ static float _itmp1003[] = {6.966e03,9.952e02,1.220e01,3.635e01,
	  1.885e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][24][j] = _itmp1003[j];
		}
	}
	{ static float _itmp1004[] = {1.195e03,1.084e02,1.148e01,3.003e01,
	  5.139e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][24][j] = _itmp1004[j];
		}
	}
	{ static float _itmp1005[] = {1.096e03,1.576e02,2.464e02,5.814e01,
	  4.081e00,1.417e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][24][j] = _itmp1005[j];
		}
	}
	{ static float _itmp1006[] = {4.352e02,5.053e00,5.856e01,1.103e03,
	  4.490e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][24][j] = _itmp1006[j];
		}
	}
	{ static float _itmp1007[] = {6.919e03,1.016e03,1.168e01,3.428e01,
	  1.894e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][24][j] = _itmp1007[j];
		}
	}
	{ static float _itmp1008[] = {1.153e03,1.412e02,9.670e00,2.617e01,
	  4.900e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][24][j] = _itmp1008[j];
		}
	}
	{ static float _itmp1009[] = {1.053e03,1.572e02,2.455e02,5.660e01,
	  4.109e00,1.411e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][24][j] = _itmp1009[j];
		}
	}
	{ static float _itmp1010[] = {4.030e02,1.345e01,3.535e01,4.180e02,
	  4.462e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][24][j] = _itmp1010[j];
		}
	}
	{ static float _itmp1011[] = {6.872e03,1.025e03,1.145e01,3.313e01,
	  1.902e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][24][j] = _itmp1011[j];
		}
	}
	{ static float _itmp1012[] = {1.111e03,1.437e02,9.475e00,2.535e01,
	  4.916e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][24][j] = _itmp1012[j];
		}
	}
	{ static float _itmp1013[] = {1.010e03,1.534e02,2.551e02,5.638e01,
	  4.140e00,1.436e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][24][j] = _itmp1013[j];
		}
	}
	{ static float _itmp1014[] = {3.731e02,2.286e01,2.034e01,2.772e02,
	  4.326e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][24][j] = _itmp1014[j];
		}
	}
	{ static float _itmp1015[] = {3.436e02,7.288e01,1.205e01,5.254e01,
	  5.787e00,1.633e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][24][j] = _itmp1015[j];
		}
	}
	{ static float _itmp1016[] = {6.826e03,1.018e03,1.161e01,3.333e01,
	  1.905e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][24][j] = _itmp1016[j];
		}
	}
	{ static float _itmp1017[] = {1.070e03,1.522e02,9.043e00,2.474e01,
	  4.856e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][24][j] = _itmp1017[j];
		}
	}
	{ static float _itmp1018[] = {9.690e02,1.541e02,2.509e02,5.596e01,
	  4.141e00,1.435e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][24][j] = _itmp1018[j];
		}
	}
	{ static float _itmp1019[] = {3.427e02,2.273e01,1.932e01,2.771e02,
	  4.340e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][24][j] = _itmp1019[j];
		}
	}
	{ static float _itmp1020[] = {3.144e02,7.442e01,2.225e01,4.974e01,
	  5.829e00,4.047e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][24][j] = _itmp1020[j];
		}
	}
	{ static float _itmp1021[] = {6.778e03,1.164e03,8.718e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][24][j] = _itmp1021[j];
		}
	}
	{ static float _itmp1022[] = {1.027e03,1.846e02,7.670e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][24][j] = _itmp1022[j];
		}
	}
	{ static float _itmp1023[] = {9.238e02,1.990e02,1.508e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][24][j] = _itmp1023[j];
		}
	}
	{ static float _itmp1024[] = {3.118e02,3.864e01,1.074e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][24][j] = _itmp1024[j];
		}
	}
	{ static float _itmp1025[] = {2.860e02,7.574e01,3.181e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][24][j] = _itmp1025[j];
		}
	}
	{ static float _itmp1026[] = {6.741e03,1.013e03,1.172e01,3.345e01,
	  1.909e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][24][j] = _itmp1026[j];
		}
	}
	{ static float _itmp1027[] = {9.939e02,1.554e02,8.799e00,2.403e01,
	  4.866e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][24][j] = _itmp1027[j];
		}
	}
	{ static float _itmp1028[] = {8.910e02,1.555e02,2.430e02,5.379e01,
	  4.166e00,1.402e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][24][j] = _itmp1028[j];
		}
	}
	{ static float _itmp1029[] = {2.840e02,2.364e01,1.585e01,2.573e02,
	  4.393e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][24][j] = _itmp1029[j];
		}
	}
	{ static float _itmp1030[] = {2.483e02,7.277e01,4.169e01,4.324e01,
	  6.012e00,3.835e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][24][j] = _itmp1030[j];
		}
	}
	{ static float _itmp1031[] = {6.698e03,1.167e03,8.667e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][24][j] = _itmp1031[j];
		}
	}
	{ static float _itmp1032[] = {9.536e02,1.856e02,7.522e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][24][j] = _itmp1032[j];
		}
	}
	{ static float _itmp1033[] = {8.492e02,1.997e02,1.482e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][24][j] = _itmp1033[j];
		}
	}
	{ static float _itmp1034[] = {2.547e02,3.986e01,9.199e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][24][j] = _itmp1034[j];
		}
	}
	{ static float _itmp1035[] = {2.218e02,7.629e01,4.645e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][24][j] = _itmp1035[j];
		}
	}
	{ static float _itmp1036[] = {6.664e03,1.021e03,1.152e01,3.256e01,
	  1.914e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][24][j] = _itmp1036[j];
		}
	}
	{ static float _itmp1037[] = {9.230e02,1.679e02,8.168e00,2.438e01,
	  4.732e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][24][j] = _itmp1037[j];
		}
	}
	{ static float _itmp1038[] = {8.191e02,1.748e02,1.921e02,5.809e01,
	  3.973e00,1.717e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][24][j] = _itmp1038[j];
		}
	}
	{ static float _itmp1039[] = {2.282e02,5.334e01,7.236e00,4.454e02,
	  3.624e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][24][j] = _itmp1039[j];
		}
	}
	{ static float _itmp1040[] = {1.945e02,7.818e01,4.992e01,4.763e01,
	  5.832e00,3.093e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][24][j] = _itmp1040[j];
		}
	}
	{ static float _itmp1041[] = {6.635e03,1.021e03,1.154e01,3.219e01,
	  1.919e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][24][j] = _itmp1041[j];
		}
	}
	{ static float _itmp1042[] = {8.900e02,1.668e02,8.196e00,2.394e01,
	  4.767e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][24][j] = _itmp1042[j];
		}
	}
	{ static float _itmp1043[] = {7.860e02,1.739e02,1.939e02,5.345e01,
	  4.041e00,1.659e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][24][j] = _itmp1043[j];
		}
	}
	{ static float _itmp1044[] = {2.016e02,5.184e01,6.791e00,3.811e02,
	  3.719e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][24][j] = _itmp1044[j];
		}
	}
	{ static float _itmp1045[] = {1.691e02,7.618e01,4.935e01,3.879e01,
	  6.116e00,3.087e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][24][j] = _itmp1045[j];
		}
	}
	{ static float _itmp1046[] = {1.193e02,3.865e01,9.713e01,1.133e02,
	  5.798e00,1.437e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][24][j] = _itmp1046[j];
		}
	}
	{ static float _itmp1047[] = {6.617e03,1.171e03,8.591e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][24][j] = _itmp1047[j];
		}
	}
	{ static float _itmp1048[] = {8.614e02,1.867e02,7.373e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][24][j] = _itmp1048[j];
		}
	}
	{ static float _itmp1049[] = {7.560e02,2.007e02,1.450e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][24][j] = _itmp1049[j];
		}
	}
	{ static float _itmp1050[] = {1.768e02,4.271e01,7.047e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][24][j] = _itmp1050[j];
		}
	}
	{ static float _itmp1051[] = {1.444e02,7.861e01,4.367e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][24][j] = _itmp1051[j];
		}
	}
	{ static float _itmp1052[] = {9.575e01,3.452e01,2.355e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][24][j] = _itmp1052[j];
		}
	}
	{ static float _itmp1053[] = {6.602e03,1.045e03,1.101e01,3.201e01,
	  1.902e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][24][j] = _itmp1053[j];
		}
	}
	{ static float _itmp1054[] = {8.319e02,1.782e02,7.660e00,2.515e01,
	  4.612e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][24][j] = _itmp1054[j];
		}
	}
	{ static float _itmp1055[] = {7.280e02,1.909e02,1.610e02,6.064e01,
	  3.847e00,2.553e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][24][j] = _itmp1055[j];
		}
	}
	{ static float _itmp1056[] = {1.530e02,5.019e01,5.951e00,3.117e02,
	  3.866e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][24][j] = _itmp1056[j];
		}
	}
	{ static float _itmp1057[] = {1.210e02,6.892e01,5.293e01,2.594e01,
	  6.855e00,1.836e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][24][j] = _itmp1057[j];
		}
	}
	{ static float _itmp1058[] = {7.240e01,3.798e01,2.289e02,7.678e01,
	  6.206e00,6.108e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][24][j] = _itmp1058[j];
		}
	}
	{ static float _itmp1059[] = {6.589e03,1.174e03,8.541e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][24][j] = _itmp1059[j];
		}
	}
	{ static float _itmp1060[] = {8.118e02,1.872e02,7.318e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][24][j] = _itmp1060[j];
		}
	}
	{ static float _itmp1061[] = {7.063e02,2.015e02,1.433e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][24][j] = _itmp1061[j];
		}
	}
	{ static float _itmp1062[] = {1.300e02,4.531e01,5.863e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][24][j] = _itmp1062[j];
		}
	}
	{ static float _itmp1063[] = {9.879e01,8.115e01,3.665e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][24][j] = _itmp1063[j];
		}
	}
	{ static float _itmp1064[] = {5.120e01,3.615e01,3.188e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][24][j] = _itmp1064[j];
		}
	}
	{ static float _itmp1065[] = {6.576e03,1.154e03,8.979e00,2.899e01,
	  1.859e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][24][j] = _itmp1065[j];
		}
	}
}
static void blkdata10m(void)
{
	int j;
	{ static float _itmp1066[] = {7.947e02,2.016e02,6.777e00,2.756e01,
	  4.332e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][24][j] = _itmp1066[j];
		}
	}
	{ static float _itmp1067[] = {6.822e02,1.908e02,1.609e02,6.198e01,
	  3.835e00,2.549e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][24][j] = _itmp1067[j];
		}
	}
	{ static float _itmp1068[] = {1.120e02,4.956e01,5.285e00,2.544e02,
	  4.005e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][24][j] = _itmp1068[j];
		}
	}
	{ static float _itmp1069[] = {8.062e01,7.190e01,4.707e01,2.356e01,
	  6.977e00,2.565e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][24][j] = _itmp1069[j];
		}
	}
	{ static float _itmp1070[] = {3.367e01,1.604e01,1.991e05,2.538e00,
	  1.808e01,6.536e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][24][j] = _itmp1070[j];
		}
	}
	{ static float _itmp1071[] = {6.564e03,8.684e02,1.627e01,2.405e01,
	  2.207e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][24][j] = _itmp1071[j];
		}
	}
	{ static float _itmp1072[] = {7.849e02,1.346e02,9.823e00,1.970e01,
	  5.386e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][24][j] = _itmp1072[j];
		}
	}
	{ static float _itmp1073[] = {6.714e02,2.207e02,1.185e02,9.212e01,
	  3.460e00,1.974e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][24][j] = _itmp1073[j];
		}
	}
	{ static float _itmp1074[] = {1.015e02,4.359e01,5.735e00,1.016e02,
	  4.563e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][24][j] = _itmp1074[j];
		}
	}
	{ static float _itmp1075[] = {7.009e01,7.141e01,4.984e01,2.130e01,
	  7.133e00,2.616e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][24][j] = _itmp1075[j];
		}
	}
	{ static float _itmp1076[] = {2.058e01,1.624e01,2.592e05,2.411e00,
	  1.797e01,4.774e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][24][j] = _itmp1076[j];
		}
	}
	{ static float _itmp1077[] = {1.564e01,9.306e00,1.189e00,1.439e09,
	  4.095e00,8.740e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][23][24][j] = _itmp1077[j];
		}
	}
	{ static float _itmp1078[] = {6.550e03,8.758e02,1.592e01,3.965e01,
	  1.947e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][24][j] = _itmp1078[j];
		}
	}
	{ static float _itmp1079[] = {7.816e02,8.316e01,1.156e01,2.187e01,
	  6.149e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][24][j] = _itmp1079[j];
		}
	}
	{ static float _itmp1080[] = {6.554e02,2.737e02,7.498e01,3.952e02,
	  2.793e00,4.661e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][24][j] = _itmp1080[j];
		}
	}
	{ static float _itmp1081[] = {9.460e01,4.114e01,6.172e00,5.928e01,
	  4.989e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][24][j] = _itmp1081[j];
		}
	}
	{ static float _itmp1082[] = {5.940e01,7.040e01,6.697e01,1.485e01,
	  7.643e00,2.659e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][24][j] = _itmp1082[j];
		}
	}
	{ static float _itmp1083[] = {1.430e01,1.311e01,1.668e04,4.497e00,
	  1.646e01,3.881e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][24][j] = _itmp1083[j];
		}
	}
	{ static float _itmp1084[] = {7.434e00,1.183e01,1.549e00,2.920e06,
	  4.113e00,3.256e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][24][24][j] = _itmp1084[j];
		}
	}
	{ static float _itmp1085[] = {9.278e03,2.932e02,8.099e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][25][j] = _itmp1085[j];
		}
	}
	{ static float _itmp1086[] = {8.829e03,1.057e03,1.195e01,5.769e01,
	  1.718e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][25][j] = _itmp1086[j];
		}
	}
	{ static float _itmp1087[] = {8.638e03,1.087e03,1.157e01,5.086e01,
	  1.722e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][25][j] = _itmp1087[j];
		}
	}
	{ static float _itmp1088[] = {2.046e03,1.873e02,5.833e00,3.849e01,
	  3.998e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][25][j] = _itmp1088[j];
		}
	}
	{ static float _itmp1089[] = {8.484e03,1.215e03,9.098e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][25][j] = _itmp1089[j];
		}
	}
	{ static float _itmp1090[] = {1.950e03,1.799e02,1.138e01,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][25][j] = _itmp1090[j];
		}
	}
	{ static float _itmp1091[] = {8.350e03,1.066e03,1.181e01,4.116e01,
	  1.827e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][25][j] = _itmp1091[j];
		}
	}
	{ static float _itmp1092[] = {1.847e03,1.708e02,1.125e01,2.839e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][25][j] = _itmp1092[j];
		}
	}
	{ static float _itmp1093[] = {1.799e03,8.070e01,2.675e02,1.191e02,
	  4.194e00,1.901e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][25][j] = _itmp1093[j];
		}
	}
	{ static float _itmp1094[] = {8.184e03,1.228e03,8.773e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][25][j] = _itmp1094[j];
		}
	}
	{ static float _itmp1095[] = {1.745e03,1.860e02,9.942e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][25][j] = _itmp1095[j];
		}
	}
	{ static float _itmp1096[] = {1.689e03,1.970e02,7.720e01,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][25][j] = _itmp1096[j];
		}
	}
	{ static float _itmp1097[] = {8.041e03,1.235e03,8.619e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][25][j] = _itmp1097[j];
		}
	}
	{ static float _itmp1098[] = {1.648e03,1.888e02,9.298e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][25][j] = _itmp1098[j];
		}
	}
	{ static float _itmp1099[] = {1.582e03,1.975e02,1.093e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][25][j] = _itmp1099[j];
		}
	}
	{ static float _itmp1100[] = {7.918e03,1.068e03,1.155e01,3.578e01,
	  1.895e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][25][j] = _itmp1100[j];
		}
	}
	{ static float _itmp1101[] = {1.559e03,1.623e02,1.000e01,2.675e01,
	  4.711e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][25][j] = _itmp1101[j];
		}
	}
	{ static float _itmp1102[] = {1.456e03,1.338e02,3.000e02,7.010e01,
	  4.143e00,1.631e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][25][j] = _itmp1102[j];
		}
	}
	{ static float _itmp1103[] = {7.769e03,1.249e03,8.327e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][25][j] = _itmp1103[j];
		}
	}
	{ static float _itmp1104[] = {1.460e03,1.940e02,8.150e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][25][j] = _itmp1104[j];
		}
	}
	{ static float _itmp1105[] = {1.358e03,1.999e02,1.561e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][25][j] = _itmp1105[j];
		}
	}
	{ static float _itmp1106[] = {7.651e03,1.067e03,1.150e01,3.412e01,
	  1.922e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][25][j] = _itmp1106[j];
		}
	}
	{ static float _itmp1107[] = {1.375e03,1.534e02,9.191e00,2.691e01,
	  4.849e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][25][j] = _itmp1107[j];
		}
	}
	{ static float _itmp1108[] = {1.262e03,1.412e02,3.368e02,5.569e01,
	  4.328e00,1.177e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][25][j] = _itmp1108[j];
		}
	}
	{ static float _itmp1109[] = {7.599e03,1.061e03,1.161e01,3.713e01,
	  1.889e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][25][j] = _itmp1109[j];
		}
	}
	{ static float _itmp1110[] = {1.329e03,1.363e02,9.940e00,3.026e01,
	  4.885e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][25][j] = _itmp1110[j];
		}
	}
	{ static float _itmp1111[] = {1.216e03,1.396e02,3.383e02,5.459e01,
	  4.366e00,1.179e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][25][j] = _itmp1111[j];
		}
	}
	{ static float _itmp1112[] = {4.893e02,2.873e01,1.207e01,5.150e02,
	  3.846e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][25][j] = _itmp1112[j];
		}
	}
	{ static float _itmp1113[] = {7.553e03,1.258e03,8.097e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][25][j] = _itmp1113[j];
		}
	}
	{ static float _itmp1114[] = {1.287e03,1.967e02,7.555e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][25][j] = _itmp1114[j];
		}
	}
	{ static float _itmp1115[] = {1.181e03,2.136e02,1.496e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][25][j] = _itmp1115[j];
		}
	}
	{ static float _itmp1116[] = {4.570e02,4.064e01,1.228e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][25][j] = _itmp1116[j];
		}
	}
	{ static float _itmp1117[] = {7.499e03,1.112e03,1.052e01,3.562e01,
	  1.871e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][25][j] = _itmp1117[j];
		}
	}
	{ static float _itmp1118[] = {1.240e03,1.724e02,8.240e00,2.693e01,
	  4.675e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][25][j] = _itmp1118[j];
		}
	}
	{ static float _itmp1119[] = {1.125e03,1.387e02,3.367e02,5.279e01,
	  4.407e00,1.111e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][25][j] = _itmp1119[j];
		}
	}
	{ static float _itmp1120[] = {4.238e02,7.077e01,7.969e00,5.650e02,
	  3.329e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][25][j] = _itmp1120[j];
		}
	}
	{ static float _itmp1121[] = {3.922e02,7.993e01,1.135e01,5.807e01,
	  5.676e00,6.512e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][25][j] = _itmp1121[j];
		}
	}
	{ static float _itmp1122[] = {7.450e03,1.103e03,1.069e01,3.585e01,
	  1.875e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][25][j] = _itmp1122[j];
		}
	}
	{ static float _itmp1123[] = {1.197e03,1.722e02,8.199e00,2.626e01,
	  4.710e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][25][j] = _itmp1123[j];
		}
	}
	{ static float _itmp1124[] = {1.081e03,1.392e02,3.316e02,5.237e01,
	  4.410e00,1.107e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][25][j] = _itmp1124[j];
		}
	}
	{ static float _itmp1125[] = {3.916e02,6.712e01,8.093e00,5.886e02,
	  3.360e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][25][j] = _itmp1125[j];
		}
	}
	{ static float _itmp1126[] = {3.610e02,8.203e01,2.092e01,6.128e01,
	  5.596e00,3.441e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][25][j] = _itmp1126[j];
		}
	}
	{ static float _itmp1127[] = {7.403e03,1.096e03,1.083e01,3.612e01,
	  1.878e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][25][j] = _itmp1127[j];
		}
	}
	{ static float _itmp1128[] = {1.155e03,1.720e02,8.161e00,2.570e01,
	  4.741e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][25][j] = _itmp1128[j];
		}
	}
	{ static float _itmp1129[] = {1.039e03,1.383e02,3.325e02,5.090e01,
	  4.446e00,1.114e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][25][j] = _itmp1129[j];
		}
	}
	{ static float _itmp1130[] = {3.600e02,6.329e01,8.143e00,5.637e02,
	  3.421e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][25][j] = _itmp1130[j];
		}
	}
	{ static float _itmp1131[] = {3.308e02,8.150e01,3.022e01,6.039e01,
	  5.612e00,2.772e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][25][j] = _itmp1131[j];
		}
	}
	{ static float _itmp1132[] = {7.359e03,1.095e03,1.084e01,3.598e01,
	  1.880e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][25][j] = _itmp1132[j];
		}
	}
	{ static float _itmp1133[] = {1.115e03,1.714e02,8.138e00,2.516e01,
	  4.774e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][25][j] = _itmp1133[j];
		}
	}
	{ static float _itmp1134[] = {9.983e02,1.632e02,2.449e02,5.452e01,
	  4.187e00,1.594e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][25][j] = _itmp1134[j];
		}
	}
	{ static float _itmp1135[] = {3.292e02,6.060e01,7.963e00,5.214e02,
	  3.487e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][25][j] = _itmp1135[j];
		}
	}
	{ static float _itmp1136[] = {2.902e02,7.972e01,3.922e01,5.574e01,
	  5.729e00,2.828e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][25][j] = _itmp1136[j];
		}
	}
	{ static float _itmp1137[] = {7.316e03,1.098e03,1.078e01,3.596e01,
	  1.878e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][25][j] = _itmp1137[j];
		}
	}
	{ static float _itmp1138[] = {1.076e03,1.710e02,8.135e00,2.440e01,
	  4.817e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][25][j] = _itmp1138[j];
		}
	}
	{ static float _itmp1139[] = {9.590e02,1.647e02,2.392e02,5.276e01,
	  4.204e00,1.574e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][25][j] = _itmp1139[j];
		}
	}
	{ static float _itmp1140[] = {2.990e02,5.854e01,7.650e00,4.679e02,
	  3.561e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][25][j] = _itmp1140[j];
		}
	}
	{ static float _itmp1141[] = {2.621e02,7.914e01,4.686e01,5.125e01,
	  5.835e00,2.574e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][25][j] = _itmp1141[j];
		}
	}
	{ static float _itmp1142[] = {7.275e03,1.102e03,1.068e01,3.576e01,
	  1.878e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][25][j] = _itmp1142[j];
		}
	}
	{ static float _itmp1143[] = {1.039e03,1.706e02,8.130e00,2.387e01,
	  4.850e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][25][j] = _itmp1143[j];
		}
	}
	{ static float _itmp1144[] = {9.211e02,1.715e02,2.205e02,5.298e01,
	  4.154e00,1.508e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][25][j] = _itmp1144[j];
		}
	}
	{ static float _itmp1145[] = {2.696e02,5.701e01,7.237e00,4.092e02,
	  3.643e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][25][j] = _itmp1145[j];
		}
	}
	{ static float _itmp1146[] = {2.336e02,7.704e01,5.530e01,4.380e01,
	  6.059e00,2.673e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][25][j] = _itmp1146[j];
		}
	}
	{ static float _itmp1147[] = {7.237e03,1.103e03,1.067e01,3.584e01,
	  1.876e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][25][j] = _itmp1147[j];
		}
	}
	{ static float _itmp1148[] = {1.003e03,1.694e02,8.158e00,2.345e01,
	  4.887e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][25][j] = _itmp1148[j];
		}
	}
	{ static float _itmp1149[] = {8.849e02,1.788e02,2.032e02,5.293e01,
	  4.107e00,1.398e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][25][j] = _itmp1149[j];
		}
	}
	{ static float _itmp1150[] = {2.409e02,5.450e01,6.938e00,3.605e02,
	  3.741e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][25][j] = _itmp1150[j];
		}
	}
	{ static float _itmp1151[] = {2.055e02,7.556e01,5.336e01,3.855e01,
	  6.265e00,2.667e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][25][j] = _itmp1151[j];
		}
	}
	{ static float _itmp1152[] = {1.511e02,3.652e01,1.323e02,9.277e01,
	  6.150e00,2.051e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][25][j] = _itmp1152[j];
		}
	}
	{ static float _itmp1153[] = {7.217e03,1.110e03,1.055e01,3.563e01,
	  1.873e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][25][j] = _itmp1153[j];
		}
	}
	{ static float _itmp1154[] = {9.693e02,1.694e02,8.138e00,2.316e01,
	  4.905e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][25][j] = _itmp1154[j];
		}
	}
	{ static float _itmp1155[] = {8.512e02,1.840e02,1.920e02,5.238e01,
	  4.082e00,1.377e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][25][j] = _itmp1155[j];
		}
	}
	{ static float _itmp1156[] = {2.135e02,5.365e01,6.463e00,3.169e02,
	  3.824e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][25][j] = _itmp1156[j];
		}
	}
	{ static float _itmp1157[] = {1.783e02,7.433e01,5.210e01,3.306e01,
	  6.509e00,2.404e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][25][j] = _itmp1157[j];
		}
	}
	{ static float _itmp1158[] = {1.250e02,4.332e01,1.701e02,9.791e01,
	  5.905e00,2.604e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][25][j] = _itmp1158[j];
		}
	}
	{ static float _itmp1159[] = {7.199e03,1.113e03,1.049e01,3.537e01,
	  1.874e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][25][j] = _itmp1159[j];
		}
	}
	{ static float _itmp1160[] = {9.383e02,1.803e02,7.682e00,2.415e01,
	  4.757e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][25][j] = _itmp1160[j];
		}
	}
	{ static float _itmp1161[] = {8.202e02,1.952e02,1.709e02,5.690e01,
	  3.953e00,1.330e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][25][j] = _itmp1161[j];
		}
	}
	{ static float _itmp1162[] = {1.876e02,5.277e01,6.047e00,2.797e02,
	  3.910e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][25][j] = _itmp1162[j];
		}
	}
	{ static float _itmp1163[] = {1.527e02,7.260e01,5.246e01,2.751e01,
	  6.823e00,2.105e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][25][j] = _itmp1163[j];
		}
	}
	{ static float _itmp1164[] = {9.906e01,4.487e01,2.082e02,9.579e01,
	  5.914e00,2.368e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][25][j] = _itmp1164[j];
		}
	}
	{ static float _itmp1165[] = {7.184e03,1.124e03,1.027e01,3.534e01,
	  1.866e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][25][j] = _itmp1165[j];
		}
	}
	{ static float _itmp1166[] = {9.101e02,1.818e02,7.623e00,2.401e01,
	  4.752e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][25][j] = _itmp1166[j];
		}
	}
	{ static float _itmp1167[] = {7.920e02,1.996e02,1.636e02,5.719e01,
	  3.924e00,1.320e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][25][j] = _itmp1167[j];
		}
	}
	{ static float _itmp1168[] = {1.633e02,5.218e01,5.672e00,2.482e02,
	  3.991e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][25][j] = _itmp1168[j];
		}
	}
	{ static float _itmp1169[] = {1.288e02,7.273e01,5.143e01,2.428e01,
	  7.028e00,1.365e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][25][j] = _itmp1169[j];
		}
	}
	{ static float _itmp1170[] = {7.501e01,4.369e01,2.661e02,6.273e01,
	  6.344e00,2.402e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][25][j] = _itmp1170[j];
		}
	}
	{ static float _itmp1171[] = {7.169e03,1.155e03,9.711e00,3.329e01,
	  1.869e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][25][j] = _itmp1171[j];
		}
	}
	{ static float _itmp1172[] = {8.871e02,2.059e02,6.695e00,2.772e01,
	  4.410e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][25][j] = _itmp1172[j];
		}
	}
	{ static float _itmp1173[] = {7.669e02,2.032e02,1.578e02,5.933e01,
	  3.879e00,1.308e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][25][j] = _itmp1173[j];
		}
	}
	{ static float _itmp1174[] = {1.411e02,5.256e01,5.295e00,2.332e02,
	  4.036e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][25][j] = _itmp1174[j];
		}
	}
	{ static float _itmp1175[] = {1.067e02,7.625e01,4.810e01,2.286e01,
	  7.043e00,2.449e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][25][j] = _itmp1175[j];
		}
	}
	{ static float _itmp1176[] = {5.480e01,4.154e01,3.683e02,3.529e01,
	  7.056e00,3.316e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][25][j] = _itmp1176[j];
		}
	}
	{ static float _itmp1177[] = {7.155e03,1.245e03,8.309e00,3.170e01,
	  1.826e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][25][j] = _itmp1177[j];
		}
	}
	{ static float _itmp1178[] = {8.710e02,2.158e02,6.454e00,2.722e01,
	  4.355e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][25][j] = _itmp1178[j];
		}
	}
	{ static float _itmp1179[] = {7.451e02,2.023e02,1.591e02,5.990e01,
	  3.878e00,1.309e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][25][j] = _itmp1179[j];
		}
	}
}
static void blkdata10n(void)
{
	int j;
	{ static float _itmp1180[] = {1.211e02,5.277e01,5.015e00,2.131e02,
	  4.093e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][25][j] = _itmp1180[j];
		}
	}
	{ static float _itmp1181[] = {8.705e01,7.777e01,4.422e01,2.336e01,
	  7.017e00,2.557e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][25][j] = _itmp1181[j];
		}
	}
	{ static float _itmp1182[] = {3.065e01,2.670e01,6.301e03,5.385e00,
	  1.232e01,4.407e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][25][j] = _itmp1182[j];
		}
	}
	{ static float _itmp1183[] = {7.140e03,8.931e02,1.666e01,2.381e01,
	  2.262e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][25][j] = _itmp1183[j];
		}
	}
	{ static float _itmp1184[] = {8.608e02,1.431e02,9.289e00,2.026e01,
	  5.376e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][25][j] = _itmp1184[j];
		}
	}
	{ static float _itmp1185[] = {7.341e02,2.281e02,1.241e02,8.058e01,
	  3.572e00,1.223e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][25][j] = _itmp1185[j];
		}
	}
	{ static float _itmp1186[] = {1.102e02,4.663e01,5.434e00,9.271e01,
	  4.640e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][25][j] = _itmp1186[j];
		}
	}
	{ static float _itmp1187[] = {7.617e01,7.750e01,4.624e01,2.155e01,
	  7.138e00,2.599e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][25][j] = _itmp1187[j];
		}
	}
	{ static float _itmp1188[] = {2.193e01,1.933e01,3.679e04,3.564e00,
	  1.566e01,4.144e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][25][j] = _itmp1188[j];
		}
	}
	{ static float _itmp1189[] = {1.619e01,1.014e01,1.084e00,2.562e04,
	  4.167e00,1.598e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][24][25][j] = _itmp1189[j];
		}
	}
	{ static float _itmp1190[] = {7.124e03,8.044e02,2.055e01,3.633e01,
	  2.118e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][25][25][j] = _itmp1190[j];
		}
	}
	{ static float _itmp1191[] = {8.570e02,5.727e01,1.076e01,2.785e01,
	  6.635e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][25][25][j] = _itmp1191[j];
		}
	}
	{ static float _itmp1192[] = {7.240e02,2.948e02,7.191e01,3.219e02,
	  2.837e00,6.314e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][25][25][j] = _itmp1192[j];
		}
	}
	{ static float _itmp1193[] = {1.040e02,4.334e01,5.921e00,5.293e01,
	  5.129e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][25][25][j] = _itmp1193[j];
		}
	}
	{ static float _itmp1194[] = {6.600e01,7.630e01,6.298e01,1.479e01,
	  7.672e00,2.646e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][25][25][j] = _itmp1194[j];
		}
	}
	{ static float _itmp1195[] = {1.470e01,1.407e01,1.850e04,4.458e00,
	  1.691e01,4.039e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][25][25][j] = _itmp1195[j];
		}
	}
	{ static float _itmp1196[] = {7.902e00,1.277e01,1.468e00,1.116e05,
	  4.112e00,3.238e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][25][25][j] = _itmp1196[j];
		}
	}
	{ static float _itmp1197[] = {1.001e04,3.163e02,7.510e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][26][j] = _itmp1197[j];
		}
	}
	{ static float _itmp1198[] = {9.545e03,1.251e03,9.046e00,6.786e01,
	  1.613e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][26][j] = _itmp1198[j];
		}
	}
	{ static float _itmp1199[] = {9.347e03,1.249e03,9.384e00,6.378e01,
	  1.609e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][26][j] = _itmp1199[j];
		}
	}
	{ static float _itmp1200[] = {2.219e03,2.352e02,4.599e00,3.873e01,
	  3.808e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][26][j] = _itmp1200[j];
		}
	}
	{ static float _itmp1201[] = {9.205e03,1.267e03,9.026e00,6.059e01,
	  1.619e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][26][j] = _itmp1201[j];
		}
	}
	{ static float _itmp1202[] = {2.119e03,1.593e02,1.253e01,3.366e01,
	  4.493e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][26][j] = _itmp1202[j];
		}
	}
	{ static float _itmp1203[] = {9.046e03,1.275e03,8.806e00,5.513e01,
	  1.651e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][26][j] = _itmp1203[j];
		}
	}
	{ static float _itmp1204[] = {2.012e03,1.799e02,1.074e01,2.878e01,
	  4.518e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][26][j] = _itmp1204[j];
		}
	}
	{ static float _itmp1205[] = {1.961e03,1.923e02,4.987e01,9.392e01,
	  3.631e00,2.239e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][26][j] = _itmp1205[j];
		}
	}
	{ static float _itmp1206[] = {8.890e03,1.277e03,8.703e00,5.267e01,
	  1.668e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][26][j] = _itmp1206[j];
		}
	}
	{ static float _itmp1207[] = {1.910e03,1.760e02,1.043e01,2.775e01,
	  4.612e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][26][j] = _itmp1207[j];
		}
	}
	{ static float _itmp1208[] = {1.846e03,2.159e02,7.348e01,9.457e01,
	  3.535e00,1.182e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][26][j] = _itmp1208[j];
		}
	}
	{ static float _itmp1209[] = {8.718e03,1.330e03,8.042e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][26][j] = _itmp1209[j];
		}
	}
	{ static float _itmp1210[] = {1.803e03,2.030e02,8.771e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][26][j] = _itmp1210[j];
		}
	}
	{ static float _itmp1211[] = {1.735e03,2.134e02,1.027e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][26][j] = _itmp1211[j];
		}
	}
	{ static float _itmp1212[] = {8.595e03,1.260e03,8.868e00,4.790e01,
	  1.717e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][26][j] = _itmp1212[j];
		}
	}
	{ static float _itmp1213[] = {1.711e03,1.706e02,9.597e00,2.731e01,
	  4.722e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][26][j] = _itmp1213[j];
		}
	}
	{ static float _itmp1214[] = {1.603e03,2.448e02,9.893e01,9.263e01,
	  3.432e00,9.870e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][26][j] = _itmp1214[j];
		}
	}
	{ static float _itmp1215[] = {8.433e03,1.344e03,7.779e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][26][j] = _itmp1215[j];
		}
	}
	{ static float _itmp1216[] = {1.606e03,2.084e02,7.728e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][26][j] = _itmp1216[j];
		}
	}
	{ static float _itmp1217[] = {1.505e03,2.157e02,1.481e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][26][j] = _itmp1217[j];
		}
	}
	{ static float _itmp1218[] = {8.315e03,1.252e03,8.903e00,4.635e01,
	  1.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][26][j] = _itmp1218[j];
		}
	}
	{ static float _itmp1219[] = {1.519e03,1.643e02,8.754e00,2.695e01,
	  4.851e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][26][j] = _itmp1219[j];
		}
	}
	{ static float _itmp1220[] = {1.397e03,2.062e02,1.816e02,6.860e01,
	  3.824e00,9.070e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][26][j] = _itmp1220[j];
		}
	}
	{ static float _itmp1221[] = {8.260e03,1.249e03,8.967e00,4.909e01,
	  1.719e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][26][j] = _itmp1221[j];
		}
	}
	{ static float _itmp1222[] = {1.470e03,1.433e02,9.597e00,2.996e01,
	  4.928e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][26][j] = _itmp1222[j];
		}
	}
	{ static float _itmp1223[] = {1.362e03,2.054e02,1.804e02,6.660e01,
	  3.855e00,8.999e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][26][j] = _itmp1223[j];
		}
	}
	{ static float _itmp1224[] = {5.466e02,1.262e01,2.734e01,6.463e02,
	  4.280e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][26][j] = _itmp1224[j];
		}
	}
	{ static float _itmp1225[] = {8.207e03,1.277e03,8.536e00,4.760e01,
	  1.714e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][26][j] = _itmp1225[j];
		}
	}
	{ static float _itmp1226[] = {1.423e03,1.673e02,8.543e00,2.705e01,
	  4.820e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][26][j] = _itmp1226[j];
		}
	}
	{ static float _itmp1227[] = {1.314e03,2.058e02,1.783e02,6.530e01,
	  3.868e00,8.972e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][26][j] = _itmp1227[j];
		}
	}
	{ static float _itmp1228[] = {5.120e02,2.690e01,2.122e01,3.166e02,
	  4.210e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][26][j] = _itmp1228[j];
		}
	}
	{ static float _itmp1229[] = {8.154e03,1.277e03,8.527e00,4.599e01,
	  1.727e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][26][j] = _itmp1229[j];
		}
	}
	{ static float _itmp1230[] = {1.376e03,1.726e02,8.292e00,2.627e01,
	  4.812e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][26][j] = _itmp1230[j];
		}
	}
	{ static float _itmp1231[] = {1.266e03,1.933e02,2.002e02,6.453e01,
	  3.945e00,9.099e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][26][j] = _itmp1231[j];
		}
	}
	{ static float _itmp1232[] = {4.777e02,2.652e01,1.977e01,2.830e02,
	  4.297e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][26][j] = _itmp1232[j];
		}
	}
	{ static float _itmp1233[] = {4.440e02,1.358e02,6.171e00,4.715e01,
	  5.247e00,8.240e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][26][j] = _itmp1233[j];
		}
	}
	{ static float _itmp1234[] = {8.102e03,1.272e03,8.593e00,4.604e01,
	  1.730e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][26][j] = _itmp1234[j];
		}
	}
	{ static float _itmp1235[] = {1.331e03,1.718e02,8.247e00,2.592e01,
	  4.840e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][26][j] = _itmp1235[j];
		}
	}
	{ static float _itmp1236[] = {1.219e03,1.931e02,1.993e02,6.407e01,
	  3.953e00,9.111e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][26][j] = _itmp1236[j];
		}
	}
	{ static float _itmp1237[] = {4.436e02,2.529e01,1.979e01,2.943e02,
	  4.315e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][26][j] = _itmp1237[j];
		}
	}
	{ static float _itmp1238[] = {4.110e02,9.918e01,1.786e01,5.216e01,
	  5.592e00,5.707e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][26][j] = _itmp1238[j];
		}
	}
	{ static float _itmp1239[] = {8.045e03,1.361e03,7.456e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][26][j] = _itmp1239[j];
		}
	}
	{ static float _itmp1240[] = {1.281e03,2.135e02,6.900e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][26][j] = _itmp1240[j];
		}
	}
	{ static float _itmp1241[] = {1.167e03,2.301e02,1.403e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][26][j] = _itmp1241[j];
		}
	}
	{ static float _itmp1242[] = {4.088e02,4.412e01,1.052e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][26][j] = _itmp1242[j];
		}
	}
	{ static float _itmp1243[] = {3.790e02,8.885e01,2.993e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][26][j] = _itmp1243[j];
		}
	}
	{ static float _itmp1244[] = {8.005e03,1.264e03,8.703e00,4.638e01,
	  1.732e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][26][j] = _itmp1244[j];
		}
	}
	{ static float _itmp1245[] = {1.244e03,1.755e02,8.017e00,2.508e01,
	  4.854e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][26][j] = _itmp1245[j];
		}
	}
	{ static float _itmp1246[] = {1.131e03,1.925e02,1.972e02,6.228e01,
	  3.980e00,9.096e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][26][j] = _itmp1246[j];
		}
	}
	{ static float _itmp1247[] = {3.775e02,2.185e01,1.954e01,3.125e02,
	  4.423e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][26][j] = _itmp1247[j];
		}
	}
	{ static float _itmp1248[] = {3.360e02,9.235e01,3.595e01,4.513e01,
	  5.839e00,5.704e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][26][j] = _itmp1248[j];
		}
	}
	{ static float _itmp1249[] = {7.951e03,1.362e03,7.447e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][26][j] = _itmp1249[j];
		}
	}
	{ static float _itmp1250[] = {1.196e03,2.146e02,6.772e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][26][j] = _itmp1250[j];
		}
	}
	{ static float _itmp1251[] = {1.080e03,2.305e02,1.383e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][26][j] = _itmp1251[j];
		}
	}
	{ static float _itmp1252[] = {3.439e02,4.522e01,9.201e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][26][j] = _itmp1252[j];
		}
	}
	{ static float _itmp1253[] = {3.053e02,8.909e01,4.487e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][26][j] = _itmp1253[j];
		}
	}
	{ static float _itmp1254[] = {7.915e03,1.266e03,8.671e00,4.646e01,
	  1.731e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][26][j] = _itmp1254[j];
		}
	}
	{ static float _itmp1255[] = {1.163e03,1.808e02,7.771e00,2.435e01,
	  4.849e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][26][j] = _itmp1255[j];
		}
	}
	{ static float _itmp1256[] = {1.048e03,1.922e02,1.949e02,5.995e01,
	  4.013e00,9.089e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][26][j] = _itmp1256[j];
		}
	}
	{ static float _itmp1257[] = {3.142e02,3.099e01,1.193e01,2.258e02,
	  4.398e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][26][j] = _itmp1257[j];
		}
	}
	{ static float _itmp1258[] = {2.754e02,9.052e01,5.045e01,4.052e01,
	  6.001e00,4.620e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][26][j] = _itmp1258[j];
		}
	}
	{ static float _itmp1259[] = {7.877e03,1.287e03,8.375e00,4.957e01,
	  1.697e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][26][j] = _itmp1259[j];
		}
	}
	{ static float _itmp1260[] = {1.123e03,1.802e02,7.760e00,2.395e01,
	  4.878e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][26][j] = _itmp1260[j];
		}
	}
	{ static float _itmp1261[] = {1.009e03,1.943e02,1.901e02,5.795e01,
	  4.029e00,8.959e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][26][j] = _itmp1261[j];
		}
	}
	{ static float _itmp1262[] = {2.833e02,3.765e01,9.284e00,1.936e02,
	  4.355e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][26][j] = _itmp1262[j];
		}
	}
	{ static float _itmp1263[] = {2.450e02,9.011e01,4.789e01,3.807e01,
	  6.102e00,4.132e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][26][j] = _itmp1263[j];
		}
	}
	{ static float _itmp1264[] = {1.861e02,3.461e01,1.735e02,7.681e01,
	  6.518e00,1.706e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][26][j] = _itmp1264[j];
		}
	}
	{ static float _itmp1265[] = {7.840e03,1.363e03,7.433e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][26][j] = _itmp1265[j];
		}
	}
	{ static float _itmp1266[] = {1.086e03,2.158e02,6.639e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][26][j] = _itmp1266[j];
		}
	}
	{ static float _itmp1267[] = {9.692e02,2.313e02,1.357e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][26][j] = _itmp1267[j];
		}
	}
	{ static float _itmp1268[] = {2.544e02,4.790e01,7.244e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][26][j] = _itmp1268[j];
		}
	}
	{ static float _itmp1269[] = {2.158e02,9.095e01,4.368e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][26][j] = _itmp1269[j];
		}
	}
	{ static float _itmp1270[] = {1.578e02,4.257e01,2.299e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][26][j] = _itmp1270[j];
		}
	}
	{ static float _itmp1271[] = {7.820e03,1.295e03,8.260e00,5.104e01,
	  1.682e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][26][j] = _itmp1271[j];
		}
	}
	{ static float _itmp1272[] = {1.052e03,1.797e02,7.740e00,2.344e01,
	  4.914e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][26][j] = _itmp1272[j];
		}
	}
	{ static float _itmp1273[] = {9.379e02,2.015e02,1.767e02,5.582e01,
	  4.018e00,8.773e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][26][j] = _itmp1273[j];
		}
	}
	{ static float _itmp1274[] = {2.255e02,4.430e01,6.990e00,1.659e02,
	  4.350e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][26][j] = _itmp1274[j];
		}
	}
	{ static float _itmp1275[] = {1.876e02,8.695e01,4.460e01,3.324e01,
	  6.378e00,3.125e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][26][j] = _itmp1275[j];
		}
	}
	{ static float _itmp1276[] = {1.290e02,4.433e01,2.748e02,5.829e01,
	  6.482e00,1.086e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][26][j] = _itmp1276[j];
		}
	}
	{ static float _itmp1277[] = {7.803e03,1.364e03,7.423e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][26][j] = _itmp1277[j];
		}
	}
	{ static float _itmp1278[] = {1.025e03,2.163e02,6.587e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][26][j] = _itmp1278[j];
		}
	}
	{ static float _itmp1279[] = {9.074e02,2.319e02,1.344e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][26][j] = _itmp1279[j];
		}
	}
	{ static float _itmp1280[] = {1.999e02,5.038e01,6.114e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][26][j] = _itmp1280[j];
		}
	}
	{ static float _itmp1281[] = {1.619e02,9.318e01,3.733e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][26][j] = _itmp1281[j];
		}
	}
	{ static float _itmp1282[] = {1.020e02,4.352e01,3.483e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][26][j] = _itmp1282[j];
		}
	}
	{ static float _itmp1283[] = {7.788e03,1.313e03,8.026e00,5.052e01,
	  1.675e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][26][j] = _itmp1283[j];
		}
	}
	{ static float _itmp1284[] = {9.918e02,1.840e02,7.606e00,2.298e01,
	  4.903e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][26][j] = _itmp1284[j];
		}
	}
	{ static float _itmp1285[] = {8.775e02,2.077e02,1.666e02,5.503e01,
	  3.993e00,8.505e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][26][j] = _itmp1285[j];
		}
	}
	{ static float _itmp1286[] = {1.740e02,5.017e01,5.619e00,1.481e02,
	  4.342e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][26][j] = _itmp1286[j];
		}
	}
	{ static float _itmp1287[] = {1.366e02,8.377e01,4.275e01,2.773e01,
	  6.744e00,2.457e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][26][j] = _itmp1287[j];
		}
	}
	{ static float _itmp1288[] = {7.950e01,4.369e01,3.792e02,4.396e01,
	  6.895e00,1.079e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][26][j] = _itmp1288[j];
		}
	}
	{ static float _itmp1289[] = {7.773e03,1.365e03,7.414e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][26][j] = _itmp1289[j];
		}
	}
	{ static float _itmp1290[] = {9.708e02,2.166e02,6.563e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][26][j] = _itmp1290[j];
		}
	}
	{ static float _itmp1291[] = {8.556e02,2.326e02,1.332e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][26][j] = _itmp1291[j];
		}
	}
	{ static float _itmp1292[] = {1.495e02,5.342e01,5.159e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][26][j] = _itmp1292[j];
		}
	}
	{ static float _itmp1293[] = {1.128e02,9.621e01,3.175e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][26][j] = _itmp1293[j];
		}
	}
}
static void blkdata10o(void)
{
	int j;
	{ static float _itmp1294[] = {5.127e01,4.530e01,3.755e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][26][j] = _itmp1294[j];
		}
	}
	{ static float _itmp1295[] = {7.758e03,1.487e03,6.149e00,5.282e01,
	  1.571e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][26][j] = _itmp1295[j];
		}
	}
	{ static float _itmp1296[] = {9.547e02,2.172e02,6.667e00,2.353e01,
	  4.602e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][26][j] = _itmp1296[j];
		}
	}
	{ static float _itmp1297[] = {8.295e02,2.089e02,1.651e02,5.457e01,
	  3.992e00,8.474e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][26][j] = _itmp1297[j];
		}
	}
	{ static float _itmp1298[] = {1.305e02,5.435e01,4.874e00,1.379e02,
	  4.336e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][26][j] = _itmp1298[j];
		}
	}
	{ static float _itmp1299[] = {9.362e01,8.419e01,4.192e01,2.297e01,
	  7.043e00,2.547e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][26][j] = _itmp1299[j];
		}
	}
	{ static float _itmp1300[] = {3.350e01,2.181e01,1.205e03,1.434e01,
	  1.114e01,1.266e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][26][j] = _itmp1300[j];
		}
	}
	{ static float _itmp1301[] = {7.742e03,2.079e03,3.020e00,1.067e03,
	  9.653e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][25][26][j] = _itmp1301[j];
		}
	}
	{ static float _itmp1302[] = {9.443e02,1.709e02,8.001e00,2.274e01,
	  5.044e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][25][26][j] = _itmp1302[j];
		}
	}
	{ static float _itmp1303[] = {8.130e02,1.989e02,1.810e02,5.274e01,
	  4.078e00,1.431e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][25][26][j] = _itmp1303[j];
		}
	}
	{ static float _itmp1304[] = {1.213e02,5.602e01,4.666e00,1.358e02,
	  4.323e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][25][26][j] = _itmp1304[j];
		}
	}
	{ static float _itmp1305[] = {7.621e01,8.408e01,4.300e01,2.074e01,
	  7.214e00,2.553e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][25][26][j] = _itmp1305[j];
		}
	}
	{ static float _itmp1306[] = {1.708e01,2.419e00,1.275e01,2.823e01,
	  1.843e01,4.806e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][25][26][j] = _itmp1306[j];
		}
	}
	{ static float _itmp1307[] = {7.725e03,6.269e02,3.582e01,3.161e01,
	  2.476e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][26][26][j] = _itmp1307[j];
		}
	}
	{ static float _itmp1308[] = {9.400e02,8.888e01,1.030e01,2.797e01,
	  5.913e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][26][26][j] = _itmp1308[j];
		}
	}
	{ static float _itmp1309[] = {8.000e02,2.832e02,9.075e01,7.686e01,
	  3.416e00,4.833e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][26][26][j] = _itmp1309[j];
		}
	}
	{ static float _itmp1310[] = {1.150e02,5.097e01,4.896e00,1.198e02,
	  4.513e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][26][26][j] = _itmp1310[j];
		}
	}
	{ static float _itmp1311[] = {7.300e01,8.256e01,4.587e01,1.973e01,
	  7.331e00,2.573e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][26][26][j] = _itmp1311[j];
		}
	}
	{ static float _itmp1312[] = {1.580e01,1.581e01,4.931e03,6.607e00,
	  1.532e01,3.676e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][26][26][j] = _itmp1312[j];
		}
	}
	{ static float _itmp1313[] = {7.864e00,1.370e01,1.555e00,7.559e02,
	  4.337e00,3.355e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][26][26][j] = _itmp1313[j];
		}
	}
	{ static float _itmp1314[] = {1.078e04,3.406e02,6.983e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][27][j] = _itmp1314[j];
		}
	}
	{ static float _itmp1315[] = {1.029e04,1.349e03,8.382e00,7.431e01,
	  1.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][27][j] = _itmp1315[j];
		}
	}
	{ static float _itmp1316[] = {1.008e04,1.373e03,8.336e00,7.347e01,
	  1.558e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][27][j] = _itmp1316[j];
		}
	}
	{ static float _itmp1317[] = {2.399e03,1.314e02,8.142e00,4.522e01,
	  4.477e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][27][j] = _itmp1317[j];
		}
	}
	{ static float _itmp1318[] = {9.937e03,1.382e03,8.149e00,6.782e01,
	  1.580e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][27][j] = _itmp1318[j];
		}
	}
	{ static float _itmp1319[] = {2.295e03,1.813e02,1.117e01,3.332e01,
	  4.426e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][27][j] = _itmp1319[j];
		}
	}
	{ static float _itmp1320[] = {9.771e03,1.404e03,7.788e00,6.396e01,
	  1.592e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][27][j] = _itmp1320[j];
		}
	}
	{ static float _itmp1321[] = {2.184e03,1.649e02,1.145e01,2.997e01,
	  4.706e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][27][j] = _itmp1321[j];
		}
	}
	{ static float _itmp1322[] = {2.131e03,2.473e02,3.198e01,1.014e02,
	  3.435e00,2.062e-06};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][27][j] = _itmp1322[j];
		}
	}
	{ static float _itmp1323[] = {9.609e03,1.415e03,7.600e00,6.229e01,
	  1.599e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][27][j] = _itmp1323[j];
		}
	}
	{ static float _itmp1324[] = {2.077e03,1.726e02,1.052e01,2.738e01,
	  4.768e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][27][j] = _itmp1324[j];
		}
	}
	{ static float _itmp1325[] = {2.011e03,2.139e02,8.219e01,9.511e01,
	  3.615e00,6.838e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][27][j] = _itmp1325[j];
		}
	}
	{ static float _itmp1326[] = {9.423e03,1.429e03,7.520e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][27][j] = _itmp1326[j];
		}
	}
	{ static float _itmp1327[] = {1.965e03,2.177e02,8.285e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][27][j] = _itmp1327[j];
		}
	}
	{ static float _itmp1328[] = {1.894e03,2.300e02,9.666e01,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][27][j] = _itmp1328[j];
		}
	}
	{ static float _itmp1329[] = {9.300e03,1.401e03,7.673e00,5.681e01,
	  1.640e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][27][j] = _itmp1329[j];
		}
	}
	{ static float _itmp1330[] = {1.870e03,1.608e02,9.953e00,2.835e01,
	  4.878e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][27][j] = _itmp1330[j];
		}
	}
	{ static float _itmp1331[] = {1.756e03,2.140e02,1.434e02,7.628e01,
	  3.752e00,5.528e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][27][j] = _itmp1331[j];
		}
	}
	{ static float _itmp1332[] = {9.125e03,1.443e03,7.283e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][27][j] = _itmp1332[j];
		}
	}
	{ static float _itmp1333[] = {1.760e03,2.233e02,7.335e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][27][j] = _itmp1333[j];
		}
	}
	{ static float _itmp1334[] = {1.648e03,2.321e02,1.405e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][27][j] = _itmp1334[j];
		}
	}
	{ static float _itmp1335[] = {9.007e03,1.400e03,7.626e00,5.528e01,
	  1.653e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][27][j] = _itmp1335[j];
		}
	}
	{ static float _itmp1336[] = {1.669e03,1.441e02,9.448e00,2.779e01,
	  5.132e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][27][j] = _itmp1336[j];
		}
	}
	{ static float _itmp1337[] = {1.541e03,2.358e02,1.530e02,7.451e01,
	  3.705e00,4.687e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][27][j] = _itmp1337[j];
		}
	}
	{ static float _itmp1338[] = {8.950e03,1.383e03,7.837e00,5.839e01,
	  1.644e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][27][j] = _itmp1338[j];
		}
	}
	{ static float _itmp1339[] = {1.618e03,1.444e02,9.470e00,3.104e01,
	  4.981e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][27][j] = _itmp1339[j];
		}
	}
	{ static float _itmp1340[] = {1.506e03,2.334e02,1.540e02,7.184e01,
	  3.746e00,4.400e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][27][j] = _itmp1340[j];
		}
	}
	{ static float _itmp1341[] = {6.071e02,1.032e01,3.674e01,8.252e02,
	  4.304e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][27][j] = _itmp1341[j];
		}
	}
	{ static float _itmp1342[] = {8.894e03,1.442e03,7.159e00,6.122e01,
	  1.602e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][27][j] = _itmp1342[j];
		}
	}
	{ static float _itmp1343[] = {1.569e03,1.824e02,8.013e00,2.738e01,
	  4.780e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][27][j] = _itmp1343[j];
		}
	}
	{ static float _itmp1344[] = {1.456e03,2.327e02,1.539e02,7.045e01,
	  3.763e00,4.221e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][27][j] = _itmp1344[j];
		}
	}
	{ static float _itmp1345[] = {5.713e02,2.577e01,2.339e01,3.455e02,
	  4.232e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][27][j] = _itmp1345[j];
		}
	}
	{ static float _itmp1346[] = {8.838e03,1.452e03,7.048e00,6.036e01,
	  1.602e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][27][j] = _itmp1346[j];
		}
	}
	{ static float _itmp1347[] = {1.519e03,1.853e02,7.851e00,2.679e01,
	  4.785e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][27][j] = _itmp1347[j];
		}
	}
	{ static float _itmp1348[] = {1.405e03,2.180e02,1.742e02,6.951e01,
	  3.842e00,4.401e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][27][j] = _itmp1348[j];
		}
	}
	{ static float _itmp1349[] = {5.347e02,2.505e01,2.361e01,3.622e02,
	  4.225e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][27][j] = _itmp1349[j];
		}
	}
	{ static float _itmp1350[] = {4.984e02,1.711e02,4.708e00,4.790e01,
	  5.019e00,8.478e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][27][j] = _itmp1350[j];
		}
	}
	{ static float _itmp1351[] = {8.783e03,1.448e03,7.081e00,6.137e01,
	  1.599e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][27][j] = _itmp1351[j];
		}
	}
	{ static float _itmp1352[] = {1.471e03,1.841e02,7.825e00,2.644e01,
	  4.816e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][27][j] = _itmp1352[j];
		}
	}
	{ static float _itmp1353[] = {1.356e03,2.108e02,1.846e02,6.874e01,
	  3.886e00,4.288e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][27][j] = _itmp1353[j];
		}
	}
	{ static float _itmp1354[] = {4.988e02,2.375e01,2.383e01,3.786e02,
	  4.245e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][27][j] = _itmp1354[j];
		}
	}
	{ static float _itmp1355[] = {4.637e02,1.543e02,1.053e01,4.743e01,
	  5.176e00,8.373e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][27][j] = _itmp1355[j];
		}
	}
	{ static float _itmp1356[] = {8.720e03,1.467e03,6.912e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][27][j] = _itmp1356[j];
		}
	}
	{ static float _itmp1357[] = {1.419e03,2.287e02,6.549e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][27][j] = _itmp1357[j];
		}
	}
	{ static float _itmp1358[] = {1.299e03,2.464e02,1.356e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][27][j] = _itmp1358[j];
		}
	}
	{ static float _itmp1359[] = {4.620e02,4.702e01,1.037e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][27][j] = _itmp1359[j];
		}
	}
	{ static float _itmp1360[] = {4.302e02,9.587e01,2.890e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][27][j] = _itmp1360[j];
		}
	}
	{ static float _itmp1361[] = {8.680e03,1.439e03,7.182e00,6.248e01,
	  1.598e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][27][j] = _itmp1361[j];
		}
	}
	{ static float _itmp1362[] = {1.379e03,1.886e02,7.589e00,2.560e01,
	  4.825e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][27][j] = _itmp1362[j];
		}
	}
	{ static float _itmp1363[] = {1.262e03,2.088e02,1.852e02,6.640e01,
	  3.924e00,4.306e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][27][j] = _itmp1363[j];
		}
	}
	{ static float _itmp1364[] = {4.291e02,2.003e01,2.274e01,3.611e02,
	  4.438e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][27][j] = _itmp1364[j];
		}
	}
	{ static float _itmp1365[] = {3.840e02,1.158e02,2.906e01,4.380e01,
	  5.646e00,7.430e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][27][j] = _itmp1365[j];
		}
	}
	{ static float _itmp1366[] = {8.620e03,1.467e03,6.916e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][27][j] = _itmp1366[j];
		}
	}
	{ static float _itmp1367[] = {1.328e03,2.299e02,6.430e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][27][j] = _itmp1367[j];
		}
	}
	{ static float _itmp1368[] = {1.207e03,2.467e02,1.337e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][27][j] = _itmp1368[j];
		}
	}
	{ static float _itmp1369[] = {3.933e02,4.806e01,9.150e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][27][j] = _itmp1369[j];
		}
	}
	{ static float _itmp1370[] = {3.521e02,9.596e01,4.382e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][27][j] = _itmp1370[j];
		}
	}
	{ static float _itmp1371[] = {8.584e03,1.440e03,7.163e00,6.246e01,
	  1.599e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][27][j] = _itmp1371[j];
		}
	}
	{ static float _itmp1372[] = {1.293e03,1.925e02,7.399e00,2.482e01,
	  4.836e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][27][j] = _itmp1372[j];
		}
	}
	{ static float _itmp1373[] = {1.174e03,2.087e02,1.825e02,6.397e01,
	  3.955e00,4.274e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][27][j] = _itmp1373[j];
		}
	}
	{ static float _itmp1374[] = {3.620e02,2.901e01,1.340e01,2.515e02,
	  4.429e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][27][j] = _itmp1374[j];
		}
	}
	{ static float _itmp1375[] = {3.210e02,1.005e02,4.742e01,4.168e01,
	  5.919e00,5.228e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][27][j] = _itmp1375[j];
		}
	}
	{ static float _itmp1376[] = {8.542e03,1.439e03,7.170e00,6.247e01,
	  1.599e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][27][j] = _itmp1376[j];
		}
	}
	{ static float _itmp1377[] = {1.251e03,1.931e02,7.348e00,2.450e01,
	  4.851e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][27][j] = _itmp1377[j];
		}
	}
	{ static float _itmp1378[] = {1.132e03,2.109e02,1.780e02,6.201e01,
	  3.969e00,4.273e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][27][j] = _itmp1378[j];
		}
	}
	{ static float _itmp1379[] = {3.290e02,3.448e01,1.054e01,2.150e02,
	  4.412e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][27][j] = _itmp1379[j];
		}
	}
	{ static float _itmp1380[] = {2.877e02,1.033e02,4.372e01,3.878e01,
	  5.977e00,5.276e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][27][j] = _itmp1380[j];
		}
	}
	{ static float _itmp1381[] = {2.246e02,3.839e01,1.714e02,7.972e01,
	  6.440e00,1.220e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][27][j] = _itmp1381[j];
		}
	}
	{ static float _itmp1382[] = {8.503e03,1.439e03,7.178e00,6.253e01,
	  1.598e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][27][j] = _itmp1382[j];
		}
	}
	{ static float _itmp1383[] = {1.211e03,1.935e02,7.316e00,2.416e01,
	  4.868e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][27][j] = _itmp1383[j];
		}
	}
	{ static float _itmp1384[] = {1.092e03,2.189e02,1.653e02,6.160e01,
	  3.932e00,4.163e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][27][j] = _itmp1384[j];
		}
	}
	{ static float _itmp1385[] = {2.972e02,3.985e01,8.589e00,1.892e02,
	  4.394e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][27][j] = _itmp1385[j];
		}
	}
	{ static float _itmp1386[] = {2.561e02,1.023e02,4.197e01,3.659e01,
	  6.079e00,4.805e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][27][j] = _itmp1386[j];
		}
	}
	{ static float _itmp1387[] = {1.930e02,4.212e01,2.596e02,6.923e01,
	  6.485e00,1.416e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][27][j] = _itmp1387[j];
		}
	}
	{ static float _itmp1388[] = {8.472e03,1.466e03,6.924e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][27][j] = _itmp1388[j];
		}
	}
	{ static float _itmp1389[] = {1.174e03,2.314e02,6.277e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][27][j] = _itmp1389[j];
		}
	}
	{ static float _itmp1390[] = {1.051e03,2.476e02,1.308e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][27][j] = _itmp1390[j];
		}
	}
	{ static float _itmp1391[] = {2.682e02,5.179e01,6.728e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][27][j] = _itmp1391[j];
		}
	}
	{ static float _itmp1392[] = {2.266e02,9.852e01,4.031e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][27][j] = _itmp1392[j];
		}
	}
	{ static float _itmp1393[] = {1.620e02,4.735e01,2.988e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][27][j] = _itmp1393[j];
		}
	}
	{ static float _itmp1394[] = {8.452e03,1.430e03,7.274e00,6.333e01,
	  1.599e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][27][j] = _itmp1394[j];
		}
	}
	{ static float _itmp1395[] = {1.139e03,1.947e02,7.253e00,2.382e01,
	  4.880e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][27][j] = _itmp1395[j];
		}
	}
	{ static float _itmp1396[] = {1.019e03,2.193e02,1.639e02,5.860e01,
	  3.969e00,4.138e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][27][j] = _itmp1396[j];
		}
	}
	{ static float _itmp1397[] = {2.378e02,4.756e01,6.461e00,1.609e02,
	  4.380e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][27][j] = _itmp1397[j];
		}
	}
	{ static float _itmp1398[] = {1.971e02,9.385e01,4.144e01,3.216e01,
	  6.437e00,3.229e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][27][j] = _itmp1398[j];
		}
	}
	{ static float _itmp1399[] = {1.330e02,5.059e01,3.124e02,5.417e01,
	  6.505e00,1.508e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][27][j] = _itmp1399[j];
		}
	}
	{ static float _itmp1400[] = {8.434e03,1.466e03,6.929e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][27][j] = _itmp1400[j];
		}
	}
	{ static float _itmp1401[] = {1.112e03,2.318e02,6.240e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][27][j] = _itmp1401[j];
		}
	}
	{ static float _itmp1402[] = {9.886e02,2.482e02,1.297e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][27][j] = _itmp1402[j];
		}
	}
	{ static float _itmp1403[] = {2.119e02,5.449e01,5.709e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][27][j] = _itmp1403[j];
		}
	}
	{ static float _itmp1404[] = {1.709e02,1.010e02,3.462e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][27][j] = _itmp1404[j];
		}
	}
	{ static float _itmp1405[] = {1.080e02,4.837e01,3.797e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][27][j] = _itmp1405[j];
		}
	}
	{ static float _itmp1406[] = {8.418e03,1.463e03,6.925e00,6.343e01,
	  1.583e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][27][j] = _itmp1406[j];
		}
	}
	{ static float _itmp1407[] = {1.077e03,1.956e02,7.233e00,2.315e01,
	  4.910e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][27][j] = _itmp1407[j];
		}
	}
}
static void blkdata10p(void)
{
	int j;
	{ static float _itmp1408[] = {9.576e02,2.215e02,1.608e02,5.699e01,
	  3.980e00,4.065e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][27][j] = _itmp1408[j];
		}
	}
	{ static float _itmp1409[] = {1.849e02,5.389e01,5.242e00,1.434e02,
	  4.370e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][27][j] = _itmp1409[j];
		}
	}
	{ static float _itmp1410[] = {1.447e02,9.036e01,4.016e01,2.699e01,
	  6.796e00,2.509e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][27][j] = _itmp1410[j];
		}
	}
	{ static float _itmp1411[] = {7.610e01,4.694e01,4.360e02,3.874e01,
	  7.119e00,3.263e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][27][j] = _itmp1411[j];
		}
	}
	{ static float _itmp1412[] = {8.402e03,1.466e03,6.933e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][27][j] = _itmp1412[j];
		}
	}
	{ static float _itmp1413[] = {1.059e03,2.320e02,6.226e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][27][j] = _itmp1413[j];
		}
	}
	{ static float _itmp1414[] = {9.358e02,2.488e02,1.288e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][27][j] = _itmp1414[j];
		}
	}
	{ static float _itmp1415[] = {1.597e02,5.774e01,4.849e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][27][j] = _itmp1415[j];
		}
	}
	{ static float _itmp1416[] = {1.201e02,1.043e02,2.963e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][27][j] = _itmp1416[j];
		}
	}
	{ static float _itmp1417[] = {5.490e01,5.023e01,3.918e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][27][j] = _itmp1417[j];
		}
	}
	{ static float _itmp1418[] = {8.386e03,1.647e03,5.367e00,6.758e01,
	  1.485e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][25][27][j] = _itmp1418[j];
		}
	}
	{ static float _itmp1419[] = {1.040e03,2.324e02,6.314e00,2.361e01,
	  4.604e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][25][27][j] = _itmp1419[j];
		}
	}
	{ static float _itmp1420[] = {9.084e02,2.230e02,1.588e02,5.650e01,
	  3.977e00,4.038e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][25][27][j] = _itmp1420[j];
		}
	}
	{ static float _itmp1421[] = {1.401e02,5.823e01,4.586e00,1.330e02,
	  4.367e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][25][27][j] = _itmp1421[j];
		}
	}
	{ static float _itmp1422[] = {1.003e02,9.061e01,3.980e01,2.247e01,
	  7.093e00,2.543e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][25][27][j] = _itmp1422[j];
		}
	}
	{ static float _itmp1423[] = {3.532e01,2.971e01,1.965e03,9.751e00,
	  1.140e01,4.019e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][25][27][j] = _itmp1423[j];
		}
	}
	{ static float _itmp1424[] = {8.368e03,2.249e03,2.776e00,1.325e03,
	  9.540e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][26][27][j] = _itmp1424[j];
		}
	}
	{ static float _itmp1425[] = {1.029e03,1.808e02,7.632e00,2.289e01,
	  5.060e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][26][27][j] = _itmp1425[j];
		}
	}
	{ static float _itmp1426[] = {8.903e02,2.205e02,1.625e02,5.653e01,
	  3.990e00,1.246e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][26][27][j] = _itmp1426[j];
		}
	}
	{ static float _itmp1427[] = {1.315e02,6.024e01,4.394e00,1.314e02,
	  4.347e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][26][27][j] = _itmp1427[j];
		}
	}
	{ static float _itmp1428[] = {8.232e01,9.066e01,4.075e01,2.048e01,
	  7.246e00,2.545e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][26][27][j] = _itmp1428[j];
		}
	}
	{ static float _itmp1429[] = {1.817e01,1.501e00,9.258e-01,
	  4.442e01,1.928e01,3.708e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][26][27][j] = _itmp1429[j];
		}
	}
	{ static float _itmp1430[] = {8.348e03,7.366e02,2.836e01,3.622e01,
	  2.316e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][27][27][j] = _itmp1430[j];
		}
	}
	{ static float _itmp1431[] = {1.024e03,1.132e02,9.424e00,2.712e01,
	  5.643e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][27][27][j] = _itmp1431[j];
		}
	}
	{ static float _itmp1432[] = {8.760e02,3.043e02,8.611e01,7.868e01,
	  3.408e00,1.680e-05};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][27][27][j] = _itmp1432[j];
		}
	}
	{ static float _itmp1433[] = {1.250e02,5.448e01,4.611e00,1.157e02,
	  4.548e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][27][27][j] = _itmp1433[j];
		}
	}
	{ static float _itmp1434[] = {8.200e01,8.896e01,4.351e01,1.942e01,
	  7.372e00,2.566e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][27][27][j] = _itmp1434[j];
		}
	}
	{ static float _itmp1435[] = {1.700e01,6.063e00,1.186e03,6.823e00,
	  2.223e01,6.227e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][27][27][j] = _itmp1435[j];
		}
	}
	{ static float _itmp1436[] = {7.637e00,1.468e01,1.437e00,7.411e02,
	  4.342e00,3.908e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][27][27][j] = _itmp1436[j];
		}
	}
	{ static float _itmp1437[] = {1.157e04,3.656e02,6.510e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][28][j] = _itmp1437[j];
		}
	}
	{ static float _itmp1438[] = {1.106e04,1.427e03,8.057e00,7.912e01,
	  1.583e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][28][j] = _itmp1438[j];
		}
	}
	{ static float _itmp1439[] = {1.085e04,1.435e03,8.196e00,7.379e01,
	  1.577e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][28][j] = _itmp1439[j];
		}
	}
	{ static float _itmp1440[] = {2.585e03,1.732e02,6.336e00,4.099e01,
	  4.316e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][28][j] = _itmp1440[j];
		}
	}
	{ static float _itmp1441[] = {1.070e04,1.476e03,7.658e00,7.281e01,
	  1.567e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][28][j] = _itmp1441[j];
		}
	}
	{ static float _itmp1442[] = {2.459e03,1.822e02,1.108e01,3.417e01,
	  4.489e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][28][j] = _itmp1442[j];
		}
	}
	{ static float _itmp1443[] = {1.053e04,1.516e03,7.156e00,7.157e01,
	  1.560e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][28][j] = _itmp1443[j];
		}
	}
	{ static float _itmp1444[] = {2.363e03,2.174e02,9.074e00,2.892e01,
	  4.445e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][28][j] = _itmp1444[j];
		}
	}
	{ static float _itmp1445[] = {2.298e03,1.099e02,1.898e02,1.272e02,
	  4.081e00,2.821e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][28][j] = _itmp1445[j];
		}
	}
	{ static float _itmp1446[] = {1.036e04,1.537e03,6.899e00,7.045e01,
	  1.560e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][28][j] = _itmp1446[j];
		}
	}
	{ static float _itmp1447[] = {2.253e03,2.118e02,8.876e00,2.857e01,
	  4.513e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][28][j] = _itmp1447[j];
		}
	}
	{ static float _itmp1448[] = {2.173e03,1.503e02,1.866e02,1.055e02,
	  3.944e00,1.972e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][28][j] = _itmp1448[j];
		}
	}
	{ static float _itmp1449[] = {1.016e04,1.531e03,7.047e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][28][j] = _itmp1449[j];
		}
	}
	{ static float _itmp1450[] = {2.133e03,2.330e02,7.838e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][28][j] = _itmp1450[j];
		}
	}
	{ static float _itmp1451[] = {2.045e03,2.473e02,9.111e01,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][28][j] = _itmp1451[j];
		}
	}
	{ static float _itmp1452[] = {1.004e04,1.556e03,6.650e00,6.987e01,
	  1.559e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][28][j] = _itmp1452[j];
		}
	}
	{ static float _itmp1453[] = {2.037e03,2.003e02,8.422e00,2.803e01,
	  4.659e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][28][j] = _itmp1453[j];
		}
	}
	{ static float _itmp1454[] = {1.905e03,1.999e02,1.798e02,7.715e01,
	  3.888e00,1.496e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][28][j] = _itmp1454[j];
		}
	}
	{ static float _itmp1455[] = {9.844e03,1.546e03,6.833e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][28][j] = _itmp1455[j];
		}
	}
	{ static float _itmp1456[] = {1.920e03,2.388e02,6.970e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][28][j] = _itmp1456[j];
		}
	}
	{ static float _itmp1457[] = {1.793e03,2.493e02,1.335e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][28][j] = _itmp1457[j];
		}
	}
	{ static float _itmp1458[] = {9.729e03,1.540e03,6.748e00,6.512e01,
	  1.590e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][28][j] = _itmp1458[j];
		}
	}
	{ static float _itmp1459[] = {1.827e03,1.901e02,7.838e00,2.795e01,
	  4.791e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][28][j] = _itmp1459[j];
		}
	}
	{ static float _itmp1460[] = {1.690e03,2.206e02,1.906e02,6.390e01,
	  3.955e00,1.558e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][28][j] = _itmp1460[j];
		}
	}
	{ static float _itmp1461[] = {9.668e03,1.523e03,6.915e00,6.870e01,
	  1.581e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][28][j] = _itmp1461[j];
		}
	}
	{ static float _itmp1462[] = {1.773e03,1.626e02,8.723e00,3.155e01,
	  4.881e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][28][j] = _itmp1462[j];
		}
	}
	{ static float _itmp1463[] = {1.657e03,2.651e02,1.307e02,7.793e01,
	  3.637e00,1.894e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][28][j] = _itmp1463[j];
		}
	}
	{ static float _itmp1464[] = {6.706e02,1.529e01,2.453e01,6.172e02,
	  4.260e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][28][j] = _itmp1464[j];
		}
	}
	{ static float _itmp1465[] = {9.610e03,1.558e03,6.567e00,6.667e01,
	  1.576e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][28][j] = _itmp1465[j];
		}
	}
	{ static float _itmp1466[] = {1.722e03,1.953e02,7.587e00,2.834e01,
	  4.738e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][28][j] = _itmp1466[j];
		}
	}
	{ static float _itmp1467[] = {1.604e03,2.619e02,1.331e02,7.654e01,
	  3.661e00,1.879e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][28][j] = _itmp1467[j];
		}
	}
	{ static float _itmp1468[] = {6.330e02,2.604e01,2.426e01,3.618e02,
	  4.240e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][28][j] = _itmp1468[j];
		}
	}
	{ static float _itmp1469[] = {9.550e03,1.563e03,6.515e00,6.616e01,
	  1.577e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][28][j] = _itmp1469[j];
		}
	}
	{ static float _itmp1470[] = {1.670e03,1.993e02,7.415e00,2.757e01,
	  4.743e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][28][j] = _itmp1470[j];
		}
	}
	{ static float _itmp1471[] = {1.551e03,2.401e02,1.577e02,7.468e01,
	  3.767e00,2.341e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][28][j] = _itmp1471[j];
		}
	}
	{ static float _itmp1472[] = {5.949e02,3.706e01,1.653e01,2.918e02,
	  4.111e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][28][j] = _itmp1472[j];
		}
	}
	{ static float _itmp1473[] = {5.570e02,2.011e02,3.929e00,5.061e01,
	  4.854e00,8.398e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][28][j] = _itmp1473[j];
		}
	}
	{ static float _itmp1474[] = {9.493e03,1.558e03,6.561e00,6.691e01,
	  1.575e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][28][j] = _itmp1474[j];
		}
	}
	{ static float _itmp1475[] = {1.619e03,1.974e02,7.417e00,2.691e01,
	  4.791e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][28][j] = _itmp1475[j];
		}
	}
	{ static float _itmp1476[] = {1.499e03,2.384e02,1.588e02,7.405e01,
	  3.780e00,2.405e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][28][j] = _itmp1476[j];
		}
	}
	{ static float _itmp1477[] = {5.572e02,3.531e01,1.668e01,3.042e02,
	  4.130e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][28][j] = _itmp1477[j];
		}
	}
	{ static float _itmp1478[] = {5.200e02,1.207e02,1.569e01,5.849e01,
	  5.405e00,4.555e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][28][j] = _itmp1478[j];
		}
	}
	{ static float _itmp1479[] = {9.423e03,1.577e03,6.419e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][28][j] = _itmp1479[j];
		}
	}
	{ static float _itmp1480[] = {1.563e03,2.446e02,6.221e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][28][j] = _itmp1480[j];
		}
	}
	{ static float _itmp1481[] = {1.439e03,2.632e02,1.311e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][28][j] = _itmp1481[j];
		}
	}
	{ static float _itmp1482[] = {5.184e02,5.001e01,1.019e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][28][j] = _itmp1482[j];
		}
	}
	{ static float _itmp1483[] = {4.840e02,1.032e02,2.783e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][28][j] = _itmp1483[j];
		}
	}
	{ static float _itmp1484[] = {9.384e03,1.553e03,6.609e00,6.923e01,
	  1.568e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][28][j] = _itmp1484[j];
		}
	}
	{ static float _itmp1485[] = {1.522e03,1.990e02,7.271e00,2.604e01,
	  4.826e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][28][j] = _itmp1485[j];
		}
	}
	{ static float _itmp1486[] = {1.400e03,2.302e02,1.675e02,7.119e01,
	  3.847e00,2.441e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][28][j] = _itmp1486[j];
		}
	}
	{ static float _itmp1487[] = {4.838e02,3.424e01,1.441e01,2.579e02,
	  4.283e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][28][j] = _itmp1487[j];
		}
	}
	{ static float _itmp1488[] = {4.350e02,1.064e02,3.399e01,5.025e01,
	  5.723e00,4.731e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][28][j] = _itmp1488[j];
		}
	}
	{ static float _itmp1489[] = {9.317e03,1.576e03,6.433e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][28][j] = _itmp1489[j];
		}
	}
	{ static float _itmp1490[] = {1.467e03,2.457e02,6.110e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][28][j] = _itmp1490[j];
		}
	}
	{ static float _itmp1491[] = {1.340e03,2.635e02,1.295e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][28][j] = _itmp1491[j];
		}
	}
	{ static float _itmp1492[] = {4.458e02,5.099e01,9.072e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][28][j] = _itmp1492[j];
		}
	}
	{ static float _itmp1493[] = {4.010e02,1.031e02,4.266e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][28][j] = _itmp1493[j];
		}
	}
	{ static float _itmp1494[] = {9.282e03,1.550e03,6.633e00,6.922e01,
	  1.570e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][28][j] = _itmp1494[j];
		}
	}
	{ static float _itmp1495[] = {1.431e03,1.960e02,7.274e00,2.502e01,
	  4.908e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][28][j] = _itmp1495[j];
		}
	}
	{ static float _itmp1496[] = {1.307e03,2.291e02,1.666e02,6.860e01,
	  3.881e00,2.421e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][28][j] = _itmp1496[j];
		}
	}
	{ static float _itmp1497[] = {4.129e02,3.356e01,1.254e01,2.441e02,
	  4.373e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][28][j] = _itmp1497[j];
		}
	}
	{ static float _itmp1498[] = {3.688e02,1.023e02,4.888e01,4.483e01,
	  5.919e00,3.996e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][28][j] = _itmp1498[j];
		}
	}
	{ static float _itmp1499[] = {9.237e03,1.550e03,6.630e00,6.917e01,
	  1.570e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][28][j] = _itmp1499[j];
		}
	}
	{ static float _itmp1500[] = {1.386e03,1.983e02,7.172e00,2.486e01,
	  4.901e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][28][j] = _itmp1500[j];
		}
	}
	{ static float _itmp1501[] = {1.262e03,2.322e02,1.615e02,6.669e01,
	  3.889e00,2.403e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][28][j] = _itmp1501[j];
		}
	}
	{ static float _itmp1502[] = {3.778e02,3.308e01,1.152e01,2.347e02,
	  4.436e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][28][j] = _itmp1502[j];
		}
	}
	{ static float _itmp1503[] = {3.335e02,1.017e02,4.646e01,4.207e01,
	  6.020e00,3.632e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][28][j] = _itmp1503[j];
		}
	}
	{ static float _itmp1504[] = {2.661e02,4.605e01,1.458e02,7.967e01,
	  6.285e00,4.503e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][28][j] = _itmp1504[j];
		}
	}
	{ static float _itmp1505[] = {9.181e03,1.574e03,6.454e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][28][j] = _itmp1505[j];
		}
	}
	{ static float _itmp1506[] = {1.339e03,2.470e02,5.993e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][28][j] = _itmp1506[j];
		}
	}
	{ static float _itmp1507[] = {1.211e03,2.640e02,1.274e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][28][j] = _itmp1507[j];
		}
	}
	{ static float _itmp1508[] = {3.447e02,5.350e01,7.318e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][28][j] = _itmp1508[j];
		}
	}
	{ static float _itmp1509[] = {2.999e02,1.045e02,4.286e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][28][j] = _itmp1509[j];
		}
	}
	{ static float _itmp1510[] = {2.320e02,5.210e01,2.093e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][28][j] = _itmp1510[j];
		}
	}
	{ static float _itmp1511[] = {9.155e03,1.546e03,6.671e00,6.964e01,
	  1.570e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][28][j] = _itmp1511[j];
		}
	}
	{ static float _itmp1512[] = {1.302e03,1.958e02,7.186e00,2.423e01,
	  4.960e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][28][j] = _itmp1512[j];
		}
	}
	{ static float _itmp1513[] = {1.178e03,2.383e02,1.525e02,6.417e01,
	  3.890e00,2.517e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][28][j] = _itmp1513[j];
		}
	}
	{ static float _itmp1514[] = {3.113e02,4.346e01,7.773e00,1.823e02,
	  4.413e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][28][j] = _itmp1514[j];
		}
	}
	{ static float _itmp1515[] = {2.672e02,9.821e01,4.314e01,3.667e01,
	  6.291e00,2.759e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][28][j] = _itmp1515[j];
		}
	}
	{ static float _itmp1516[] = {1.990e02,5.000e01,3.041e02,6.355e01,
	  6.458e00,2.040e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][28][j] = _itmp1516[j];
		}
	}
	{ static float _itmp1517[] = {9.127e03,1.573e03,6.468e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][28][j] = _itmp1517[j];
		}
	}
	{ static float _itmp1518[] = {1.267e03,2.476e02,5.944e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][28][j] = _itmp1518[j];
		}
	}
	{ static float _itmp1519[] = {1.137e03,2.644e02,1.263e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][28][j] = _itmp1519[j];
		}
	}
	{ static float _itmp1520[] = {2.824e02,5.587e01,6.260e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][28][j] = _itmp1520[j];
		}
	}
	{ static float _itmp1521[] = {2.375e02,1.064e02,3.728e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][28][j] = _itmp1521[j];
		}
	}
}
static void blkdata10q(void)
{
	int j;
	{ static float _itmp1522[] = {1.670e02,5.236e01,3.470e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][28][j] = _itmp1522[j];
		}
	}
	{ static float _itmp1523[] = {9.107e03,1.541e03,6.731e00,7.196e01,
	  1.562e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][28][j] = _itmp1523[j];
		}
	}
	{ static float _itmp1524[] = {1.229e03,1.968e02,7.138e00,2.379e01,
	  4.979e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][28][j] = _itmp1524[j];
		}
	}
	{ static float _itmp1525[] = {1.104e03,2.376e02,1.529e02,6.163e01,
	  3.925e00,2.511e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][28][j] = _itmp1525[j];
		}
	}
	{ static float _itmp1526[] = {2.504e02,5.085e01,5.992e00,1.563e02,
	  4.410e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][28][j] = _itmp1526[j];
		}
	}
	{ static float _itmp1527[] = {2.067e02,1.010e02,3.860e01,3.121e01,
	  6.491e00,3.331e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][28][j] = _itmp1527[j];
		}
	}
	{ static float _itmp1528[] = {1.390e02,5.652e01,3.452e02,5.007e01,
	  6.558e00,2.171e-03};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][28][j] = _itmp1528[j];
		}
	}
	{ static float _itmp1529[] = {9.088e03,1.572e03,6.482e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][28][j] = _itmp1529[j];
		}
	}
	{ static float _itmp1530[] = {1.203e03,2.479e02,5.918e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][28][j] = _itmp1530[j];
		}
	}
	{ static float _itmp1531[] = {1.073e03,2.649e02,1.255e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][28][j] = _itmp1531[j];
		}
	}
	{ static float _itmp1532[] = {2.243e02,5.878e01,5.342e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][28][j] = _itmp1532[j];
		}
	}
	{ static float _itmp1533[] = {1.801e02,1.092e02,3.217e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][28][j] = _itmp1533[j];
		}
	}
	{ static float _itmp1534[] = {1.030e02,5.346e01,4.010e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][28][j] = _itmp1534[j];
		}
	}
	{ static float _itmp1535[] = {9.070e03,1.572e03,6.440e00,6.913e01,
	  1.560e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][28][j] = _itmp1535[j];
		}
	}
	{ static float _itmp1536[] = {1.166e03,2.072e02,6.884e00,2.337e01,
	  4.917e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][28][j] = _itmp1536[j];
		}
	}
	{ static float _itmp1537[] = {1.041e03,2.368e02,1.537e02,5.951e01,
	  3.955e00,2.525e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][28][j] = _itmp1537[j];
		}
	}
	{ static float _itmp1538[] = {1.960e02,5.776e01,4.896e00,1.391e02,
	  4.397e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][28][j] = _itmp1538[j];
		}
	}
	{ static float _itmp1539[] = {1.528e02,9.650e01,3.804e01,2.618e01,
	  6.870e00,2.460e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][28][j] = _itmp1539[j];
		}
	}
	{ static float _itmp1540[] = {7.990e01,5.875e01,3.868e02,3.774e01,
	  6.878e00,3.091e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][28][j] = _itmp1540[j];
		}
	}
	{ static float _itmp1541[] = {9.052e03,1.571e03,6.497e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][25][28][j] = _itmp1541[j];
		}
	}
	{ static float _itmp1542[] = {1.146e03,2.480e02,5.914e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][25][28][j] = _itmp1542[j];
		}
	}
	{ static float _itmp1543[] = {1.020e03,2.654e02,1.248e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][25][28][j] = _itmp1543[j];
		}
	}
	{ static float _itmp1544[] = {1.703e02,6.225e01,4.565e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][25][28][j] = _itmp1544[j];
		}
	}
	{ static float _itmp1545[] = {1.277e02,1.127e02,2.769e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][25][28][j] = _itmp1545[j];
		}
	}
	{ static float _itmp1546[] = {5.738e01,5.539e01,4.028e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][25][28][j] = _itmp1546[j];
		}
	}
	{ static float _itmp1547[] = {9.032e03,2.025e03,3.761e00,2.259e02,
	  1.184e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][26][28][j] = _itmp1547[j];
		}
	}
	{ static float _itmp1548[] = {1.128e03,2.508e02,5.929e00,2.384e01,
	  4.581e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][26][28][j] = _itmp1548[j];
		}
	}
	{ static float _itmp1549[] = {9.911e02,2.369e02,1.537e02,5.847e01,
	  3.967e00,2.525e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][26][28][j] = _itmp1549[j];
		}
	}
	{ static float _itmp1550[] = {1.499e02,6.247e01,4.311e00,1.291e02,
	  4.390e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][26][28][j] = _itmp1550[j];
		}
	}
	{ static float _itmp1551[] = {1.072e02,9.745e01,3.768e01,2.211e01,
	  7.130e00,2.537e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][26][28][j] = _itmp1551[j];
		}
	}
	{ static float _itmp1552[] = {3.684e01,3.541e01,1.181e03,1.390e01,
	  1.017e01,3.416e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][26][28][j] = _itmp1552[j];
		}
	}
	{ static float _itmp1553[] = {9.012e03,2.378e03,2.659e00,7.489e02,
	  9.937e-01,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][27][28][j] = _itmp1553[j];
		}
	}
	{ static float _itmp1554[] = {1.114e03,3.054e02,4.889e00,2.675e01,
	  4.155e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][27][28][j] = _itmp1554[j];
		}
	}
	{ static float _itmp1555[] = {9.715e02,2.328e02,1.588e02,5.776e01,
	  3.997e00,2.543e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][27][28][j] = _itmp1555[j];
		}
	}
	{ static float _itmp1556[] = {1.312e02,6.472e01,4.139e00,1.278e02,
	  4.366e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][27][28][j] = _itmp1556[j];
		}
	}
	{ static float _itmp1557[] = {8.861e01,9.750e01,3.865e01,2.022e01,
	  7.277e00,2.537e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][27][28][j] = _itmp1557[j];
		}
	}
	{ static float _itmp1558[] = {2.029e01,1.590e01,3.992e03,7.098e00,
	  1.616e01,7.439e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][27][28][j] = _itmp1558[j];
		}
	}
	{ static float _itmp1559[] = {8.988e03,1.788e03,4.870e00,7.645e01,
	  1.451e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][28][28][j] = _itmp1559[j];
		}
	}
	{ static float _itmp1560[] = {1.106e03,2.502e02,5.938e00,2.402e01,
	  4.576e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][28][28][j] = _itmp1560[j];
		}
	}
	{ static float _itmp1561[] = {9.470e02,2.826e02,1.093e02,6.688e01,
	  3.668e00,9.174e-07};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][28][28][j] = _itmp1561[j];
		}
	}
	{ static float _itmp1562[] = {1.288e02,6.198e01,4.164e00,1.158e02,
	  4.488e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][28][28][j] = _itmp1562[j];
		}
	}
	{ static float _itmp1563[] = {8.300e01,9.617e01,4.275e01,1.747e01,
	  7.555e00,2.599e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][28][28][j] = _itmp1563[j];
		}
	}
	{ static float _itmp1564[] = {1.064e01,7.279e00,1.027e03,7.988e00,
	  2.033e01,1.582e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][28][28][j] = _itmp1564[j];
		}
	}
	{ static float _itmp1565[] = {7.726e00,1.436e01,4.681e-01,
	  2.383e03,4.224e00,3.736e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][28][28][j] = _itmp1565[j];
		}
	}
	{ static float _itmp1566[] = {1.239e04,3.915e02,6.083e01,3.288e01,
	  2.963e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][0][29][j] = _itmp1566[j];
		}
	}
	{ static float _itmp1567[] = {1.187e04,1.564e03,7.165e00,9.095e01,
	  1.535e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][1][29][j] = _itmp1567[j];
		}
	}
	{ static float _itmp1568[] = {1.165e04,1.600e03,7.032e00,9.272e01,
	  1.497e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][2][29][j] = _itmp1568[j];
		}
	}
	{ static float _itmp1569[] = {2.780e03,3.219e02,3.342e00,3.904e01,
	  3.684e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][2][29][j] = _itmp1569[j];
		}
	}
	{ static float _itmp1570[] = {1.149e04,1.565e03,7.294e00,7.835e01,
	  1.557e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][3][29][j] = _itmp1570[j];
		}
	}
	{ static float _itmp1571[] = {2.647e03,1.989e02,1.025e01,3.502e01,
	  4.434e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][3][29][j] = _itmp1571[j];
		}
	}
	{ static float _itmp1572[] = {1.131e04,1.582e03,7.052e00,7.246e01,
	  1.577e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][4][29][j] = _itmp1572[j];
		}
	}
	{ static float _itmp1573[] = {2.550e03,2.168e02,9.068e00,2.977e01,
	  4.514e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][4][29][j] = _itmp1573[j];
		}
	}
	{ static float _itmp1574[] = {2.479e03,1.230e02,1.663e02,1.330e02,
	  4.013e00,2.250e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][4][29][j] = _itmp1574[j];
		}
	}
	{ static float _itmp1575[] = {1.113e04,1.607e03,6.765e00,7.173e01,
	  1.574e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][5][29][j] = _itmp1575[j];
		}
	}
	{ static float _itmp1576[] = {2.435e03,2.335e02,8.158e00,2.769e01,
	  4.506e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][5][29][j] = _itmp1576[j];
		}
	}
	{ static float _itmp1577[] = {2.363e03,1.386e02,2.396e02,1.169e02,
	  4.016e00,1.579e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][5][29][j] = _itmp1577[j];
		}
	}
	{ static float _itmp1578[] = {1.092e04,1.637e03,6.617e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][6][29][j] = _itmp1578[j];
		}
	}
	{ static float _itmp1579[] = {2.309e03,2.488e02,7.424e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][6][29][j] = _itmp1579[j];
		}
	}
	{ static float _itmp1580[] = {2.216e03,2.651e02,8.601e01,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][6][29][j] = _itmp1580[j];
		}
	}
	{ static float _itmp1581[] = {1.080e04,1.629e03,6.509e00,7.085e01,
	  1.574e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][7][29][j] = _itmp1581[j];
		}
	}
	{ static float _itmp1582[] = {2.210e03,2.179e02,7.856e00,2.852e01,
	  4.612e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][7][29][j] = _itmp1582[j];
		}
	}
	{ static float _itmp1583[] = {2.070e03,2.034e02,1.893e02,8.099e01,
	  3.908e00,6.713e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][7][29][j] = _itmp1583[j];
		}
	}
	{ static float _itmp1584[] = {1.059e04,1.652e03,6.423e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][8][29][j] = _itmp1584[j];
		}
	}
	{ static float _itmp1585[] = {2.087e03,2.548e02,6.629e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][8][29][j] = _itmp1585[j];
		}
	}
	{ static float _itmp1586[] = {1.953e03,2.670e02,1.269e02,5.000e01,
	  4.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][8][29][j] = _itmp1586[j];
		}
	}
	{ static float _itmp1587[] = {1.048e04,1.636e03,6.400e00,6.864e01,
	  1.584e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][9][29][j] = _itmp1587[j];
		}
	}
	{ static float _itmp1588[] = {1.992e03,2.104e02,7.257e00,2.813e01,
	  4.728e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][9][29][j] = _itmp1588[j];
		}
	}
	{ static float _itmp1589[] = {1.846e03,2.254e02,1.992e02,6.645e01,
	  3.978e00,6.413e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][9][29][j] = _itmp1589[j];
		}
	}
	{ static float _itmp1590[] = {1.042e04,1.605e03,6.675e00,7.053e01,
	  1.588e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][10][29][j] = _itmp1590[j];
		}
	}
	{ static float _itmp1591[] = {1.936e03,1.953e02,7.654e00,3.173e01,
	  4.697e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][10][29][j] = _itmp1591[j];
		}
	}
	{ static float _itmp1592[] = {1.815e03,2.273e02,1.928e02,6.347e01,
	  4.011e00,6.017e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][10][29][j] = _itmp1592[j];
		}
	}
	{ static float _itmp1593[] = {7.374e02,1.960e01,1.939e01,5.293e02,
	  4.225e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][10][29][j] = _itmp1593[j];
		}
	}
	{ static float _itmp1594[] = {1.035e04,1.631e03,6.432e00,6.791e01,
	  1.590e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][11][29][j] = _itmp1594[j];
		}
	}
	{ static float _itmp1595[] = {1.882e03,2.070e02,7.256e00,2.865e01,
	  4.736e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][11][29][j] = _itmp1595[j];
		}
	}
	{ static float _itmp1596[] = {1.760e03,2.265e02,1.930e02,6.308e01,
	  4.019e00,6.018e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][11][29][j] = _itmp1596[j];
		}
	}
	{ static float _itmp1597[] = {6.980e02,3.115e01,2.108e01,3.355e02,
	  4.197e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][11][29][j] = _itmp1597[j];
		}
	}
	{ static float _itmp1598[] = {1.029e04,1.636e03,6.381e00,6.693e01,
	  1.592e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][12][29][j] = _itmp1598[j];
		}
	}
	{ static float _itmp1599[] = {1.828e03,2.085e02,7.155e00,2.796e01,
	  4.758e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][12][29][j] = _itmp1599[j];
		}
	}
	{ static float _itmp1600[] = {1.704e03,2.296e02,1.871e02,6.376e01,
	  3.995e00,5.868e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][12][29][j] = _itmp1600[j];
		}
	}
	{ static float _itmp1601[] = {6.583e02,3.116e01,2.073e01,3.448e02,
	  4.181e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][12][29][j] = _itmp1601[j];
		}
	}
	{ static float _itmp1602[] = {6.190e02,2.539e02,2.886e00,5.384e01,
	  4.592e00,8.255e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][12][29][j] = _itmp1602[j];
		}
	}
	{ static float _itmp1603[] = {1.023e04,1.633e03,6.399e00,6.753e01,
	  1.591e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][13][29][j] = _itmp1603[j];
		}
	}
	{ static float _itmp1604[] = {1.775e03,2.101e02,7.058e00,2.748e01,
	  4.771e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][13][29][j] = _itmp1604[j];
		}
	}
	{ static float _itmp1605[] = {1.650e03,2.720e02,1.333e02,8.071e01,
	  3.661e00,4.757e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][13][29][j] = _itmp1605[j];
		}
	}
	{ static float _itmp1606[] = {6.187e02,2.985e01,2.083e01,3.577e02,
	  4.196e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][13][29][j] = _itmp1606[j];
		}
	}
	{ static float _itmp1607[] = {5.790e02,1.403e02,1.361e01,6.070e01,
	  5.261e00,5.034e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][13][29][j] = _itmp1607[j];
		}
	}
	{ static float _itmp1608[] = {1.015e04,1.691e03,5.972e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][14][29][j] = _itmp1608[j];
		}
	}
	{ static float _itmp1609[] = {1.716e03,2.609e02,5.912e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][14][29][j] = _itmp1609[j];
		}
	}
	{ static float _itmp1610[] = {1.586e03,2.806e02,1.269e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][14][29][j] = _itmp1610[j];
		}
	}
	{ static float _itmp1611[] = {5.780e02,5.311e01,1.000e01,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][14][29][j] = _itmp1611[j];
		}
	}
	{ static float _itmp1612[] = {5.420e02,1.108e02,2.676e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][14][29][j] = _itmp1612[j];
		}
	}
	{ static float _itmp1613[] = {1.012e04,1.617e03,6.536e00,6.839e01,
	  1.594e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][15][29][j] = _itmp1613[j];
		}
	}
	{ static float _itmp1614[] = {1.673e03,2.142e02,6.875e00,2.631e01,
	  4.800e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][15][29][j] = _itmp1614[j];
		}
	}
	{ static float _itmp1615[] = {1.546e03,2.596e02,1.443e02,7.722e01,
	  3.739e00,5.496e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][15][29][j] = _itmp1615[j];
		}
	}
	{ static float _itmp1616[] = {5.416e02,3.912e01,1.395e01,2.883e02,
	  4.155e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][15][29][j] = _itmp1616[j];
		}
	}
	{ static float _itmp1617[] = {4.900e02,1.153e02,3.254e01,5.308e01,
	  5.645e00,4.056e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][15][29][j] = _itmp1617[j];
		}
	}
	{ static float _itmp1618[] = {1.004e04,1.689e03,5.993e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][16][29][j] = _itmp1618[j];
		}
	}
	{ static float _itmp1619[] = {1.613e03,2.621e02,5.810e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][16][29][j] = _itmp1619[j];
		}
	}
	{ static float _itmp1620[] = {1.481e03,2.807e02,1.254e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][16][29][j] = _itmp1620[j];
		}
	}
	{ static float _itmp1621[] = {5.015e02,5.403e01,8.971e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][16][29][j] = _itmp1621[j];
		}
	}
	{ static float _itmp1622[] = {4.540e02,1.106e02,4.142e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][16][29][j] = _itmp1622[j];
		}
	}
	{ static float _itmp1623[] = {1.001e04,1.617e03,6.532e00,6.768e01,
	  1.597e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][17][29][j] = _itmp1623[j];
		}
	}
	{ static float _itmp1624[] = {1.576e03,2.135e02,6.802e00,2.575e01,
	  4.839e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][17][29][j] = _itmp1624[j];
		}
	}
	{ static float _itmp1625[] = {1.448e03,2.538e02,1.487e02,7.400e01,
	  3.794e00,5.551e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][17][29][j] = _itmp1625[j];
		}
	}
	{ static float _itmp1626[] = {4.671e02,3.780e01,1.186e01,2.389e02,
	  4.334e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][17][29][j] = _itmp1626[j];
		}
	}
	{ static float _itmp1627[] = {4.197e02,1.073e02,4.863e01,4.776e01,
	  5.875e00,2.432e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][17][29][j] = _itmp1627[j];
		}
	}
	{ static float _itmp1628[] = {9.960e03,1.610e03,6.593e00,6.774e01,
	  1.600e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][18][29][j] = _itmp1628[j];
		}
	}
	{ static float _itmp1629[] = {1.528e03,2.118e02,6.804e00,2.536e01,
	  4.875e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][18][29][j] = _itmp1629[j];
		}
	}
}
static void blkdata10v(void)
{
	int j;
	{ static float _itmp1630[] = {1.399e03,2.529e02,1.489e02,7.156e01,
	  3.823e00,5.330e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][18][29][j] = _itmp1630[j];
		}
	}
	{ static float _itmp1631[] = {4.299e02,3.741e01,1.098e01,2.313e02,
	  4.386e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][18][29][j] = _itmp1631[j];
		}
	}
	{ static float _itmp1632[] = {3.828e02,1.057e02,4.664e01,4.477e01,
	  5.995e00,2.234e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][18][29][j] = _itmp1632[j];
		}
	}
	{ static float _itmp1633[] = {3.108e02,5.749e01,1.122e02,7.804e01,
	  6.097e00,3.731e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][18][29][j] = _itmp1633[j];
		}
	}
	{ static float _itmp1634[] = {9.915e03,1.611e03,6.591e00,6.799e01,
	  1.598e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][19][29][j] = _itmp1634[j];
		}
	}
	{ static float _itmp1635[] = {1.482e03,2.023e02,6.987e00,2.500e01,
	  4.972e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][19][29][j] = _itmp1635[j];
		}
	}
	{ static float _itmp1636[] = {1.353e03,2.543e02,1.465e02,6.961e01,
	  3.838e00,5.027e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][19][29][j] = _itmp1636[j];
		}
	}
	{ static float _itmp1637[] = {3.939e02,3.705e01,1.008e01,2.216e02,
	  4.447e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][19][29][j] = _itmp1637[j];
		}
	}
	{ static float _itmp1638[] = {3.467e02,1.046e02,4.454e01,4.180e01,
	  6.115e00,1.997e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][19][29][j] = _itmp1638[j];
		}
	}
	{ static float _itmp1639[] = {2.740e02,5.735e01,2.033e02,7.143e01,
	  6.214e00,3.888e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][19][29][j] = _itmp1639[j];
		}
	}
	{ static float _itmp1640[] = {9.854e03,1.685e03,6.036e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][20][29][j] = _itmp1640[j];
		}
	}
	{ static float _itmp1641[] = {1.436e03,2.638e02,5.673e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][20][29][j] = _itmp1641[j];
		}
	}
	{ static float _itmp1642[] = {1.302e03,2.813e02,1.231e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][20][29][j] = _itmp1642[j];
		}
	}
	{ static float _itmp1643[] = {3.609e02,5.754e01,6.797e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][20][29][j] = _itmp1643[j];
		}
	}
	{ static float _itmp1644[] = {3.128e02,1.126e02,3.961e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][20][29][j] = _itmp1644[j];
		}
	}
	{ static float _itmp1645[] = {2.380e02,5.727e01,2.777e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][20][29][j] = _itmp1645[j];
		}
	}
	{ static float _itmp1646[] = {9.831e03,1.605e03,6.653e00,6.874e01,
	  1.597e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][21][29][j] = _itmp1646[j];
		}
	}
	{ static float _itmp1647[] = {1.397e03,2.114e02,6.748e00,2.443e01,
	  4.934e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][21][29][j] = _itmp1647[j];
		}
	}
	{ static float _itmp1648[] = {1.267e03,2.512e02,1.490e02,6.562e01,
	  3.896e00,5.943e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][21][29][j] = _itmp1648[j];
		}
	}
	{ static float _itmp1649[] = {3.257e02,4.721e01,7.066e00,1.761e02,
	  4.431e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][21][29][j] = _itmp1649[j];
		}
	}
	{ static float _itmp1650[] = {2.785e02,1.016e02,4.118e01,3.606e01,
	  6.396e00,1.450e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][21][29][j] = _itmp1650[j];
		}
	}
	{ static float _itmp1651[] = {2.030e02,5.906e01,3.187e02,5.850e01,
	  6.430e00,2.472e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][21][29][j] = _itmp1651[j];
		}
	}
	{ static float _itmp1652[] = {9.809e03,1.683e03,6.057e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][22][29][j] = _itmp1652[j];
		}
	}
	{ static float _itmp1653[] = {1.362e03,2.642e02,5.637e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][22][29][j] = _itmp1653[j];
		}
	}
	{ static float _itmp1654[] = {1.227e03,2.816e02,1.222e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][22][29][j] = _itmp1654[j];
		}
	}
	{ static float _itmp1655[] = {2.969e02,6.012e01,5.837e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][22][29][j] = _itmp1655[j];
		}
	}
	{ static float _itmp1656[] = {2.487e02,1.147e02,3.456e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][22][29][j] = _itmp1656[j];
		}
	}
	{ static float _itmp1657[] = {1.750e02,5.760e01,3.804e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][22][29][j] = _itmp1657[j];
		}
	}
	{ static float _itmp1658[] = {9.788e03,1.697e03,5.935e00,9.066e01,
	  1.488e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][23][29][j] = _itmp1658[j];
		}
	}
	{ static float _itmp1659[] = {1.323e03,2.094e02,6.772e00,2.401e01,
	  4.975e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][23][29][j] = _itmp1659[j];
		}
	}
	{ static float _itmp1660[] = {1.193e03,2.522e02,1.476e02,6.376e01,
	  3.914e00,6.079e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][23][29][j] = _itmp1660[j];
		}
	}
	{ static float _itmp1661[] = {2.633e02,5.492e01,5.518e00,1.512e02,
	  4.431e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][23][29][j] = _itmp1661[j];
		}
	}
	{ static float _itmp1662[] = {2.165e02,1.096e02,3.576e01,3.034e01,
	  6.524e00,3.502e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][23][29][j] = _itmp1662[j];
		}
	}
	{ static float _itmp1663[] = {1.360e02,6.530e01,3.456e02,4.608e01,
	  6.555e00,2.476e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][23][29][j] = _itmp1663[j];
		}
	}
	{ static float _itmp1664[] = {9.770e03,1.682e03,6.079e00,5.000e01,
	  1.650e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][24][29][j] = _itmp1664[j];
		}
	}
	{ static float _itmp1665[] = {1.298e03,2.645e02,5.621e00,2.600e01,
	  4.500e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][24][29][j] = _itmp1665[j];
		}
	}
	{ static float _itmp1666[] = {1.162e03,2.821e02,1.215e02,7.000e01,
	  3.700e00,1.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][24][29][j] = _itmp1666[j];
		}
	}
	{ static float _itmp1667[] = {2.369e02,6.326e01,5.006e00,1.800e02,
	  4.200e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][24][29][j] = _itmp1667[j];
		}
	}
	{ static float _itmp1668[] = {1.896e02,1.177e02,2.996e01,4.500e01,
	  5.900e00,2.600e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][24][29][j] = _itmp1668[j];
		}
	}
	{ static float _itmp1669[] = {1.080e02,5.878e01,4.151e02,4.000e01,
	  7.000e00,3.000e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][24][29][j] = _itmp1669[j];
		}
	}
	{ static float _itmp1670[] = {9.751e03,1.732e03,5.666e00,8.751e01,
	  1.484e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][25][29][j] = _itmp1670[j];
		}
	}
	{ static float _itmp1671[] = {1.259e03,2.231e02,6.480e00,2.364e01,
	  4.891e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][25][29][j] = _itmp1671[j];
		}
	}
	{ static float _itmp1672[] = {1.129e03,2.523e02,1.473e02,6.205e01,
	  3.933e00,6.078e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][25][29][j] = _itmp1672[j];
		}
	}
	{ static float _itmp1673[] = {2.075e02,6.183e01,4.578e00,1.352e02,
	  4.422e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][25][29][j] = _itmp1673[j];
		}
	}
	{ static float _itmp1674[] = {1.612e02,1.030e02,3.598e01,2.554e01,
	  6.932e00,2.426e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][25][29][j] = _itmp1674[j];
		}
	}
	{ static float _itmp1675[] = {8.260e01,6.378e01,4.172e02,3.462e01,
	  7.005e00,3.108e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][25][29][j] = _itmp1675[j];
		}
	}
	{ static float _itmp1676[] = {9.733e03,1.890e03,4.708e00,1.202e02,
	  1.363e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][26][29][j] = _itmp1676[j];
		}
	}
	{ static float _itmp1677[] = {1.239e03,2.366e02,6.210e00,2.347e01,
	  4.803e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][26][29][j] = _itmp1677[j];
		}
	}
	{ static float _itmp1678[] = {1.101e03,2.528e02,1.467e02,6.144e01,
	  3.938e00,6.071e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][26][29][j] = _itmp1678[j];
		}
	}
	{ static float _itmp1679[] = {1.826e02,6.427e01,4.285e00,1.295e02,
	  4.424e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][26][29][j] = _itmp1679[j];
		}
	}
	{ static float _itmp1680[] = {1.365e02,1.033e02,3.582e01,2.337e01,
	  7.076e00,2.470e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][26][29][j] = _itmp1680[j];
		}
	}
	{ static float _itmp1681[] = {5.940e01,5.376e01,6.007e02,2.429e01,
	  7.985e00,3.026e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][26][29][j] = _itmp1681[j];
		}
	}
	{ static float _itmp1682[] = {9.713e03,1.981e03,4.228e00,1.057e02,
	  1.361e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][27][29][j] = _itmp1682[j];
		}
	}
	{ static float _itmp1683[] = {1.222e03,2.686e02,5.600e00,2.394e01,
	  4.574e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][27][29][j] = _itmp1683[j];
		}
	}
	{ static float _itmp1684[] = {1.077e03,2.519e02,1.478e02,6.090e01,
	  3.949e00,6.087e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][27][29][j] = _itmp1684[j];
		}
	}
	{ static float _itmp1685[] = {1.601e02,6.684e01,4.057e00,1.255e02,
	  4.414e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][27][29][j] = _itmp1685[j];
		}
	}
	{ static float _itmp1686[] = {1.143e02,1.045e02,3.568e01,2.181e01,
	  7.163e00,2.533e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][27][29][j] = _itmp1686[j];
		}
	}
	{ static float _itmp1687[] = {3.972e01,3.640e01,1.498e03,1.188e01,
	  1.082e01,3.519e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][27][29][j] = _itmp1687[j];
		}
	}
	{ static float _itmp1688[] = {9.691e03,1.125e03,1.382e01,2.765e01,
	  2.242e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][28][29][j] = _itmp1688[j];
		}
	}
	{ static float _itmp1689[] = {1.209e03,2.121e02,6.713e00,2.342e01,
	  4.988e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][28][29][j] = _itmp1689[j];
		}
	}
	{ static float _itmp1690[] = {1.065e03,2.664e02,1.329e02,6.260e01,
	  3.864e00,5.913e-09};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][28][29][j] = _itmp1690[j];
		}
	}
	{ static float _itmp1691[] = {1.479e02,6.443e01,4.075e00,1.175e02,
	  4.506e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][28][29][j] = _itmp1691[j];
		}
	}
	{ static float _itmp1692[] = {1.021e02,1.047e02,3.618e01,2.122e01,
	  7.201e00,2.534e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][28][29][j] = _itmp1692[j];
		}
	}
	{ static float _itmp1693[] = {2.694e01,2.593e01,3.408e03,7.832e00,
	  1.363e01,3.562e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][28][29][j] = _itmp1693[j];
		}
	}
	{ static float _itmp1694[] = {1.796e01,1.411e01,8.168e-01,
	  8.775e02,4.393e00,4.021e-04};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][28][29][j] = _itmp1694[j];
		}
	}
	{ static float _itmp1695[] = {9.667e03,8.320e02,2.586e01,4.497e01,
	  2.215e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[0][29][29][j] = _itmp1695[j];
		}
	}
	{ static float _itmp1696[] = {1.203e03,9.755e01,9.077e00,3.219e01,
	  5.888e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[1][29][29][j] = _itmp1696[j];
		}
	}
	{ static float _itmp1697[] = {1.037e03,3.486e02,7.784e01,8.298e01,
	  3.391e00,1.125e-08};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[2][29][29][j] = _itmp1697[j];
		}
	}
	{ static float _itmp1698[] = {1.450e02,6.195e01,4.094e00,1.086e02,
	  4.614e00,0.000e00};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[3][29][29][j] = _itmp1698[j];
		}
	}
	{ static float _itmp1699[] = {9.700e01,1.025e02,3.930e01,1.876e01,
	  7.456e00,2.559e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[4][29][29][j] = _itmp1699[j];
		}
	}
	{ static float _itmp1700[] = {1.730e01,1.818e01,1.017e04,5.288e00,
	  1.736e01,4.667e-01};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[5][29][29][j] = _itmp1700[j];
		}
	}
	{ static float _itmp1701[] = {9.394e00,1.673e01,1.236e00,1.029e03,
	  4.259e00,3.962e-02};
	for( j=0; j < 6; j++ )
	{
		PH1COM.PH1[6][29][29][j] = _itmp1701[j];
		}
	}
	{ static float _itmp1702[] = {4.298e-01,5.475e04,3.288e01,
	  2.963e00,0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][0][j] = _itmp1702[j];
		}
	}
	{ static float _itmp1703[] = {1.720e00,1.369e04,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][1][j] = _itmp1703[j];
		}
	}
	{ static float _itmp1704[] = {1.361e01,9.492e02,1.469e00,3.188e00,
	  2.039e00,4.434e-01,2.136e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][1][j] = _itmp1704[j];
		}
	}
	{ static float _itmp1705[] = {3.871e00,6.083e03,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][2][j] = _itmp1705[j];
		}
	}
	{ static float _itmp1706[] = {2.006e01,3.201e02,7.391e00,2.916e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][2][j] = _itmp1706[j];
		}
	}
	{ static float _itmp1707[] = {3.107e00,6.245e01,1.501e01,4.895e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][2][j] = _itmp1707[j];
		}
	}
	{ static float _itmp1708[] = {6.879e00,3.422e03,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][3][j] = _itmp1708[j];
		}
	}
	{ static float _itmp1709[] = {1.760e01,5.458e02,1.719e01,3.157e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][3][j] = _itmp1709[j];
		}
	}
	{ static float _itmp1710[] = {1.181e00,2.678e02,5.645e00,1.170e01,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][3][j] = _itmp1710[j];
		}
	}
	{ static float _itmp1711[] = {9.539e00,2.932e05,4.301e-01,
	  1.052e01,3.655e-01,8.278e-04,1.269e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][3][j] = _itmp1711[j];
		}
	}
	{ static float _itmp1712[] = {1.075e01,2.190e03,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][4][j] = _itmp1712[j];
		}
	}
	{ static float _itmp1713[] = {3.336e01,2.846e02,2.163e01,2.624e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][4][j] = _itmp1713[j];
		}
	}
	{ static float _itmp1714[] = {1.041e00,5.393e01,1.767e01,9.540e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][4][j] = _itmp1714[j];
		}
	}
	{ static float _itmp1715[] = {2.869e00,1.859e04,1.783e00,1.618e01,
	  3.503e00,4.960e-03,3.400e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][4][j] = _itmp1715[j];
		}
	}
	{ static float _itmp1716[] = {5.213e-01,5.466e00,8.618e00,
	  1.728e01,1.887e01,1.319e01,4.556e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][4][j] = _itmp1716[j];
		}
	}
	{ static float _itmp1717[] = {1.548e01,1.521e03,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][5][j] = _itmp1717[j];
		}
	}
	{ static float _itmp1718[] = {4.624e01,2.344e02,2.183e01,2.581e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][5][j] = _itmp1718[j];
		}
	}
	{ static float _itmp1719[] = {3.506e00,1.068e02,1.436e01,7.457e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][5][j] = _itmp1719[j];
		}
	}
	{ static float _itmp1720[] = {4.614e00,1.539e04,1.737e00,1.593e01,
	  5.922e00,4.378e-03,2.528e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][5][j] = _itmp1720[j];
		}
	}
	{ static float _itmp1721[] = {4.058e-01,8.709e00,1.261e02,
	  8.578e00,2.093e00,4.929e01,3.234e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][5][j] = _itmp1721[j];
		}
	}
	{ static float _itmp1722[] = {2.144e00,5.027e02,6.216e01,5.101e00,
	  9.157e-02,1.133e00,1.607e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][5][j] = _itmp1722[j];
		}
	}
	{ static float _itmp1723[] = {2.108e01,1.117e03,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][6][j] = _itmp1723[j];
		}
	}
	{ static float _itmp1724[] = {6.943e01,1.519e02,2.627e01,2.315e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][6][j] = _itmp1724[j];
		}
	}
	{ static float _itmp1725[] = {4.471e00,8.376e01,3.297e01,6.003e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][6][j] = _itmp1725[j];
		}
	}
	{ static float _itmp1726[] = {5.494e00,1.690e04,1.714e00,1.706e01,
	  7.904e00,6.415e-03,1.937e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][6][j] = _itmp1726[j];
		}
	}
	{ static float _itmp1727[] = {2.420e-01,9.375e-01,2.788e02,
	  9.156e00,1.850e00,1.877e02,3.999e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][6][j] = _itmp1727[j];
		}
	}
	{ static float _itmp1728[] = {6.128e-02,1.944e00,8.163e02,
	  8.773e00,1.043e01,4.280e02,2.030e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][6][j] = _itmp1728[j];
		}
	}
	{ static float _itmp1729[] = {4.034e00,8.235e02,8.033e01,3.928e00,
	  9.097e-02,8.598e-01,2.325e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][6][j] = _itmp1729[j];
		}
	}
	{ static float _itmp1730[] = {2.754e01,8.554e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][7][j] = _itmp1730[j];
		}
	}
	{ static float _itmp1731[] = {8.709e01,1.329e02,2.535e01,2.336e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][7][j] = _itmp1731[j];
		}
	}
	{ static float _itmp1732[] = {7.824e00,6.864e01,3.210e01,5.495e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][7][j] = _itmp1732[j];
		}
	}
	{ static float _itmp1733[] = {2.854e00,1.642e04,1.792e00,2.647e01,
	  2.836e01,3.036e-02,5.554e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][7][j] = _itmp1733[j];
		}
	}
	{ static float _itmp1734[] = {2.044e-01,8.659e-01,4.931e02,
	  8.785e00,3.143e00,3.328e02,4.285e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][7][j] = _itmp1734[j];
		}
	}
	{ static float _itmp1735[] = {1.723e-01,6.753e02,3.852e02,
	  6.822e00,1.191e-01,3.839e-03,4.569e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][7][j] = _itmp1735[j];
		}
	}
	{ static float _itmp1736[] = {1.386e00,5.967e01,3.175e01,8.943e00,
	  1.934e-02,2.131e01,1.503e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][7][j] = _itmp1736[j];
		}
	}
	{ static float _itmp1737[] = {1.240e00,1.745e03,3.784e00,1.764e01,
	  7.589e-02,8.698e00,1.271e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][7][j] = _itmp1737[j];
		}
	}
	{ static float _itmp1738[] = {3.485e01,6.759e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][8][j] = _itmp1738[j];
		}
	}
	{ static float _itmp1739[] = {1.131e02,1.039e02,2.657e01,2.255e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][8][j] = _itmp1739[j];
		}
	}
	{ static float _itmp1740[] = {2.563e00,6.930e01,7.547e01,6.448e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][8][j] = _itmp1740[j];
		}
	}
	{ static float _itmp1741[] = {4.008e00,1.157e04,1.848e00,2.446e01,
	  2.411e01,2.071e-02,3.998e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][8][j] = _itmp1741[j];
		}
	}
	{ static float _itmp1742[] = {7.286e-01,4.690e-01,1.400e02,
	  9.718e00,2.570e-01,1.506e02,2.574e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][8][j] = _itmp1742[j];
		}
	}
	{ static float _itmp1743[] = {7.744e-01,3.165e00,1.099e02,
	  9.203e00,6.812e00,9.531e01,9.781e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][8][j] = _itmp1743[j];
		}
	}
}
static void blkdata10w(void)
{
	int j;
	{ static float _itmp1744[] = {2.542e00,1.541e02,5.742e01,6.614e00,
	  1.115e00,1.641e01,5.124e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][8][j] = _itmp1744[j];
		}
	}
	{ static float _itmp1745[] = {1.763e00,8.013e01,1.667e01,1.050e01,
	  5.103e-01,1.715e01,7.724e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][8][j] = _itmp1745[j];
		}
	}
	{ static float _itmp1746[] = {1.297e01,3.803e03,2.587e00,7.275e00,
	  2.170e-03,1.701e-04,1.345e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][8][j] = _itmp1746[j];
		}
	}
	{ static float _itmp1747[] = {4.304e01,5.475e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][9][j] = _itmp1747[j];
		}
	}
	{ static float _itmp1748[] = {1.586e02,6.695e01,3.352e01,2.002e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][9][j] = _itmp1748[j];
		}
	}
	{ static float _itmp1749[] = {1.003e01,5.631e01,3.628e01,5.585e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][9][j] = _itmp1749[j];
		}
	}
	{ static float _itmp1750[] = {4.888e00,1.198e04,1.788e00,2.550e01,
	  2.811e01,2.536e-02,4.417e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][9][j] = _itmp1750[j];
		}
	}
	{ static float _itmp1751[] = {1.499e00,9.854e-01,1.350e02,
	  8.836e00,1.656e00,1.042e02,1.435e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][9][j] = _itmp1751[j];
		}
	}
	{ static float _itmp1752[] = {1.248e00,2.430e00,1.066e02,8.999e00,
	  6.855e-01,9.169e01,3.702e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][9][j] = _itmp1752[j];
		}
	}
	{ static float _itmp1753[] = {5.566e00,1.685e03,6.409e02,3.056e00,
	  8.290e-03,5.149e00,6.687e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][9][j] = _itmp1753[j];
		}
	}
	{ static float _itmp1754[] = {7.753e-01,5.708e00,6.725e01,
	  1.005e01,4.633e-01,7.654e01,2.023e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][9][j] = _itmp1754[j];
		}
	}
	{ static float _itmp1755[] = {1.247e01,1.583e03,3.935e00,7.810e00,
	  6.558e-02,1.520e00,1.084e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][9][j] = _itmp1755[j];
		}
	}
	{ static float _itmp1756[] = {4.870e00,4.287e03,5.798e00,8.355e00,
	  2.434e-01,4.236e-02,5.873e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][9][j] = _itmp1756[j];
		}
	}
	{ static float _itmp1757[] = {5.211e01,4.525e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][10][j] = _itmp1757[j];
		}
	}
	{ static float _itmp1758[] = {2.268e02,3.995e01,5.315e01,1.678e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][10][j] = _itmp1758[j];
		}
	}
	{ static float _itmp1759[] = {1.391e01,4.729e01,3.889e01,5.265e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][10][j] = _itmp1759[j];
		}
	}
	{ static float _itmp1760[] = {1.535e02,7.215e03,3.886e-01,
	  8.476e00,9.121e-01,1.667e-01,1.766e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][10][j] = _itmp1760[j];
		}
	}
	{ static float _itmp1761[] = {2.096e00,1.609e00,2.473e02,7.681e00,
	  1.895e00,9.940e01,3.278e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][10][j] = _itmp1761[j];
		}
	}
	{ static float _itmp1762[] = {4.846e01,7.101e01,3.945e01,2.832e00,
	  1.285e-02,9.603e-04,6.378e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][10][j] = _itmp1762[j];
		}
	}
	{ static float _itmp1763[] = {5.408e00,2.346e01,2.913e01,8.260e00,
	  9.275e-01,2.204e01,7.577e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][10][j] = _itmp1763[j];
		}
	}
	{ static float _itmp1764[] = {6.690e-01,2.330e00,1.205e02,
	  9.714e00,7.365e-01,1.383e02,4.260e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][10][j] = _itmp1764[j];
		}
	}
	{ static float _itmp1765[] = {1.069e01,1.885e03,3.613e00,9.803e00,
	  8.579e-02,3.725e00,2.279e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][10][j] = _itmp1765[j];
		}
	}
	{ static float _itmp1766[] = {8.203e00,1.040e03,8.259e00,7.362e00,
	  2.328e00,3.375e00,4.010e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][10][j] = _itmp1766[j];
		}
	}
	{ static float _itmp1767[] = {6.139e00,1.601e00,6.148e03,3.839e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][10][j] = _itmp1767[j];
		}
	}
	{ static float _itmp1768[] = {6.203e01,3.802e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][11][j] = _itmp1768[j];
		}
	}
	{ static float _itmp1769[] = {2.042e02,6.140e01,2.778e01,2.161e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][11][j] = _itmp1769[j];
		}
	}
	{ static float _itmp1770[] = {1.452e01,4.427e01,3.826e01,5.460e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][11][j] = _itmp1770[j];
		}
	}
	{ static float _itmp1771[] = {3.482e01,9.008e02,1.823e00,1.444e01,
	  2.751e00,5.444e00,7.918e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][11][j] = _itmp1771[j];
		}
	}
	{ static float _itmp1772[] = {4.884e-01,6.344e-02,5.085e02,
	  9.385e00,6.666e-01,5.348e02,3.997e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][11][j] = _itmp1772[j];
		}
	}
	{ static float _itmp1773[] = {3.570e00,3.104e00,6.060e01,8.857e00,
	  1.422e00,5.452e01,2.078e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][11][j] = _itmp1773[j];
		}
	}
	{ static float _itmp1774[] = {1.711e00,2.185e00,9.350e01,9.202e00,
	  6.325e-01,1.007e02,1.729e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][11][j] = _itmp1774[j];
		}
	}
	{ static float _itmp1775[] = {9.762e-01,1.728e00,9.184e01,
	  1.006e01,8.090e-01,1.276e02,3.979e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][11][j] = _itmp1775[j];
		}
	}
	{ static float _itmp1776[] = {2.912e01,1.394e03,2.895e00,6.487e00,
	  4.326e-02,9.402e-01,1.135e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][11][j] = _itmp1776[j];
		}
	}
	{ static float _itmp1777[] = {1.086e01,5.377e02,9.779e00,7.117e00,
	  2.604e00,4.860e00,3.722e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][11][j] = _itmp1777[j];
		}
	}
	{ static float _itmp1778[] = {8.139e00,3.278e00,4.341e07,3.610e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][11][j] = _itmp1778[j];
		}
	}
	{ static float _itmp1779[] = {1.197e01,1.372e08,2.228e-01,
	  1.574e01,2.805e-01,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][11][j] = _itmp1779[j];
		}
	}
	{ static float _itmp1780[] = {7.281e01,3.239e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][12][j] = _itmp1780[j];
		}
	}
	{ static float _itmp1781[] = {2.738e02,4.036e01,3.567e01,1.915e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][12][j] = _itmp1781[j];
		}
	}
	{ static float _itmp1782[] = {2.355e01,3.388e01,3.432e01,5.085e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][12][j] = _itmp1782[j];
		}
	}
	{ static float _itmp1783[] = {8.044e00,1.774e04,1.653e00,2.655e01,
	  2.953e01,2.538e-02,1.203e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][12][j] = _itmp1783[j];
		}
	}
	{ static float _itmp1784[] = {1.842e00,4.982e-01,2.568e02,
	  8.406e00,6.945e-01,1.719e02,6.595e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][12][j] = _itmp1784[j];
		}
	}
	{ static float _itmp1785[] = {4.866e-01,2.350e-01,7.216e02,
	  8.659e00,2.773e-01,5.704e02,1.580e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][12][j] = _itmp1785[j];
		}
	}
	{ static float _itmp1786[] = {2.636e00,1.889e02,1.338e02,6.204e00,
	  1.836e00,3.552e01,8.223e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][12][j] = _itmp1786[j];
		}
	}
	{ static float _itmp1787[] = {3.483e-01,1.962e-02,1.856e01,
	  2.084e01,8.839e00,5.675e-02,2.768e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][12][j] = _itmp1787[j];
		}
	}
	{ static float _itmp1788[] = {2.414e01,2.925e02,6.973e00,6.724e00,
	  1.000e-01,3.495e00,2.701e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][12][j] = _itmp1788[j];
		}
	}
	{ static float _itmp1789[] = {3.130e00,1.513e01,1.674e01,1.180e01,
	  5.342e00,3.994e01,4.803e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][12][j] = _itmp1789[j];
		}
	}
	{ static float _itmp1790[] = {1.027e01,4.915e00,1.990e06,3.477e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][12][j] = _itmp1790[j];
		}
	}
	{ static float _itmp1791[] = {2.048e-01,6.948e-02,5.675e02,
	  9.049e00,4.615e-01,9.149e01,6.565e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][12][j] = _itmp1791[j];
		}
	}
	{ static float _itmp1792[] = {1.381e01,7.195e00,1.621e03,3.642e00,
	  3.166e-01,2.041e-01,4.753e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][12][j] = _itmp1792[j];
		}
	}
	{ static float _itmp1793[] = {8.447e01,2.793e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][13][j] = _itmp1793[j];
		}
	}
	{ static float _itmp1794[] = {2.752e02,4.754e01,2.848e01,2.135e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][13][j] = _itmp1794[j];
		}
	}
	{ static float _itmp1795[] = {3.560e01,2.539e01,3.307e01,4.728e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][13][j] = _itmp1795[j];
		}
	}
	{ static float _itmp1796[] = {1.205e01,1.992e04,1.582e00,2.425e01,
	  2.392e01,1.990e-02,1.007e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][13][j] = _itmp1796[j];
		}
	}
	{ static float _itmp1797[] = {8.787e-01,1.950e-01,7.461e02,
	  8.302e00,4.489e-01,4.528e02,1.015e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][13][j] = _itmp1797[j];
		}
	}
	{ static float _itmp1798[] = {3.343e-01,1.465e-01,1.404e03,
	  8.503e00,1.646e00,1.036e03,2.936e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][13][j] = _itmp1798[j];
		}
	}
	{ static float _itmp1799[] = {7.655e-01,3.477e-01,3.733e02,
	  8.986e00,1.476e-03,3.850e02,8.999e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][13][j] = _itmp1799[j];
		}
	}
	{ static float _itmp1800[] = {3.277e-01,6.680e-02,4.132e01,
	  1.606e01,3.280e00,1.149e-02,6.396e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][13][j] = _itmp1800[j];
		}
	}
	{ static float _itmp1801[] = {6.305e01,7.293e01,1.558e02,2.400e00,
	  2.989e-03,1.115e00,8.051e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][13][j] = _itmp1801[j];
		}
	}
	{ static float _itmp1802[] = {7.761e-01,8.863e-01,1.541e02,
	  9.980e00,1.303e00,2.009e02,4.537e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][13][j] = _itmp1802[j];
		}
	}
	{ static float _itmp1803[] = {1.288e01,6.083e00,1.356e06,3.353e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][13][j] = _itmp1803[j];
		}
	}
	{ static float _itmp1804[] = {1.659e-01,5.790e-04,1.474e02,
	  1.336e01,8.626e-01,9.613e01,6.442e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][13][j] = _itmp1804[j];
		}
	}
	{ static float _itmp1805[] = {2.556e00,4.140e00,1.337e01,1.191e01,
	  1.570e00,6.634e00,1.272e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][13][j] = _itmp1805[j];
		}
	}
	{ static float _itmp1806[] = {2.317e01,2.506e01,2.057e01,3.546e00,
	  2.837e-01,1.672e-05,4.207e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[13][13][j] = _itmp1806[j];
		}
	}
	{ static float _itmp1807[] = {1.104e02,2.139e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][15][j] = _itmp1807[j];
		}
	}
	{ static float _itmp1808[] = {4.390e02,2.453e01,4.405e01,1.765e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][15][j] = _itmp1808[j];
		}
	}
	{ static float _itmp1809[] = {3.310e01,2.555e01,3.821e01,5.037e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][15][j] = _itmp1809[j];
		}
	}
	{ static float _itmp1810[] = {1.474e01,2.294e04,1.529e00,2.568e01,
	  2.738e01,2.203e-02,1.073e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][15][j] = _itmp1810[j];
		}
	}
	{ static float _itmp1811[] = {2.443e00,3.490e-01,5.411e02,
	  7.769e00,7.033e-01,2.279e02,1.172e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][15][j] = _itmp1811[j];
		}
	}
	{ static float _itmp1812[] = {6.485e00,1.275e01,6.583e01,7.692e00,
	  1.678e00,3.426e01,1.370e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][15][j] = _itmp1812[j];
		}
	}
	{ static float _itmp1813[] = {1.040e01,5.364e01,3.641e01,7.090e00,
	  2.310e00,1.775e01,1.663e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][15][j] = _itmp1813[j];
		}
	}
	{ static float _itmp1814[] = {1.526e-01,9.646e03,1.438e03,
	  5.977e00,1.492e00,1.615e-03,4.049e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][15][j] = _itmp1814[j];
		}
	}
	{ static float _itmp1815[] = {1.462e01,3.161e01,1.611e01,8.642e00,
	  1.153e-03,1.869e01,3.037e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][15][j] = _itmp1815[j];
		}
	}
	{ static float _itmp1816[] = {3.757e-01,5.703e-01,1.460e02,
	  1.135e01,1.503e00,2.222e02,4.606e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][15][j] = _itmp1816[j];
		}
	}
	{ static float _itmp1817[] = {1.413e01,9.139e00,1.656e03,3.626e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][15][j] = _itmp1817[j];
		}
	}
	{ static float _itmp1818[] = {1.713e-01,5.072e-04,1.986e02,
	  1.307e01,7.880e-01,9.424e01,6.265e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][15][j] = _itmp1818[j];
		}
	}
	{ static float _itmp1819[] = {2.173e00,2.606e00,6.641e01,8.655e00,
	  1.863e00,1.975e01,3.361e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][15][j] = _itmp1819[j];
		}
	}
	{ static float _itmp1820[] = {2.027e00,6.666e00,5.454e01,8.611e00,
	  4.109e00,1.568e01,9.421e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[13][15][j] = _itmp1820[j];
		}
	}
	{ static float _itmp1821[] = {8.787e00,3.136e02,3.442e00,1.281e01,
	  7.354e-01,2.782e00,1.788e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[14][15][j] = _itmp1821[j];
		}
	}
	{ static float _itmp1822[] = {1.808e01,4.564e04,1.000e00,1.361e01,
	  6.385e-01,9.935e-01,2.486e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[15][15][j] = _itmp1822[j];
		}
	}
	{ static float _itmp1823[] = {1.399e02,1.690e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][17][j] = _itmp1823[j];
		}
	}
	{ static float _itmp1824[] = {4.468e02,3.108e01,3.039e01,2.092e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][17][j] = _itmp1824[j];
		}
	}
	{ static float _itmp1825[] = {4.154e01,2.135e01,4.118e01,4.945e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][17][j] = _itmp1825[j];
		}
	}
	{ static float _itmp1826[] = {1.888e01,2.571e04,1.475e00,2.634e01,
	  2.909e01,2.445e-02,1.054e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][17][j] = _itmp1826[j];
		}
	}
	{ static float _itmp1827[] = {1.557e00,4.997e-02,5.031e02,
	  8.966e00,2.938e-01,4.552e02,6.459e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][17][j] = _itmp1827[j];
		}
	}
	{ static float _itmp1828[] = {3.209e-01,2.459e-02,2.285e03,
	  8.810e00,6.692e-01,2.068e03,2.113e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][17][j] = _itmp1828[j];
		}
	}
	{ static float _itmp1829[] = {5.310e00,7.018e-01,1.001e02,
	  8.939e00,4.987e-01,1.099e02,2.202e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][17][j] = _itmp1829[j];
		}
	}
	{ static float _itmp1830[] = {1.257e-01,1.760e03,1.579e03,
	  6.714e00,1.975e00,3.286e-03,3.226e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][17][j] = _itmp1830[j];
		}
	}
	{ static float _itmp1831[] = {1.040e01,8.204e00,1.495e01,1.115e01,
	  9.203e-04,3.804e01,6.390e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][17][j] = _itmp1831[j];
		}
	}
	{ static float _itmp1832[] = {1.926e-01,8.279e-01,2.392e02,
	  1.121e01,1.434e00,3.814e01,4.649e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][17][j] = _itmp1832[j];
		}
	}
	{ static float _itmp1833[] = {3.884e00,3.295e01,7.082e02,4.645e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][17][j] = _itmp1833[j];
		}
	}
	{ static float _itmp1834[] = {2.966e-02,3.693e00,9.951e03,
	  7.313e00,1.363e-02,4.383e-04,2.513e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][17][j] = _itmp1834[j];
		}
	}
	{ static float _itmp1835[] = {5.440e-01,1.080e00,9.419e02,
	  7.582e00,1.107e01,1.700e02,1.587e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][17][j] = _itmp1835[j];
		}
	}
	{ static float _itmp1836[] = {1.031e01,9.946e00,7.444e01,6.261e00,
	  4.885e-01,6.406e00,3.659e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[13][17][j] = _itmp1836[j];
		}
	}
	{ static float _itmp1837[] = {6.953e00,2.035e01,1.400e01,9.595e00,
	  8.842e-01,7.501e00,1.806e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[14][17][j] = _itmp1837[j];
		}
	}
	{ static float _itmp1838[] = {1.417e01,3.580e01,3.776e01,5.742e00,
	  6.316e-01,2.384e00,1.794e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[15][17][j] = _itmp1838[j];
		}
	}
	{ static float _itmp1839[] = {2.494e01,2.503e01,1.272e02,4.288e00,
	  5.108e-01,9.299e-01,7.195e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[16][17][j] = _itmp1839[j];
		}
	}
	{ static float _itmp1840[] = {1.709e01,2.106e01,2.645e02,4.796e00,
	  4.185e-01,1.688e00,8.943e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[17][17][j] = _itmp1840[j];
		}
	}
	{ static float _itmp1841[] = {1.729e02,1.369e02,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][19][j] = _itmp1841[j];
		}
	}
	{ static float _itmp1842[] = {6.297e02,1.936e01,3.921e01,1.862e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][19][j] = _itmp1842[j];
		}
	}
	{ static float _itmp1843[] = {9.472e01,1.105e01,3.818e01,4.192e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][19][j] = _itmp1843[j];
		}
	}
	{ static float _itmp1844[] = {2.618e01,2.028e04,1.456e00,2.560e01,
	  2.803e01,2.402e-02,9.323e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][19][j] = _itmp1844[j];
		}
	}
	{ static float _itmp1845[] = {4.293e00,1.293e00,1.691e01,1.438e01,
	  3.461e-05,9.363e-01,4.589e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][19][j] = _itmp1845[j];
		}
	}
	{ static float _itmp1846[] = {1.309e02,5.513e01,3.828e02,2.023e00,
	  9.084e-02,1.833e-02,9.359e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][19][j] = _itmp1846[j];
		}
	}
}
static void blkdata10x(void)
{
	int j;
	{ static float _itmp1847[] = {9.980e00,1.116e00,5.918e01,9.005e00,
	  3.879e00,7.104e01,5.311e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][19][j] = _itmp1847[j];
		}
	}
	{ static float _itmp1848[] = {1.008e01,1.849e03,1.792e04,2.868e00,
	  2.410e02,6.138e-03,6.931e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][19][j] = _itmp1848[j];
		}
	}
	{ static float _itmp1849[] = {2.345e01,1.227e01,1.312e01,9.771e00,
	  6.842e-04,2.417e01,5.469e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][19][j] = _itmp1849[j];
		}
	}
	{ static float _itmp1850[] = {2.288e-01,9.384e-01,2.549e02,
	  1.103e01,1.390e00,2.478e01,3.100e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][19][j] = _itmp1850[j];
		}
	}
	{ static float _itmp1851[] = {1.605e01,1.437e01,6.989e02,3.857e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][19][j] = _itmp1851[j];
		}
	}
	{ static float _itmp1852[] = {5.520e-02,2.076e02,1.790e04,
	  5.893e00,1.843e-03,2.826e-04,1.657e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][19][j] = _itmp1852[j];
		}
	}
	{ static float _itmp1853[] = {1.366e00,6.641e-01,3.188e02,
	  8.138e00,2.806e-01,1.039e02,3.329e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][19][j] = _itmp1853[j];
		}
	}
	{ static float _itmp1854[] = {8.080e-01,4.760e-01,3.682e02,
	  8.634e00,5.720e-01,1.487e02,1.283e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[13][19][j] = _itmp1854[j];
		}
	}
	{ static float _itmp1855[] = {9.515e00,7.642e01,8.973e01,5.141e00,
	  2.471e00,4.829e00,5.824e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[14][19][j] = _itmp1855[j];
		}
	}
	{ static float _itmp1856[] = {6.882e-01,1.523e-01,1.502e02,
	  1.061e01,8.227e00,1.210e02,3.876e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[15][19][j] = _itmp1856[j];
		}
	}
	{ static float _itmp1857[] = {4.255e00,7.736e00,1.355e01,1.236e01,
	  1.369e00,1.467e01,3.298e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[16][19][j] = _itmp1857[j];
		}
	}
	{ static float _itmp1858[] = {2.436e01,3.815e01,2.931e02,3.944e00,
	  3.126e-01,1.802e00,1.233e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[17][19][j] = _itmp1858[j];
		}
	}
	{ static float _itmp1859[] = {1.553e01,1.064e07,7.790e-01,
	  2.130e01,6.453e-01,2.161e-03,6.706e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[18][19][j] = _itmp1859[j];
		}
	}
	{ static float _itmp1860[] = {1.278e01,5.370e05,3.162e-01,
	  1.242e01,4.477e-01,1.012e-03,1.851e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[19][19][j] = _itmp1860[j];
		}
	}
	{ static float _itmp1861[] = {2.932e02,8.099e01,3.288e01,2.963e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[0][25][j] = _itmp1861[j];
		}
	}
	{ static float _itmp1862[] = {1.057e03,1.195e01,5.769e01,1.718e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[1][25][j] = _itmp1862[j];
		}
	}
	{ static float _itmp1863[] = {7.326e01,1.276e01,4.914e01,4.941e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[2][25][j] = _itmp1863[j];
		}
	}
	{ static float _itmp1864[] = {4.575e01,2.580e04,1.358e00,2.604e01,
	  2.723e01,3.582e-02,8.712e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[3][25][j] = _itmp1864[j];
		}
	}
	{ static float _itmp1865[] = {9.713e00,7.204e-02,1.853e02,
	  8.843e00,9.551e-03,1.702e02,4.263e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[4][25][j] = _itmp1865[j];
		}
	}
	{ static float _itmp1866[] = {9.243e00,1.098e01,7.637e01,7.962e00,
	  1.748e00,4.446e01,3.512e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[5][25][j] = _itmp1866[j];
		}
	}
	{ static float _itmp1867[] = {2.011e01,4.455e-01,4.236e01,
	  9.724e00,2.757e00,6.847e01,3.989e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[6][25][j] = _itmp1867[j];
		}
	}
	{ static float _itmp1868[] = {7.519e-04,6.066e-05,1.606e06,
	  8.813e00,4.398e00,1.915e06,3.140e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[7][25][j] = _itmp1868[j];
		}
	}
	{ static float _itmp1869[] = {3.190e01,2.388e00,2.186e01,9.589e00,
	  2.902e-02,3.805e01,4.805e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[8][25][j] = _itmp1869[j];
		}
	}
	{ static float _itmp1870[] = {3.444e-01,1.452e00,3.960e02,
	  1.013e01,1.264e00,2.891e01,3.404e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[9][25][j] = _itmp1870[j];
		}
	}
	{ static float _itmp1871[] = {2.873e01,1.207e01,5.150e02,3.846e00,
	  0.000e00,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[10][25][j] = _itmp1871[j];
		}
	}
	{ static float _itmp1872[] = {5.555e-02,2.108e02,2.045e04,
	  6.033e00,1.885e-03,2.706e-04,1.628e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[11][25][j] = _itmp1872[j];
		}
	}
	{ static float _itmp1873[] = {8.509e-01,1.454e-01,1.239e03,
	  8.066e00,4.937e-01,4.505e02,2.504e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[12][25][j] = _itmp1873[j];
		}
	}
	{ static float _itmp1874[] = {1.317e-01,2.791e-03,2.487e03,
	  9.791e00,6.938e-01,2.170e03,6.852e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[13][25][j] = _itmp1874[j];
		}
	}
	{ static float _itmp1875[] = {6.295e00,1.738e00,1.130e02,8.037e00,
	  3.096e-01,4.671e01,1.425e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[14][25][j] = _itmp1875[j];
		}
	}
	{ static float _itmp1876[] = {8.284e00,3.281e00,5.360e01,8.571e00,
	  3.279e-01,2.971e01,5.220e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[15][25][j] = _itmp1876[j];
		}
	}
	{ static float _itmp1877[] = {6.886e01,6.470e01,2.062e01,4.111e00,
	  2.778e-04,1.190e-05,6.570e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[16][25][j] = _itmp1877[j];
		}
	}
	{ static float _itmp1878[] = {6.741e00,2.687e01,1.807e02,6.290e00,
	  2.387e-04,2.494e01,8.251e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[17][25][j] = _itmp1878[j];
		}
	}
	{ static float _itmp1879[] = {7.098e-02,1.979e01,1.745e04,
	  6.750e00,2.158e02,2.542e03,4.672e02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[18][25][j] = _itmp1879[j];
		}
	}
	{ static float _itmp1880[] = {5.059e00,2.420e04,4.850e04,2.374e00,
	  2.516e-03,4.546e-01,2.683e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[19][25][j] = _itmp1880[j];
		}
	}
	{ static float _itmp1881[] = {2.656e00,5.259e-01,1.450e01,
	  1.632e01,1.558e01,3.361e01,3.743e-03};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[20][25][j] = _itmp1881[j];
		}
	}
	{ static float _itmp1882[] = {7.256e-01,1.523e-03,3.736e01,
	  1.767e01,5.064e01,8.871e01,5.280e-02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[21][25][j] = _itmp1882[j];
		}
	}
	{ static float _itmp1883[] = {2.544e01,3.653e02,8.913e00,6.538e00,
	  5.602e-01,0.000e00,0.000e00};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[22][25][j] = _itmp1883[j];
		}
	}
	{ static float _itmp1884[] = {1.698e-01,6.107e00,1.555e03,
	  8.055e00,8.698e00,1.760e02,1.847e01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[23][25][j] = _itmp1884[j];
		}
	}
	{ static float _itmp1885[] = {1.761e-01,4.365e03,6.298e03,
	  5.204e00,1.141e01,9.272e01,1.075e02};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[24][25][j] = _itmp1885[j];
		}
	}
	{ static float _itmp1886[] = {5.461e-02,3.062e-01,2.671e07,
	  7.923e00,2.069e01,1.382e02,2.481e-01};
	for( j=0; j < 7; j++ )
	{
		ADfAPH2.PH2[25][25][j] = _itmp1886[j];
		}
	}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif

#	ifdef DEBUG_FUN
	fputs( " <->blkdata0()\n", debug_fp );
#	endif
}

