/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*atmdat_dielrec_fe Dielectronic recombination rates for Fe from Arnaud & Raymond 1992 */
#include "cddefines.h"
#include "atmdat.h"
#include "physconst.h"

/*atmdat_dielrec_fe Dielectronic recombination rates for Fe from Arnaud & Raymond 1992 */
double atmdat_dielrec_fe(long int ion, double t)
{
	long int i, 
	  j, 
	  k, 
	  _r;
	double te;
	static double dfe[25][8];
	double rate;
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp0[] = {5.120e00,1.29e01,0.00e00,0.00e00,
		  2.20e-04,1.00e-04,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[0][i-1] = _itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {1.670e01,3.14e01,0.00e00,0.00e00,
		  2.30e-03,2.70e-03,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[1][i-1] = _itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {2.860e01,5.21e01,0.00e00,0.00e00,
		  1.50e-02,4.70e-03,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[2][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {3.730e01,6.74e01,0.00e00,0.00e00,
		  3.80e-02,1.60e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[3][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {5.420e01,1.00e02,0.00e00,0.00e00,
		  8.00e-02,2.40e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[4][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {4.550e01,3.60e02,0.00e00,0.00e00,
		  9.20e-02,4.10e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[5][i-1] = _itmp5[_r++];
			}
		}
		{ static double _itmp6[] = {6.670e01,1.23e02,0.00e00,0.00e00,
		  1.60e-01,3.60e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[6][i-1] = _itmp6[_r++];
			}
		}
		{ static double _itmp7[] = {6.610e01,1.29e02,0.00e00,0.00e00,
		  1.80e-01,7.00e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[7][i-1] = _itmp7[_r++];
			}
		}
		{ static double _itmp8[] = {2.160e01,1.36e02,0.00e00,0.00e00,
		  1.40e-01,2.60e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[8][i-1] = _itmp8[_r++];
			}
		}
		{ static double _itmp9[] = {2.220e01,1.44e02,0.00e00,0.00e00,
		  1.00e-01,2.80e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[9][i-1] = _itmp9[_r++];
			}
		}
		{ static double _itmp10[] = {5.960e01,3.62e02,0.00e00,0.00e00,
		  2.25e-01,2.31e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[10][i-1] = _itmp10[_r++];
			}
		}
		{ static double _itmp11[] = {7.500e01,2.05e02,0.00e00,0.00e00,
		  2.40e-01,1.70e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[11][i-1] = _itmp11[_r++];
			}
		}
		{ static double _itmp12[] = {3.630e01,1.93e02,0.00e00,0.00e00,
		  2.60e-01,1.60e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[12][i-1] = _itmp12[_r++];
			}
		}
		{ static double _itmp13[] = {3.940e01,1.98e02,0.00e00,0.00e00,
		  1.90e-01,9.00e-02,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[13][i-1] = _itmp13[_r++];
			}
		}
		{ static double _itmp14[] = {2.460e01,2.48e02,5.60e02,0.00e00,
		  1.20e-01,1.20e-01,6.00e-01,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[14][i-1] = _itmp14[_r++];
			}
		}
		{ static double _itmp15[] = {5.600e02,0.00e00,0.00e00,0.00e00,
		  1.23e00,0.00e00,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[15][i-1] = _itmp15[_r++];
			}
		}
		{ static double _itmp16[] = {2.250e01,1.17e02,3.41e02,6.83e02,
		  2.53e-03,3.36e-02,1.81e-01,1.92e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[16][i-1] = _itmp16[_r++];
			}
		}
		{ static double _itmp17[] = {1.620e01,9.60e01,3.30e02,7.29e02,
		  5.67e-03,7.82e-02,3.18e-02,1.26e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[17][i-1] = _itmp17[_r++];
			}
		}
		{ static double _itmp18[] = {2.370e01,8.51e01,3.29e02,7.87e02,
		  1.60e-02,7.17e-02,9.06e-02,7.39e-01};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[18][i-1] = _itmp18[_r++];
			}
		}
		{ static double _itmp19[] = {1.320e01,6.66e01,2.97e02,7.14e02,
		  1.85e-02,9.53e-02,7.90e-02,1.23e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[19][i-1] = _itmp19[_r++];
			}
		}
		{ static double _itmp20[] = {3.910e01,8.03e01,3.92e02,9.19e02,
		  9.20e-04,1.29e-01,1.92e-01,9.12e-01};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[20][i-1] = _itmp20[_r++];
			}
		}
		{ static double _itmp21[] = {7.320e01,3.16e02,8.77e02,0.00e00,
		  1.31e-01,8.49e-02,6.13e-01,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[21][i-1] = _itmp21[_r++];
			}
		}
		{ static double _itmp22[] = {1.000e-01,3.62e01,3.06e02,9.28e02,
		  1.10e-02,4.88e-02,8.01e-02,5.29e-01};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[22][i-1] = _itmp22[_r++];
			}
		}
		{ static double _itmp23[] = {4.625e03,6.00e03,0.00e00,0.00e00,
		  2.56e-01,4.52e-01,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[23][i-1] = _itmp23[_r++];
			}
		}
		{ static double _itmp24[] = {5.300e03,0.00e00,0.00e00,0.00e00,
		  4.30e-01,0.00e00,0.00e00,0.00e00};
		for( i=1, _r = 0; i <= 8; i++ )
		{
			dfe[24][i-1] = _itmp24[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>atmdat_dielrec_fe()\n", debug_fp );
#	endif
	/*Dielectronic recombination rates for Fe from 
	 * >>refer	fe	rec	Arnaud, M. & Raymond, J 1992, ApJ, 398, 394 */

	/* ion - spectroscopic symbol of final ion
	 * t - temperature, K
	 * d - rate coefficient, cm^3 s^-1 */

	if( ion > 26 )
	{
		fprintf( ioQQQ, " atmdat_dielrec_fe invalid ion%10ld\n", ion );
		puts( "[Stop in atmdat_dielrec_fe]" );
		cdEXIT(EXIT_FAILURE);
	}

	else if( ion == 26 )
	{
		/* d is the rate */
		rate = 0.0;
	}

	else
	{
		te = t*EVRYD/TE1RYD;
		rate = 0.0;
		for( j=0; j < 4; j++ )
		{
			k = j + 4;
			rate += (dfe[ion-1][k]*sexp(dfe[ion-1][j]/te));
		}
		rate = rate/pow(t,1.5);
	}


#	ifdef DEBUG_FUN
	fputs( " <->atmdat_dielrec_fe()\n", debug_fp );
#	endif
	return rate;
}

