/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */

/* atmdat_2phot_shapefunction two photon emission function for all atomic and ionic species	*/
double atmdat_2phot_shapefunction( double EbyE2nu, long ipISO, long nelem );

/*atmdat_2phot_rate hydrogen two photon emission, including induced emission */
void atmdat_2phot_rate(
	/* atomic number on c scale */
	long ipZ , 
	/* 2s to 1s rate, just induced 
	float *ri2s1s , */
	/* induced upward rate, 1s to 2s
	float *ri1s2s ,  */
	/* the iso sequence, must be either 0 (hydrogen) or 1 (he-like) */
	long ipISO );

/*atmdat_coll_ion D Verner's routine to compute collisional ionization rate coefficients */
double atmdat_coll_ion(long int iz, 
	  long int in, 
	  double t);

/*atmdat_readin read in some data files, but only if this is very first call */
void atmdat_readin(void);

/*atmdat_outer_shell determine outer shell, and statistical weights of that and higher ion, for any ion
 * written by Dima Verner */
void atmdat_outer_shell(long int iz, /* atomic number from 1 to 30 */
  long int in, /* number of electrons from 1 to iz */
  long int *imax, /* number of the outer shell */
  long int *ig0, /* statistical weight of (iz,in) ground state */
  long int *ig1); /* statistical weight of (iz,in-1) ground state */

/*atmdat_rec_lines effective recombination coefficients for lines of C, N, O, by D. Verner */
void atmdat_rec_lines(double t, 
	  float r[][471]);

/*atmdat fill in the HCharExcIonOf and Rec arrays with Kingdon's fitted CT with H,
 * return value is rate O ionizes H */
void ChargTranEval( double * O_HIonRate );

/* sum up the charge transfer heating */
double ChargTranSumHeat(void);

/* punch charge transfer rate coefficients */
void ChargTranPun( FILE* ipPnunit , char* chPunch );

/*atmdat_dielrec_fe Dielectronic recombination rates for Fe from Arnaud & Raymond 1992 */
double atmdat_dielrec_fe(long int ion, double t);

/*atmdat_rad_rec calculates rates of radiative recombination for all ions */
double atmdat_rad_rec(
	/* nuclear number on physics scale */
	long int iz, 
	/* number of recombined electrons */
	long int in, 
	/* temperature K */
	double t);

/* this initializes the arrays containing the fitting coefficients,
 * called by OpacityCreateAll, done once per coreload */
void atmdat_H_phot_cs(void);

/*atmdat_hpfit state specific photoionization cross sections for model hydrogen atom */
double atmdat_hpfit(long int iz, 
	  long int n, 
	  double e );

/* same as atmdat_hpfit, but energy is relative to threshold */
double atmdat_hpfit_rel(long int iz, 
	  long int n, 
	  double e);

/*atmdat_3body derive three-body recombination coefficients */
void atmdat_3body(void);

/*atmdat_H_rad_rec calculates state-specific recombination rates for H and H-like ions*/
double atmdat_H_rad_rec(long int iz, 
	  long int n, 
	  double t);

double atmdat_HS_caseB( 
/* general utility to read in line emissivities from the Storey & Hummer tables
 of case B emissivities.  */
	long int iHi,	/* the principal quantum numbers, . */
	long int iLo,	/* upper and lower levels in any order*/
	long int iZ,	/* charge of ion, only 1 and 2 for now*/
	double TempIn,	/* temperature, must lie within the range of the table,
						   which depends on 
						   the ion charge, and is 500 - 30,000K for hydrogen */
	double DenIn,	/* the density and must lie within the range of the table*/
	/* case - 'a' or 'b' */
	char chCase 
	);

/*atmdat_DielSupres derive scale factors for suppression of Burgess dielectronic recombination */
void atmdat_DielSupres(void);

/* these are the vectors that store the original Hummer and Storey case B
 * line data for H and He - the declaration for the interpolator follows */
#define NHSDIM 15 /*used for following vectors*/
#define NLINEHS 300  /*dimension of array with lines*/
#define HS_NZ 8 /* number of elements that can be read in */

EXTERN struct t_CharExc {
	/*
	 * ion, nelem
	 * these arrays save the charge transfer ionization and recom
	 * rates for the heavy elements onto hydrogen.  ionization is
	 * of the heavy element, and so is a recom for hydrogen
	 * 
	 * HCharExcIonOf( ion , nelem ), HCharExcRecTo( ion , nelem )
	 * charge transfer ionization of atomic oxygen = HCharExcIonOf[ipOXYGEN][0]*hii
	 * charge transfer recombination of ionized oxygen = HCharExcRecTo[ipOXYGEN][0]*hi
	 * HCharHeatMax, HCharCoolMax are largest fractions of local heating
	 * or cooling due to ct
	 * HCharHeatOn usually 1, set to 0 with no CTHeat command
	 */
	/* CharExcIon is ionization, */
	/* [0] is Atom^0 + H+ => Atom+1 + H0
	 * [n] is Atom^+n + H+ => Atom^+n-1 + H0 */

	/* CharExcRec is recombination */
	/* [0] is Atom^+1 + H0 => Atom^0 + H^+
	 * [n] is Atom^+n+1 + H0 => Atom^+n + H^+ */
	double HCharExcIonOf[LIMELM][LIMELM+1], 
	  HCharExcRecTo[LIMELM][LIMELM+1], 
	  HCharHeatMax, 
	  HCharCoolMax, 
	  HCharHeatOn;

	/* this is total rate (s-1) for ct ionization and recombination of H */
	double HCharExcIonTotal,
	  HCharExcRecTotal;

	/* this is total rate (s-1) for ct ionization and recombination of He */
	double HeCharExcIonTotal,
	  HeCharExcRecTotal;

	/* this is the current ratio of ct ionization of H, relative to total dest rate*/
	double HIonFrac;

	/* this is the largest ratio of ct ionization of H, relative to total dest rate*/
	double HIonFracMax;

	/*
	 *this is the charge ionization, recom array
	 *that goes into the ionization balance
	 *Ion[ion] is ionization, Rec[ion] is recombination
	 *it has all He charge transfer rates
	 */
	double HeCharExcIonOf[LIMELM][LIMELM], 
	  HeCharExcRecTo[LIMELM][LIMELM];

	/* Dalgarno H charge transfer rate coef for high stages of ionization
	 * default is 1.92e-9 in zero, reset with 'set charge transfer' command */
	double HCTAlex;

	/* variable to turn on or off ct ionization-recombiantion of
	 * all elements - set off with no charge trasnfer command */
	int lgCTOn;

	/* array of cross sections for photoionization of hydrogen at threshold,
	 * 0 is 1s, 1 is 2s, 2 is 2p, up to 400 */
	float STH[NHYDRO_MAX_LEVEL];

	/* these are the density and temperature mesh points on the
	 * original Hummer & Storey data, for H[0] and He[1], */
	double Density[2][HS_NZ][NHSDIM], 
		ElecTemp[2][HS_NZ][NHSDIM],
		/*emiss[ipTemp][ipDens][ipLevel]*/
		Emiss[2][HS_NZ][NHSDIM][NHSDIM][NLINEHS] ;

	/* saves the number of density temperature mesh points for the two cases for the HS_NZ elements */
	long int nDensity[2][HS_NZ] , ntemp[2][HS_NZ] , ncut[2][HS_NZ] ;

	/* following will be set false if we ever stop over bounds of HS table
	 * for any element.  first index is case A [0] or case B [1] -
	 * second is element number */
	int lgHCaseBOK[2][HS_NZ];

	/* related to highest stage of ionization needed for cota recom */
	long int nsbig;

	/* by default, include collisional ionization, option to not include it,
	 * with "no collisional ionization" command */
	int lgCollIonOn;

	}	atmdat;

/* parameters needed for D Verner's fit to cs cross sections */
EXTERN struct t_PH1COM {
	float PH1[7][30][30][6];
	}	PH1COM;

/*atmdat_phfit derive photoionization cross sectoins for first 30 elements */
double atmdat_phfit(long int nz, 
	  long int ne, 
	  long int is, 
	  double e, 
	  int lghs);

EXTERN struct t_PhFitOn {
	/* which version of atmdat_phfit should be used? */
	int lgPhFit;

	}	PhFitOn;

