/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*AbundancesSet sets initial abundances after parameters are entered by reading input */
void AbundancesSet(void);

/*AbundancesPrt print all abundances, both gas phase and grains */
void AbundancesPrt( void );

/*AbundancesZero set initial abundances for different mixes */
void AbundancesZero(void);

void abund_starburst(char*);

/*AbundancesTable interpolate on table of points to do 'element table' command, */
double AbundancesTable(double r0, 
  double depth, 
  long int iel);

/* abund.h */
EXTERN struct t_abund {

	/* logical flag saying whether to include this element in punch output for AGN tables */
	int lgAGN[LIMELM];

	float SolarSave[LIMELM], 
	  OldSolar84[LIMELM], 
	  anova[LIMELM], 
	  apn[LIMELM], 
	  ahii[LIMELM], 
	  camern[LIMELM], 
	  aprim[LIMELM], 
	  aism[LIMELM];

	int lgAbnSolar;

	/* solar abundances for the current calculation */
	float solar[LIMELM];

	/*lgAbunTabl says whether this element is to have its abundance
	 *determined from a table (true) or stored constant (false)
	 *set true with element table command */
	int lgAbunTabl[LIMELM], 

	  /* lgAbTaDepth says whether depth or radius, true is depth */
	  lgAbTaDepth[LIMELM], 

	  /* general flag saying this option turned on */
	  lgAbTaON;

#	define	LIMTABD	500

	/*AbTabFac abundances for element table*/
	float AbTabFac[LIMTABD][LIMELM], 

	/*AbTabRad depth scale 
	 *parameters for dlaw table command*/
	  AbTabRad[LIMTABD][LIMELM];

	long int nAbunTabl;

	/* indices so that abundances can be in any order */
	long int ipSolar[LIMELM], 
	  npSolar;

	/* scale factors to alter abundances of elements, set with element scale */
	float ScaleElement[LIMELM];

	/* Depletion is set of stored scale factors for depletion of general ism */
	float Depletion[LIMELM], 

	/* depset is unity unless depletion is used */
	  depset[LIMELM];

	/* lgDepln is true if depln used */
	int lgDepln;

	/* scale factor for metals, set with metals command	 */
	float ScaleMetals;

	}	abund;


